# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/maps/fleetengine/v1/vehicle_api.proto for package 'Google.Maps.FleetEngine.V1'
# Original file comments:
# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/maps/fleetengine/v1/vehicle_api_pb'

module Google
  module Maps
    module FleetEngine
      module V1
        module VehicleService
          # Vehicle management service.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'maps.fleetengine.v1.VehicleService'

            # Instantiates a new vehicle associated with an on-demand rideshare or
            # deliveries provider. Each `Vehicle` must have a unique vehicle ID.
            #
            # The following `Vehicle` fields are required when creating a `Vehicle`:
            #
            # * `vehicleState`
            # * `supportedTripTypes`
            # * `maximumCapacity`
            # * `vehicleType`
            #
            # The following `Vehicle` fields are ignored when creating a `Vehicle`:
            #
            # * `name`
            # * `currentTrips`
            # * `availableCapacity`
            # * `current_route_segment`
            # * `current_route_segment_end_point`
            # * `current_route_segment_version`
            # * `current_route_segment_traffic`
            # * `route`
            # * `waypoints`
            # * `waypoints_version`
            # * `remaining_distance_meters`
            # * `remaining_time_seconds`
            # * `eta_to_next_waypoint`
            # * `navigation_status`
            #
            # All other fields are optional and used if provided.
            rpc :CreateVehicle, ::Google::Maps::FleetEngine::V1::CreateVehicleRequest, ::Google::Maps::FleetEngine::V1::Vehicle
            # Returns a vehicle from the Fleet Engine.
            rpc :GetVehicle, ::Google::Maps::FleetEngine::V1::GetVehicleRequest, ::Google::Maps::FleetEngine::V1::Vehicle
            # Deletes a Vehicle from the Fleet Engine.
            #
            # Returns FAILED_PRECONDITION if the Vehicle has active Trips.
            # assigned to it.
            rpc :DeleteVehicle, ::Google::Maps::FleetEngine::V1::DeleteVehicleRequest, ::Google::Protobuf::Empty
            # Writes updated vehicle data to the Fleet Engine.
            #
            # When updating a `Vehicle`, the following fields cannot be updated since
            # they are managed by the server:
            #
            # * `currentTrips`
            # * `availableCapacity`
            # * `current_route_segment_version`
            # * `waypoints_version`
            #
            # The vehicle `name` also cannot be updated.
            #
            # If the `attributes` field is updated, **all** the vehicle's attributes are
            # replaced with the attributes provided in the request. If you want to update
            # only some attributes, see the `UpdateVehicleAttributes` method. Likewise,
            # the `waypoints` field can be updated, but must contain all the waypoints
            # currently on the vehicle, and no other waypoints.
            rpc :UpdateVehicle, ::Google::Maps::FleetEngine::V1::UpdateVehicleRequest, ::Google::Maps::FleetEngine::V1::Vehicle
            # Partially updates a vehicle's attributes.
            # Only the attributes mentioned in the request will be updated, other
            # attributes will NOT be altered. Note: this is different in `UpdateVehicle`,
            # where the whole `attributes` field will be replaced by the one in
            # `UpdateVehicleRequest`, attributes not in the request would be removed.
            rpc :UpdateVehicleAttributes, ::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest, ::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesResponse
            # Returns a paginated list of vehicles associated with
            # a provider that match the request options.
            rpc :ListVehicles, ::Google::Maps::FleetEngine::V1::ListVehiclesRequest, ::Google::Maps::FleetEngine::V1::ListVehiclesResponse
            # Returns a list of vehicles that match the request options.
            rpc :SearchVehicles, ::Google::Maps::FleetEngine::V1::SearchVehiclesRequest, ::Google::Maps::FleetEngine::V1::SearchVehiclesResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
