# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/maps/fleetengine/v1/vehicle_api_pb"
require "google/maps/fleet_engine/v1/vehicle_service/rest/service_stub"

module Google
  module Maps
    module FleetEngine
      module V1
        module VehicleService
          module Rest
            ##
            # REST client for the VehicleService service.
            #
            # Vehicle management service.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "fleetengine.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :vehicle_service_stub

              ##
              # Configure the VehicleService Client class.
              #
              # See {::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all VehicleService clients
              #   ::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Maps", "FleetEngine", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_vehicle.timeout = 15.0
                  default_config.rpcs.create_vehicle.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_vehicle.timeout = 15.0
                  default_config.rpcs.get_vehicle.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_vehicle.timeout = 15.0
                  default_config.rpcs.update_vehicle.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_vehicle_attributes.timeout = 15.0
                  default_config.rpcs.update_vehicle_attributes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.search_vehicles.timeout = 15.0
                  default_config.rpcs.search_vehicles.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the VehicleService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @vehicle_service_stub.universe_domain
              end

              ##
              # Create a new VehicleService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the VehicleService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @vehicle_service_stub = ::Google::Maps::FleetEngine::V1::VehicleService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @vehicle_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @vehicle_service_stub.logger
              end

              # Service calls

              ##
              # Instantiates a new vehicle associated with an on-demand rideshare or
              # deliveries provider. Each `Vehicle` must have a unique vehicle ID.
              #
              # The following `Vehicle` fields are required when creating a `Vehicle`:
              #
              # * `vehicleState`
              # * `supportedTripTypes`
              # * `maximumCapacity`
              # * `vehicleType`
              #
              # The following `Vehicle` fields are ignored when creating a `Vehicle`:
              #
              # * `name`
              # * `currentTrips`
              # * `availableCapacity`
              # * `current_route_segment`
              # * `current_route_segment_end_point`
              # * `current_route_segment_version`
              # * `current_route_segment_traffic`
              # * `route`
              # * `waypoints`
              # * `waypoints_version`
              # * `remaining_distance_meters`
              # * `remaining_time_seconds`
              # * `eta_to_next_waypoint`
              # * `navigation_status`
              #
              # All other fields are optional and used if provided.
              #
              # @overload create_vehicle(request, options = nil)
              #   Pass arguments to `create_vehicle` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::CreateVehicleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::CreateVehicleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_vehicle(header: nil, parent: nil, vehicle_id: nil, vehicle: nil)
              #   Pass arguments to `create_vehicle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     The standard Fleet Engine request header.
              #   @param parent [::String]
              #     Required. Must be in the format `providers/{provider}`.
              #     The provider must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              #   @param vehicle_id [::String]
              #     Required. Unique Vehicle ID.
              #     Subject to the following restrictions:
              #
              #     * Must be a valid Unicode string.
              #     * Limited to a maximum length of 64 characters.
              #     * Normalized according to [Unicode Normalization Form C]
              #     (http://www.unicode.org/reports/tr15/).
              #     * May not contain any of the following ASCII characters: '/', ':', '?',
              #     ',', or '#'.
              #   @param vehicle [::Google::Maps::FleetEngine::V1::Vehicle, ::Hash]
              #     Required. The Vehicle entity to create. When creating a Vehicle, the
              #     following fields are required:
              #
              #     * `vehicleState`
              #     * `supportedTripTypes`
              #     * `maximumCapacity`
              #     * `vehicleType`
              #
              #     When creating a Vehicle, the following fields are ignored:
              #
              #     * `name`
              #     * `currentTrips`
              #     * `availableCapacity`
              #     * `current_route_segment`
              #     * `current_route_segment_end_point`
              #     * `current_route_segment_version`
              #     * `current_route_segment_traffic`
              #     * `route`
              #     * `waypoints`
              #     * `waypoints_version`
              #     * `remaining_distance_meters`
              #     * `remaining_time_seconds`
              #     * `eta_to_next_waypoint`
              #     * `navigation_status`
              #
              #     All other fields are optional and used if provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Maps::FleetEngine::V1::Vehicle]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Maps::FleetEngine::V1::Vehicle]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::CreateVehicleRequest.new
              #
              #   # Call the create_vehicle method.
              #   result = client.create_vehicle request
              #
              #   # The returned object is of type Google::Maps::FleetEngine::V1::Vehicle.
              #   p result
              #
              def create_vehicle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::CreateVehicleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_vehicle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_vehicle.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_vehicle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.create_vehicle request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a vehicle from the Fleet Engine.
              #
              # @overload get_vehicle(request, options = nil)
              #   Pass arguments to `get_vehicle` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::GetVehicleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::GetVehicleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_vehicle(header: nil, name: nil, current_route_segment_version: nil, waypoints_version: nil)
              #   Pass arguments to `get_vehicle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     The standard Fleet Engine request header.
              #   @param name [::String]
              #     Required. Must be in the format
              #     `providers/{provider}/vehicles/{vehicle}`.
              #     The provider must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              #   @param current_route_segment_version [::Google::Protobuf::Timestamp, ::Hash]
              #     Indicates the minimum timestamp (exclusive) for which
              #     `Vehicle.current_route_segment` is retrieved.
              #     If the route is unchanged since this timestamp, the `current_route_segment`
              #     field is not set in the response. If a minimum is unspecified, the
              #     `current_route_segment` is always retrieved.
              #   @param waypoints_version [::Google::Protobuf::Timestamp, ::Hash]
              #     Indicates the minimum timestamp (exclusive) for which `Vehicle.waypoints`
              #     data is retrieved. If the waypoints are unchanged since this timestamp, the
              #     `vehicle.waypoints` data is not set in the response. If this field is
              #     unspecified, `vehicle.waypoints` is always retrieved.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Maps::FleetEngine::V1::Vehicle]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Maps::FleetEngine::V1::Vehicle]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::GetVehicleRequest.new
              #
              #   # Call the get_vehicle method.
              #   result = client.get_vehicle request
              #
              #   # The returned object is of type Google::Maps::FleetEngine::V1::Vehicle.
              #   p result
              #
              def get_vehicle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::GetVehicleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_vehicle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_vehicle.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_vehicle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.get_vehicle request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a Vehicle from the Fleet Engine.
              #
              # Returns FAILED_PRECONDITION if the Vehicle has active Trips.
              # assigned to it.
              #
              # @overload delete_vehicle(request, options = nil)
              #   Pass arguments to `delete_vehicle` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::DeleteVehicleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::DeleteVehicleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_vehicle(header: nil, name: nil)
              #   Pass arguments to `delete_vehicle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     Optional. The standard Fleet Engine request header.
              #   @param name [::String]
              #     Required. Must be in the format
              #     `providers/{provider}/vehicles/{vehicle}`.
              #     The \\{provider} must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::DeleteVehicleRequest.new
              #
              #   # Call the delete_vehicle method.
              #   result = client.delete_vehicle request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_vehicle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::DeleteVehicleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_vehicle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_vehicle.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_vehicle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.delete_vehicle request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Writes updated vehicle data to the Fleet Engine.
              #
              # When updating a `Vehicle`, the following fields cannot be updated since
              # they are managed by the server:
              #
              # * `currentTrips`
              # * `availableCapacity`
              # * `current_route_segment_version`
              # * `waypoints_version`
              #
              # The vehicle `name` also cannot be updated.
              #
              # If the `attributes` field is updated, **all** the vehicle's attributes are
              # replaced with the attributes provided in the request. If you want to update
              # only some attributes, see the `UpdateVehicleAttributes` method. Likewise,
              # the `waypoints` field can be updated, but must contain all the waypoints
              # currently on the vehicle, and no other waypoints.
              #
              # @overload update_vehicle(request, options = nil)
              #   Pass arguments to `update_vehicle` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::UpdateVehicleRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::UpdateVehicleRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_vehicle(header: nil, name: nil, vehicle: nil, update_mask: nil)
              #   Pass arguments to `update_vehicle` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     The standard Fleet Engine request header.
              #   @param name [::String]
              #     Required. Must be in the format
              #     `providers/{provider}/vehicles/{vehicle}`.
              #     The \\{provider} must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              #   @param vehicle [::Google::Maps::FleetEngine::V1::Vehicle, ::Hash]
              #     Required. The `Vehicle` entity values to apply.  When updating a `Vehicle`,
              #     the following fields may not be updated as they are managed by the
              #     server.
              #
              #     * `available_capacity`
              #     * `current_route_segment_version`
              #     * `current_trips`
              #     * `name`
              #     * `waypoints_version`
              #
              #     If the `attributes` field is updated, **all** the vehicle's attributes are
              #     replaced with the attributes provided in the request. If you want to update
              #     only some attributes, see the `UpdateVehicleAttributes` method.
              #
              #     Likewise, the `waypoints` field can be updated, but must contain all the
              #     waypoints currently on the vehicle, and no other waypoints.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. A field mask indicating which fields of the `Vehicle` to update.
              #     At least one field name must be provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Maps::FleetEngine::V1::Vehicle]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Maps::FleetEngine::V1::Vehicle]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::UpdateVehicleRequest.new
              #
              #   # Call the update_vehicle method.
              #   result = client.update_vehicle request
              #
              #   # The returned object is of type Google::Maps::FleetEngine::V1::Vehicle.
              #   p result
              #
              def update_vehicle request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::UpdateVehicleRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_vehicle.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_vehicle.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_vehicle.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.update_vehicle request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Partially updates a vehicle's attributes.
              # Only the attributes mentioned in the request will be updated, other
              # attributes will NOT be altered. Note: this is different in `UpdateVehicle`,
              # where the whole `attributes` field will be replaced by the one in
              # `UpdateVehicleRequest`, attributes not in the request would be removed.
              #
              # @overload update_vehicle_attributes(request, options = nil)
              #   Pass arguments to `update_vehicle_attributes` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_vehicle_attributes(header: nil, name: nil, attributes: nil)
              #   Pass arguments to `update_vehicle_attributes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     The standard Fleet Engine request header.
              #   @param name [::String]
              #     Required. Must be in the format `providers/{provider}/vehicles/{vehicle}`.
              #     The provider must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              #   @param attributes [::Array<::Google::Maps::FleetEngine::V1::VehicleAttribute, ::Hash>]
              #     Required. The vehicle attributes to update. Unmentioned attributes are not
              #     altered or removed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest.new
              #
              #   # Call the update_vehicle_attributes method.
              #   result = client.update_vehicle_attributes request
              #
              #   # The returned object is of type Google::Maps::FleetEngine::V1::UpdateVehicleAttributesResponse.
              #   p result
              #
              def update_vehicle_attributes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_vehicle_attributes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_vehicle_attributes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_vehicle_attributes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.update_vehicle_attributes request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a paginated list of vehicles associated with
              # a provider that match the request options.
              #
              # @overload list_vehicles(request, options = nil)
              #   Pass arguments to `list_vehicles` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::ListVehiclesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::ListVehiclesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_vehicles(header: nil, parent: nil, page_size: nil, page_token: nil, minimum_capacity: nil, trip_types: nil, maximum_staleness: nil, vehicle_type_categories: nil, required_attributes: nil, required_one_of_attributes: nil, required_one_of_attribute_sets: nil, vehicle_state: nil, on_trip_only: nil, filter: nil, viewport: nil)
              #   Pass arguments to `list_vehicles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     The standard Fleet Engine request header.
              #   @param parent [::String]
              #     Required. Must be in the format `providers/{provider}`.
              #     The provider must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              #   @param page_size [::Integer]
              #     The maximum number of vehicles to return.
              #     Default value: 100.
              #   @param page_token [::String]
              #     The value of the `next_page_token` provided by a previous call to
              #     `ListVehicles` so that you can paginate through groups of vehicles. The
              #     value is undefined if the filter criteria of the request is not the same as
              #     the filter criteria for the previous call to `ListVehicles`.
              #   @param minimum_capacity [::Google::Protobuf::Int32Value, ::Hash]
              #     Specifies the required minimum capacity of the vehicle. All vehicles
              #     returned will have a `maximum_capacity` greater than or equal to this
              #     value. If set, must be greater or equal to 0.
              #   @param trip_types [::Array<::Google::Maps::FleetEngine::V1::TripType>]
              #     Restricts the response to vehicles that support at least one of the
              #     specified trip types.
              #   @param maximum_staleness [::Google::Protobuf::Duration, ::Hash]
              #     Restricts the response to vehicles that have sent location updates to Fleet
              #     Engine within the specified duration. Stationary vehicles still
              #     transmitting their locations are not considered stale. If present, must be
              #     a valid positive duration.
              #   @param vehicle_type_categories [::Array<::Google::Maps::FleetEngine::V1::Vehicle::VehicleType::Category>]
              #     Required. Restricts the response to vehicles with one of the specified type
              #     categories. `UNKNOWN` is not allowed.
              #   @param required_attributes [::Array<::String>]
              #     Callers can form complex logical operations using any combination of the
              #     `required_attributes`, `required_one_of_attributes`, and
              #     `required_one_of_attribute_sets` fields.
              #
              #     `required_attributes` is a list; `required_one_of_attributes` uses a
              #     message which allows a list of lists. In combination, the two fields allow
              #     the composition of this expression:
              #
              #     ```
              #     (required_attributes[0] AND required_attributes[1] AND ...)
              #     AND
              #     (required_one_of_attributes[0][0] OR required_one_of_attributes[0][1] OR
              #     ...)
              #     AND
              #     (required_one_of_attributes[1][0] OR required_one_of_attributes[1][1] OR
              #     ...)
              #     ```
              #
              #     Restricts the response to vehicles with the specified attributes. This
              #     field is a conjunction/AND operation. A max of 50 required_attributes is
              #     allowed. This matches the maximum number of attributes allowed on a
              #     vehicle. Each repeated string should be of the format "key:value".
              #   @param required_one_of_attributes [::Array<::String>]
              #     Restricts the response to vehicles with at least one of the specified
              #     attributes in each `VehicleAttributeList`. Within each list, a vehicle must
              #     match at least one of the attributes. This field is an inclusive
              #     disjunction/OR operation in each `VehicleAttributeList` and a
              #     conjunction/AND operation across the collection of `VehicleAttributeList`.
              #     Each repeated string should be of the format
              #     "key1:value1|key2:value2|key3:value3".
              #   @param required_one_of_attribute_sets [::Array<::String>]
              #     `required_one_of_attribute_sets` provides additional functionality.
              #
              #     Similar to `required_one_of_attributes`, `required_one_of_attribute_sets`
              #     uses a message which allows a list of lists, allowing expressions such as
              #     this one:
              #
              #     ```
              #     (required_attributes[0] AND required_attributes[1] AND ...)
              #     AND
              #     (
              #       (required_one_of_attribute_sets[0][0] AND
              #       required_one_of_attribute_sets[0][1] AND
              #       ...)
              #       OR
              #       (required_one_of_attribute_sets[1][0] AND
              #       required_one_of_attribute_sets[1][1] AND
              #       ...)
              #     )
              #     ```
              #
              #     Restricts the response to vehicles that match all the attributes in a
              #     `VehicleAttributeList`. Within each list, a vehicle must match all of the
              #     attributes. This field is a conjunction/AND operation in each
              #     `VehicleAttributeList` and inclusive disjunction/OR operation across the
              #     collection of `VehicleAttributeList`. Each repeated string should be of the
              #     format "key1:value1|key2:value2|key3:value3".
              #   @param vehicle_state [::Google::Maps::FleetEngine::V1::VehicleState]
              #     Restricts the response to vehicles that have this vehicle state.
              #   @param on_trip_only [::Boolean]
              #     Only return the vehicles with current trip(s).
              #   @param filter [::String]
              #     Optional. A filter query to apply when listing vehicles. See
              #     http://aip.dev/160 for examples of the filter syntax.
              #
              #     This field is designed to replace the `required_attributes`,
              #     `required_one_of_attributes`, and `required_one_of_attributes_sets` fields.
              #     If a non-empty value is specified here, the following fields must be empty:
              #     `required_attributes`, `required_one_of_attributes`, and
              #     `required_one_of_attributes_sets`.
              #
              #     This filter functions as an AND clause with other constraints,
              #     such as `vehicle_state` or `on_trip_only`.
              #
              #     Note that the only queries supported are on vehicle attributes (for
              #     example, `attributes.<key> = <value>` or `attributes.<key1> = <value1> AND
              #     attributes.<key2> = <value2>`). The maximum number of restrictions allowed
              #     in a filter query is 50.
              #
              #     Also, all attributes are stored as strings, so the only supported
              #     comparisons against attributes are string comparisons. In order to compare
              #     against number or boolean values, the values must be explicitly quoted to
              #     be treated as strings (for example, `attributes.<key> = "10"` or
              #     `attributes.<key> = "true"`).
              #   @param viewport [::Google::Geo::Type::Viewport, ::Hash]
              #     Optional. A filter that limits the vehicles returned to those whose last
              #     known location was in the rectangular area defined by the viewport.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Maps::FleetEngine::V1::Vehicle>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Maps::FleetEngine::V1::Vehicle>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::ListVehiclesRequest.new
              #
              #   # Call the list_vehicles method.
              #   result = client.list_vehicles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Maps::FleetEngine::V1::Vehicle.
              #     p item
              #   end
              #
              def list_vehicles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::ListVehiclesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_vehicles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_vehicles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_vehicles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.list_vehicles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @vehicle_service_stub, :list_vehicles, "vehicles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of vehicles that match the request options.
              #
              # @overload search_vehicles(request, options = nil)
              #   Pass arguments to `search_vehicles` via a request object, either of type
              #   {::Google::Maps::FleetEngine::V1::SearchVehiclesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Maps::FleetEngine::V1::SearchVehiclesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_vehicles(header: nil, parent: nil, pickup_point: nil, dropoff_point: nil, pickup_radius_meters: nil, count: nil, minimum_capacity: nil, trip_types: nil, maximum_staleness: nil, vehicle_types: nil, required_attributes: nil, required_one_of_attributes: nil, required_one_of_attribute_sets: nil, order_by: nil, include_back_to_back: nil, trip_id: nil, current_trips_present: nil, filter: nil)
              #   Pass arguments to `search_vehicles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
              #     The standard Fleet Engine request header.
              #   @param parent [::String]
              #     Required. Must be in the format `providers/{provider}`.
              #     The provider must be the Project ID (for example, `sample-cloud-project`)
              #     of the Google Cloud Project of which the service account making
              #     this call is a member.
              #   @param pickup_point [::Google::Maps::FleetEngine::V1::TerminalLocation, ::Hash]
              #     Required. The pickup point to search near.
              #   @param dropoff_point [::Google::Maps::FleetEngine::V1::TerminalLocation, ::Hash]
              #     The customer's intended dropoff location. The field is required if
              #     `trip_types` contains `TripType.SHARED`.
              #   @param pickup_radius_meters [::Integer]
              #     Required. Defines the vehicle search radius around the pickup point. Only
              #     vehicles within the search radius will be returned. Value must be between
              #     400 and 10000 meters (inclusive).
              #   @param count [::Integer]
              #     Required. Specifies the maximum number of vehicles to return. The value
              #     must be between 1 and 50 (inclusive).
              #   @param minimum_capacity [::Integer]
              #     Required. Specifies the number of passengers being considered for a trip.
              #     The value must be greater than or equal to one. The driver is not
              #     considered in the capacity value.
              #   @param trip_types [::Array<::Google::Maps::FleetEngine::V1::TripType>]
              #     Required. Represents the type of proposed trip. Must include exactly one
              #     type. `UNKNOWN_TRIP_TYPE` is not allowed. Restricts the search to only
              #     those vehicles that can support that trip type.
              #   @param maximum_staleness [::Google::Protobuf::Duration, ::Hash]
              #     Restricts the search to only those vehicles that have sent location updates
              #     to Fleet Engine within the specified duration. Stationary vehicles still
              #     transmitting their locations are not considered stale. If this field is not
              #     set, the server uses five minutes as the default value.
              #   @param vehicle_types [::Array<::Google::Maps::FleetEngine::V1::Vehicle::VehicleType, ::Hash>]
              #     Required. Restricts the search to vehicles with one of the specified types.
              #     At least one vehicle type must be specified. VehicleTypes with a category
              #     of `UNKNOWN` are not allowed.
              #   @param required_attributes [::Array<::Google::Maps::FleetEngine::V1::VehicleAttribute, ::Hash>]
              #     Callers can form complex logical operations using any combination of the
              #     `required_attributes`, `required_one_of_attributes`, and
              #     `required_one_of_attribute_sets` fields.
              #
              #     `required_attributes` is a list; `required_one_of_attributes` uses a
              #     message which allows a list of lists. In combination, the two fields allow
              #     the composition of this expression:
              #
              #     ```
              #     (required_attributes[0] AND required_attributes[1] AND ...)
              #     AND
              #     (required_one_of_attributes[0][0] OR required_one_of_attributes[0][1] OR
              #     ...)
              #     AND
              #     (required_one_of_attributes[1][0] OR required_one_of_attributes[1][1] OR
              #     ...)
              #     ```
              #
              #     Restricts the search to only those vehicles with the specified attributes.
              #     This field is a conjunction/AND operation. A max of 50 required_attributes
              #     is allowed. This matches the maximum number of attributes allowed on a
              #     vehicle.
              #   @param required_one_of_attributes [::Array<::Google::Maps::FleetEngine::V1::VehicleAttributeList, ::Hash>]
              #     Restricts the search to only those vehicles with at least one of
              #     the specified attributes in each `VehicleAttributeList`. Within each
              #     list, a vehicle must match at least one of the attributes. This field is an
              #     inclusive disjunction/OR operation in each `VehicleAttributeList` and a
              #     conjunction/AND operation across the collection of `VehicleAttributeList`.
              #   @param required_one_of_attribute_sets [::Array<::Google::Maps::FleetEngine::V1::VehicleAttributeList, ::Hash>]
              #     `required_one_of_attribute_sets` provides additional functionality.
              #
              #     Similar to `required_one_of_attributes`, `required_one_of_attribute_sets`
              #     uses a message which allows a list of lists, allowing expressions such as
              #     this one:
              #
              #     ```
              #     (required_attributes[0] AND required_attributes[1] AND ...)
              #     AND
              #     (
              #       (required_one_of_attribute_sets[0][0] AND
              #       required_one_of_attribute_sets[0][1] AND
              #       ...)
              #       OR
              #       (required_one_of_attribute_sets[1][0] AND
              #       required_one_of_attribute_sets[1][1] AND
              #       ...)
              #     )
              #     ```
              #
              #     Restricts the search to only those vehicles with all the attributes in a
              #     `VehicleAttributeList`. Within each list, a
              #     vehicle must match all of the attributes. This field is a conjunction/AND
              #     operation in each `VehicleAttributeList` and inclusive disjunction/OR
              #     operation across the collection of `VehicleAttributeList`.
              #   @param order_by [::Google::Maps::FleetEngine::V1::SearchVehiclesRequest::VehicleMatchOrder]
              #     Required. Specifies the desired ordering criterion for results.
              #   @param include_back_to_back [::Boolean]
              #     This indicates if vehicles with a single active trip are eligible for this
              #     search. This field is only used when `current_trips_present` is
              #     unspecified. When `current_trips_present` is unspecified  and  this field
              #     is `false`, vehicles with assigned trips are excluded from the search
              #     results. When `current_trips_present` is unspecified and this field is
              #     `true`, search results can include vehicles with one active trip that has a
              #     status of `ENROUTE_TO_DROPOFF`. When `current_trips_present` is specified,
              #     this field cannot be set to true.
              #
              #     The default value is `false`.
              #   @param trip_id [::String]
              #     Indicates the trip associated with this `SearchVehicleRequest`.
              #   @param current_trips_present [::Google::Maps::FleetEngine::V1::SearchVehiclesRequest::CurrentTripsPresent]
              #     This indicates if vehicles with active trips are eligible for this search.
              #     This must be set to something other than
              #     `CURRENT_TRIPS_PRESENT_UNSPECIFIED` if `trip_type` includes `SHARED`.
              #   @param filter [::String]
              #     Optional. A filter query to apply when searching vehicles. See
              #     http://aip.dev/160 for examples of the filter syntax.
              #
              #     This field is designed to replace the `required_attributes`,
              #     `required_one_of_attributes`, and `required_one_of_attributes_sets` fields.
              #     If a non-empty value is specified here, the following fields must be empty:
              #     `required_attributes`, `required_one_of_attributes`, and
              #     `required_one_of_attributes_sets`.
              #
              #     This filter functions as an AND clause with other constraints,
              #     such as `minimum_capacity` or `vehicle_types`.
              #
              #     Note that the only queries supported are on vehicle attributes (for
              #     example, `attributes.<key> = <value>` or `attributes.<key1> = <value1> AND
              #     attributes.<key2> = <value2>`). The maximum number of restrictions allowed
              #     in a filter query is 50.
              #
              #     Also, all attributes are stored as strings, so the only supported
              #     comparisons against attributes are string comparisons. In order to compare
              #     against number or boolean values, the values must be explicitly quoted to
              #     be treated as strings (for example, `attributes.<key> = "10"` or
              #     `attributes.<key> = "true"`).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Maps::FleetEngine::V1::SearchVehiclesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Maps::FleetEngine::V1::SearchVehiclesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/maps/fleet_engine/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Maps::FleetEngine::V1::SearchVehiclesRequest.new
              #
              #   # Call the search_vehicles method.
              #   result = client.search_vehicles request
              #
              #   # The returned object is of type Google::Maps::FleetEngine::V1::SearchVehiclesResponse.
              #   p result
              #
              def search_vehicles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::SearchVehiclesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_vehicles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Maps::FleetEngine::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_vehicles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_vehicles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @vehicle_service_stub.search_vehicles request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the VehicleService REST API.
              #
              # This class represents the configuration for VehicleService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_vehicle to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_vehicle.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Maps::FleetEngine::V1::VehicleService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_vehicle.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "fleetengine.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the VehicleService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_vehicle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_vehicle
                  ##
                  # RPC-specific configuration for `get_vehicle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_vehicle
                  ##
                  # RPC-specific configuration for `delete_vehicle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_vehicle
                  ##
                  # RPC-specific configuration for `update_vehicle`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_vehicle
                  ##
                  # RPC-specific configuration for `update_vehicle_attributes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_vehicle_attributes
                  ##
                  # RPC-specific configuration for `list_vehicles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_vehicles
                  ##
                  # RPC-specific configuration for `search_vehicles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_vehicles

                  # @private
                  def initialize parent_rpcs = nil
                    create_vehicle_config = parent_rpcs.create_vehicle if parent_rpcs.respond_to? :create_vehicle
                    @create_vehicle = ::Gapic::Config::Method.new create_vehicle_config
                    get_vehicle_config = parent_rpcs.get_vehicle if parent_rpcs.respond_to? :get_vehicle
                    @get_vehicle = ::Gapic::Config::Method.new get_vehicle_config
                    delete_vehicle_config = parent_rpcs.delete_vehicle if parent_rpcs.respond_to? :delete_vehicle
                    @delete_vehicle = ::Gapic::Config::Method.new delete_vehicle_config
                    update_vehicle_config = parent_rpcs.update_vehicle if parent_rpcs.respond_to? :update_vehicle
                    @update_vehicle = ::Gapic::Config::Method.new update_vehicle_config
                    update_vehicle_attributes_config = parent_rpcs.update_vehicle_attributes if parent_rpcs.respond_to? :update_vehicle_attributes
                    @update_vehicle_attributes = ::Gapic::Config::Method.new update_vehicle_attributes_config
                    list_vehicles_config = parent_rpcs.list_vehicles if parent_rpcs.respond_to? :list_vehicles
                    @list_vehicles = ::Gapic::Config::Method.new list_vehicles_config
                    search_vehicles_config = parent_rpcs.search_vehicles if parent_rpcs.respond_to? :search_vehicles
                    @search_vehicles = ::Gapic::Config::Method.new search_vehicles_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
