# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/maps/fleetengine/v1/trip_api_pb"

module Google
  module Maps
    module FleetEngine
      module V1
        module TripService
          ##
          # Client for the TripService service.
          #
          # Trip management service.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "fleetengine.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :trip_service_stub

            ##
            # Configure the TripService Client class.
            #
            # See {::Google::Maps::FleetEngine::V1::TripService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all TripService clients
            #   ::Google::Maps::FleetEngine::V1::TripService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Maps", "FleetEngine", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_trip.timeout = 15.0
                default_config.rpcs.create_trip.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_trip.timeout = 15.0
                default_config.rpcs.get_trip.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.search_trips.timeout = 15.0
                default_config.rpcs.search_trips.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_trip.timeout = 15.0
                default_config.rpcs.update_trip.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the TripService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Maps::FleetEngine::V1::TripService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @trip_service_stub.universe_domain
            end

            ##
            # Create a new TripService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Maps::FleetEngine::V1::TripService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the TripService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/maps/fleetengine/v1/trip_api_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @trip_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Maps::FleetEngine::V1::TripService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @trip_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @trip_service_stub.logger
            end

            # Service calls

            ##
            # Creates a trip in the Fleet Engine and returns the new trip.
            #
            # @overload create_trip(request, options = nil)
            #   Pass arguments to `create_trip` via a request object, either of type
            #   {::Google::Maps::FleetEngine::V1::CreateTripRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Maps::FleetEngine::V1::CreateTripRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_trip(header: nil, parent: nil, trip_id: nil, trip: nil)
            #   Pass arguments to `create_trip` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
            #     The standard Fleet Engine request header.
            #   @param parent [::String]
            #     Required. Must be in the format `providers/{provider}`.
            #     The provider must be the Project ID (for example, `sample-cloud-project`)
            #     of the Google Cloud Project of which the service account making
            #     this call is a member.
            #   @param trip_id [::String]
            #     Required. Unique Trip ID.
            #     Subject to the following restrictions:
            #
            #     * Must be a valid Unicode string.
            #     * Limited to a maximum length of 64 characters.
            #     * Normalized according to [Unicode Normalization Form C]
            #     (http://www.unicode.org/reports/tr15/).
            #     * May not contain any of the following ASCII characters: '/', ':', '?',
            #     ',', or '#'.
            #   @param trip [::Google::Maps::FleetEngine::V1::Trip, ::Hash]
            #     Required. Trip entity to create.
            #
            #     When creating a Trip, the following fields are required:
            #
            #     * `trip_type`
            #     * `pickup_point`
            #
            #     The following fields are used if you provide them:
            #
            #     * `number_of_passengers`
            #     * `vehicle_id`
            #     * `dropoff_point`
            #     * `intermediate_destinations`
            #     * `vehicle_waypoints`
            #
            #     All other Trip fields are ignored. For example, all trips start with a
            #     `trip_status` of `NEW` even if you pass in a `trip_status` of `CANCELED` in
            #     the creation request.
            #
            #     Only `EXCLUSIVE` trips support `intermediate_destinations`.
            #
            #     When `vehicle_id` is set for a shared trip, you must supply
            #     the list of `Trip.vehicle_waypoints` to specify the order of the remaining
            #     waypoints for the vehicle, otherwise the waypoint order will be
            #     undetermined.
            #
            #     When you specify `Trip.vehicle_waypoints`, the list must contain all
            #     the remaining waypoints of the vehicle's trips, with no extra waypoints.
            #     You must order these waypoints such that for a given trip, the pickup
            #     point is before intermediate destinations, and all intermediate
            #     destinations come before the drop-off point. An `EXCLUSIVE` trip's
            #     waypoints must not interleave with any other trips.
            #
            #     The `trip_id`, `waypoint_type` and `location` fields are used, and all
            #     other TripWaypoint fields in `vehicle_waypoints` are ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Maps::FleetEngine::V1::Trip]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Maps::FleetEngine::V1::Trip]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/maps/fleet_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Maps::FleetEngine::V1::CreateTripRequest.new
            #
            #   # Call the create_trip method.
            #   result = client.create_trip request
            #
            #   # The returned object is of type Google::Maps::FleetEngine::V1::Trip.
            #   p result
            #
            def create_trip request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::CreateTripRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_trip.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Maps::FleetEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent &&
                 %r{^providers/[^/]+/?$}.match?(request.parent)
                header_params["provider_id"] = request.parent
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_trip.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_trip.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @trip_service_stub.call_rpc :create_trip, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get information about a single trip.
            #
            # @overload get_trip(request, options = nil)
            #   Pass arguments to `get_trip` via a request object, either of type
            #   {::Google::Maps::FleetEngine::V1::GetTripRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Maps::FleetEngine::V1::GetTripRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_trip(header: nil, name: nil, view: nil, current_route_segment_version: nil, remaining_waypoints_version: nil, route_format_type: nil, current_route_segment_traffic_version: nil, remaining_waypoints_route_version: nil)
            #   Pass arguments to `get_trip` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
            #     The standard Fleet Engine request header.
            #   @param name [::String]
            #     Required. Must be in the format `providers/{provider}/trips/{trip}`.
            #     The provider must be the Project ID (for example, `sample-cloud-project`)
            #     of the Google Cloud Project of which the service account making
            #     this call is a member.
            #   @param view [::Google::Maps::FleetEngine::V1::TripView]
            #     The subset of Trip fields that should be returned and their interpretation.
            #   @param current_route_segment_version [::Google::Protobuf::Timestamp, ::Hash]
            #     Indicates the minimum timestamp (exclusive) for which `Trip.route` or
            #     `Trip.current_route_segment` data are retrieved. If route data are
            #     unchanged since this timestamp, the route field is not set in the response.
            #     If a minimum is unspecified, the route data are always retrieved.
            #   @param remaining_waypoints_version [::Google::Protobuf::Timestamp, ::Hash]
            #     Deprecated: `Trip.remaining_waypoints` are always retrieved. Use
            #     `remaining_waypoints_route_version` to control when
            #     `Trip.remaining_waypoints.traffic_to_waypoint` and
            #     `Trip.remaining_waypoints.path_to_waypoint` data are retrieved.
            #   @param route_format_type [::Google::Maps::FleetEngine::V1::PolylineFormatType]
            #     The returned current route format, `LAT_LNG_LIST_TYPE` (in `Trip.route`),
            #     or `ENCODED_POLYLINE_TYPE` (in `Trip.current_route_segment`). The default
            #     is `LAT_LNG_LIST_TYPE`.
            #   @param current_route_segment_traffic_version [::Google::Protobuf::Timestamp, ::Hash]
            #     Indicates the minimum timestamp (exclusive) for which
            #     `Trip.current_route_segment_traffic` is retrieved. If traffic data are
            #     unchanged since this timestamp, the `current_route_segment_traffic` field
            #     is not set in the response. If a minimum is unspecified, the traffic data
            #     are always retrieved. Note that traffic is only available for On-Demand
            #     Rides and Deliveries Solution customers.
            #   @param remaining_waypoints_route_version [::Google::Protobuf::Timestamp, ::Hash]
            #     Indicates the minimum timestamp (exclusive) for which
            #     `Trip.remaining_waypoints.traffic_to_waypoint` and
            #     `Trip.remaining_waypoints.path_to_waypoint` data are retrieved. If data are
            #     unchanged since this timestamp, the fields above are
            #     not set in the response. If `remaining_waypoints_route_version` is
            #     unspecified, traffic and path are always retrieved.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Maps::FleetEngine::V1::Trip]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Maps::FleetEngine::V1::Trip]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/maps/fleet_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Maps::FleetEngine::V1::GetTripRequest.new
            #
            #   # Call the get_trip method.
            #   result = client.get_trip request
            #
            #   # The returned object is of type Google::Maps::FleetEngine::V1::Trip.
            #   p result
            #
            def get_trip request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::GetTripRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_trip.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Maps::FleetEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name &&
                 %r{^providers/[^/]+/?$}.match?(request.name)
                header_params["provider_id"] = request.name
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_trip.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_trip.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @trip_service_stub.call_rpc :get_trip, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Trip.
            #
            # Returns FAILED_PRECONDITION if the Trip is active and assigned to a
            # vehicle.
            #
            # @overload delete_trip(request, options = nil)
            #   Pass arguments to `delete_trip` via a request object, either of type
            #   {::Google::Maps::FleetEngine::V1::DeleteTripRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Maps::FleetEngine::V1::DeleteTripRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_trip(header: nil, name: nil)
            #   Pass arguments to `delete_trip` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
            #     Optional. The standard Fleet Engine request header.
            #   @param name [::String]
            #     Required. Must be in the format `providers/{provider}/trips/{trip}`.
            #     The provider must be the Project ID (for example, `sample-cloud-project`)
            #     of the Google Cloud Project of which the service account making
            #     this call is a member.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/maps/fleet_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Maps::FleetEngine::V1::DeleteTripRequest.new
            #
            #   # Call the delete_trip method.
            #   result = client.delete_trip request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_trip request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::DeleteTripRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_trip.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Maps::FleetEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name &&
                 %r{^providers/[^/]+/?$}.match?(request.name)
                header_params["provider_id"] = request.name
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_trip.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_trip.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @trip_service_stub.call_rpc :delete_trip, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Report billable trip usage.
            #
            # @overload report_billable_trip(request, options = nil)
            #   Pass arguments to `report_billable_trip` via a request object, either of type
            #   {::Google::Maps::FleetEngine::V1::ReportBillableTripRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Maps::FleetEngine::V1::ReportBillableTripRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload report_billable_trip(name: nil, country_code: nil, platform: nil, related_ids: nil, solution_type: nil)
            #   Pass arguments to `report_billable_trip` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Must be in the format
            #     `providers/{provider}/billableTrips/{billable_trip}`. The
            #     provider must be the Project ID (for example, `sample-cloud-project`) of
            #     the Google Cloud Project of which the service account making this call is a
            #     member.
            #   @param country_code [::String]
            #     Required. Two letter country code of the country where the trip takes
            #     place. Price is defined according to country code.
            #   @param platform [::Google::Maps::FleetEngine::V1::BillingPlatformIdentifier]
            #     The platform upon which the request was issued.
            #   @param related_ids [::Array<::String>]
            #     The identifiers that are directly related to the trip being reported. These
            #     are usually IDs (for example, session IDs) of pre-booking operations done
            #     before the trip ID is available. The number of `related_ids` is
            #     limited to 50.
            #   @param solution_type [::Google::Maps::FleetEngine::V1::ReportBillableTripRequest::SolutionType]
            #     The type of GMP product solution (for example,
            #     `ON_DEMAND_RIDESHARING_AND_DELIVERIES`) used for the reported trip.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/maps/fleet_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Maps::FleetEngine::V1::ReportBillableTripRequest.new
            #
            #   # Call the report_billable_trip method.
            #   result = client.report_billable_trip request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def report_billable_trip request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::ReportBillableTripRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.report_billable_trip.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Maps::FleetEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name &&
                 %r{^providers/[^/]+/?$}.match?(request.name)
                header_params["provider_id"] = request.name
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.report_billable_trip.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.report_billable_trip.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @trip_service_stub.call_rpc :report_billable_trip, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get all the trips for a specific vehicle.
            #
            # @overload search_trips(request, options = nil)
            #   Pass arguments to `search_trips` via a request object, either of type
            #   {::Google::Maps::FleetEngine::V1::SearchTripsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Maps::FleetEngine::V1::SearchTripsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload search_trips(header: nil, parent: nil, vehicle_id: nil, active_trips_only: nil, page_size: nil, page_token: nil, minimum_staleness: nil)
            #   Pass arguments to `search_trips` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
            #     The standard Fleet Engine request header.
            #   @param parent [::String]
            #     Required. Must be in the format `providers/{provider}`.
            #     The provider must be the Project ID (for example, `sample-cloud-project`)
            #     of the Google Cloud Project of which the service account making
            #     this call is a member.
            #   @param vehicle_id [::String]
            #     The vehicle associated with the trips in the request. If unspecified, the
            #     returned trips do not contain:
            #
            #     * `current_route_segment`
            #     * `remaining_waypoints`
            #     * `remaining_distance_meters`
            #     * `eta_to_first_waypoint`
            #   @param active_trips_only [::Boolean]
            #     If set to true, the response includes Trips that influence a driver's
            #     route.
            #   @param page_size [::Integer]
            #     If not set, the server decides the number of results to return.
            #   @param page_token [::String]
            #     Set this to a value previously returned in the `SearchTripsResponse` to
            #     continue from previous results.
            #   @param minimum_staleness [::Google::Protobuf::Duration, ::Hash]
            #     If specified, returns the trips that have not been updated after the time
            #     `(current - minimum_staleness)`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Maps::FleetEngine::V1::Trip>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Maps::FleetEngine::V1::Trip>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/maps/fleet_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Maps::FleetEngine::V1::SearchTripsRequest.new
            #
            #   # Call the search_trips method.
            #   result = client.search_trips request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Maps::FleetEngine::V1::Trip.
            #     p item
            #   end
            #
            def search_trips request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::SearchTripsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.search_trips.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Maps::FleetEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent &&
                 %r{^providers/[^/]+/?$}.match?(request.parent)
                header_params["provider_id"] = request.parent
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.search_trips.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.search_trips.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @trip_service_stub.call_rpc :search_trips, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @trip_service_stub, :search_trips, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates trip data.
            #
            # @overload update_trip(request, options = nil)
            #   Pass arguments to `update_trip` via a request object, either of type
            #   {::Google::Maps::FleetEngine::V1::UpdateTripRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Maps::FleetEngine::V1::UpdateTripRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_trip(header: nil, name: nil, trip: nil, update_mask: nil)
            #   Pass arguments to `update_trip` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param header [::Google::Maps::FleetEngine::V1::RequestHeader, ::Hash]
            #     The standard Fleet Engine request header.
            #   @param name [::String]
            #     Required. Must be in the format
            #     `providers/{provider}/trips/{trip}`. The provider must
            #     be the Project ID (for example, `sample-consumer-project`) of the Google
            #     Cloud Project of which the service account making this call is a member.
            #   @param trip [::Google::Maps::FleetEngine::V1::Trip, ::Hash]
            #     Required. The Trip associated with the update.
            #
            #     The following fields are maintained by the Fleet Engine. Do not update
            #     them using Trip.update.
            #
            #     * `current_route_segment`
            #     * `current_route_segment_end_point`
            #     * `current_route_segment_traffic`
            #     * `current_route_segment_traffic_version`
            #     * `current_route_segment_version`
            #     * `dropoff_time`
            #     * `eta_to_next_waypoint`
            #     * `intermediate_destinations_version`
            #     * `last_location`
            #     * `name`
            #     * `number_of_passengers`
            #     * `pickup_time`
            #     * `remaining_distance_meters`
            #     * `remaining_time_to_first_waypoint`
            #     * `remaining_waypoints`
            #     * `remaining_waypoints_version`
            #     * `route`
            #
            #     When you update the `Trip.vehicle_id` for a shared trip, you must supply
            #     the list of `Trip.vehicle_waypoints` to specify the order of the remaining
            #     waypoints, otherwise the order will be undetermined.
            #
            #     When you specify `Trip.vehicle_waypoints`, the list must contain all
            #     the remaining waypoints of the vehicle's trips, with no extra waypoints.
            #     You must order these waypoints such that for a given trip, the pickup
            #     point is before intermediate destinations, and all intermediate
            #     destinations come before the drop-off point. An `EXCLUSIVE` trip's
            #     waypoints must not interleave with any other trips.
            #     The `trip_id`, `waypoint_type` and `location` fields are used, and all
            #     other TripWaypoint fields in `vehicle_waypoints` are ignored.
            #
            #     To avoid a race condition for trips with multiple destinations, you
            #     should provide `Trip.intermediate_destinations_version` when updating
            #     the trip status to `ENROUTE_TO_INTERMEDIATE_DESTINATION`. The
            #     `Trip.intermediate_destinations_version` passed must be consistent with
            #     Fleet Engine's version. If it isn't, the request fails.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. The field mask indicating which fields in Trip to update.
            #     The `update_mask` must contain at least one field.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Maps::FleetEngine::V1::Trip]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Maps::FleetEngine::V1::Trip]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/maps/fleet_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Maps::FleetEngine::V1::TripService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Maps::FleetEngine::V1::UpdateTripRequest.new
            #
            #   # Call the update_trip method.
            #   result = client.update_trip request
            #
            #   # The returned object is of type Google::Maps::FleetEngine::V1::Trip.
            #   p result
            #
            def update_trip request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::V1::UpdateTripRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_trip.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Maps::FleetEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name &&
                 %r{^providers/[^/]+/?$}.match?(request.name)
                header_params["provider_id"] = request.name
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_trip.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_trip.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @trip_service_stub.call_rpc :update_trip, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the TripService API.
            #
            # This class represents the configuration for TripService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Maps::FleetEngine::V1::TripService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_trip to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Maps::FleetEngine::V1::TripService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_trip.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Maps::FleetEngine::V1::TripService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_trip.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Maps::FleetEngine::V1::TripService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "fleetengine.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the TripService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_trip`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_trip
                ##
                # RPC-specific configuration for `get_trip`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_trip
                ##
                # RPC-specific configuration for `delete_trip`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_trip
                ##
                # RPC-specific configuration for `report_billable_trip`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :report_billable_trip
                ##
                # RPC-specific configuration for `search_trips`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_trips
                ##
                # RPC-specific configuration for `update_trip`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_trip

                # @private
                def initialize parent_rpcs = nil
                  create_trip_config = parent_rpcs.create_trip if parent_rpcs.respond_to? :create_trip
                  @create_trip = ::Gapic::Config::Method.new create_trip_config
                  get_trip_config = parent_rpcs.get_trip if parent_rpcs.respond_to? :get_trip
                  @get_trip = ::Gapic::Config::Method.new get_trip_config
                  delete_trip_config = parent_rpcs.delete_trip if parent_rpcs.respond_to? :delete_trip
                  @delete_trip = ::Gapic::Config::Method.new delete_trip_config
                  report_billable_trip_config = parent_rpcs.report_billable_trip if parent_rpcs.respond_to? :report_billable_trip
                  @report_billable_trip = ::Gapic::Config::Method.new report_billable_trip_config
                  search_trips_config = parent_rpcs.search_trips if parent_rpcs.respond_to? :search_trips
                  @search_trips = ::Gapic::Config::Method.new search_trips_config
                  update_trip_config = parent_rpcs.update_trip if parent_rpcs.respond_to? :update_trip
                  @update_trip = ::Gapic::Config::Method.new update_trip_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
