# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Maps
    module FleetEngine
      module Delivery
        module V1
          # The `TaskTrackingInfo` message. The message contains task tracking
          # information which will be used for display. If a tracking ID is associated
          # with multiple Tasks, Fleet Engine uses a heuristic to decide which Task's
          # TaskTrackingInfo to select.
          # @!attribute [rw] name
          #   @return [::String]
          #     Must be in the format `providers/{provider}/taskTrackingInfo/{tracking}`,
          #     where `tracking` represents the tracking ID.
          # @!attribute [rw] tracking_id
          #   @return [::String]
          #     Immutable. The tracking ID of a Task.
          #     * Must be a valid Unicode string.
          #     * Limited to a maximum length of 64 characters.
          #     * Normalized according to [Unicode Normalization Form C]
          #     (http://www.unicode.org/reports/tr15/).
          #     * May not contain any of the following ASCII characters: '/', ':', '?',
          #     ',', or '#'.
          # @!attribute [rw] vehicle_location
          #   @return [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicleLocation]
          #     The vehicle's last location.
          # @!attribute [rw] route_polyline_points
          #   @return [::Array<::Google::Type::LatLng>]
          #     A list of points which when connected forms a polyline of the vehicle's
          #     expected route to the location of this task.
          # @!attribute [rw] remaining_stop_count
          #   @return [::Google::Protobuf::Int32Value]
          #     Indicates the number of stops the vehicle remaining until the task stop is
          #     reached, including the task stop. For example, if the vehicle's next stop
          #     is the task stop, the value will be 1.
          # @!attribute [rw] remaining_driving_distance_meters
          #   @return [::Google::Protobuf::Int32Value]
          #     The total remaining distance in meters to the `VehicleStop` of interest.
          # @!attribute [rw] estimated_arrival_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp that indicates the estimated arrival time to the stop
          #     location.
          # @!attribute [rw] estimated_task_completion_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp that indicates the estimated completion time of a Task.
          # @!attribute [rw] state
          #   @return [::Google::Maps::FleetEngine::Delivery::V1::Task::State]
          #     The current execution state of the Task.
          # @!attribute [rw] task_outcome
          #   @return [::Google::Maps::FleetEngine::Delivery::V1::Task::TaskOutcome]
          #     The outcome of attempting to execute a Task.
          # @!attribute [rw] task_outcome_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The timestamp that indicates when the Task's outcome was set by the
          #     provider.
          # @!attribute [rw] planned_location
          #   @return [::Google::Maps::FleetEngine::Delivery::V1::LocationInfo]
          #     Immutable. The location where the Task will be completed.
          # @!attribute [rw] target_time_window
          #   @return [::Google::Maps::FleetEngine::Delivery::V1::TimeWindow]
          #     The time window during which the task should be completed.
          # @!attribute [rw] attributes
          #   @return [::Array<::Google::Maps::FleetEngine::Delivery::V1::TaskAttribute>]
          #     The custom attributes set on the task.
          class TaskTrackingInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
