# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/maps/fleetengine/delivery/v1/delivery_api_pb"
require "google/maps/fleet_engine/delivery/v1/delivery_service/rest/service_stub"

module Google
  module Maps
    module FleetEngine
      module Delivery
        module V1
          module DeliveryService
            module Rest
              ##
              # REST client for the DeliveryService service.
              #
              # The Last Mile Delivery service.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "fleetengine.$UNIVERSE_DOMAIN$"

                include Paths

                # @private
                attr_reader :delivery_service_stub

                ##
                # Configure the DeliveryService Client class.
                #
                # See {::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all DeliveryService clients
                #   ::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Maps", "FleetEngine", "Delivery", "V1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.create_delivery_vehicle.timeout = 60.0
                    default_config.rpcs.create_delivery_vehicle.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_delivery_vehicle.timeout = 60.0
                    default_config.rpcs.get_delivery_vehicle.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.update_delivery_vehicle.timeout = 60.0
                    default_config.rpcs.update_delivery_vehicle.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.batch_create_tasks.timeout = 60.0
                    default_config.rpcs.batch_create_tasks.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.create_task.timeout = 60.0
                    default_config.rpcs.create_task.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_task.timeout = 60.0
                    default_config.rpcs.get_task.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.update_task.timeout = 60.0
                    default_config.rpcs.update_task.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_tasks.timeout = 60.0
                    default_config.rpcs.list_tasks.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.get_task_tracking_info.timeout = 60.0
                    default_config.rpcs.get_task_tracking_info.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config.rpcs.list_delivery_vehicles.timeout = 60.0
                    default_config.rpcs.list_delivery_vehicles.retry_policy = {
                      initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the DeliveryService Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @delivery_service_stub.universe_domain
                end

                ##
                # Create a new DeliveryService REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the DeliveryService client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @delivery_service_stub = ::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @delivery_service_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @delivery_service_stub.logger
                end

                # Service calls

                ##
                # Creates and returns a new `DeliveryVehicle`.
                #
                # @overload create_delivery_vehicle(request, options = nil)
                #   Pass arguments to `create_delivery_vehicle` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::CreateDeliveryVehicleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::CreateDeliveryVehicleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_delivery_vehicle(header: nil, parent: nil, delivery_vehicle_id: nil, delivery_vehicle: nil)
                #   Pass arguments to `create_delivery_vehicle` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param parent [::String]
                #     Required. Must be in the format `providers/{provider}`. The provider must
                #     be the Google Cloud Project ID. For example, `sample-cloud-project`.
                #   @param delivery_vehicle_id [::String]
                #     Required. The Delivery Vehicle ID must be unique and subject to the
                #     following restrictions:
                #
                #     * Must be a valid Unicode string.
                #     * Limited to a maximum length of 64 characters.
                #     * Normalized according to [Unicode Normalization Form C]
                #     (http://www.unicode.org/reports/tr15/).
                #     * May not contain any of the following ASCII characters: '/', ':', '?',
                #     ',', or '#'.
                #   @param delivery_vehicle [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle, ::Hash]
                #     Required. The `DeliveryVehicle` entity to create. When creating a new
                #     delivery vehicle, you may set the following optional fields:
                #
                #     * type
                #     * last_location
                #     * attributes
                #
                #     Note: The DeliveryVehicle's `name` field is ignored. All other
                #     DeliveryVehicle fields must not be set; otherwise, an error is returned.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::CreateDeliveryVehicleRequest.new
                #
                #   # Call the create_delivery_vehicle method.
                #   result = client.create_delivery_vehicle request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle.
                #   p result
                #
                def create_delivery_vehicle request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::CreateDeliveryVehicleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_delivery_vehicle.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_delivery_vehicle.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_delivery_vehicle.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.create_delivery_vehicle request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns the specified `DeliveryVehicle` instance.
                #
                # @overload get_delivery_vehicle(request, options = nil)
                #   Pass arguments to `get_delivery_vehicle` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::GetDeliveryVehicleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::GetDeliveryVehicleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_delivery_vehicle(header: nil, name: nil)
                #   Pass arguments to `get_delivery_vehicle` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param name [::String]
                #     Required. Must be in the format
                #     `providers/{provider}/deliveryVehicles/{delivery_vehicle}`.
                #     The `provider` must be the Google Cloud Project ID. For example,
                #     `sample-cloud-project`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::GetDeliveryVehicleRequest.new
                #
                #   # Call the get_delivery_vehicle method.
                #   result = client.get_delivery_vehicle request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle.
                #   p result
                #
                def get_delivery_vehicle request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::GetDeliveryVehicleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_delivery_vehicle.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_delivery_vehicle.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_delivery_vehicle.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.get_delivery_vehicle request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a DeliveryVehicle from the Fleet Engine.
                #
                # Returns FAILED_PRECONDITION if the DeliveryVehicle has OPEN Tasks
                # assigned to it.
                #
                # @overload delete_delivery_vehicle(request, options = nil)
                #   Pass arguments to `delete_delivery_vehicle` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::DeleteDeliveryVehicleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::DeleteDeliveryVehicleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_delivery_vehicle(header: nil, name: nil)
                #   Pass arguments to `delete_delivery_vehicle` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param name [::String]
                #     Required. Must be in the format
                #     `providers/{provider}/deliveryVehicles/{delivery_vehicle}`.
                #     The `provider` must be the Google Cloud Project ID. For example,
                #     `sample-cloud-project`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::DeleteDeliveryVehicleRequest.new
                #
                #   # Call the delete_delivery_vehicle method.
                #   result = client.delete_delivery_vehicle request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_delivery_vehicle request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::DeleteDeliveryVehicleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_delivery_vehicle.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_delivery_vehicle.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_delivery_vehicle.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.delete_delivery_vehicle request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Writes updated `DeliveryVehicle` data to Fleet Engine, and assigns
                # `Tasks` to the `DeliveryVehicle`. You cannot update the name of the
                # `DeliveryVehicle`. You *can* update `remaining_vehicle_journey_segments`,
                # but it must contain all of the `VehicleJourneySegment`s to be persisted on
                # the `DeliveryVehicle`. The `task_id`s are retrieved from
                # `remaining_vehicle_journey_segments`, and their corresponding `Tasks` are
                # assigned to the `DeliveryVehicle` if they have not yet been assigned.
                #
                # @overload update_delivery_vehicle(request, options = nil)
                #   Pass arguments to `update_delivery_vehicle` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::UpdateDeliveryVehicleRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::UpdateDeliveryVehicleRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_delivery_vehicle(header: nil, delivery_vehicle: nil, update_mask: nil)
                #   Pass arguments to `update_delivery_vehicle` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param delivery_vehicle [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle, ::Hash]
                #     Required. The `DeliveryVehicle` entity update to apply.
                #     Note: You cannot update the name of the `DeliveryVehicle`.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. A field mask that indicates which `DeliveryVehicle` fields to
                #     update. Note that the update_mask must contain at least one field.
                #
                #     This is a comma-separated list of fully qualified names of fields. Example:
                #     `"remaining_vehicle_journey_segments"`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::UpdateDeliveryVehicleRequest.new
                #
                #   # Call the update_delivery_vehicle method.
                #   result = client.update_delivery_vehicle request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle.
                #   p result
                #
                def update_delivery_vehicle request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::UpdateDeliveryVehicleRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_delivery_vehicle.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_delivery_vehicle.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_delivery_vehicle.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.update_delivery_vehicle request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates and returns a batch of new `Task` objects.
                #
                # @overload batch_create_tasks(request, options = nil)
                #   Pass arguments to `batch_create_tasks` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload batch_create_tasks(header: nil, parent: nil, requests: nil)
                #   Pass arguments to `batch_create_tasks` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #     Note: If you set this field, then the header field in the
                #     `CreateTaskRequest` messages must either be empty, or it must match this
                #     field.
                #   @param parent [::String]
                #     Required. The parent resource shared by all tasks. This value must be in
                #     the format `providers/{provider}`. The `provider` must be the Google Cloud
                #     Project ID. For example, `sample-cloud-project`. The parent field in the
                #     `CreateTaskRequest` messages must either  be empty, or it must match this
                #     field.
                #   @param requests [::Array<::Google::Maps::FleetEngine::Delivery::V1::CreateTaskRequest, ::Hash>]
                #     Required. The request message that specifies the resources to create.
                #     Note: You can create a maximum of 500 tasks in a batch.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksResponse]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksResponse]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksRequest.new
                #
                #   # Call the batch_create_tasks method.
                #   result = client.batch_create_tasks request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksResponse.
                #   p result
                #
                def batch_create_tasks request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::BatchCreateTasksRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.batch_create_tasks.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.batch_create_tasks.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.batch_create_tasks.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.batch_create_tasks request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates and returns a new `Task` object.
                #
                # @overload create_task(request, options = nil)
                #   Pass arguments to `create_task` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::CreateTaskRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::CreateTaskRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_task(header: nil, parent: nil, task_id: nil, task: nil)
                #   Pass arguments to `create_task` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param parent [::String]
                #     Required. Must be in the format `providers/{provider}`. The `provider` must
                #     be the Google Cloud Project ID. For example, `sample-cloud-project`.
                #   @param task_id [::String]
                #     Required. The Task ID must be unique, but it should be not a shipment
                #     tracking ID. To store a shipment tracking ID, use the `tracking_id` field.
                #     Note that multiple tasks can have the same `tracking_id`. Task IDs are
                #     subject to the following restrictions:
                #
                #     * Must be a valid Unicode string.
                #     * Limited to a maximum length of 64 characters.
                #     * Normalized according to [Unicode Normalization Form C]
                #     (http://www.unicode.org/reports/tr15/).
                #     * May not contain any of the following ASCII characters: '/', ':', '?',
                #     ',', or '#'.
                #   @param task [::Google::Maps::FleetEngine::Delivery::V1::Task, ::Hash]
                #     Required. The Task entity to create.
                #     When creating a Task, the following fields are required:
                #
                #     * `type`
                #     * `state` (must be set to `OPEN`)
                #     * `tracking_id` (must not be set for `UNAVAILABLE` or `SCHEDULED_STOP`
                #     tasks, but required for all other task types)
                #     * `planned_location` (optional for `UNAVAILABLE` tasks)
                #     * `task_duration`
                #
                #     The following fields can be optionally set:
                #
                #     * `target_time_window`
                #     * `task_tracking_view_config`
                #     * `attributes`
                #
                #     Note: The Task's `name` field is ignored. All other Task fields must not be
                #     set; otherwise, an error is returned.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::Task]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::Task]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::CreateTaskRequest.new
                #
                #   # Call the create_task method.
                #   result = client.create_task request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::Task.
                #   p result
                #
                def create_task request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::CreateTaskRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_task.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_task.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_task.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.create_task request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets information about a `Task`.
                #
                # @overload get_task(request, options = nil)
                #   Pass arguments to `get_task` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::GetTaskRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::GetTaskRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_task(header: nil, name: nil)
                #   Pass arguments to `get_task` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param name [::String]
                #     Required. Must be in the format `providers/{provider}/tasks/{task}`. The
                #     `provider` must be the Google Cloud Project ID. For example,
                #     `sample-cloud-project`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::Task]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::Task]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::GetTaskRequest.new
                #
                #   # Call the get_task method.
                #   result = client.get_task request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::Task.
                #   p result
                #
                def get_task request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::GetTaskRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_task.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_task.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_task.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.get_task request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes a single Task.
                #
                # Returns FAILED_PRECONDITION if the Task is OPEN and assigned to a
                # DeliveryVehicle.
                #
                # @overload delete_task(request, options = nil)
                #   Pass arguments to `delete_task` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::DeleteTaskRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::DeleteTaskRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_task(header: nil, name: nil)
                #   Pass arguments to `delete_task` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param name [::String]
                #     Required. Must be in the format `providers/{provider}/tasks/{task}`. The
                #     `provider` must be the Google Cloud Project ID. For example,
                #     `sample-cloud-project`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Protobuf::Empty]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Protobuf::Empty]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::DeleteTaskRequest.new
                #
                #   # Call the delete_task method.
                #   result = client.delete_task request
                #
                #   # The returned object is of type Google::Protobuf::Empty.
                #   p result
                #
                def delete_task request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::DeleteTaskRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_task.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_task.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_task.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.delete_task request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Updates `Task` data.
                #
                # @overload update_task(request, options = nil)
                #   Pass arguments to `update_task` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::UpdateTaskRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::UpdateTaskRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload update_task(header: nil, task: nil, update_mask: nil)
                #   Pass arguments to `update_task` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param task [::Google::Maps::FleetEngine::Delivery::V1::Task, ::Hash]
                #     Required. The Task associated with the update.
                #     The following fields are maintained by Fleet Engine. Do not update
                #     them using `Task.update`.
                #
                #       * `last_location`.
                #       * `last_location_snappable`.
                #       * `name`.
                #       * `remaining_vehicle_journey_segments`.
                #       * `task_outcome_location_source`.
                #
                #     Note: You cannot change the value of `task_outcome` once you set it.
                #
                #     If the Task has been assigned to a delivery vehicle, then don't set the
                #     Task state to CLOSED using `Task.update`. Instead, remove the `VehicleStop`
                #     that contains the Task from the delivery vehicle, which automatically sets
                #     the Task state to CLOSED.
                #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
                #     Required. The field mask that indicates which Task fields to update.
                #     Note: The `update_mask` must contain at least one field.
                #
                #     This is a comma-separated list of fully qualified names of fields. Example:
                #     `"task_outcome,task_outcome_time,task_outcome_location"`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::Task]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::Task]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::UpdateTaskRequest.new
                #
                #   # Call the update_task method.
                #   result = client.update_task request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::Task.
                #   p result
                #
                def update_task request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::UpdateTaskRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.update_task.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.update_task.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.update_task.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.update_task request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets all `Task`s that meet the specified filtering criteria.
                #
                # @overload list_tasks(request, options = nil)
                #   Pass arguments to `list_tasks` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::ListTasksRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::ListTasksRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_tasks(header: nil, parent: nil, page_size: nil, page_token: nil, filter: nil)
                #   Pass arguments to `list_tasks` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param parent [::String]
                #     Required. Must be in the format `providers/{provider}`.
                #     The `provider` must be the Google Cloud Project ID. For example,
                #     `sample-cloud-project`.
                #   @param page_size [::Integer]
                #     Optional. The maximum number of Tasks to return. The service may return
                #     fewer than this value. If you don't specify this value, then the server
                #     determines the number of results to return.
                #   @param page_token [::String]
                #     Optional. A page token received from a previous `ListTasks` call.
                #     You can provide this to retrieve the subsequent page.
                #
                #     When paginating, all other parameters provided to `ListTasks` must match
                #     the call that provided the page token.
                #   @param filter [::String]
                #     Optional. A filter query to apply when listing Tasks. See
                #     http://aip.dev/160 for examples of filter syntax. If you don't specify a
                #     value, or if you filter on an empty string, then all Tasks are returned.
                #     For information about the Task properties that you can filter on, see [List
                #     tasks](https://developers.google.com/maps/documentation/mobility/fleet-engine/journeys/tasks/find-tasks#filter_listed_tasks).
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Maps::FleetEngine::Delivery::V1::Task>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Maps::FleetEngine::Delivery::V1::Task>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::ListTasksRequest.new
                #
                #   # Call the list_tasks method.
                #   result = client.list_tasks request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Maps::FleetEngine::Delivery::V1::Task.
                #     p item
                #   end
                #
                def list_tasks request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::ListTasksRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_tasks.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_tasks.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_tasks.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.list_tasks request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @delivery_service_stub, :list_tasks, "tasks", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Returns the specified `TaskTrackingInfo` instance.
                #
                # @overload get_task_tracking_info(request, options = nil)
                #   Pass arguments to `get_task_tracking_info` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::GetTaskTrackingInfoRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::GetTaskTrackingInfoRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_task_tracking_info(header: nil, name: nil)
                #   Pass arguments to `get_task_tracking_info` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param name [::String]
                #     Required. Must be in the format
                #     `providers/{provider}/taskTrackingInfo/{tracking_id}`. The `provider`
                #     must be the Google Cloud Project ID, and the `tracking_id` must be the
                #     tracking ID associated with the task. An example name can be
                #     `providers/sample-cloud-project/taskTrackingInfo/sample-tracking-id`.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Maps::FleetEngine::Delivery::V1::TaskTrackingInfo]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Maps::FleetEngine::Delivery::V1::TaskTrackingInfo]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::GetTaskTrackingInfoRequest.new
                #
                #   # Call the get_task_tracking_info method.
                #   result = client.get_task_tracking_info request
                #
                #   # The returned object is of type Google::Maps::FleetEngine::Delivery::V1::TaskTrackingInfo.
                #   p result
                #
                def get_task_tracking_info request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::GetTaskTrackingInfoRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_task_tracking_info.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_task_tracking_info.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_task_tracking_info.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.get_task_tracking_info request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets all `DeliveryVehicle`s that meet the specified filtering criteria.
                #
                # @overload list_delivery_vehicles(request, options = nil)
                #   Pass arguments to `list_delivery_vehicles` via a request object, either of type
                #   {::Google::Maps::FleetEngine::Delivery::V1::ListDeliveryVehiclesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Maps::FleetEngine::Delivery::V1::ListDeliveryVehiclesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_delivery_vehicles(header: nil, parent: nil, page_size: nil, page_token: nil, filter: nil, viewport: nil)
                #   Pass arguments to `list_delivery_vehicles` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param header [::Google::Maps::FleetEngine::Delivery::V1::DeliveryRequestHeader, ::Hash]
                #     Optional. The standard Delivery API request header.
                #   @param parent [::String]
                #     Required. Must be in the format `providers/{provider}`.
                #     The `provider` must be the Google Cloud Project ID.
                #     For example, `sample-cloud-project`.
                #   @param page_size [::Integer]
                #     Optional. The maximum number of vehicles to return. The service may return
                #     fewer than this number. If you don't specify this number, then the server
                #     determines the number of results to return.
                #   @param page_token [::String]
                #     Optional. A page token, received from a previous `ListDeliveryVehicles`
                #     call. You must provide this in order to retrieve the subsequent page.
                #
                #     When paginating, all other parameters provided to `ListDeliveryVehicles`
                #     must match the call that provided the page token.
                #   @param filter [::String]
                #     Optional. A filter query to apply when listing delivery vehicles. See
                #     http://aip.dev/160 for examples of the filter syntax. If you don't specify
                #     a value, or if you specify an empty string for the filter, then all
                #     delivery vehicles are returned.
                #
                #     Note that the only queries supported for `ListDeliveryVehicles` are
                #     on vehicle attributes (for example, `attributes.<key> = <value>` or
                #     `attributes.<key1> = <value1> AND attributes.<key2> = <value2>`). Also, all
                #     attributes are stored as strings, so the only supported comparisons against
                #     attributes are string comparisons. In order to compare against number or
                #     boolean values, the values must be explicitly quoted to be treated as
                #     strings (for example, `attributes.<key> = "10"` or
                #     `attributes.<key> = "true"`).
                #
                #     The maximum number of restrictions allowed in a filter query is 50. A
                #     restriction is a part of the query of the form
                #     `attribute.<KEY> <COMPARATOR> <VALUE>`, for example `attributes.foo = bar`
                #     is 1 restriction.
                #   @param viewport [::Google::Geo::Type::Viewport, ::Hash]
                #     Optional. A filter that limits the vehicles returned to those whose last
                #     known location was in the rectangular area defined by the viewport.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/maps/fleet_engine/delivery/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Maps::FleetEngine::Delivery::V1::ListDeliveryVehiclesRequest.new
                #
                #   # Call the list_delivery_vehicles method.
                #   result = client.list_delivery_vehicles request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Maps::FleetEngine::Delivery::V1::DeliveryVehicle.
                #     p item
                #   end
                #
                def list_delivery_vehicles request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Maps::FleetEngine::Delivery::V1::ListDeliveryVehiclesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_delivery_vehicles.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Maps::FleetEngine::Delivery::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_delivery_vehicles.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_delivery_vehicles.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @delivery_service_stub.list_delivery_vehicles request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @delivery_service_stub, :list_delivery_vehicles, "delivery_vehicles", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the DeliveryService REST API.
                #
                # This class represents the configuration for DeliveryService REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # create_delivery_vehicle to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_delivery_vehicle.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Maps::FleetEngine::Delivery::V1::DeliveryService::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.create_delivery_vehicle.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "fleetengine.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the DeliveryService API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `create_delivery_vehicle`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_delivery_vehicle
                    ##
                    # RPC-specific configuration for `get_delivery_vehicle`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_delivery_vehicle
                    ##
                    # RPC-specific configuration for `delete_delivery_vehicle`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_delivery_vehicle
                    ##
                    # RPC-specific configuration for `update_delivery_vehicle`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_delivery_vehicle
                    ##
                    # RPC-specific configuration for `batch_create_tasks`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :batch_create_tasks
                    ##
                    # RPC-specific configuration for `create_task`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_task
                    ##
                    # RPC-specific configuration for `get_task`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_task
                    ##
                    # RPC-specific configuration for `delete_task`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_task
                    ##
                    # RPC-specific configuration for `update_task`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :update_task
                    ##
                    # RPC-specific configuration for `list_tasks`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_tasks
                    ##
                    # RPC-specific configuration for `get_task_tracking_info`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_task_tracking_info
                    ##
                    # RPC-specific configuration for `list_delivery_vehicles`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_delivery_vehicles

                    # @private
                    def initialize parent_rpcs = nil
                      create_delivery_vehicle_config = parent_rpcs.create_delivery_vehicle if parent_rpcs.respond_to? :create_delivery_vehicle
                      @create_delivery_vehicle = ::Gapic::Config::Method.new create_delivery_vehicle_config
                      get_delivery_vehicle_config = parent_rpcs.get_delivery_vehicle if parent_rpcs.respond_to? :get_delivery_vehicle
                      @get_delivery_vehicle = ::Gapic::Config::Method.new get_delivery_vehicle_config
                      delete_delivery_vehicle_config = parent_rpcs.delete_delivery_vehicle if parent_rpcs.respond_to? :delete_delivery_vehicle
                      @delete_delivery_vehicle = ::Gapic::Config::Method.new delete_delivery_vehicle_config
                      update_delivery_vehicle_config = parent_rpcs.update_delivery_vehicle if parent_rpcs.respond_to? :update_delivery_vehicle
                      @update_delivery_vehicle = ::Gapic::Config::Method.new update_delivery_vehicle_config
                      batch_create_tasks_config = parent_rpcs.batch_create_tasks if parent_rpcs.respond_to? :batch_create_tasks
                      @batch_create_tasks = ::Gapic::Config::Method.new batch_create_tasks_config
                      create_task_config = parent_rpcs.create_task if parent_rpcs.respond_to? :create_task
                      @create_task = ::Gapic::Config::Method.new create_task_config
                      get_task_config = parent_rpcs.get_task if parent_rpcs.respond_to? :get_task
                      @get_task = ::Gapic::Config::Method.new get_task_config
                      delete_task_config = parent_rpcs.delete_task if parent_rpcs.respond_to? :delete_task
                      @delete_task = ::Gapic::Config::Method.new delete_task_config
                      update_task_config = parent_rpcs.update_task if parent_rpcs.respond_to? :update_task
                      @update_task = ::Gapic::Config::Method.new update_task_config
                      list_tasks_config = parent_rpcs.list_tasks if parent_rpcs.respond_to? :list_tasks
                      @list_tasks = ::Gapic::Config::Method.new list_tasks_config
                      get_task_tracking_info_config = parent_rpcs.get_task_tracking_info if parent_rpcs.respond_to? :get_task_tracking_info
                      @get_task_tracking_info = ::Gapic::Config::Method.new get_task_tracking_info_config
                      list_delivery_vehicles_config = parent_rpcs.list_delivery_vehicles if parent_rpcs.respond_to? :list_delivery_vehicles
                      @list_delivery_vehicles = ::Gapic::Config::Method.new list_delivery_vehicles_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
