# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Maps
    module FleetEngine
      module Delivery
        module V1
          module DeliveryService
            # Path helper methods for the DeliveryService API.
            module Paths
              ##
              # Create a fully-qualified DeliveryVehicle resource string.
              #
              # The resource will be in the following format:
              #
              # `providers/{provider}/deliveryVehicles/{vehicle}`
              #
              # @param provider [String]
              # @param vehicle [String]
              #
              # @return [::String]
              def delivery_vehicle_path provider:, vehicle:
                raise ::ArgumentError, "provider cannot contain /" if provider.to_s.include? "/"

                "providers/#{provider}/deliveryVehicles/#{vehicle}"
              end

              ##
              # Create a fully-qualified Provider resource string.
              #
              # The resource will be in the following format:
              #
              # `providers/{provider}`
              #
              # @param provider [String]
              #
              # @return [::String]
              def provider_path provider:
                "providers/#{provider}"
              end

              ##
              # Create a fully-qualified Task resource string.
              #
              # The resource will be in the following format:
              #
              # `providers/{provider}/tasks/{task}`
              #
              # @param provider [String]
              # @param task [String]
              #
              # @return [::String]
              def task_path provider:, task:
                raise ::ArgumentError, "provider cannot contain /" if provider.to_s.include? "/"

                "providers/#{provider}/tasks/#{task}"
              end

              ##
              # Create a fully-qualified TaskTrackingInfo resource string.
              #
              # The resource will be in the following format:
              #
              # `providers/{provider}/taskTrackingInfo/{tracking}`
              #
              # @param provider [String]
              # @param tracking [String]
              #
              # @return [::String]
              def task_tracking_info_path provider:, tracking:
                raise ::ArgumentError, "provider cannot contain /" if provider.to_s.include? "/"

                "providers/#{provider}/taskTrackingInfo/#{tracking}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
