# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/identity/accesscontextmanager/v1/access_context_manager_pb"
require "google/identity/access_context_manager/v1/access_context_manager"

class ::Google::Identity::AccessContextManager::V1::AccessContextManager::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_access_policies
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_access_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_access_policies, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_access_policies_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_access_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_access_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_access_policies ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_access_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_access_policies(::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_access_policies_client_stub.call_rpc_count
    end
  end

  def test_get_access_policy
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::AccessPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_access_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_access_policy, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_access_policy_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_access_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_access_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_access_policy ::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_access_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_access_policy(::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_access_policy_client_stub.call_rpc_count
    end
  end

  def test_create_access_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    parent = "hello world"
    title = "hello world"
    scopes = ["hello world"]
    create_time = {}
    update_time = {}
    etag = "hello world"

    create_access_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_access_policy, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::AccessPolicy, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["title"]
      assert_equal ["hello world"], request["scopes"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["create_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["update_time"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_access_policy_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_access_policy({ name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_access_policy name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_access_policy ::Google::Identity::AccessContextManager::V1::AccessPolicy.new(name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_access_policy({ name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_access_policy(::Google::Identity::AccessContextManager::V1::AccessPolicy.new(name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_access_policy_client_stub.call_rpc_count
    end
  end

  def test_update_access_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    policy = {}
    update_mask = {}

    update_access_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_access_policy, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::AccessPolicy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_access_policy_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_access_policy({ policy: policy, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_access_policy policy: policy, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_access_policy ::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest.new(policy: policy, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_access_policy({ policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_access_policy(::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest.new(policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_access_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_access_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_access_policy, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_access_policy_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_access_policy({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_access_policy name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_access_policy ::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_access_policy({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_access_policy(::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_access_policy_client_stub.call_rpc_count
    end
  end

  def test_list_access_levels
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::ListAccessLevelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    access_level_format = :LEVEL_FORMAT_UNSPECIFIED

    list_access_levels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_access_levels, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal :LEVEL_FORMAT_UNSPECIFIED, request["access_level_format"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_access_levels_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_access_levels({ parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_access_levels parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_access_levels ::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_access_levels({ parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_access_levels(::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_access_levels_client_stub.call_rpc_count
    end
  end

  def test_get_access_level
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::AccessLevel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    access_level_format = :LEVEL_FORMAT_UNSPECIFIED

    get_access_level_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_access_level, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :LEVEL_FORMAT_UNSPECIFIED, request["access_level_format"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_access_level_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_access_level({ name: name, access_level_format: access_level_format }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_access_level name: name, access_level_format: access_level_format do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_access_level ::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest.new(name: name, access_level_format: access_level_format) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_access_level({ name: name, access_level_format: access_level_format }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_access_level(::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest.new(name: name, access_level_format: access_level_format), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_access_level_client_stub.call_rpc_count
    end
  end

  def test_create_access_level
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    access_level = {}

    create_access_level_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_access_level, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::AccessLevel), request["access_level"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_access_level_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_access_level({ parent: parent, access_level: access_level }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_access_level parent: parent, access_level: access_level do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_access_level ::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest.new(parent: parent, access_level: access_level) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_access_level({ parent: parent, access_level: access_level }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_access_level(::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest.new(parent: parent, access_level: access_level), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_access_level_client_stub.call_rpc_count
    end
  end

  def test_update_access_level
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    access_level = {}
    update_mask = {}

    update_access_level_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_access_level, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::AccessLevel), request["access_level"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_access_level_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_access_level({ access_level: access_level, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_access_level access_level: access_level, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_access_level ::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest.new(access_level: access_level, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_access_level({ access_level: access_level, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_access_level(::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest.new(access_level: access_level, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_access_level_client_stub.call_rpc_count
    end
  end

  def test_delete_access_level
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_level_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_access_level, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_access_level_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_access_level({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_access_level name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_access_level ::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_access_level({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_access_level(::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_access_level_client_stub.call_rpc_count
    end
  end

  def test_replace_access_levels
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    access_levels = [{}]
    etag = "hello world"

    replace_access_levels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :replace_access_levels, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Identity::AccessContextManager::V1::AccessLevel, request["access_levels"].first
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, replace_access_levels_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.replace_access_levels({ parent: parent, access_levels: access_levels, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.replace_access_levels parent: parent, access_levels: access_levels, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.replace_access_levels ::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest.new(parent: parent, access_levels: access_levels, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.replace_access_levels({ parent: parent, access_levels: access_levels, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.replace_access_levels(::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest.new(parent: parent, access_levels: access_levels, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, replace_access_levels_client_stub.call_rpc_count
    end
  end

  def test_list_service_perimeters
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::ListServicePerimetersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_service_perimeters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_service_perimeters, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_service_perimeters_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_service_perimeters({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_service_perimeters parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_service_perimeters ::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_service_perimeters({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_service_perimeters(::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_service_perimeters_client_stub.call_rpc_count
    end
  end

  def test_get_service_perimeter
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::ServicePerimeter.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_perimeter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_service_perimeter, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_service_perimeter_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_service_perimeter({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_service_perimeter name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_service_perimeter ::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_service_perimeter({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_service_perimeter(::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_service_perimeter_client_stub.call_rpc_count
    end
  end

  def test_create_service_perimeter
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_perimeter = {}

    create_service_perimeter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_service_perimeter, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::ServicePerimeter), request["service_perimeter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_service_perimeter_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_service_perimeter({ parent: parent, service_perimeter: service_perimeter }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_service_perimeter parent: parent, service_perimeter: service_perimeter do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_service_perimeter ::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest.new(parent: parent, service_perimeter: service_perimeter) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_service_perimeter({ parent: parent, service_perimeter: service_perimeter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_service_perimeter(::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest.new(parent: parent, service_perimeter: service_perimeter), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_service_perimeter_client_stub.call_rpc_count
    end
  end

  def test_update_service_perimeter
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    service_perimeter = {}
    update_mask = {}

    update_service_perimeter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_service_perimeter, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::ServicePerimeter), request["service_perimeter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_service_perimeter_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_service_perimeter({ service_perimeter: service_perimeter, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_service_perimeter service_perimeter: service_perimeter, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_service_perimeter ::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest.new(service_perimeter: service_perimeter, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_service_perimeter({ service_perimeter: service_perimeter, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_service_perimeter(::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest.new(service_perimeter: service_perimeter, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_service_perimeter_client_stub.call_rpc_count
    end
  end

  def test_delete_service_perimeter
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_service_perimeter_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_service_perimeter, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_service_perimeter_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_service_perimeter({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_service_perimeter name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_service_perimeter ::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_service_perimeter({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_service_perimeter(::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_service_perimeter_client_stub.call_rpc_count
    end
  end

  def test_replace_service_perimeters
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_perimeters = [{}]
    etag = "hello world"

    replace_service_perimeters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :replace_service_perimeters, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ServicePerimeter, request["service_perimeters"].first
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, replace_service_perimeters_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.replace_service_perimeters({ parent: parent, service_perimeters: service_perimeters, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.replace_service_perimeters parent: parent, service_perimeters: service_perimeters, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.replace_service_perimeters ::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest.new(parent: parent, service_perimeters: service_perimeters, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.replace_service_perimeters({ parent: parent, service_perimeters: service_perimeters, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.replace_service_perimeters(::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest.new(parent: parent, service_perimeters: service_perimeters, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, replace_service_perimeters_client_stub.call_rpc_count
    end
  end

  def test_commit_service_perimeters
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    etag = "hello world"

    commit_service_perimeters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :commit_service_perimeters, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, commit_service_perimeters_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.commit_service_perimeters({ parent: parent, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.commit_service_perimeters parent: parent, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.commit_service_perimeters ::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest.new(parent: parent, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.commit_service_perimeters({ parent: parent, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.commit_service_perimeters(::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest.new(parent: parent, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, commit_service_perimeters_client_stub.call_rpc_count
    end
  end

  def test_list_gcp_user_access_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_gcp_user_access_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_gcp_user_access_bindings, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_gcp_user_access_bindings_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_gcp_user_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_gcp_user_access_bindings parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_gcp_user_access_bindings ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_gcp_user_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_gcp_user_access_bindings(::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_gcp_user_access_bindings_client_stub.call_rpc_count
    end
  end

  def test_get_gcp_user_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gcp_user_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_gcp_user_access_binding, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_gcp_user_access_binding_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_gcp_user_access_binding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_gcp_user_access_binding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_gcp_user_access_binding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_gcp_user_access_binding_client_stub.call_rpc_count
    end
  end

  def test_create_gcp_user_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gcp_user_access_binding = {}

    create_gcp_user_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_gcp_user_access_binding, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding), request["gcp_user_access_binding"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_gcp_user_access_binding_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_gcp_user_access_binding({ parent: parent, gcp_user_access_binding: gcp_user_access_binding }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_gcp_user_access_binding parent: parent, gcp_user_access_binding: gcp_user_access_binding do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest.new(parent: parent, gcp_user_access_binding: gcp_user_access_binding) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_gcp_user_access_binding({ parent: parent, gcp_user_access_binding: gcp_user_access_binding }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest.new(parent: parent, gcp_user_access_binding: gcp_user_access_binding), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_gcp_user_access_binding_client_stub.call_rpc_count
    end
  end

  def test_update_gcp_user_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    gcp_user_access_binding = {}
    update_mask = {}

    update_gcp_user_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_gcp_user_access_binding, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding), request["gcp_user_access_binding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_gcp_user_access_binding_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_gcp_user_access_binding({ gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_gcp_user_access_binding gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest.new(gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_gcp_user_access_binding({ gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest.new(gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_gcp_user_access_binding_client_stub.call_rpc_count
    end
  end

  def test_delete_gcp_user_access_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_gcp_user_access_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_gcp_user_access_binding, name
      assert_kind_of ::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_gcp_user_access_binding_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_gcp_user_access_binding({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_gcp_user_access_binding name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_gcp_user_access_binding({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_gcp_user_access_binding_client_stub.call_rpc_count
    end
  end

  def test_set_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :set_iam_policy, name
      assert_kind_of ::Google::Iam::V1::SetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::Policy), request["policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, set_iam_policy_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, set_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_get_iam_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::Policy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_iam_policy, name
      assert_kind_of ::Google::Iam::V1::GetIamPolicyRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V1::GetPolicyOptions), request["options"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_iam_policy_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_iam_policy({ resource: resource, options: options }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_iam_policy resource: resource, options: options do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_iam_policy({ resource: resource, options: options }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_iam_policy_client_stub.call_rpc_count
    end
  end

  def test_test_iam_permissions
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V1::TestIamPermissionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :test_iam_permissions, name
      assert_kind_of ::Google::Iam::V1::TestIamPermissionsRequest, request
      assert_equal "hello world", request["resource"]
      assert_equal ["hello world"], request["permissions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, test_iam_permissions_client_stub do
      # Create client
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.test_iam_permissions({ resource: resource, permissions: permissions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.test_iam_permissions resource: resource, permissions: permissions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.test_iam_permissions({ resource: resource, permissions: permissions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, test_iam_permissions_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Identity::AccessContextManager::V1::AccessContextManager::Operations, client.operations_client
  end
end
