# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/identity/accesscontextmanager/v1/access_context_manager_pb"
require "google/identity/access_context_manager/v1/access_context_manager/rest"


class ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_access_policies
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_access_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_list_access_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_access_policies_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_access_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_access_policies parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_access_policies ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_access_policies({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_access_policies(::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_access_policies_client_stub.call_count
      end
    end
  end

  def test_get_access_policy
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::AccessPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_access_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_get_access_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_access_policy_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_access_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_access_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_access_policy ::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_access_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_access_policy(::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_access_policy_client_stub.call_count
      end
    end
  end

  def test_create_access_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    parent = "hello world"
    title = "hello world"
    scopes = ["hello world"]
    create_time = {}
    update_time = {}
    etag = "hello world"

    create_access_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_create_access_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_access_policy_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_access_policy({ name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_access_policy name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_access_policy ::Google::Identity::AccessContextManager::V1::AccessPolicy.new(name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_access_policy({ name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_access_policy(::Google::Identity::AccessContextManager::V1::AccessPolicy.new(name: name, parent: parent, title: title, scopes: scopes, create_time: create_time, update_time: update_time, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_access_policy_client_stub.call_count
      end
    end
  end

  def test_update_access_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    policy = {}
    update_mask = {}

    update_access_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_update_access_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_access_policy_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_access_policy({ policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_access_policy policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_access_policy ::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest.new(policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_access_policy({ policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_access_policy(::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest.new(policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_access_policy_client_stub.call_count
      end
    end
  end

  def test_delete_access_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_delete_access_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_access_policy_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_access_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_access_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_access_policy ::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_access_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_access_policy(::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_access_policy_client_stub.call_count
      end
    end
  end

  def test_list_access_levels
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::ListAccessLevelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    access_level_format = :LEVEL_FORMAT_UNSPECIFIED

    list_access_levels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_list_access_levels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_access_levels_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_access_levels({ parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_access_levels parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_access_levels ::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_access_levels({ parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_access_levels(::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, access_level_format: access_level_format), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_access_levels_client_stub.call_count
      end
    end
  end

  def test_get_access_level
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::AccessLevel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    access_level_format = :LEVEL_FORMAT_UNSPECIFIED

    get_access_level_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_get_access_level_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_access_level_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_access_level({ name: name, access_level_format: access_level_format }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_access_level name: name, access_level_format: access_level_format do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_access_level ::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest.new(name: name, access_level_format: access_level_format) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_access_level({ name: name, access_level_format: access_level_format }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_access_level(::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest.new(name: name, access_level_format: access_level_format), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_access_level_client_stub.call_count
      end
    end
  end

  def test_create_access_level
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    access_level = {}

    create_access_level_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_create_access_level_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_access_level_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_access_level({ parent: parent, access_level: access_level }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_access_level parent: parent, access_level: access_level do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_access_level ::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest.new(parent: parent, access_level: access_level) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_access_level({ parent: parent, access_level: access_level }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_access_level(::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest.new(parent: parent, access_level: access_level), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_access_level_client_stub.call_count
      end
    end
  end

  def test_update_access_level
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    access_level = {}
    update_mask = {}

    update_access_level_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_update_access_level_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_access_level_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_access_level({ access_level: access_level, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_access_level access_level: access_level, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_access_level ::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest.new(access_level: access_level, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_access_level({ access_level: access_level, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_access_level(::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest.new(access_level: access_level, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_access_level_client_stub.call_count
      end
    end
  end

  def test_delete_access_level
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_access_level_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_delete_access_level_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_access_level_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_access_level({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_access_level name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_access_level ::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_access_level({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_access_level(::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_access_level_client_stub.call_count
      end
    end
  end

  def test_replace_access_levels
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    access_levels = [{}]
    etag = "hello world"

    replace_access_levels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_replace_access_levels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, replace_access_levels_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.replace_access_levels({ parent: parent, access_levels: access_levels, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.replace_access_levels parent: parent, access_levels: access_levels, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.replace_access_levels ::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest.new(parent: parent, access_levels: access_levels, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.replace_access_levels({ parent: parent, access_levels: access_levels, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.replace_access_levels(::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest.new(parent: parent, access_levels: access_levels, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, replace_access_levels_client_stub.call_count
      end
    end
  end

  def test_list_service_perimeters
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::ListServicePerimetersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_service_perimeters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_list_service_perimeters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_service_perimeters_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_service_perimeters({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_service_perimeters parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_service_perimeters ::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_service_perimeters({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_service_perimeters(::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_service_perimeters_client_stub.call_count
      end
    end
  end

  def test_get_service_perimeter
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::ServicePerimeter.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_service_perimeter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_get_service_perimeter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_service_perimeter_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_service_perimeter({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_service_perimeter name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_service_perimeter ::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_service_perimeter({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_service_perimeter(::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_service_perimeter_client_stub.call_count
      end
    end
  end

  def test_create_service_perimeter
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_perimeter = {}

    create_service_perimeter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_create_service_perimeter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_service_perimeter_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_service_perimeter({ parent: parent, service_perimeter: service_perimeter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_service_perimeter parent: parent, service_perimeter: service_perimeter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_service_perimeter ::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest.new(parent: parent, service_perimeter: service_perimeter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_service_perimeter({ parent: parent, service_perimeter: service_perimeter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_service_perimeter(::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest.new(parent: parent, service_perimeter: service_perimeter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_service_perimeter_client_stub.call_count
      end
    end
  end

  def test_update_service_perimeter
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    service_perimeter = {}
    update_mask = {}

    update_service_perimeter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_update_service_perimeter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_service_perimeter_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_service_perimeter({ service_perimeter: service_perimeter, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_service_perimeter service_perimeter: service_perimeter, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_service_perimeter ::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest.new(service_perimeter: service_perimeter, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_service_perimeter({ service_perimeter: service_perimeter, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_service_perimeter(::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest.new(service_perimeter: service_perimeter, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_service_perimeter_client_stub.call_count
      end
    end
  end

  def test_delete_service_perimeter
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_service_perimeter_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_delete_service_perimeter_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_service_perimeter_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_service_perimeter({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_service_perimeter name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_service_perimeter ::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_service_perimeter({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_service_perimeter(::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_service_perimeter_client_stub.call_count
      end
    end
  end

  def test_replace_service_perimeters
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    service_perimeters = [{}]
    etag = "hello world"

    replace_service_perimeters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_replace_service_perimeters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, replace_service_perimeters_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.replace_service_perimeters({ parent: parent, service_perimeters: service_perimeters, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.replace_service_perimeters parent: parent, service_perimeters: service_perimeters, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.replace_service_perimeters ::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest.new(parent: parent, service_perimeters: service_perimeters, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.replace_service_perimeters({ parent: parent, service_perimeters: service_perimeters, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.replace_service_perimeters(::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest.new(parent: parent, service_perimeters: service_perimeters, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, replace_service_perimeters_client_stub.call_count
      end
    end
  end

  def test_commit_service_perimeters
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    etag = "hello world"

    commit_service_perimeters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_commit_service_perimeters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, commit_service_perimeters_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.commit_service_perimeters({ parent: parent, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.commit_service_perimeters parent: parent, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.commit_service_perimeters ::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest.new(parent: parent, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.commit_service_perimeters({ parent: parent, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.commit_service_perimeters(::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest.new(parent: parent, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, commit_service_perimeters_client_stub.call_count
      end
    end
  end

  def test_list_gcp_user_access_bindings
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_gcp_user_access_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_list_gcp_user_access_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_gcp_user_access_bindings_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_gcp_user_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_gcp_user_access_bindings parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_gcp_user_access_bindings ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_gcp_user_access_bindings({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_gcp_user_access_bindings(::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_gcp_user_access_bindings_client_stub.call_count
      end
    end
  end

  def test_get_gcp_user_access_binding
    # Create test objects.
    client_result = ::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_gcp_user_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_get_gcp_user_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_gcp_user_access_binding_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_gcp_user_access_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_gcp_user_access_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_gcp_user_access_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_gcp_user_access_binding_client_stub.call_count
      end
    end
  end

  def test_create_gcp_user_access_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    gcp_user_access_binding = {}

    create_gcp_user_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_create_gcp_user_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_gcp_user_access_binding_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_gcp_user_access_binding({ parent: parent, gcp_user_access_binding: gcp_user_access_binding }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_gcp_user_access_binding parent: parent, gcp_user_access_binding: gcp_user_access_binding do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest.new(parent: parent, gcp_user_access_binding: gcp_user_access_binding) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_gcp_user_access_binding({ parent: parent, gcp_user_access_binding: gcp_user_access_binding }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest.new(parent: parent, gcp_user_access_binding: gcp_user_access_binding), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_gcp_user_access_binding_client_stub.call_count
      end
    end
  end

  def test_update_gcp_user_access_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    gcp_user_access_binding = {}
    update_mask = {}

    update_gcp_user_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_update_gcp_user_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_gcp_user_access_binding_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_gcp_user_access_binding({ gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_gcp_user_access_binding gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest.new(gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_gcp_user_access_binding({ gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest.new(gcp_user_access_binding: gcp_user_access_binding, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_gcp_user_access_binding_client_stub.call_count
      end
    end
  end

  def test_delete_gcp_user_access_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_gcp_user_access_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_delete_gcp_user_access_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_gcp_user_access_binding_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_gcp_user_access_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_gcp_user_access_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_gcp_user_access_binding ::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_gcp_user_access_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_gcp_user_access_binding(::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_gcp_user_access_binding_client_stub.call_count
      end
    end
  end

  def test_set_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    policy = {}
    update_mask = {}

    set_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_set_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_iam_policy_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_iam_policy resource: resource, policy: policy, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_iam_policy ::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_iam_policy({ resource: resource, policy: policy, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_iam_policy(::Google::Iam::V1::SetIamPolicyRequest.new(resource: resource, policy: policy, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_iam_policy_client_stub.call_count
      end
    end
  end

  def test_get_iam_policy
    # Create test objects.
    client_result = ::Google::Iam::V1::Policy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    options = {}

    get_iam_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_get_iam_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_iam_policy_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_iam_policy({ resource: resource, options: options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_iam_policy resource: resource, options: options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_iam_policy ::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_iam_policy({ resource: resource, options: options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_iam_policy(::Google::Iam::V1::GetIamPolicyRequest.new(resource: resource, options: options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_iam_policy_client_stub.call_count
      end
    end
  end

  def test_test_iam_permissions
    # Create test objects.
    client_result = ::Google::Iam::V1::TestIamPermissionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    resource = "hello world"
    permissions = ["hello world"]

    test_iam_permissions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.stub :transcode_test_iam_permissions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, test_iam_permissions_client_stub do
        # Create client
        client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.test_iam_permissions({ resource: resource, permissions: permissions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.test_iam_permissions resource: resource, permissions: permissions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.test_iam_permissions ::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.test_iam_permissions({ resource: resource, permissions: permissions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.test_iam_permissions(::Google::Iam::V1::TestIamPermissionsRequest.new(resource: resource, permissions: permissions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, test_iam_permissions_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client::Configuration, config
  end
end
