# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/identity/accesscontextmanager/v1/access_context_manager.proto for package 'Google.Identity.AccessContextManager.V1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/identity/accesscontextmanager/v1/access_context_manager_pb'

module Google
  module Identity
    module AccessContextManager
      module V1
        module AccessContextManager
          # API for setting [access levels]
          # [google.identity.accesscontextmanager.v1.AccessLevel] and [service
          # perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
          # for Google Cloud projects. Each organization has one [access policy]
          # [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
          # [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
          # and [service perimeters]
          # [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
          # [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
          # applicable to all resources in the organization.
          # AccessPolicies
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.identity.accesscontextmanager.v1.AccessContextManager'

            # Lists all [access policies]
            # [google.identity.accesscontextmanager.v1.AccessPolicy] in an
            # organization.
            rpc :ListAccessPolicies, ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest, ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesResponse
            # Returns an [access policy]
            # [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
            rpc :GetAccessPolicy, ::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest, ::Google::Identity::AccessContextManager::V1::AccessPolicy
            # Creates an access policy. This method fails if the organization already has
            # an access policy. The long-running operation has a successful status
            # after the access policy propagates to long-lasting storage.
            # Syntactic and basic semantic errors are returned in `metadata` as a
            # BadRequest proto.
            rpc :CreateAccessPolicy, ::Google::Identity::AccessContextManager::V1::AccessPolicy, ::Google::Longrunning::Operation
            # Updates an [access policy]
            # [google.identity.accesscontextmanager.v1.AccessPolicy]. The
            # long-running operation from this RPC has a successful status after the
            # changes to the [access policy]
            # [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
            # to long-lasting storage.
            rpc :UpdateAccessPolicy, ::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest, ::Google::Longrunning::Operation
            # Deletes an [access policy]
            # [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
            # resource name. The long-running operation has a successful status after the
            # [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
            # is removed from long-lasting storage.
            rpc :DeleteAccessPolicy, ::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest, ::Google::Longrunning::Operation
            # Lists all [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] for an access
            # policy.
            rpc :ListAccessLevels, ::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest, ::Google::Identity::AccessContextManager::V1::ListAccessLevelsResponse
            # Gets an [access level]
            # [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
            # name.
            rpc :GetAccessLevel, ::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest, ::Google::Identity::AccessContextManager::V1::AccessLevel
            # Creates an [access level]
            # [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
            # operation from this RPC has a successful status after the [access
            # level] [google.identity.accesscontextmanager.v1.AccessLevel]
            # propagates to long-lasting storage. If [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] contain
            # errors, an error response is returned for the first error encountered.
            rpc :CreateAccessLevel, ::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest, ::Google::Longrunning::Operation
            # Updates an [access level]
            # [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
            # operation from this RPC has a successful status after the changes to
            # the [access level]
            # [google.identity.accesscontextmanager.v1.AccessLevel] propagate
            # to long-lasting storage. If [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] contain
            # errors, an error response is returned for the first error encountered.
            rpc :UpdateAccessLevel, ::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest, ::Google::Longrunning::Operation
            # Deletes an [access level]
            # [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
            # name. The long-running operation from this RPC has a successful status
            # after the [access level]
            # [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
            # from long-lasting storage.
            rpc :DeleteAccessLevel, ::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest, ::Google::Longrunning::Operation
            # Replaces all existing [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
            # policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
            # the [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
            # is done atomically. The long-running operation from this RPC has a
            # successful status after all replacements propagate to long-lasting
            # storage. If the replacement contains errors, an error response is returned
            # for the first error encountered.  Upon error, the replacement is cancelled,
            # and existing [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] are not
            # affected. The Operation.response field contains
            # ReplaceAccessLevelsResponse. Removing [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
            # [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
            # error.
            rpc :ReplaceAccessLevels, ::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest, ::Google::Longrunning::Operation
            # Lists all [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
            # access policy.
            rpc :ListServicePerimeters, ::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest, ::Google::Identity::AccessContextManager::V1::ListServicePerimetersResponse
            # Gets a [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
            # resource name.
            rpc :GetServicePerimeter, ::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest, ::Google::Identity::AccessContextManager::V1::ServicePerimeter
            # Creates a [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
            # long-running operation from this RPC has a successful status after the
            # [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter]
            # propagates to long-lasting storage. If a [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
            # errors, an error response is returned for the first error encountered.
            rpc :CreateServicePerimeter, ::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest, ::Google::Longrunning::Operation
            # Updates a [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
            # long-running operation from this RPC has a successful status after the
            # [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter]
            # propagates to long-lasting storage. If a [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
            # errors, an error response is returned for the first error encountered.
            rpc :UpdateServicePerimeter, ::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest, ::Google::Longrunning::Operation
            # Deletes a [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
            # resource name. The long-running operation from this RPC has a successful
            # status after the [service perimeter]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
            # long-lasting storage.
            rpc :DeleteServicePerimeter, ::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest, ::Google::Longrunning::Operation
            # Replace all existing [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
            # policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
            # [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
            # is done atomically. The long-running operation from this RPC has a
            # successful status after all replacements propagate to long-lasting storage.
            # Replacements containing errors result in an error response for the first
            # error encountered. Upon an error, replacement are cancelled and existing
            # [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
            # affected. The Operation.response field contains
            # ReplaceServicePerimetersResponse.
            rpc :ReplaceServicePerimeters, ::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest, ::Google::Longrunning::Operation
            # Commits the dry-run specification for all the [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
            # [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
            # A commit operation on a service perimeter involves copying its `spec` field
            # to the `status` field of the service perimeter. Only [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] with
            # `use_explicit_dry_run_spec` field set to true are affected by a commit
            # operation. The long-running operation from this RPC has a successful
            # status after the dry-run specifications for all the [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
            # committed. If a commit fails, it causes the long-running operation to
            # return an error response and the entire commit operation is cancelled.
            # When successful, the Operation.response field contains
            # CommitServicePerimetersResponse. The `dry_run` and the `spec` fields are
            # cleared after a successful commit operation.
            rpc :CommitServicePerimeters, ::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest, ::Google::Longrunning::Operation
            # Lists all [GcpUserAccessBindings]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
            # Google Cloud organization.
            rpc :ListGcpUserAccessBindings, ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest, ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsResponse
            # Gets the [GcpUserAccessBinding]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
            # the given name.
            rpc :GetGcpUserAccessBinding, ::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest, ::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding
            # Creates a [GcpUserAccessBinding]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
            # client specifies a [name]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
            # the server ignores it. Fails if a resource already exists with the same
            # [group_key]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
            # Completion of this long-running operation does not necessarily signify that
            # the new binding is deployed onto all affected users, which may take more
            # time.
            rpc :CreateGcpUserAccessBinding, ::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest, ::Google::Longrunning::Operation
            # Updates a [GcpUserAccessBinding]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
            # Completion of this long-running operation does not necessarily signify that
            # the changed binding is deployed onto all affected users, which may take
            # more time.
            rpc :UpdateGcpUserAccessBinding, ::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest, ::Google::Longrunning::Operation
            # Deletes a [GcpUserAccessBinding]
            # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
            # Completion of this long-running operation does not necessarily signify that
            # the binding deletion is deployed onto all affected users, which may take
            # more time.
            rpc :DeleteGcpUserAccessBinding, ::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest, ::Google::Longrunning::Operation
            # Sets the IAM policy for the specified Access Context Manager
            # [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
            # This method replaces the existing IAM policy on the access policy. The IAM
            # policy controls the set of users who can perform specific operations on the
            # Access Context Manager [access
            # policy][google.identity.accesscontextmanager.v1.AccessPolicy].
            rpc :SetIamPolicy, ::Google::Iam::V1::SetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Gets the IAM policy for the specified Access Context Manager
            # [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
            rpc :GetIamPolicy, ::Google::Iam::V1::GetIamPolicyRequest, ::Google::Iam::V1::Policy
            # Returns the IAM permissions that the caller has on the specified Access
            # Context Manager resource. The resource can be an
            # [AccessPolicy][google.identity.accesscontextmanager.v1.AccessPolicy],
            # [AccessLevel][google.identity.accesscontextmanager.v1.AccessLevel], or
            # [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
            # ]. This method does not support other resources.
            rpc :TestIamPermissions, ::Google::Iam::V1::TestIamPermissionsRequest, ::Google::Iam::V1::TestIamPermissionsResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
