# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/identity/accesscontextmanager/v1/access_context_manager_pb"
require "google/identity/access_context_manager/v1/access_context_manager/rest/service_stub"

module Google
  module Identity
    module AccessContextManager
      module V1
        module AccessContextManager
          module Rest
            ##
            # REST client for the AccessContextManager service.
            #
            # API for setting [access levels]
            # [google.identity.accesscontextmanager.v1.AccessLevel] and [service
            # perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
            # for Google Cloud projects. Each organization has one [access policy]
            # [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
            # [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
            # and [service perimeters]
            # [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
            # [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
            # applicable to all resources in the organization.
            # AccessPolicies
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "accesscontextmanager.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :access_context_manager_stub

              ##
              # Configure the AccessContextManager Client class.
              #
              # See {::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AccessContextManager clients
              #   ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Identity", "AccessContextManager", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AccessContextManager Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @access_context_manager_stub.universe_domain
              end

              ##
              # Create a new AccessContextManager REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AccessContextManager client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @access_context_manager_stub = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @access_context_manager_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @access_context_manager_stub.logger
              end

              # Service calls

              ##
              # Lists all [access policies]
              # [google.identity.accesscontextmanager.v1.AccessPolicy] in an
              # organization.
              #
              # @overload list_access_policies(request, options = nil)
              #   Pass arguments to `list_access_policies` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_access_policies(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_access_policies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the container to list AccessPolicy instances
              #     from.
              #
              #     Format:
              #     `organizations/{org_id}`
              #   @param page_size [::Integer]
              #     Number of AccessPolicy instances to include in the list. Default 100.
              #   @param page_token [::String]
              #     Next page token for the next batch of AccessPolicy instances. Defaults to
              #     the first page of results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::AccessPolicy>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::AccessPolicy>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest.new
              #
              #   # Call the list_access_policies method.
              #   result = client.list_access_policies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Identity::AccessContextManager::V1::AccessPolicy.
              #     p item
              #   end
              #
              def list_access_policies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::ListAccessPoliciesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_access_policies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_access_policies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_access_policies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.list_access_policies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @access_context_manager_stub, :list_access_policies, "access_policies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns an [access policy]
              # [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
              #
              # @overload get_access_policy(request, options = nil)
              #   Pass arguments to `get_access_policy` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_access_policy(name: nil)
              #   Pass arguments to `get_access_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the access policy to get.
              #
              #     Format `accessPolicies/{policy_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Identity::AccessContextManager::V1::AccessPolicy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Identity::AccessContextManager::V1::AccessPolicy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest.new
              #
              #   # Call the get_access_policy method.
              #   result = client.get_access_policy request
              #
              #   # The returned object is of type Google::Identity::AccessContextManager::V1::AccessPolicy.
              #   p result
              #
              def get_access_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::GetAccessPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_access_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_access_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_access_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.get_access_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an access policy. This method fails if the organization already has
              # an access policy. The long-running operation has a successful status
              # after the access policy propagates to long-lasting storage.
              # Syntactic and basic semantic errors are returned in `metadata` as a
              # BadRequest proto.
              #
              # @overload create_access_policy(request, options = nil)
              #   Pass arguments to `create_access_policy` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::AccessPolicy} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::AccessPolicy, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_access_policy(name: nil, parent: nil, title: nil, scopes: nil, create_time: nil, update_time: nil, etag: nil)
              #   Pass arguments to `create_access_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Output only. Resource name of the `AccessPolicy`. Format:
              #     `accessPolicies/{access_policy}`
              #   @param parent [::String]
              #     Required. The parent of this `AccessPolicy` in the Cloud Resource
              #     Hierarchy. Currently immutable once created. Format:
              #     `organizations/{organization_id}`
              #   @param title [::String]
              #     Required. Human readable title. Does not affect behavior.
              #   @param scopes [::Array<::String>]
              #     The scopes of a policy define which resources an ACM policy can restrict,
              #     and where ACM resources can be referenced.
              #     For example, a policy with scopes=["folders/123"] has the following
              #     behavior:
              #     - vpcsc perimeters can only restrict projects within folders/123
              #     - access levels can only be referenced by resources within folders/123.
              #     If empty, there are no limitations on which resources can be restricted by
              #     an ACM policy, and there are no limitations on where ACM resources can be
              #     referenced.
              #     Only one policy can include a given scope (attempting to create a second
              #     policy which includes "folders/123" will result in an error).
              #     Currently, scopes cannot be modified after a policy is created.
              #     Currently, policies can only have a single scope.
              #     Format: list of `folders/{folder_number}` or `projects/{project_number}`
              #   @param create_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Output only. Time the `AccessPolicy` was created in UTC.
              #   @param update_time [::Google::Protobuf::Timestamp, ::Hash]
              #     Output only. Time the `AccessPolicy` was updated in UTC.
              #   @param etag [::String]
              #     Output only. An opaque identifier for the current version of the
              #     `AccessPolicy`. This will always be a strongly validated etag, meaning that
              #     two Access Polices will be identical if and only if their etags are
              #     identical. Clients should not expect this to be in any specific format.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::AccessPolicy.new
              #
              #   # Call the create_access_policy method.
              #   result = client.create_access_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_access_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::AccessPolicy

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_access_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_access_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_access_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.create_access_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an [access policy]
              # [google.identity.accesscontextmanager.v1.AccessPolicy]. The
              # long-running operation from this RPC has a successful status after the
              # changes to the [access policy]
              # [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
              # to long-lasting storage.
              #
              # @overload update_access_policy(request, options = nil)
              #   Pass arguments to `update_access_policy` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_access_policy(policy: nil, update_mask: nil)
              #   Pass arguments to `update_access_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param policy [::Google::Identity::AccessContextManager::V1::AccessPolicy, ::Hash]
              #     Required. The updated AccessPolicy.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask to control which fields get updated. Must be non-empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest.new
              #
              #   # Call the update_access_policy method.
              #   result = client.update_access_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_access_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::UpdateAccessPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_access_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_access_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_access_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.update_access_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an [access policy]
              # [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
              # resource name. The long-running operation has a successful status after the
              # [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
              # is removed from long-lasting storage.
              #
              # @overload delete_access_policy(request, options = nil)
              #   Pass arguments to `delete_access_policy` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_access_policy(name: nil)
              #   Pass arguments to `delete_access_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the access policy to delete.
              #
              #     Format `accessPolicies/{policy_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest.new
              #
              #   # Call the delete_access_policy method.
              #   result = client.delete_access_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_access_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::DeleteAccessPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_access_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_access_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_access_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.delete_access_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] for an access
              # policy.
              #
              # @overload list_access_levels(request, options = nil)
              #   Pass arguments to `list_access_levels` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_access_levels(parent: nil, page_size: nil, page_token: nil, access_level_format: nil)
              #   Pass arguments to `list_access_levels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the access policy to list [Access Levels]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] from.
              #
              #     Format:
              #     `accessPolicies/{policy_id}`
              #   @param page_size [::Integer]
              #     Number of [Access Levels]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] to include in
              #     the list. Default 100.
              #   @param page_token [::String]
              #     Next page token for the next batch of [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] instances.
              #     Defaults to the first page of results.
              #   @param access_level_format [::Google::Identity::AccessContextManager::V1::LevelFormat]
              #     Whether to return `BasicLevels` in the Cloud Common Expression language, as
              #     `CustomLevels`, rather than as `BasicLevels`. Defaults to returning
              #     `AccessLevels` in the format they were defined.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::AccessLevel>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::AccessLevel>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest.new
              #
              #   # Call the list_access_levels method.
              #   result = client.list_access_levels request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Identity::AccessContextManager::V1::AccessLevel.
              #     p item
              #   end
              #
              def list_access_levels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::ListAccessLevelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_access_levels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_access_levels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_access_levels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.list_access_levels request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @access_context_manager_stub, :list_access_levels, "access_levels", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an [access level]
              # [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
              # name.
              #
              # @overload get_access_level(request, options = nil)
              #   Pass arguments to `get_access_level` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_access_level(name: nil, access_level_format: nil)
              #   Pass arguments to `get_access_level` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel].
              #
              #     Format:
              #     `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
              #   @param access_level_format [::Google::Identity::AccessContextManager::V1::LevelFormat]
              #     Whether to return `BasicLevels` in the Cloud Common Expression
              #     Language rather than as `BasicLevels`. Defaults to AS_DEFINED, where
              #     [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
              #     are returned as `BasicLevels` or `CustomLevels` based on how they were
              #     created. If set to CEL, all [Access Levels]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] are returned as
              #     `CustomLevels`. In the CEL case, `BasicLevels` are translated to equivalent
              #     `CustomLevels`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Identity::AccessContextManager::V1::AccessLevel]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Identity::AccessContextManager::V1::AccessLevel]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::GetAccessLevelRequest.new
              #
              #   # Call the get_access_level method.
              #   result = client.get_access_level request
              #
              #   # The returned object is of type Google::Identity::AccessContextManager::V1::AccessLevel.
              #   p result
              #
              def get_access_level request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::GetAccessLevelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_access_level.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_access_level.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_access_level.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.get_access_level request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an [access level]
              # [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
              # operation from this RPC has a successful status after the [access
              # level] [google.identity.accesscontextmanager.v1.AccessLevel]
              # propagates to long-lasting storage. If [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] contain
              # errors, an error response is returned for the first error encountered.
              #
              # @overload create_access_level(request, options = nil)
              #   Pass arguments to `create_access_level` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_access_level(parent: nil, access_level: nil)
              #   Pass arguments to `create_access_level` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the access policy which owns this [Access
              #     Level] [google.identity.accesscontextmanager.v1.AccessLevel].
              #
              #     Format: `accessPolicies/{policy_id}`
              #   @param access_level [::Google::Identity::AccessContextManager::V1::AccessLevel, ::Hash]
              #     Required. The [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] to create.
              #     Syntactic correctness of the [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] is a
              #     precondition for creation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest.new
              #
              #   # Call the create_access_level method.
              #   result = client.create_access_level request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_access_level request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::CreateAccessLevelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_access_level.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_access_level.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_access_level.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.create_access_level request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an [access level]
              # [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
              # operation from this RPC has a successful status after the changes to
              # the [access level]
              # [google.identity.accesscontextmanager.v1.AccessLevel] propagate
              # to long-lasting storage. If [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] contain
              # errors, an error response is returned for the first error encountered.
              #
              # @overload update_access_level(request, options = nil)
              #   Pass arguments to `update_access_level` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_access_level(access_level: nil, update_mask: nil)
              #   Pass arguments to `update_access_level` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param access_level [::Google::Identity::AccessContextManager::V1::AccessLevel, ::Hash]
              #     Required. The updated [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel]. Syntactic
              #     correctness of the [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] is a
              #     precondition for creation.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask to control which fields get updated. Must be non-empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest.new
              #
              #   # Call the update_access_level method.
              #   result = client.update_access_level request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_access_level request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::UpdateAccessLevelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_access_level.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_access_level.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_access_level.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.update_access_level request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an [access level]
              # [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
              # name. The long-running operation from this RPC has a successful status
              # after the [access level]
              # [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
              # from long-lasting storage.
              #
              # @overload delete_access_level(request, options = nil)
              #   Pass arguments to `delete_access_level` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_access_level(name: nil)
              #   Pass arguments to `delete_access_level` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the [Access Level]
              #     [google.identity.accesscontextmanager.v1.AccessLevel].
              #
              #     Format:
              #     `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest.new
              #
              #   # Call the delete_access_level method.
              #   result = client.delete_access_level request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_access_level request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::DeleteAccessLevelRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_access_level.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_access_level.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_access_level.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.delete_access_level request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Replaces all existing [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
              # policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
              # the [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
              # is done atomically. The long-running operation from this RPC has a
              # successful status after all replacements propagate to long-lasting
              # storage. If the replacement contains errors, an error response is returned
              # for the first error encountered.  Upon error, the replacement is cancelled,
              # and existing [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] are not
              # affected. The Operation.response field contains
              # ReplaceAccessLevelsResponse. Removing [access levels]
              # [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
              # [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
              # error.
              #
              # @overload replace_access_levels(request, options = nil)
              #   Pass arguments to `replace_access_levels` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload replace_access_levels(parent: nil, access_levels: nil, etag: nil)
              #   Pass arguments to `replace_access_levels` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the access policy which owns these
              #     [Access Levels]
              #     [google.identity.accesscontextmanager.v1.AccessLevel].
              #
              #     Format: `accessPolicies/{policy_id}`
              #   @param access_levels [::Array<::Google::Identity::AccessContextManager::V1::AccessLevel, ::Hash>]
              #     Required. The desired [Access Levels]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] that should
              #     replace all existing [Access Levels]
              #     [google.identity.accesscontextmanager.v1.AccessLevel] in the
              #     [Access Policy]
              #     [google.identity.accesscontextmanager.v1.AccessPolicy].
              #   @param etag [::String]
              #     Optional. The etag for the version of the [Access Policy]
              #     [google.identity.accesscontextmanager.v1.AccessPolicy] that this
              #     replace operation is to be performed on. If, at the time of replace, the
              #     etag for the Access Policy stored in Access Context Manager is different
              #     from the specified etag, then the replace operation will not be performed
              #     and the call will fail. This field is not required. If etag is not
              #     provided, the operation will be performed as if a valid etag is provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest.new
              #
              #   # Call the replace_access_levels method.
              #   result = client.replace_access_levels request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def replace_access_levels request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::ReplaceAccessLevelsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.replace_access_levels.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.replace_access_levels.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.replace_access_levels.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.replace_access_levels request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
              # access policy.
              #
              # @overload list_service_perimeters(request, options = nil)
              #   Pass arguments to `list_service_perimeters` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_service_perimeters(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_service_perimeters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the access policy to list [Service Perimeters]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
              #
              #     Format:
              #     `accessPolicies/{policy_id}`
              #   @param page_size [::Integer]
              #     Number of [Service Perimeters]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] to include
              #     in the list. Default 100.
              #   @param page_token [::String]
              #     Next page token for the next batch of [Service Perimeter]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] instances.
              #     Defaults to the first page of results.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::ServicePerimeter>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::ServicePerimeter>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest.new
              #
              #   # Call the list_service_perimeters method.
              #   result = client.list_service_perimeters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Identity::AccessContextManager::V1::ServicePerimeter.
              #     p item
              #   end
              #
              def list_service_perimeters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::ListServicePerimetersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_service_perimeters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_service_perimeters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_service_perimeters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.list_service_perimeters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @access_context_manager_stub, :list_service_perimeters, "service_perimeters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
              # resource name.
              #
              # @overload get_service_perimeter(request, options = nil)
              #   Pass arguments to `get_service_perimeter` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_service_perimeter(name: nil)
              #   Pass arguments to `get_service_perimeter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the [Service Perimeter]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter].
              #
              #     Format:
              #     `accessPolicies/{policy_id}/servicePerimeters/{service_perimeters_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Identity::AccessContextManager::V1::ServicePerimeter]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Identity::AccessContextManager::V1::ServicePerimeter]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest.new
              #
              #   # Call the get_service_perimeter method.
              #   result = client.get_service_perimeter request
              #
              #   # The returned object is of type Google::Identity::AccessContextManager::V1::ServicePerimeter.
              #   p result
              #
              def get_service_perimeter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::GetServicePerimeterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_service_perimeter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_service_perimeter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_service_perimeter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.get_service_perimeter request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
              # long-running operation from this RPC has a successful status after the
              # [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter]
              # propagates to long-lasting storage. If a [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
              # errors, an error response is returned for the first error encountered.
              #
              # @overload create_service_perimeter(request, options = nil)
              #   Pass arguments to `create_service_perimeter` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_service_perimeter(parent: nil, service_perimeter: nil)
              #   Pass arguments to `create_service_perimeter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the access policy which owns this [Service
              #     Perimeter] [google.identity.accesscontextmanager.v1.ServicePerimeter].
              #
              #     Format: `accessPolicies/{policy_id}`
              #   @param service_perimeter [::Google::Identity::AccessContextManager::V1::ServicePerimeter, ::Hash]
              #     Required. The [Service Perimeter]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] to create.
              #     Syntactic correctness of the [Service Perimeter]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] is a
              #     precondition for creation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest.new
              #
              #   # Call the create_service_perimeter method.
              #   result = client.create_service_perimeter request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_service_perimeter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::CreateServicePerimeterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_service_perimeter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_service_perimeter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_service_perimeter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.create_service_perimeter request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
              # long-running operation from this RPC has a successful status after the
              # [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter]
              # propagates to long-lasting storage. If a [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
              # errors, an error response is returned for the first error encountered.
              #
              # @overload update_service_perimeter(request, options = nil)
              #   Pass arguments to `update_service_perimeter` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_service_perimeter(service_perimeter: nil, update_mask: nil)
              #   Pass arguments to `update_service_perimeter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param service_perimeter [::Google::Identity::AccessContextManager::V1::ServicePerimeter, ::Hash]
              #     Required. The updated `ServicePerimeter`. Syntactic correctness of the
              #     `ServicePerimeter` is a precondition for creation.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask to control which fields get updated. Must be non-empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest.new
              #
              #   # Call the update_service_perimeter method.
              #   result = client.update_service_perimeter request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_service_perimeter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::UpdateServicePerimeterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_service_perimeter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_service_perimeter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_service_perimeter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.update_service_perimeter request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
              # resource name. The long-running operation from this RPC has a successful
              # status after the [service perimeter]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
              # long-lasting storage.
              #
              # @overload delete_service_perimeter(request, options = nil)
              #   Pass arguments to `delete_service_perimeter` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_service_perimeter(name: nil)
              #   Pass arguments to `delete_service_perimeter` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name for the [Service Perimeter]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter].
              #
              #     Format:
              #     `accessPolicies/{policy_id}/servicePerimeters/{service_perimeter_id}`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest.new
              #
              #   # Call the delete_service_perimeter method.
              #   result = client.delete_service_perimeter request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_service_perimeter request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::DeleteServicePerimeterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_service_perimeter.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_service_perimeter.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_service_perimeter.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.delete_service_perimeter request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Replace all existing [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
              # policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
              # [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
              # is done atomically. The long-running operation from this RPC has a
              # successful status after all replacements propagate to long-lasting storage.
              # Replacements containing errors result in an error response for the first
              # error encountered. Upon an error, replacement are cancelled and existing
              # [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
              # affected. The Operation.response field contains
              # ReplaceServicePerimetersResponse.
              #
              # @overload replace_service_perimeters(request, options = nil)
              #   Pass arguments to `replace_service_perimeters` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload replace_service_perimeters(parent: nil, service_perimeters: nil, etag: nil)
              #   Pass arguments to `replace_service_perimeters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the access policy which owns these
              #     [Service Perimeters]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter].
              #
              #     Format: `accessPolicies/{policy_id}`
              #   @param service_perimeters [::Array<::Google::Identity::AccessContextManager::V1::ServicePerimeter, ::Hash>]
              #     Required. The desired [Service Perimeters]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] that should
              #     replace all existing [Service Perimeters]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] in the
              #     [Access Policy]
              #     [google.identity.accesscontextmanager.v1.AccessPolicy].
              #   @param etag [::String]
              #     Optional. The etag for the version of the [Access Policy]
              #     [google.identity.accesscontextmanager.v1.AccessPolicy] that this
              #     replace operation is to be performed on. If, at the time of replace, the
              #     etag for the Access Policy stored in Access Context Manager is different
              #     from the specified etag, then the replace operation will not be performed
              #     and the call will fail. This field is not required. If etag is not
              #     provided, the operation will be performed as if a valid etag is provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest.new
              #
              #   # Call the replace_service_perimeters method.
              #   result = client.replace_service_perimeters request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def replace_service_perimeters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::ReplaceServicePerimetersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.replace_service_perimeters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.replace_service_perimeters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.replace_service_perimeters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.replace_service_perimeters request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Commits the dry-run specification for all the [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
              # {::Google::Identity::AccessContextManager::V1::AccessPolicy access policy}.
              # A commit operation on a service perimeter involves copying its `spec` field
              # to the `status` field of the service perimeter. Only [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] with
              # `use_explicit_dry_run_spec` field set to true are affected by a commit
              # operation. The long-running operation from this RPC has a successful
              # status after the dry-run specifications for all the [service perimeters]
              # [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
              # committed. If a commit fails, it causes the long-running operation to
              # return an error response and the entire commit operation is cancelled.
              # When successful, the Operation.response field contains
              # CommitServicePerimetersResponse. The `dry_run` and the `spec` fields are
              # cleared after a successful commit operation.
              #
              # @overload commit_service_perimeters(request, options = nil)
              #   Pass arguments to `commit_service_perimeters` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload commit_service_perimeters(parent: nil, etag: nil)
              #   Pass arguments to `commit_service_perimeters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name for the parent [Access Policy]
              #     [google.identity.accesscontextmanager.v1.AccessPolicy] which owns all
              #     [Service Perimeters]
              #     [google.identity.accesscontextmanager.v1.ServicePerimeter] in scope for
              #     the commit operation.
              #
              #     Format: `accessPolicies/{policy_id}`
              #   @param etag [::String]
              #     Optional. The etag for the version of the [Access Policy]
              #     [google.identity.accesscontextmanager.v1.AccessPolicy] that this
              #     commit operation is to be performed on. If, at the time of commit, the
              #     etag for the Access Policy stored in Access Context Manager is different
              #     from the specified etag, then the commit operation will not be performed
              #     and the call will fail. This field is not required. If etag is not
              #     provided, the operation will be performed as if a valid etag is provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest.new
              #
              #   # Call the commit_service_perimeters method.
              #   result = client.commit_service_perimeters request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def commit_service_perimeters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::CommitServicePerimetersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.commit_service_perimeters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.commit_service_perimeters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.commit_service_perimeters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.commit_service_perimeters request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all [GcpUserAccessBindings]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
              # Google Cloud organization.
              #
              # @overload list_gcp_user_access_bindings(request, options = nil)
              #   Pass arguments to `list_gcp_user_access_bindings` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_gcp_user_access_bindings(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_gcp_user_access_bindings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example: "organizations/256"
              #   @param page_size [::Integer]
              #     Optional. Maximum number of items to return. The server may return fewer items.
              #     If left blank, the server may return any number of items.
              #   @param page_token [::String]
              #     Optional. If left blank, returns the first page. To enumerate all items, use the
              #     [next_page_token]
              #     [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse.next_page_token]
              #     from your previous list operation.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest.new
              #
              #   # Call the list_gcp_user_access_bindings method.
              #   result = client.list_gcp_user_access_bindings request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding.
              #     p item
              #   end
              #
              def list_gcp_user_access_bindings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::ListGcpUserAccessBindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_gcp_user_access_bindings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_gcp_user_access_bindings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_gcp_user_access_bindings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.list_gcp_user_access_bindings request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @access_context_manager_stub, :list_gcp_user_access_bindings, "gcp_user_access_bindings", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the [GcpUserAccessBinding]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
              # the given name.
              #
              # @overload get_gcp_user_access_binding(request, options = nil)
              #   Pass arguments to `get_gcp_user_access_binding` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_gcp_user_access_binding(name: nil)
              #   Pass arguments to `get_gcp_user_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest.new
              #
              #   # Call the get_gcp_user_access_binding method.
              #   result = client.get_gcp_user_access_binding request
              #
              #   # The returned object is of type Google::Identity::AccessContextManager::V1::GcpUserAccessBinding.
              #   p result
              #
              def get_gcp_user_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::GetGcpUserAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_gcp_user_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_gcp_user_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_gcp_user_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.get_gcp_user_access_binding request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a [GcpUserAccessBinding]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
              # client specifies a [name]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
              # the server ignores it. Fails if a resource already exists with the same
              # [group_key]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
              # Completion of this long-running operation does not necessarily signify that
              # the new binding is deployed onto all affected users, which may take more
              # time.
              #
              # @overload create_gcp_user_access_binding(request, options = nil)
              #   Pass arguments to `create_gcp_user_access_binding` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_gcp_user_access_binding(parent: nil, gcp_user_access_binding: nil)
              #   Pass arguments to `create_gcp_user_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Example: "organizations/256"
              #   @param gcp_user_access_binding [::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding, ::Hash]
              #     Required. [GcpUserAccessBinding]
              #     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest.new
              #
              #   # Call the create_gcp_user_access_binding method.
              #   result = client.create_gcp_user_access_binding request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_gcp_user_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::CreateGcpUserAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_gcp_user_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_gcp_user_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_gcp_user_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.create_gcp_user_access_binding request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a [GcpUserAccessBinding]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
              # Completion of this long-running operation does not necessarily signify that
              # the changed binding is deployed onto all affected users, which may take
              # more time.
              #
              # @overload update_gcp_user_access_binding(request, options = nil)
              #   Pass arguments to `update_gcp_user_access_binding` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_gcp_user_access_binding(gcp_user_access_binding: nil, update_mask: nil)
              #   Pass arguments to `update_gcp_user_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param gcp_user_access_binding [::Google::Identity::AccessContextManager::V1::GcpUserAccessBinding, ::Hash]
              #     Required. [GcpUserAccessBinding]
              #     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Only the fields specified in this mask are updated. Because name and
              #     group_key cannot be changed, update_mask is required and must always be:
              #
              #     update_mask {
              #     paths: "access_levels"
              #     }
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest.new
              #
              #   # Call the update_gcp_user_access_binding method.
              #   result = client.update_gcp_user_access_binding request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_gcp_user_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::UpdateGcpUserAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_gcp_user_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_gcp_user_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_gcp_user_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.update_gcp_user_access_binding request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a [GcpUserAccessBinding]
              # [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
              # Completion of this long-running operation does not necessarily signify that
              # the binding deletion is deployed onto all affected users, which may take
              # more time.
              #
              # @overload delete_gcp_user_access_binding(request, options = nil)
              #   Pass arguments to `delete_gcp_user_access_binding` via a request object, either of type
              #   {::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_gcp_user_access_binding(name: nil)
              #   Pass arguments to `delete_gcp_user_access_binding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest.new
              #
              #   # Call the delete_gcp_user_access_binding method.
              #   result = client.delete_gcp_user_access_binding request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_gcp_user_access_binding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Identity::AccessContextManager::V1::DeleteGcpUserAccessBindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_gcp_user_access_binding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_gcp_user_access_binding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_gcp_user_access_binding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.delete_gcp_user_access_binding request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Sets the IAM policy for the specified Access Context Manager
              # {::Google::Identity::AccessContextManager::V1::AccessPolicy access policy}.
              # This method replaces the existing IAM policy on the access policy. The IAM
              # policy controls the set of users who can perform specific operations on the
              # Access Context Manager [access
              # policy][google.identity.accesscontextmanager.v1.AccessPolicy].
              #
              # @overload set_iam_policy(request, options = nil)
              #   Pass arguments to `set_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::SetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::SetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload set_iam_policy(resource: nil, policy: nil, update_mask: nil)
              #   Pass arguments to `set_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being specified.
              #     See the operation documentation for the appropriate value for this field.
              #   @param policy [::Google::Iam::V1::Policy, ::Hash]
              #     REQUIRED: The complete policy to be applied to the `resource`. The size of
              #     the policy is limited to a few 10s of KB. An empty policy is a
              #     valid policy but certain Cloud Platform services (such as Projects)
              #     might reject them.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
              #     the fields in the mask will be modified. If no mask is provided, the
              #     following default mask is used:
              #
              #     `paths: "bindings, etag"`
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::SetIamPolicyRequest.new
              #
              #   # Call the set_iam_policy method.
              #   result = client.set_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def set_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::SetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.set_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.set_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.set_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.set_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the IAM policy for the specified Access Context Manager
              # {::Google::Identity::AccessContextManager::V1::AccessPolicy access policy}.
              #
              # @overload get_iam_policy(request, options = nil)
              #   Pass arguments to `get_iam_policy` via a request object, either of type
              #   {::Google::Iam::V1::GetIamPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::GetIamPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_iam_policy(resource: nil, options: nil)
              #   Pass arguments to `get_iam_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param options [::Google::Iam::V1::GetPolicyOptions, ::Hash]
              #     OPTIONAL: A `GetPolicyOptions` object for specifying options to
              #     `GetIamPolicy`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::Policy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::Policy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::GetIamPolicyRequest.new
              #
              #   # Call the get_iam_policy method.
              #   result = client.get_iam_policy request
              #
              #   # The returned object is of type Google::Iam::V1::Policy.
              #   p result
              #
              def get_iam_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::GetIamPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_iam_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_iam_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_iam_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.get_iam_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns the IAM permissions that the caller has on the specified Access
              # Context Manager resource. The resource can be an
              # {::Google::Identity::AccessContextManager::V1::AccessPolicy AccessPolicy},
              # {::Google::Identity::AccessContextManager::V1::AccessLevel AccessLevel}, or
              # [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
              # ]. This method does not support other resources.
              #
              # @overload test_iam_permissions(request, options = nil)
              #   Pass arguments to `test_iam_permissions` via a request object, either of type
              #   {::Google::Iam::V1::TestIamPermissionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Iam::V1::TestIamPermissionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload test_iam_permissions(resource: nil, permissions: nil)
              #   Pass arguments to `test_iam_permissions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param resource [::String]
              #     REQUIRED: The resource for which the policy detail is being requested.
              #     See the operation documentation for the appropriate value for this field.
              #   @param permissions [::Array<::String>]
              #     The set of permissions to check for the `resource`. Permissions with
              #     wildcards (such as '*' or 'storage.*') are not allowed. For more
              #     information see
              #     [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Iam::V1::TestIamPermissionsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Iam::V1::TestIamPermissionsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/identity/access_context_manager/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Iam::V1::TestIamPermissionsRequest.new
              #
              #   # Call the test_iam_permissions method.
              #   result = client.test_iam_permissions request
              #
              #   # The returned object is of type Google::Iam::V1::TestIamPermissionsResponse.
              #   p result
              #
              def test_iam_permissions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1::TestIamPermissionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.test_iam_permissions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Identity::AccessContextManager::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.test_iam_permissions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.test_iam_permissions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @access_context_manager_stub.test_iam_permissions request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AccessContextManager REST API.
              #
              # This class represents the configuration for AccessContextManager REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_access_policies to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_access_policies.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Identity::AccessContextManager::V1::AccessContextManager::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_access_policies.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "accesscontextmanager.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the AccessContextManager API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_access_policies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_access_policies
                  ##
                  # RPC-specific configuration for `get_access_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_access_policy
                  ##
                  # RPC-specific configuration for `create_access_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_access_policy
                  ##
                  # RPC-specific configuration for `update_access_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_access_policy
                  ##
                  # RPC-specific configuration for `delete_access_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_access_policy
                  ##
                  # RPC-specific configuration for `list_access_levels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_access_levels
                  ##
                  # RPC-specific configuration for `get_access_level`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_access_level
                  ##
                  # RPC-specific configuration for `create_access_level`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_access_level
                  ##
                  # RPC-specific configuration for `update_access_level`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_access_level
                  ##
                  # RPC-specific configuration for `delete_access_level`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_access_level
                  ##
                  # RPC-specific configuration for `replace_access_levels`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :replace_access_levels
                  ##
                  # RPC-specific configuration for `list_service_perimeters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_service_perimeters
                  ##
                  # RPC-specific configuration for `get_service_perimeter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_service_perimeter
                  ##
                  # RPC-specific configuration for `create_service_perimeter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_service_perimeter
                  ##
                  # RPC-specific configuration for `update_service_perimeter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_service_perimeter
                  ##
                  # RPC-specific configuration for `delete_service_perimeter`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_service_perimeter
                  ##
                  # RPC-specific configuration for `replace_service_perimeters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :replace_service_perimeters
                  ##
                  # RPC-specific configuration for `commit_service_perimeters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :commit_service_perimeters
                  ##
                  # RPC-specific configuration for `list_gcp_user_access_bindings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_gcp_user_access_bindings
                  ##
                  # RPC-specific configuration for `get_gcp_user_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_gcp_user_access_binding
                  ##
                  # RPC-specific configuration for `create_gcp_user_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_gcp_user_access_binding
                  ##
                  # RPC-specific configuration for `update_gcp_user_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_gcp_user_access_binding
                  ##
                  # RPC-specific configuration for `delete_gcp_user_access_binding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_gcp_user_access_binding
                  ##
                  # RPC-specific configuration for `set_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :set_iam_policy
                  ##
                  # RPC-specific configuration for `get_iam_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_iam_policy
                  ##
                  # RPC-specific configuration for `test_iam_permissions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :test_iam_permissions

                  # @private
                  def initialize parent_rpcs = nil
                    list_access_policies_config = parent_rpcs.list_access_policies if parent_rpcs.respond_to? :list_access_policies
                    @list_access_policies = ::Gapic::Config::Method.new list_access_policies_config
                    get_access_policy_config = parent_rpcs.get_access_policy if parent_rpcs.respond_to? :get_access_policy
                    @get_access_policy = ::Gapic::Config::Method.new get_access_policy_config
                    create_access_policy_config = parent_rpcs.create_access_policy if parent_rpcs.respond_to? :create_access_policy
                    @create_access_policy = ::Gapic::Config::Method.new create_access_policy_config
                    update_access_policy_config = parent_rpcs.update_access_policy if parent_rpcs.respond_to? :update_access_policy
                    @update_access_policy = ::Gapic::Config::Method.new update_access_policy_config
                    delete_access_policy_config = parent_rpcs.delete_access_policy if parent_rpcs.respond_to? :delete_access_policy
                    @delete_access_policy = ::Gapic::Config::Method.new delete_access_policy_config
                    list_access_levels_config = parent_rpcs.list_access_levels if parent_rpcs.respond_to? :list_access_levels
                    @list_access_levels = ::Gapic::Config::Method.new list_access_levels_config
                    get_access_level_config = parent_rpcs.get_access_level if parent_rpcs.respond_to? :get_access_level
                    @get_access_level = ::Gapic::Config::Method.new get_access_level_config
                    create_access_level_config = parent_rpcs.create_access_level if parent_rpcs.respond_to? :create_access_level
                    @create_access_level = ::Gapic::Config::Method.new create_access_level_config
                    update_access_level_config = parent_rpcs.update_access_level if parent_rpcs.respond_to? :update_access_level
                    @update_access_level = ::Gapic::Config::Method.new update_access_level_config
                    delete_access_level_config = parent_rpcs.delete_access_level if parent_rpcs.respond_to? :delete_access_level
                    @delete_access_level = ::Gapic::Config::Method.new delete_access_level_config
                    replace_access_levels_config = parent_rpcs.replace_access_levels if parent_rpcs.respond_to? :replace_access_levels
                    @replace_access_levels = ::Gapic::Config::Method.new replace_access_levels_config
                    list_service_perimeters_config = parent_rpcs.list_service_perimeters if parent_rpcs.respond_to? :list_service_perimeters
                    @list_service_perimeters = ::Gapic::Config::Method.new list_service_perimeters_config
                    get_service_perimeter_config = parent_rpcs.get_service_perimeter if parent_rpcs.respond_to? :get_service_perimeter
                    @get_service_perimeter = ::Gapic::Config::Method.new get_service_perimeter_config
                    create_service_perimeter_config = parent_rpcs.create_service_perimeter if parent_rpcs.respond_to? :create_service_perimeter
                    @create_service_perimeter = ::Gapic::Config::Method.new create_service_perimeter_config
                    update_service_perimeter_config = parent_rpcs.update_service_perimeter if parent_rpcs.respond_to? :update_service_perimeter
                    @update_service_perimeter = ::Gapic::Config::Method.new update_service_perimeter_config
                    delete_service_perimeter_config = parent_rpcs.delete_service_perimeter if parent_rpcs.respond_to? :delete_service_perimeter
                    @delete_service_perimeter = ::Gapic::Config::Method.new delete_service_perimeter_config
                    replace_service_perimeters_config = parent_rpcs.replace_service_perimeters if parent_rpcs.respond_to? :replace_service_perimeters
                    @replace_service_perimeters = ::Gapic::Config::Method.new replace_service_perimeters_config
                    commit_service_perimeters_config = parent_rpcs.commit_service_perimeters if parent_rpcs.respond_to? :commit_service_perimeters
                    @commit_service_perimeters = ::Gapic::Config::Method.new commit_service_perimeters_config
                    list_gcp_user_access_bindings_config = parent_rpcs.list_gcp_user_access_bindings if parent_rpcs.respond_to? :list_gcp_user_access_bindings
                    @list_gcp_user_access_bindings = ::Gapic::Config::Method.new list_gcp_user_access_bindings_config
                    get_gcp_user_access_binding_config = parent_rpcs.get_gcp_user_access_binding if parent_rpcs.respond_to? :get_gcp_user_access_binding
                    @get_gcp_user_access_binding = ::Gapic::Config::Method.new get_gcp_user_access_binding_config
                    create_gcp_user_access_binding_config = parent_rpcs.create_gcp_user_access_binding if parent_rpcs.respond_to? :create_gcp_user_access_binding
                    @create_gcp_user_access_binding = ::Gapic::Config::Method.new create_gcp_user_access_binding_config
                    update_gcp_user_access_binding_config = parent_rpcs.update_gcp_user_access_binding if parent_rpcs.respond_to? :update_gcp_user_access_binding
                    @update_gcp_user_access_binding = ::Gapic::Config::Method.new update_gcp_user_access_binding_config
                    delete_gcp_user_access_binding_config = parent_rpcs.delete_gcp_user_access_binding if parent_rpcs.respond_to? :delete_gcp_user_access_binding
                    @delete_gcp_user_access_binding = ::Gapic::Config::Method.new delete_gcp_user_access_binding_config
                    set_iam_policy_config = parent_rpcs.set_iam_policy if parent_rpcs.respond_to? :set_iam_policy
                    @set_iam_policy = ::Gapic::Config::Method.new set_iam_policy_config
                    get_iam_policy_config = parent_rpcs.get_iam_policy if parent_rpcs.respond_to? :get_iam_policy
                    @get_iam_policy = ::Gapic::Config::Method.new get_iam_policy_config
                    test_iam_permissions_config = parent_rpcs.test_iam_permissions if parent_rpcs.respond_to? :test_iam_permissions
                    @test_iam_permissions = ::Gapic::Config::Method.new test_iam_permissions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
