# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Identity
    module AccessContextManager
      module V1
        module AccessContextManager
          # Path helper methods for the AccessContextManager API.
          module Paths
            ##
            # Create a fully-qualified AccessLevel resource string.
            #
            # The resource will be in the following format:
            #
            # `accessPolicies/{access_policy}/accessLevels/{access_level}`
            #
            # @param access_policy [String]
            # @param access_level [String]
            #
            # @return [::String]
            def access_level_path access_policy:, access_level:
              raise ::ArgumentError, "access_policy cannot contain /" if access_policy.to_s.include? "/"

              "accessPolicies/#{access_policy}/accessLevels/#{access_level}"
            end

            ##
            # Create a fully-qualified AccessPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `accessPolicies/{access_policy}`
            #
            # @param access_policy [String]
            #
            # @return [::String]
            def access_policy_path access_policy:
              "accessPolicies/#{access_policy}"
            end

            ##
            # Create a fully-qualified GcpUserAccessBinding resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}/gcpUserAccessBindings/{gcp_user_access_binding}`
            #
            # @param organization [String]
            # @param gcp_user_access_binding [String]
            #
            # @return [::String]
            def gcp_user_access_binding_path organization:, gcp_user_access_binding:
              raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

              "organizations/#{organization}/gcpUserAccessBindings/#{gcp_user_access_binding}"
            end

            ##
            # Create a fully-qualified Organization resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}`
            #
            # @param organization [String]
            #
            # @return [::String]
            def organization_path organization:
              "organizations/#{organization}"
            end

            ##
            # Create a fully-qualified ServicePerimeter resource string.
            #
            # The resource will be in the following format:
            #
            # `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
            #
            # @param access_policy [String]
            # @param service_perimeter [String]
            #
            # @return [::String]
            def service_perimeter_path access_policy:, service_perimeter:
              raise ::ArgumentError, "access_policy cannot contain /" if access_policy.to_s.include? "/"

              "accessPolicies/#{access_policy}/servicePerimeters/#{service_perimeter}"
            end

            extend self
          end
        end
      end
    end
  end
end
