# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/iam/v3beta/principal_access_boundary_policies_service_pb"
require "google/iam/v3beta/principal_access_boundary_policies"

class ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_principal_access_boundary_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    principal_access_boundary_policy_id = "hello world"
    principal_access_boundary_policy = {}
    validate_only = true

    create_principal_access_boundary_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_principal_access_boundary_policy, name
      assert_kind_of ::Google::Iam::V3beta::CreatePrincipalAccessBoundaryPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["principal_access_boundary_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicy), request["principal_access_boundary_policy"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_principal_access_boundary_policy_client_stub do
      # Create client
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_principal_access_boundary_policy({ parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_principal_access_boundary_policy parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_principal_access_boundary_policy ::Google::Iam::V3beta::CreatePrincipalAccessBoundaryPolicyRequest.new(parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_principal_access_boundary_policy({ parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_principal_access_boundary_policy(::Google::Iam::V3beta::CreatePrincipalAccessBoundaryPolicyRequest.new(parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_principal_access_boundary_policy_client_stub.call_rpc_count
    end
  end

  def test_get_principal_access_boundary_policy
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_principal_access_boundary_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_principal_access_boundary_policy, name
      assert_kind_of ::Google::Iam::V3beta::GetPrincipalAccessBoundaryPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_principal_access_boundary_policy_client_stub do
      # Create client
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_principal_access_boundary_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_principal_access_boundary_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_principal_access_boundary_policy ::Google::Iam::V3beta::GetPrincipalAccessBoundaryPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_principal_access_boundary_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_principal_access_boundary_policy(::Google::Iam::V3beta::GetPrincipalAccessBoundaryPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_principal_access_boundary_policy_client_stub.call_rpc_count
    end
  end

  def test_update_principal_access_boundary_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    principal_access_boundary_policy = {}
    validate_only = true
    update_mask = {}

    update_principal_access_boundary_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_principal_access_boundary_policy, name
      assert_kind_of ::Google::Iam::V3beta::UpdatePrincipalAccessBoundaryPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicy), request["principal_access_boundary_policy"]
      assert_equal true, request["validate_only"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_principal_access_boundary_policy_client_stub do
      # Create client
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_principal_access_boundary_policy({ principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_principal_access_boundary_policy principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_principal_access_boundary_policy ::Google::Iam::V3beta::UpdatePrincipalAccessBoundaryPolicyRequest.new(principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_principal_access_boundary_policy({ principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_principal_access_boundary_policy(::Google::Iam::V3beta::UpdatePrincipalAccessBoundaryPolicyRequest.new(principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_principal_access_boundary_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_principal_access_boundary_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    force = true

    delete_principal_access_boundary_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_principal_access_boundary_policy, name
      assert_kind_of ::Google::Iam::V3beta::DeletePrincipalAccessBoundaryPolicyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_principal_access_boundary_policy_client_stub do
      # Create client
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_principal_access_boundary_policy({ name: name, etag: etag, validate_only: validate_only, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_principal_access_boundary_policy name: name, etag: etag, validate_only: validate_only, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_principal_access_boundary_policy ::Google::Iam::V3beta::DeletePrincipalAccessBoundaryPolicyRequest.new(name: name, etag: etag, validate_only: validate_only, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_principal_access_boundary_policy({ name: name, etag: etag, validate_only: validate_only, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_principal_access_boundary_policy(::Google::Iam::V3beta::DeletePrincipalAccessBoundaryPolicyRequest.new(name: name, etag: etag, validate_only: validate_only, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_principal_access_boundary_policy_client_stub.call_rpc_count
    end
  end

  def test_list_principal_access_boundary_policies
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_principal_access_boundary_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_principal_access_boundary_policies, name
      assert_kind_of ::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_principal_access_boundary_policies_client_stub do
      # Create client
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_principal_access_boundary_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_principal_access_boundary_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_principal_access_boundary_policies ::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_principal_access_boundary_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_principal_access_boundary_policies(::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_principal_access_boundary_policies_client_stub.call_rpc_count
    end
  end

  def test_search_principal_access_boundary_policy_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    search_principal_access_boundary_policy_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_principal_access_boundary_policy_bindings, name
      assert_kind_of ::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_principal_access_boundary_policy_bindings_client_stub do
      # Create client
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_principal_access_boundary_policy_bindings({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_principal_access_boundary_policy_bindings name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_principal_access_boundary_policy_bindings ::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_principal_access_boundary_policy_bindings({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_principal_access_boundary_policy_bindings(::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_principal_access_boundary_policy_bindings_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Operations, client.operations_client
  end
end
