# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/iam/v3beta/principal_access_boundary_policies_service_pb"
require "google/iam/v3beta/principal_access_boundary_policies/rest"


class ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_principal_access_boundary_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    principal_access_boundary_policy_id = "hello world"
    principal_access_boundary_policy = {}
    validate_only = true

    create_principal_access_boundary_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.stub :transcode_create_principal_access_boundary_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_principal_access_boundary_policy_client_stub do
        # Create client
        client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_principal_access_boundary_policy({ parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_principal_access_boundary_policy parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_principal_access_boundary_policy ::Google::Iam::V3beta::CreatePrincipalAccessBoundaryPolicyRequest.new(parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_principal_access_boundary_policy({ parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_principal_access_boundary_policy(::Google::Iam::V3beta::CreatePrincipalAccessBoundaryPolicyRequest.new(parent: parent, principal_access_boundary_policy_id: principal_access_boundary_policy_id, principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_principal_access_boundary_policy_client_stub.call_count
      end
    end
  end

  def test_get_principal_access_boundary_policy
    # Create test objects.
    client_result = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_principal_access_boundary_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.stub :transcode_get_principal_access_boundary_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_principal_access_boundary_policy_client_stub do
        # Create client
        client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_principal_access_boundary_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_principal_access_boundary_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_principal_access_boundary_policy ::Google::Iam::V3beta::GetPrincipalAccessBoundaryPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_principal_access_boundary_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_principal_access_boundary_policy(::Google::Iam::V3beta::GetPrincipalAccessBoundaryPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_principal_access_boundary_policy_client_stub.call_count
      end
    end
  end

  def test_update_principal_access_boundary_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    principal_access_boundary_policy = {}
    validate_only = true
    update_mask = {}

    update_principal_access_boundary_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.stub :transcode_update_principal_access_boundary_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_principal_access_boundary_policy_client_stub do
        # Create client
        client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_principal_access_boundary_policy({ principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_principal_access_boundary_policy principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_principal_access_boundary_policy ::Google::Iam::V3beta::UpdatePrincipalAccessBoundaryPolicyRequest.new(principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_principal_access_boundary_policy({ principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_principal_access_boundary_policy(::Google::Iam::V3beta::UpdatePrincipalAccessBoundaryPolicyRequest.new(principal_access_boundary_policy: principal_access_boundary_policy, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_principal_access_boundary_policy_client_stub.call_count
      end
    end
  end

  def test_delete_principal_access_boundary_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true
    force = true

    delete_principal_access_boundary_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.stub :transcode_delete_principal_access_boundary_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_principal_access_boundary_policy_client_stub do
        # Create client
        client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_principal_access_boundary_policy({ name: name, etag: etag, validate_only: validate_only, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_principal_access_boundary_policy name: name, etag: etag, validate_only: validate_only, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_principal_access_boundary_policy ::Google::Iam::V3beta::DeletePrincipalAccessBoundaryPolicyRequest.new(name: name, etag: etag, validate_only: validate_only, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_principal_access_boundary_policy({ name: name, etag: etag, validate_only: validate_only, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_principal_access_boundary_policy(::Google::Iam::V3beta::DeletePrincipalAccessBoundaryPolicyRequest.new(name: name, etag: etag, validate_only: validate_only, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_principal_access_boundary_policy_client_stub.call_count
      end
    end
  end

  def test_list_principal_access_boundary_policies
    # Create test objects.
    client_result = ::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_principal_access_boundary_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.stub :transcode_list_principal_access_boundary_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_principal_access_boundary_policies_client_stub do
        # Create client
        client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_principal_access_boundary_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_principal_access_boundary_policies parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_principal_access_boundary_policies ::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_principal_access_boundary_policies({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_principal_access_boundary_policies(::Google::Iam::V3beta::ListPrincipalAccessBoundaryPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_principal_access_boundary_policies_client_stub.call_count
      end
    end
  end

  def test_search_principal_access_boundary_policy_bindings
    # Create test objects.
    client_result = ::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    search_principal_access_boundary_policy_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.stub :transcode_search_principal_access_boundary_policy_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_principal_access_boundary_policy_bindings_client_stub do
        # Create client
        client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_principal_access_boundary_policy_bindings({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_principal_access_boundary_policy_bindings name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_principal_access_boundary_policy_bindings ::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_principal_access_boundary_policy_bindings({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_principal_access_boundary_policy_bindings(::Google::Iam::V3beta::SearchPrincipalAccessBoundaryPolicyBindingsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_principal_access_boundary_policy_bindings_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Iam::V3beta::PrincipalAccessBoundaryPolicies::Rest::Client::Configuration, config
  end
end
