# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Iam
    module V3beta
      module PrincipalAccessBoundaryPolicies
        # Path helper methods for the PrincipalAccessBoundaryPolicies API.
        module Paths
          ##
          # Create a fully-qualified OrganizationLocation resource string.
          #
          # The resource will be in the following format:
          #
          # `organizations/{organization}/locations/{location}`
          #
          # @param organization [String]
          # @param location [String]
          #
          # @return [::String]
          def organization_location_path organization:, location:
            raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

            "organizations/#{organization}/locations/#{location}"
          end

          ##
          # Create a fully-qualified PrincipalAccessBoundaryPolicy resource string.
          #
          # The resource will be in the following format:
          #
          # `organizations/{organization}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy}`
          #
          # @param organization [String]
          # @param location [String]
          # @param principal_access_boundary_policy [String]
          #
          # @return [::String]
          def principal_access_boundary_policy_path organization:, location:, principal_access_boundary_policy:
            raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"
            raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

            "organizations/#{organization}/locations/#{location}/principalAccessBoundaryPolicies/#{principal_access_boundary_policy}"
          end

          extend self
        end
      end
    end
  end
end
