# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/iam/v3beta/policy_bindings_service_pb"
require "google/iam/v3beta/policy_bindings/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Iam
    module V3beta
      module PolicyBindings
        module Rest
          ##
          # REST client for the PolicyBindings service.
          #
          # An interface for managing Identity and Access Management (IAM) policy
          # bindings.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "iam.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :policy_bindings_stub

            ##
            # Configure the PolicyBindings Client class.
            #
            # See {::Google::Iam::V3beta::PolicyBindings::Rest::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all PolicyBindings clients
            #   ::Google::Iam::V3beta::PolicyBindings::Rest::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Iam", "V3beta"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_policy_binding.timeout = 30.0

                default_config.rpcs.get_policy_binding.timeout = 60.0
                default_config.rpcs.get_policy_binding.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_policy_binding.timeout = 30.0

                default_config.rpcs.delete_policy_binding.timeout = 30.0

                default_config.rpcs.list_policy_bindings.timeout = 60.0
                default_config.rpcs.list_policy_bindings.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.search_target_policy_bindings.timeout = 60.0
                default_config.rpcs.search_target_policy_bindings.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the PolicyBindings Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Iam::V3beta::PolicyBindings::Rest::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @policy_bindings_stub.universe_domain
            end

            ##
            # Create a new PolicyBindings REST client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Iam::V3beta::PolicyBindings::Rest::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the PolicyBindings client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end

              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = ::Google::Iam::V3beta::PolicyBindings::Rest::Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @policy_bindings_stub = ::Google::Iam::V3beta::PolicyBindings::Rest::ServiceStub.new(
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                credentials: credentials,
                logger: @config.logger
              )

              @policy_bindings_stub.logger(stub: true)&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @policy_bindings_stub.endpoint
                config.universe_domain = @policy_bindings_stub.universe_domain
                config.logger = @policy_bindings_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Iam::V3beta::PolicyBindings::Rest::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Rest::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @policy_bindings_stub.logger
            end

            # Service calls

            ##
            # Creates a policy binding and returns a long-running operation.
            # Callers will need the IAM permissions on both the policy and target.
            # Once the binding is created, the policy is applied to the target.
            #
            # @overload create_policy_binding(request, options = nil)
            #   Pass arguments to `create_policy_binding` via a request object, either of type
            #   {::Google::Iam::V3beta::CreatePolicyBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3beta::CreatePolicyBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload create_policy_binding(parent: nil, policy_binding_id: nil, policy_binding: nil, validate_only: nil)
            #   Pass arguments to `create_policy_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this policy binding will be created.
            #     The binding parent is the closest Resource Manager resource (project,
            #     folder or organization) to the binding target.
            #
            #     Format:
            #
            #     * `projects/{project_id}/locations/{location}`
            #     * `projects/{project_number}/locations/{location}`
            #     * `folders/{folder_id}/locations/{location}`
            #     * `organizations/{organization_id}/locations/{location}`
            #   @param policy_binding_id [::String]
            #     Required. The ID to use for the policy binding, which will become the final
            #     component of the policy binding's resource name.
            #
            #     This value must start with a lowercase letter followed by up to 62
            #     lowercase letters, numbers, hyphens, or dots. Pattern,
            #     /[a-z][a-z0-9-\.]\\{2,62}/.
            #   @param policy_binding [::Google::Iam::V3beta::PolicyBinding, ::Hash]
            #     Required. The policy binding to create.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the creation, but do not
            #     actually post it.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3beta::CreatePolicyBindingRequest.new
            #
            #   # Call the create_policy_binding method.
            #   result = client.create_policy_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_policy_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3beta::CreatePolicyBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.create_policy_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3beta::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.create_policy_binding.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.create_policy_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @policy_bindings_stub.create_policy_binding request, options do |result, operation|
                result = ::Gapic::Operation.new result, @operations_client, options: options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a policy binding.
            #
            # @overload get_policy_binding(request, options = nil)
            #   Pass arguments to `get_policy_binding` via a request object, either of type
            #   {::Google::Iam::V3beta::GetPolicyBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3beta::GetPolicyBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload get_policy_binding(name: nil)
            #   Pass arguments to `get_policy_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the policy binding to retrieve.
            #
            #     Format:
            #
            #     * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
            #     * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
            #     * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
            #     * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Iam::V3beta::PolicyBinding]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Iam::V3beta::PolicyBinding]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3beta::GetPolicyBindingRequest.new
            #
            #   # Call the get_policy_binding method.
            #   result = client.get_policy_binding request
            #
            #   # The returned object is of type Google::Iam::V3beta::PolicyBinding.
            #   p result
            #
            def get_policy_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3beta::GetPolicyBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.get_policy_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3beta::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.get_policy_binding.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.get_policy_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @policy_bindings_stub.get_policy_binding request, options do |result, operation|
                yield result, operation if block_given?
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a policy binding and returns a long-running operation.
            # Callers will need the IAM permissions on the policy and target in the
            # binding to update, and the IAM permission to remove the existing policy
            # from the binding. Target is immutable and cannot be updated. Once the
            # binding is updated, the new policy is applied to the target.
            #
            # @overload update_policy_binding(request, options = nil)
            #   Pass arguments to `update_policy_binding` via a request object, either of type
            #   {::Google::Iam::V3beta::UpdatePolicyBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3beta::UpdatePolicyBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload update_policy_binding(policy_binding: nil, validate_only: nil, update_mask: nil)
            #   Pass arguments to `update_policy_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param policy_binding [::Google::Iam::V3beta::PolicyBinding, ::Hash]
            #     Required. The policy binding to update.
            #
            #     The policy binding's `name` field is used to identify the policy binding to
            #     update.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the update, but do not
            #     actually post it.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The list of fields to update
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3beta::UpdatePolicyBindingRequest.new
            #
            #   # Call the update_policy_binding method.
            #   result = client.update_policy_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_policy_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3beta::UpdatePolicyBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.update_policy_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3beta::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.update_policy_binding.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.update_policy_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @policy_bindings_stub.update_policy_binding request, options do |result, operation|
                result = ::Gapic::Operation.new result, @operations_client, options: options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a policy binding and returns a long-running operation.
            # Callers will need the IAM permissions on both the policy and target.
            # Once the binding is deleted, the policy no longer applies to the target.
            #
            # @overload delete_policy_binding(request, options = nil)
            #   Pass arguments to `delete_policy_binding` via a request object, either of type
            #   {::Google::Iam::V3beta::DeletePolicyBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3beta::DeletePolicyBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload delete_policy_binding(name: nil, etag: nil, validate_only: nil)
            #   Pass arguments to `delete_policy_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the policy binding to delete.
            #
            #     Format:
            #
            #     * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
            #     * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
            #     * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
            #     * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
            #   @param etag [::String]
            #     Optional. The etag of the policy binding.
            #     If this is provided, it must match the server's etag.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the deletion, but do not
            #     actually post it.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3beta::DeletePolicyBindingRequest.new
            #
            #   # Call the delete_policy_binding method.
            #   result = client.delete_policy_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_policy_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3beta::DeletePolicyBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.delete_policy_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3beta::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.delete_policy_binding.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.delete_policy_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @policy_bindings_stub.delete_policy_binding request, options do |result, operation|
                result = ::Gapic::Operation.new result, @operations_client, options: options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists policy bindings.
            #
            # @overload list_policy_bindings(request, options = nil)
            #   Pass arguments to `list_policy_bindings` via a request object, either of type
            #   {::Google::Iam::V3beta::ListPolicyBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3beta::ListPolicyBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload list_policy_bindings(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_policy_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource, which owns the collection of policy
            #     bindings.
            #
            #     Format:
            #
            #     * `projects/{project_id}/locations/{location}`
            #     * `projects/{project_number}/locations/{location}`
            #     * `folders/{folder_id}/locations/{location}`
            #     * `organizations/{organization_id}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of policy bindings to return. The service may
            #     return fewer than this value.
            #
            #     If unspecified, at most 50 policy bindings will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous `ListPolicyBindings` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListPolicyBindings` must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     Optional. An expression for filtering the results of the request. Filter
            #     rules are case insensitive. Some eligible fields for filtering are:
            #
            #     + `target`
            #     + `policy`
            #
            #     Some examples of filter queries:
            #
            #     * `target:ex*`: The binding target's name starts with "ex".
            #     * `target:example`: The binding target's name is `example`.
            #     * `policy:example`: The binding policy's name is `example`.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3beta::PolicyBinding>]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3beta::PolicyBinding>]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3beta::ListPolicyBindingsRequest.new
            #
            #   # Call the list_policy_bindings method.
            #   result = client.list_policy_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Iam::V3beta::PolicyBinding.
            #     p item
            #   end
            #
            def list_policy_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3beta::ListPolicyBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.list_policy_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3beta::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_policy_bindings.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.list_policy_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @policy_bindings_stub.list_policy_bindings request, options do |result, operation|
                result = ::Gapic::Rest::PagedEnumerable.new @policy_bindings_stub, :list_policy_bindings, "policy_bindings", request, result, options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Search policy bindings by target. Returns all policy binding objects bound
            # directly to target.
            #
            # @overload search_target_policy_bindings(request, options = nil)
            #   Pass arguments to `search_target_policy_bindings` via a request object, either of type
            #   {::Google::Iam::V3beta::SearchTargetPolicyBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3beta::SearchTargetPolicyBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload search_target_policy_bindings(target: nil, page_size: nil, page_token: nil, parent: nil)
            #   Pass arguments to `search_target_policy_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param target [::String]
            #     Required. The target resource, which is bound to the policy in the binding.
            #
            #     Format:
            #
            #     * `//iam.googleapis.com/locations/global/workforcePools/POOL_ID`
            #     * `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/global/workloadIdentityPools/POOL_ID`
            #     * `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
            #     * `//cloudresourcemanager.googleapis.com/projects/{project_number}`
            #     * `//cloudresourcemanager.googleapis.com/folders/{folder_id}`
            #     * `//cloudresourcemanager.googleapis.com/organizations/{organization_id}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of policy bindings to return. The service may
            #     return fewer than this value.
            #
            #     If unspecified, at most 50 policy bindings will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous
            #     `SearchTargetPolicyBindingsRequest` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `SearchTargetPolicyBindingsRequest` must match the call that provided the
            #     page token.
            #   @param parent [::String]
            #     Required. The parent resource where this search will be performed. This
            #     should be the nearest Resource Manager resource (project, folder, or
            #     organization) to the target.
            #
            #     Format:
            #
            #     * `projects/{project_id}/locations/{location}`
            #     * `projects/{project_number}/locations/{location}`
            #     * `folders/{folder_id}/locations/{location}`
            #     * `organizations/{organization_id}/locations/{location}`
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3beta::PolicyBinding>]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3beta::PolicyBinding>]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3beta"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3beta::PolicyBindings::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3beta::SearchTargetPolicyBindingsRequest.new
            #
            #   # Call the search_target_policy_bindings method.
            #   result = client.search_target_policy_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Iam::V3beta::PolicyBinding.
            #     p item
            #   end
            #
            def search_target_policy_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3beta::SearchTargetPolicyBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.search_target_policy_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3beta::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.search_target_policy_bindings.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.search_target_policy_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @policy_bindings_stub.search_target_policy_bindings request, options do |result, operation|
                result = ::Gapic::Rest::PagedEnumerable.new @policy_bindings_stub, :search_target_policy_bindings, "policy_bindings", request, result, options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the PolicyBindings REST API.
            #
            # This class represents the configuration for PolicyBindings REST,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Iam::V3beta::PolicyBindings::Rest::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_policy_binding to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Iam::V3beta::PolicyBindings::Rest::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_policy_binding.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Iam::V3beta::PolicyBindings::Rest::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_policy_binding.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`String`) The path to a service account key file in JSON format
            #    *  (`Hash`) A service account key as a Hash
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`nil`) indicating no credentials
            #
            #   Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "iam.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration RPC class for the PolicyBindings API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_policy_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_policy_binding
                ##
                # RPC-specific configuration for `get_policy_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_policy_binding
                ##
                # RPC-specific configuration for `update_policy_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_policy_binding
                ##
                # RPC-specific configuration for `delete_policy_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_policy_binding
                ##
                # RPC-specific configuration for `list_policy_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_policy_bindings
                ##
                # RPC-specific configuration for `search_target_policy_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_target_policy_bindings

                # @private
                def initialize parent_rpcs = nil
                  create_policy_binding_config = parent_rpcs.create_policy_binding if parent_rpcs.respond_to? :create_policy_binding
                  @create_policy_binding = ::Gapic::Config::Method.new create_policy_binding_config
                  get_policy_binding_config = parent_rpcs.get_policy_binding if parent_rpcs.respond_to? :get_policy_binding
                  @get_policy_binding = ::Gapic::Config::Method.new get_policy_binding_config
                  update_policy_binding_config = parent_rpcs.update_policy_binding if parent_rpcs.respond_to? :update_policy_binding
                  @update_policy_binding = ::Gapic::Config::Method.new update_policy_binding_config
                  delete_policy_binding_config = parent_rpcs.delete_policy_binding if parent_rpcs.respond_to? :delete_policy_binding
                  @delete_policy_binding = ::Gapic::Config::Method.new delete_policy_binding_config
                  list_policy_bindings_config = parent_rpcs.list_policy_bindings if parent_rpcs.respond_to? :list_policy_bindings
                  @list_policy_bindings = ::Gapic::Config::Method.new list_policy_bindings_config
                  search_target_policy_bindings_config = parent_rpcs.search_target_policy_bindings if parent_rpcs.respond_to? :search_target_policy_bindings
                  @search_target_policy_bindings = ::Gapic::Config::Method.new search_target_policy_bindings_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
