# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/iam/v3/policy_bindings_service_pb"
require "google/iam/v3/policy_bindings/rest"


class ::Google::Iam::V3::PolicyBindings::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_policy_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    policy_binding_id = "hello world"
    policy_binding = {}
    validate_only = true

    create_policy_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3::PolicyBindings::Rest::ServiceStub.stub :transcode_create_policy_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_policy_binding_client_stub do
        # Create client
        client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_policy_binding({ parent: parent, policy_binding_id: policy_binding_id, policy_binding: policy_binding, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_policy_binding parent: parent, policy_binding_id: policy_binding_id, policy_binding: policy_binding, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_policy_binding ::Google::Iam::V3::CreatePolicyBindingRequest.new(parent: parent, policy_binding_id: policy_binding_id, policy_binding: policy_binding, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_policy_binding({ parent: parent, policy_binding_id: policy_binding_id, policy_binding: policy_binding, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_policy_binding(::Google::Iam::V3::CreatePolicyBindingRequest.new(parent: parent, policy_binding_id: policy_binding_id, policy_binding: policy_binding, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_policy_binding_client_stub.call_count
      end
    end
  end

  def test_get_policy_binding
    # Create test objects.
    client_result = ::Google::Iam::V3::PolicyBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_policy_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3::PolicyBindings::Rest::ServiceStub.stub :transcode_get_policy_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_policy_binding_client_stub do
        # Create client
        client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_policy_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_policy_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_policy_binding ::Google::Iam::V3::GetPolicyBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_policy_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_policy_binding(::Google::Iam::V3::GetPolicyBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_policy_binding_client_stub.call_count
      end
    end
  end

  def test_update_policy_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    policy_binding = {}
    validate_only = true
    update_mask = {}

    update_policy_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3::PolicyBindings::Rest::ServiceStub.stub :transcode_update_policy_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_policy_binding_client_stub do
        # Create client
        client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_policy_binding({ policy_binding: policy_binding, validate_only: validate_only, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_policy_binding policy_binding: policy_binding, validate_only: validate_only, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_policy_binding ::Google::Iam::V3::UpdatePolicyBindingRequest.new(policy_binding: policy_binding, validate_only: validate_only, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_policy_binding({ policy_binding: policy_binding, validate_only: validate_only, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_policy_binding(::Google::Iam::V3::UpdatePolicyBindingRequest.new(policy_binding: policy_binding, validate_only: validate_only, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_policy_binding_client_stub.call_count
      end
    end
  end

  def test_delete_policy_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    validate_only = true

    delete_policy_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3::PolicyBindings::Rest::ServiceStub.stub :transcode_delete_policy_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_policy_binding_client_stub do
        # Create client
        client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_policy_binding({ name: name, etag: etag, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_policy_binding name: name, etag: etag, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_policy_binding ::Google::Iam::V3::DeletePolicyBindingRequest.new(name: name, etag: etag, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_policy_binding({ name: name, etag: etag, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_policy_binding(::Google::Iam::V3::DeletePolicyBindingRequest.new(name: name, etag: etag, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_policy_binding_client_stub.call_count
      end
    end
  end

  def test_list_policy_bindings
    # Create test objects.
    client_result = ::Google::Iam::V3::ListPolicyBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_policy_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3::PolicyBindings::Rest::ServiceStub.stub :transcode_list_policy_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_policy_bindings_client_stub do
        # Create client
        client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_policy_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_policy_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_policy_bindings ::Google::Iam::V3::ListPolicyBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_policy_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_policy_bindings(::Google::Iam::V3::ListPolicyBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_policy_bindings_client_stub.call_count
      end
    end
  end

  def test_search_target_policy_bindings
    # Create test objects.
    client_result = ::Google::Iam::V3::SearchTargetPolicyBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    target = "hello world"
    page_size = 42
    page_token = "hello world"
    parent = "hello world"

    search_target_policy_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Iam::V3::PolicyBindings::Rest::ServiceStub.stub :transcode_search_target_policy_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_target_policy_bindings_client_stub do
        # Create client
        client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_target_policy_bindings({ target: target, page_size: page_size, page_token: page_token, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_target_policy_bindings target: target, page_size: page_size, page_token: page_token, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_target_policy_bindings ::Google::Iam::V3::SearchTargetPolicyBindingsRequest.new(target: target, page_size: page_size, page_token: page_token, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_target_policy_bindings({ target: target, page_size: page_size, page_token: page_token, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_target_policy_bindings(::Google::Iam::V3::SearchTargetPolicyBindingsRequest.new(target: target, page_size: page_size, page_token: page_token, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_target_policy_bindings_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Iam::V3::PolicyBindings::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Iam::V3::PolicyBindings::Rest::Client::Configuration, config
  end
end
