# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Iam
    module V3
      # An IAM principal access boundary policy resource.
      # @!attribute [rw] name
      #   @return [::String]
      #     Identifier. The resource name of the principal access boundary policy.
      #
      #     The following format is supported:
      #     `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{policy_id}`
      # @!attribute [r] uid
      #   @return [::String]
      #     Output only. The globally unique ID of the principal access boundary
      #     policy.
      # @!attribute [rw] etag
      #   @return [::String]
      #     Optional. The etag for the principal access boundary.
      #     If this is provided on update, it must match the server's etag.
      # @!attribute [rw] display_name
      #   @return [::String]
      #     Optional. The description of the principal access boundary policy. Must be
      #     less than or equal to 63 characters.
      # @!attribute [rw] annotations
      #   @return [::Google::Protobuf::Map{::String => ::String}]
      #     Optional. User defined annotations. See
      #     https://google.aip.dev/148#annotations for more details such as format and
      #     size limitations
      # @!attribute [r] create_time
      #   @return [::Google::Protobuf::Timestamp]
      #     Output only. The time when the principal access boundary policy was
      #     created.
      # @!attribute [r] update_time
      #   @return [::Google::Protobuf::Timestamp]
      #     Output only. The time when the principal access boundary policy was most
      #     recently updated.
      # @!attribute [rw] details
      #   @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicyDetails]
      #     Optional. The details for the principal access boundary policy.
      class PrincipalAccessBoundaryPolicy
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # @!attribute [rw] key
        #   @return [::String]
        # @!attribute [rw] value
        #   @return [::String]
        class AnnotationsEntry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end

      # Principal access boundary policy details
      # @!attribute [rw] rules
      #   @return [::Array<::Google::Iam::V3::PrincipalAccessBoundaryPolicyRule>]
      #     Required. A list of principal access boundary policy rules. The number of
      #     rules in a policy is limited to 500.
      # @!attribute [rw] enforcement_version
      #   @return [::String]
      #     Optional.
      #     The version number (for example, `1` or `latest`) that indicates which
      #     permissions are able to be blocked by the policy. If empty, the PAB policy
      #     version will be set to the most recent version number at the time of the
      #     policy's creation.
      class PrincipalAccessBoundaryPolicyDetails
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Principal access boundary policy rule that defines the resource boundary.
      # @!attribute [rw] description
      #   @return [::String]
      #     Optional. The description of the principal access boundary policy rule.
      #     Must be less than or equal to 256 characters.
      # @!attribute [rw] resources
      #   @return [::Array<::String>]
      #     Required. A list of Resource Manager resources. If a resource is listed in
      #     the rule, then the rule applies for that resource and its descendants. The
      #     number of resources in a policy is limited to 500 across all rules in the
      #     policy.
      #
      #     The following resource types are supported:
      #
      #     * Organizations, such as
      #     `//cloudresourcemanager.googleapis.com/organizations/123`.
      #     * Folders, such as `//cloudresourcemanager.googleapis.com/folders/123`.
      #     * Projects, such as `//cloudresourcemanager.googleapis.com/projects/123`
      #       or `//cloudresourcemanager.googleapis.com/projects/my-project-id`.
      # @!attribute [rw] effect
      #   @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicyRule::Effect]
      #     Required. The access relationship of principals to the resources in this
      #     rule.
      class PrincipalAccessBoundaryPolicyRule
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # An effect to describe the access relationship.
        module Effect
          # Effect unspecified.
          EFFECT_UNSPECIFIED = 0

          # Allows access to the resources in this rule.
          ALLOW = 1
        end
      end
    end
  end
end
