# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Iam
    module V3
      # Request message for CreatePrincipalAccessBoundaryPolicyRequest method.
      # @!attribute [rw] parent
      #   @return [::String]
      #     Required. The parent resource where this principal access boundary policy
      #     will be created. Only organizations are supported.
      #
      #     Format:
      #       `organizations/{organization_id}/locations/{location}`
      # @!attribute [rw] principal_access_boundary_policy_id
      #   @return [::String]
      #     Required. The ID to use for the principal access boundary policy, which
      #     will become the final component of the principal access boundary policy's
      #     resource name.
      #
      #     This value must start with a lowercase letter followed by up to 62
      #     lowercase letters, numbers, hyphens, or dots. Pattern,
      #     /[a-z][a-z0-9-\.]\\{2,62}/.
      # @!attribute [rw] principal_access_boundary_policy
      #   @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicy]
      #     Required. The principal access boundary policy to create.
      # @!attribute [rw] validate_only
      #   @return [::Boolean]
      #     Optional. If set, validate the request and preview the creation, but do not
      #     actually post it.
      class CreatePrincipalAccessBoundaryPolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for GetPrincipalAccessBoundaryPolicy method.
      # @!attribute [rw] name
      #   @return [::String]
      #     Required. The name of the principal access boundary policy to retrieve.
      #
      #     Format:
      #       `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
      class GetPrincipalAccessBoundaryPolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for UpdatePrincipalAccessBoundaryPolicy method.
      # @!attribute [rw] principal_access_boundary_policy
      #   @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicy]
      #     Required. The principal access boundary policy to update.
      #
      #     The principal access boundary policy's `name` field is used to identify the
      #     policy to update.
      # @!attribute [rw] validate_only
      #   @return [::Boolean]
      #     Optional. If set, validate the request and preview the update, but do not
      #     actually post it.
      # @!attribute [rw] update_mask
      #   @return [::Google::Protobuf::FieldMask]
      #     Optional. The list of fields to update
      class UpdatePrincipalAccessBoundaryPolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for DeletePrincipalAccessBoundaryPolicy method.
      # @!attribute [rw] name
      #   @return [::String]
      #     Required. The name of the principal access boundary policy to delete.
      #
      #     Format:
      #       `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
      # @!attribute [rw] etag
      #   @return [::String]
      #     Optional. The etag of the principal access boundary policy.
      #     If this is provided, it must match the server's etag.
      # @!attribute [rw] validate_only
      #   @return [::Boolean]
      #     Optional. If set, validate the request and preview the deletion, but do not
      #     actually post it.
      # @!attribute [rw] force
      #   @return [::Boolean]
      #     Optional. If set to true, the request will force the deletion of the policy
      #     even if the policy is referenced in policy bindings.
      class DeletePrincipalAccessBoundaryPolicyRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for ListPrincipalAccessBoundaryPolicies method.
      # @!attribute [rw] parent
      #   @return [::String]
      #     Required. The parent resource, which owns the collection of principal
      #     access boundary policies.
      #
      #     Format:
      #       `organizations/{organization_id}/locations/{location}`
      # @!attribute [rw] page_size
      #   @return [::Integer]
      #     Optional. The maximum number of principal access boundary policies to
      #     return. The service may return fewer than this value.
      #
      #     If unspecified, at most 50 principal access boundary policies will be
      #     returned. The maximum value is 1000; values above 1000 will be coerced to
      #     1000.
      # @!attribute [rw] page_token
      #   @return [::String]
      #     Optional. A page token, received from a previous
      #     `ListPrincipalAccessBoundaryPolicies` call. Provide this to retrieve the
      #     subsequent page.
      #
      #     When paginating, all other parameters provided to
      #     `ListPrincipalAccessBoundaryPolicies` must match the call that provided the
      #     page token.
      class ListPrincipalAccessBoundaryPoliciesRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Response message for ListPrincipalAccessBoundaryPolicies method.
      # @!attribute [rw] principal_access_boundary_policies
      #   @return [::Array<::Google::Iam::V3::PrincipalAccessBoundaryPolicy>]
      #     The principal access boundary policies from the specified parent.
      # @!attribute [rw] next_page_token
      #   @return [::String]
      #     Optional. A token, which can be sent as `page_token` to retrieve the next
      #     page. If this field is omitted, there are no subsequent pages.
      class ListPrincipalAccessBoundaryPoliciesResponse
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Request message for SearchPrincipalAccessBoundaryPolicyBindings rpc.
      # @!attribute [rw] name
      #   @return [::String]
      #     Required. The name of the principal access boundary policy.
      #     Format:
      #      `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
      # @!attribute [rw] page_size
      #   @return [::Integer]
      #     Optional. The maximum number of policy bindings to return. The service may
      #     return fewer than this value.
      #
      #     If unspecified, at most 50 policy bindings will be returned.
      #     The maximum value is 1000; values above 1000 will be coerced to 1000.
      # @!attribute [rw] page_token
      #   @return [::String]
      #     Optional. A page token, received from a previous
      #     `SearchPrincipalAccessBoundaryPolicyBindingsRequest` call. Provide this to
      #     retrieve the subsequent page.
      #
      #     When paginating, all other parameters provided to
      #     `SearchPrincipalAccessBoundaryPolicyBindingsRequest` must match the call
      #     that provided the page token.
      class SearchPrincipalAccessBoundaryPolicyBindingsRequest
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Response message for SearchPrincipalAccessBoundaryPolicyBindings rpc.
      # @!attribute [rw] policy_bindings
      #   @return [::Array<::Google::Iam::V3::PolicyBinding>]
      #     The policy bindings that reference the specified policy.
      # @!attribute [rw] next_page_token
      #   @return [::String]
      #     Optional. A token, which can be sent as `page_token` to retrieve the next
      #     page. If this field is omitted, there are no subsequent pages.
      class SearchPrincipalAccessBoundaryPolicyBindingsResponse
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end
    end
  end
end
