# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/iam/v3/principal_access_boundary_policies_service_pb"

module Google
  module Iam
    module V3
      module PrincipalAccessBoundaryPolicies
        module Rest
          ##
          # REST service stub for the PrincipalAccessBoundaryPolicies service.
          # Service stub contains baseline method implementations
          # including transcoding, making the REST call, and deserialing the response.
          #
          class ServiceStub
            # @private
            def initialize endpoint:, endpoint_template:, universe_domain:, credentials:, logger:
              # These require statements are intentionally placed here to initialize
              # the REST modules only when it's required.
              require "gapic/rest"

              @client_stub = ::Gapic::Rest::ClientStub.new endpoint: endpoint,
                                                           endpoint_template: endpoint_template,
                                                           universe_domain: universe_domain,
                                                           credentials: credentials,
                                                           numeric_enums: true,
                                                           service_name: self.class,
                                                           raise_faraday_errors: false,
                                                           logger: logger
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @client_stub.universe_domain
            end

            ##
            # The effective endpoint
            #
            # @return [String]
            #
            def endpoint
              @client_stub.endpoint
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger stub: false
              stub ? @client_stub.stub_logger : @client_stub.logger
            end

            ##
            # Baseline implementation for the create_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::CreatePrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @param options [::Gapic::CallOptions]
            #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Longrunning::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Longrunning::Operation]
            #   A result object deserialized from the server's reply
            def create_principal_access_boundary_policy request_pb, options = nil
              raise ::ArgumentError, "request must be provided" if request_pb.nil?

              verb, uri, query_string_params, body = ServiceStub.transcode_create_principal_access_boundary_policy_request request_pb
              query_string_params = if query_string_params.any?
                                      query_string_params.to_h { |p| p.split "=", 2 }
                                    else
                                      {}
                                    end

              response = @client_stub.make_http_request(
                verb,
                uri: uri,
                body: body || "",
                params: query_string_params,
                method_name: "create_principal_access_boundary_policy",
                options: options
              )
              operation = ::Gapic::Rest::TransportOperation.new response
              result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
              catch :response do
                yield result, operation if block_given?
                result
              end
            end

            ##
            # Baseline implementation for the get_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::GetPrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @param options [::Gapic::CallOptions]
            #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Iam::V3::PrincipalAccessBoundaryPolicy]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicy]
            #   A result object deserialized from the server's reply
            def get_principal_access_boundary_policy request_pb, options = nil
              raise ::ArgumentError, "request must be provided" if request_pb.nil?

              verb, uri, query_string_params, body = ServiceStub.transcode_get_principal_access_boundary_policy_request request_pb
              query_string_params = if query_string_params.any?
                                      query_string_params.to_h { |p| p.split "=", 2 }
                                    else
                                      {}
                                    end

              response = @client_stub.make_http_request(
                verb,
                uri: uri,
                body: body || "",
                params: query_string_params,
                method_name: "get_principal_access_boundary_policy",
                options: options
              )
              operation = ::Gapic::Rest::TransportOperation.new response
              result = ::Google::Iam::V3::PrincipalAccessBoundaryPolicy.decode_json response.body, ignore_unknown_fields: true
              catch :response do
                yield result, operation if block_given?
                result
              end
            end

            ##
            # Baseline implementation for the update_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::UpdatePrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @param options [::Gapic::CallOptions]
            #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Longrunning::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Longrunning::Operation]
            #   A result object deserialized from the server's reply
            def update_principal_access_boundary_policy request_pb, options = nil
              raise ::ArgumentError, "request must be provided" if request_pb.nil?

              verb, uri, query_string_params, body = ServiceStub.transcode_update_principal_access_boundary_policy_request request_pb
              query_string_params = if query_string_params.any?
                                      query_string_params.to_h { |p| p.split "=", 2 }
                                    else
                                      {}
                                    end

              response = @client_stub.make_http_request(
                verb,
                uri: uri,
                body: body || "",
                params: query_string_params,
                method_name: "update_principal_access_boundary_policy",
                options: options
              )
              operation = ::Gapic::Rest::TransportOperation.new response
              result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
              catch :response do
                yield result, operation if block_given?
                result
              end
            end

            ##
            # Baseline implementation for the delete_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::DeletePrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @param options [::Gapic::CallOptions]
            #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Longrunning::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Longrunning::Operation]
            #   A result object deserialized from the server's reply
            def delete_principal_access_boundary_policy request_pb, options = nil
              raise ::ArgumentError, "request must be provided" if request_pb.nil?

              verb, uri, query_string_params, body = ServiceStub.transcode_delete_principal_access_boundary_policy_request request_pb
              query_string_params = if query_string_params.any?
                                      query_string_params.to_h { |p| p.split "=", 2 }
                                    else
                                      {}
                                    end

              response = @client_stub.make_http_request(
                verb,
                uri: uri,
                body: body || "",
                params: query_string_params,
                method_name: "delete_principal_access_boundary_policy",
                options: options
              )
              operation = ::Gapic::Rest::TransportOperation.new response
              result = ::Google::Longrunning::Operation.decode_json response.body, ignore_unknown_fields: true
              catch :response do
                yield result, operation if block_given?
                result
              end
            end

            ##
            # Baseline implementation for the list_principal_access_boundary_policies REST call
            #
            # @param request_pb [::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesRequest]
            #   A request object representing the call parameters. Required.
            # @param options [::Gapic::CallOptions]
            #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesResponse]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesResponse]
            #   A result object deserialized from the server's reply
            def list_principal_access_boundary_policies request_pb, options = nil
              raise ::ArgumentError, "request must be provided" if request_pb.nil?

              verb, uri, query_string_params, body = ServiceStub.transcode_list_principal_access_boundary_policies_request request_pb
              query_string_params = if query_string_params.any?
                                      query_string_params.to_h { |p| p.split "=", 2 }
                                    else
                                      {}
                                    end

              response = @client_stub.make_http_request(
                verb,
                uri: uri,
                body: body || "",
                params: query_string_params,
                method_name: "list_principal_access_boundary_policies",
                options: options
              )
              operation = ::Gapic::Rest::TransportOperation.new response
              result = ::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesResponse.decode_json response.body, ignore_unknown_fields: true
              catch :response do
                yield result, operation if block_given?
                result
              end
            end

            ##
            # Baseline implementation for the search_principal_access_boundary_policy_bindings REST call
            #
            # @param request_pb [::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsRequest]
            #   A request object representing the call parameters. Required.
            # @param options [::Gapic::CallOptions]
            #   Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsResponse]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsResponse]
            #   A result object deserialized from the server's reply
            def search_principal_access_boundary_policy_bindings request_pb, options = nil
              raise ::ArgumentError, "request must be provided" if request_pb.nil?

              verb, uri, query_string_params, body = ServiceStub.transcode_search_principal_access_boundary_policy_bindings_request request_pb
              query_string_params = if query_string_params.any?
                                      query_string_params.to_h { |p| p.split "=", 2 }
                                    else
                                      {}
                                    end

              response = @client_stub.make_http_request(
                verb,
                uri: uri,
                body: body || "",
                params: query_string_params,
                method_name: "search_principal_access_boundary_policy_bindings",
                options: options
              )
              operation = ::Gapic::Rest::TransportOperation.new response
              result = ::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsResponse.decode_json response.body, ignore_unknown_fields: true
              catch :response do
                yield result, operation if block_given?
                result
              end
            end

            ##
            # @private
            #
            # GRPC transcoding helper method for the create_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::CreatePrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @return [Array(String, [String, nil], Hash{String => String})]
            #   Uri, Body, Query string parameters
            def self.transcode_create_principal_access_boundary_policy_request request_pb
              transcoder = Gapic::Rest::GrpcTranscoder.new
                                                      .with_bindings(
                                                        uri_method: :post,
                                                        uri_template: "/v3/{parent}/principalAccessBoundaryPolicies",
                                                        body: "principal_access_boundary_policy",
                                                        matches: [
                                                          ["parent", %r{^organizations/[^/]+/locations/[^/]+/?$}, false]
                                                        ]
                                                      )
              transcoder.transcode request_pb
            end

            ##
            # @private
            #
            # GRPC transcoding helper method for the get_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::GetPrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @return [Array(String, [String, nil], Hash{String => String})]
            #   Uri, Body, Query string parameters
            def self.transcode_get_principal_access_boundary_policy_request request_pb
              transcoder = Gapic::Rest::GrpcTranscoder.new
                                                      .with_bindings(
                                                        uri_method: :get,
                                                        uri_template: "/v3/{name}",
                                                        matches: [
                                                          ["name", %r{^organizations/[^/]+/locations/[^/]+/principalAccessBoundaryPolicies/[^/]+/?$}, false]
                                                        ]
                                                      )
              transcoder.transcode request_pb
            end

            ##
            # @private
            #
            # GRPC transcoding helper method for the update_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::UpdatePrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @return [Array(String, [String, nil], Hash{String => String})]
            #   Uri, Body, Query string parameters
            def self.transcode_update_principal_access_boundary_policy_request request_pb
              transcoder = Gapic::Rest::GrpcTranscoder.new
                                                      .with_bindings(
                                                        uri_method: :patch,
                                                        uri_template: "/v3/{principal_access_boundary_policy.name}",
                                                        body: "principal_access_boundary_policy",
                                                        matches: [
                                                          ["principal_access_boundary_policy.name", %r{^organizations/[^/]+/locations/[^/]+/principalAccessBoundaryPolicies/[^/]+/?$}, false]
                                                        ]
                                                      )
              transcoder.transcode request_pb
            end

            ##
            # @private
            #
            # GRPC transcoding helper method for the delete_principal_access_boundary_policy REST call
            #
            # @param request_pb [::Google::Iam::V3::DeletePrincipalAccessBoundaryPolicyRequest]
            #   A request object representing the call parameters. Required.
            # @return [Array(String, [String, nil], Hash{String => String})]
            #   Uri, Body, Query string parameters
            def self.transcode_delete_principal_access_boundary_policy_request request_pb
              transcoder = Gapic::Rest::GrpcTranscoder.new
                                                      .with_bindings(
                                                        uri_method: :delete,
                                                        uri_template: "/v3/{name}",
                                                        matches: [
                                                          ["name", %r{^organizations/[^/]+/locations/[^/]+/principalAccessBoundaryPolicies/[^/]+/?$}, false]
                                                        ]
                                                      )
              transcoder.transcode request_pb
            end

            ##
            # @private
            #
            # GRPC transcoding helper method for the list_principal_access_boundary_policies REST call
            #
            # @param request_pb [::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesRequest]
            #   A request object representing the call parameters. Required.
            # @return [Array(String, [String, nil], Hash{String => String})]
            #   Uri, Body, Query string parameters
            def self.transcode_list_principal_access_boundary_policies_request request_pb
              transcoder = Gapic::Rest::GrpcTranscoder.new
                                                      .with_bindings(
                                                        uri_method: :get,
                                                        uri_template: "/v3/{parent}/principalAccessBoundaryPolicies",
                                                        matches: [
                                                          ["parent", %r{^organizations/[^/]+/locations/[^/]+/?$}, false]
                                                        ]
                                                      )
              transcoder.transcode request_pb
            end

            ##
            # @private
            #
            # GRPC transcoding helper method for the search_principal_access_boundary_policy_bindings REST call
            #
            # @param request_pb [::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsRequest]
            #   A request object representing the call parameters. Required.
            # @return [Array(String, [String, nil], Hash{String => String})]
            #   Uri, Body, Query string parameters
            def self.transcode_search_principal_access_boundary_policy_bindings_request request_pb
              transcoder = Gapic::Rest::GrpcTranscoder.new
                                                      .with_bindings(
                                                        uri_method: :get,
                                                        uri_template: "/v3/{name}:searchPolicyBindings",
                                                        matches: [
                                                          ["name", %r{^organizations/[^/]+/locations/[^/]+/principalAccessBoundaryPolicies/[^/]+/?$}, false]
                                                        ]
                                                      )
              transcoder.transcode request_pb
            end
          end
        end
      end
    end
  end
end
