# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/iam/v3/principal_access_boundary_policies_service_pb"
require "google/iam/v3/principal_access_boundary_policies/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Iam
    module V3
      module PrincipalAccessBoundaryPolicies
        module Rest
          ##
          # REST client for the PrincipalAccessBoundaryPolicies service.
          #
          # Manages Identity and Access Management (IAM) principal access boundary
          # policies.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "iam.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :principal_access_boundary_policies_stub

            ##
            # Configure the PrincipalAccessBoundaryPolicies Client class.
            #
            # See {::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all PrincipalAccessBoundaryPolicies clients
            #   ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Iam", "V3"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_principal_access_boundary_policy.timeout = 30.0

                default_config.rpcs.get_principal_access_boundary_policy.timeout = 60.0
                default_config.rpcs.get_principal_access_boundary_policy.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_principal_access_boundary_policy.timeout = 30.0

                default_config.rpcs.delete_principal_access_boundary_policy.timeout = 30.0

                default_config.rpcs.list_principal_access_boundary_policies.timeout = 60.0
                default_config.rpcs.list_principal_access_boundary_policies.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.search_principal_access_boundary_policy_bindings.timeout = 60.0
                default_config.rpcs.search_principal_access_boundary_policy_bindings.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the PrincipalAccessBoundaryPolicies Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @principal_access_boundary_policies_stub.universe_domain
            end

            ##
            # Create a new PrincipalAccessBoundaryPolicies REST client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the PrincipalAccessBoundaryPolicies client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end

              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @principal_access_boundary_policies_stub = ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::ServiceStub.new(
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                credentials: credentials,
                logger: @config.logger
              )

              @principal_access_boundary_policies_stub.logger(stub: true)&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @principal_access_boundary_policies_stub.endpoint
                config.universe_domain = @principal_access_boundary_policies_stub.universe_domain
                config.logger = @principal_access_boundary_policies_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Rest::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @principal_access_boundary_policies_stub.logger
            end

            # Service calls

            ##
            # Creates a principal access boundary policy, and returns a long running
            # operation.
            #
            # @overload create_principal_access_boundary_policy(request, options = nil)
            #   Pass arguments to `create_principal_access_boundary_policy` via a request object, either of type
            #   {::Google::Iam::V3::CreatePrincipalAccessBoundaryPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3::CreatePrincipalAccessBoundaryPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload create_principal_access_boundary_policy(parent: nil, principal_access_boundary_policy_id: nil, principal_access_boundary_policy: nil, validate_only: nil)
            #   Pass arguments to `create_principal_access_boundary_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource where this principal access boundary policy
            #     will be created. Only organizations are supported.
            #
            #     Format:
            #       `organizations/{organization_id}/locations/{location}`
            #   @param principal_access_boundary_policy_id [::String]
            #     Required. The ID to use for the principal access boundary policy, which
            #     will become the final component of the principal access boundary policy's
            #     resource name.
            #
            #     This value must start with a lowercase letter followed by up to 62
            #     lowercase letters, numbers, hyphens, or dots. Pattern,
            #     /[a-z][a-z0-9-\.]\\{2,62}/.
            #   @param principal_access_boundary_policy [::Google::Iam::V3::PrincipalAccessBoundaryPolicy, ::Hash]
            #     Required. The principal access boundary policy to create.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the creation, but do not
            #     actually post it.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3::CreatePrincipalAccessBoundaryPolicyRequest.new
            #
            #   # Call the create_principal_access_boundary_policy method.
            #   result = client.create_principal_access_boundary_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_principal_access_boundary_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3::CreatePrincipalAccessBoundaryPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.create_principal_access_boundary_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.create_principal_access_boundary_policy.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.create_principal_access_boundary_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @principal_access_boundary_policies_stub.create_principal_access_boundary_policy request, options do |result, operation|
                result = ::Gapic::Operation.new result, @operations_client, options: options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a principal access boundary policy.
            #
            # @overload get_principal_access_boundary_policy(request, options = nil)
            #   Pass arguments to `get_principal_access_boundary_policy` via a request object, either of type
            #   {::Google::Iam::V3::GetPrincipalAccessBoundaryPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3::GetPrincipalAccessBoundaryPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload get_principal_access_boundary_policy(name: nil)
            #   Pass arguments to `get_principal_access_boundary_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the principal access boundary policy to retrieve.
            #
            #     Format:
            #       `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Google::Iam::V3::PrincipalAccessBoundaryPolicy]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Google::Iam::V3::PrincipalAccessBoundaryPolicy]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3::GetPrincipalAccessBoundaryPolicyRequest.new
            #
            #   # Call the get_principal_access_boundary_policy method.
            #   result = client.get_principal_access_boundary_policy request
            #
            #   # The returned object is of type Google::Iam::V3::PrincipalAccessBoundaryPolicy.
            #   p result
            #
            def get_principal_access_boundary_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3::GetPrincipalAccessBoundaryPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.get_principal_access_boundary_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.get_principal_access_boundary_policy.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.get_principal_access_boundary_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @principal_access_boundary_policies_stub.get_principal_access_boundary_policy request, options do |result, operation|
                yield result, operation if block_given?
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a principal access boundary policy.
            #
            # @overload update_principal_access_boundary_policy(request, options = nil)
            #   Pass arguments to `update_principal_access_boundary_policy` via a request object, either of type
            #   {::Google::Iam::V3::UpdatePrincipalAccessBoundaryPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3::UpdatePrincipalAccessBoundaryPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload update_principal_access_boundary_policy(principal_access_boundary_policy: nil, validate_only: nil, update_mask: nil)
            #   Pass arguments to `update_principal_access_boundary_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param principal_access_boundary_policy [::Google::Iam::V3::PrincipalAccessBoundaryPolicy, ::Hash]
            #     Required. The principal access boundary policy to update.
            #
            #     The principal access boundary policy's `name` field is used to identify the
            #     policy to update.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the update, but do not
            #     actually post it.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The list of fields to update
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3::UpdatePrincipalAccessBoundaryPolicyRequest.new
            #
            #   # Call the update_principal_access_boundary_policy method.
            #   result = client.update_principal_access_boundary_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_principal_access_boundary_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3::UpdatePrincipalAccessBoundaryPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.update_principal_access_boundary_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.update_principal_access_boundary_policy.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.update_principal_access_boundary_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @principal_access_boundary_policies_stub.update_principal_access_boundary_policy request, options do |result, operation|
                result = ::Gapic::Operation.new result, @operations_client, options: options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a principal access boundary policy.
            #
            # @overload delete_principal_access_boundary_policy(request, options = nil)
            #   Pass arguments to `delete_principal_access_boundary_policy` via a request object, either of type
            #   {::Google::Iam::V3::DeletePrincipalAccessBoundaryPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3::DeletePrincipalAccessBoundaryPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload delete_principal_access_boundary_policy(name: nil, etag: nil, validate_only: nil, force: nil)
            #   Pass arguments to `delete_principal_access_boundary_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the principal access boundary policy to delete.
            #
            #     Format:
            #       `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
            #   @param etag [::String]
            #     Optional. The etag of the principal access boundary policy.
            #     If this is provided, it must match the server's etag.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the deletion, but do not
            #     actually post it.
            #   @param force [::Boolean]
            #     Optional. If set to true, the request will force the deletion of the policy
            #     even if the policy is referenced in policy bindings.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Operation]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3::DeletePrincipalAccessBoundaryPolicyRequest.new
            #
            #   # Call the delete_principal_access_boundary_policy method.
            #   result = client.delete_principal_access_boundary_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_principal_access_boundary_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3::DeletePrincipalAccessBoundaryPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.delete_principal_access_boundary_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.delete_principal_access_boundary_policy.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.delete_principal_access_boundary_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @principal_access_boundary_policies_stub.delete_principal_access_boundary_policy request, options do |result, operation|
                result = ::Gapic::Operation.new result, @operations_client, options: options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists principal access boundary policies.
            #
            # @overload list_principal_access_boundary_policies(request, options = nil)
            #   Pass arguments to `list_principal_access_boundary_policies` via a request object, either of type
            #   {::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload list_principal_access_boundary_policies(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_principal_access_boundary_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent resource, which owns the collection of principal
            #     access boundary policies.
            #
            #     Format:
            #       `organizations/{organization_id}/locations/{location}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of principal access boundary policies to
            #     return. The service may return fewer than this value.
            #
            #     If unspecified, at most 50 principal access boundary policies will be
            #     returned. The maximum value is 1000; values above 1000 will be coerced to
            #     1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous
            #     `ListPrincipalAccessBoundaryPolicies` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListPrincipalAccessBoundaryPolicies` must match the call that provided the
            #     page token.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3::PrincipalAccessBoundaryPolicy>]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3::PrincipalAccessBoundaryPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesRequest.new
            #
            #   # Call the list_principal_access_boundary_policies method.
            #   result = client.list_principal_access_boundary_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Iam::V3::PrincipalAccessBoundaryPolicy.
            #     p item
            #   end
            #
            def list_principal_access_boundary_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3::ListPrincipalAccessBoundaryPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.list_principal_access_boundary_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.list_principal_access_boundary_policies.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.list_principal_access_boundary_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @principal_access_boundary_policies_stub.list_principal_access_boundary_policies request, options do |result, operation|
                result = ::Gapic::Rest::PagedEnumerable.new @principal_access_boundary_policies_stub, :list_principal_access_boundary_policies, "principal_access_boundary_policies", request, result, options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns all policy bindings that bind a specific policy if a user has
            # searchPolicyBindings permission on that policy.
            #
            # @overload search_principal_access_boundary_policy_bindings(request, options = nil)
            #   Pass arguments to `search_principal_access_boundary_policy_bindings` via a request object, either of type
            #   {::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
            #
            # @overload search_principal_access_boundary_policy_bindings(name: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `search_principal_access_boundary_policy_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the principal access boundary policy.
            #     Format:
            #      `organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
            #   @param page_size [::Integer]
            #     Optional. The maximum number of policy bindings to return. The service may
            #     return fewer than this value.
            #
            #     If unspecified, at most 50 policy bindings will be returned.
            #     The maximum value is 1000; values above 1000 will be coerced to 1000.
            #   @param page_token [::String]
            #     Optional. A page token, received from a previous
            #     `SearchPrincipalAccessBoundaryPolicyBindingsRequest` call. Provide this to
            #     retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `SearchPrincipalAccessBoundaryPolicyBindingsRequest` must match the call
            #     that provided the page token.
            # @yield [result, operation] Access the result along with the TransportOperation object
            # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3::PolicyBinding>]
            # @yieldparam operation [::Gapic::Rest::TransportOperation]
            #
            # @return [::Gapic::Rest::PagedEnumerable<::Google::Iam::V3::PolicyBinding>]
            #
            # @raise [::Google::Cloud::Error] if the REST call is aborted.
            #
            # @example Basic example
            #   require "google/iam/v3"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsRequest.new
            #
            #   # Call the search_principal_access_boundary_policy_bindings method.
            #   result = client.search_principal_access_boundary_policy_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Iam::V3::PolicyBinding.
            #     p item
            #   end
            #
            def search_principal_access_boundary_policy_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V3::SearchPrincipalAccessBoundaryPolicyBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              call_metadata = @config.rpcs.search_principal_access_boundary_policy_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Iam::V3::VERSION,
                transports_version_send: [:rest]

              call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              options.apply_defaults timeout:      @config.rpcs.search_principal_access_boundary_policy_bindings.timeout,
                                     metadata:     call_metadata,
                                     retry_policy: @config.rpcs.search_principal_access_boundary_policy_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @principal_access_boundary_policies_stub.search_principal_access_boundary_policy_bindings request, options do |result, operation|
                result = ::Gapic::Rest::PagedEnumerable.new @principal_access_boundary_policies_stub, :search_principal_access_boundary_policy_bindings, "policy_bindings", request, result, options
                yield result, operation if block_given?
                throw :response, result
              end
            rescue ::Gapic::Rest::Error => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the PrincipalAccessBoundaryPolicies REST API.
            #
            # This class represents the configuration for PrincipalAccessBoundaryPolicies REST,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_principal_access_boundary_policy to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_principal_access_boundary_policy.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Iam::V3::PrincipalAccessBoundaryPolicies::Rest::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_principal_access_boundary_policy.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`String`) The path to a service account key file in JSON format
            #    *  (`Hash`) A service account key as a Hash
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`nil`) indicating no credentials
            #
            #   Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "iam.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration RPC class for the PrincipalAccessBoundaryPolicies API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_principal_access_boundary_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_principal_access_boundary_policy
                ##
                # RPC-specific configuration for `get_principal_access_boundary_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_principal_access_boundary_policy
                ##
                # RPC-specific configuration for `update_principal_access_boundary_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_principal_access_boundary_policy
                ##
                # RPC-specific configuration for `delete_principal_access_boundary_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_principal_access_boundary_policy
                ##
                # RPC-specific configuration for `list_principal_access_boundary_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_principal_access_boundary_policies
                ##
                # RPC-specific configuration for `search_principal_access_boundary_policy_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :search_principal_access_boundary_policy_bindings

                # @private
                def initialize parent_rpcs = nil
                  create_principal_access_boundary_policy_config = parent_rpcs.create_principal_access_boundary_policy if parent_rpcs.respond_to? :create_principal_access_boundary_policy
                  @create_principal_access_boundary_policy = ::Gapic::Config::Method.new create_principal_access_boundary_policy_config
                  get_principal_access_boundary_policy_config = parent_rpcs.get_principal_access_boundary_policy if parent_rpcs.respond_to? :get_principal_access_boundary_policy
                  @get_principal_access_boundary_policy = ::Gapic::Config::Method.new get_principal_access_boundary_policy_config
                  update_principal_access_boundary_policy_config = parent_rpcs.update_principal_access_boundary_policy if parent_rpcs.respond_to? :update_principal_access_boundary_policy
                  @update_principal_access_boundary_policy = ::Gapic::Config::Method.new update_principal_access_boundary_policy_config
                  delete_principal_access_boundary_policy_config = parent_rpcs.delete_principal_access_boundary_policy if parent_rpcs.respond_to? :delete_principal_access_boundary_policy
                  @delete_principal_access_boundary_policy = ::Gapic::Config::Method.new delete_principal_access_boundary_policy_config
                  list_principal_access_boundary_policies_config = parent_rpcs.list_principal_access_boundary_policies if parent_rpcs.respond_to? :list_principal_access_boundary_policies
                  @list_principal_access_boundary_policies = ::Gapic::Config::Method.new list_principal_access_boundary_policies_config
                  search_principal_access_boundary_policy_bindings_config = parent_rpcs.search_principal_access_boundary_policy_bindings if parent_rpcs.respond_to? :search_principal_access_boundary_policy_bindings
                  @search_principal_access_boundary_policy_bindings = ::Gapic::Config::Method.new search_principal_access_boundary_policy_bindings_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
