# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/iam/v3/policy_bindings_service.proto for package 'google.iam.v3'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/iam/v3/policy_bindings_service_pb'

module Google
  module Iam
    module V3
      module PolicyBindings
        # An interface for managing Identity and Access Management (IAM) policy
        # bindings.
        class Service

          include ::GRPC::GenericService

          self.marshal_class_method = :encode
          self.unmarshal_class_method = :decode
          self.service_name = 'google.iam.v3.PolicyBindings'

          # Creates a policy binding and returns a long-running operation.
          # Callers will need the IAM permissions on both the policy and target.
          # Once the binding is created, the policy is applied to the target.
          rpc :CreatePolicyBinding, ::Google::Iam::V3::CreatePolicyBindingRequest, ::Google::Longrunning::Operation
          # Gets a policy binding.
          rpc :GetPolicyBinding, ::Google::Iam::V3::GetPolicyBindingRequest, ::Google::Iam::V3::PolicyBinding
          # Updates a policy binding and returns a long-running operation.
          # Callers will need the IAM permissions on the policy and target in the
          # binding to update, and the IAM permission to remove the existing policy
          # from the binding. Target is immutable and cannot be updated. Once the
          # binding is updated, the new policy is applied to the target.
          rpc :UpdatePolicyBinding, ::Google::Iam::V3::UpdatePolicyBindingRequest, ::Google::Longrunning::Operation
          # Deletes a policy binding and returns a long-running operation.
          # Callers will need the IAM permissions on both the policy and target.
          # Once the binding is deleted, the policy no longer applies to the target.
          rpc :DeletePolicyBinding, ::Google::Iam::V3::DeletePolicyBindingRequest, ::Google::Longrunning::Operation
          # Lists policy bindings.
          rpc :ListPolicyBindings, ::Google::Iam::V3::ListPolicyBindingsRequest, ::Google::Iam::V3::ListPolicyBindingsResponse
          # Search policy bindings by target. Returns all policy binding objects bound
          # directly to target.
          rpc :SearchTargetPolicyBindings, ::Google::Iam::V3::SearchTargetPolicyBindingsRequest, ::Google::Iam::V3::SearchTargetPolicyBindingsResponse
        end

        Stub = Service.rpc_stub_class
      end
    end
  end
end
