# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Iam
    module V1beta
      module WorkloadIdentityPools
        # Path helper methods for the WorkloadIdentityPools API.
        module Paths
          ##
          # Create a fully-qualified Project resource string.
          #
          # The resource will be in the following format:
          #
          # `projects/{project}`
          #
          # @param project [String]
          #
          # @return [::String]
          def project_path project:
            "projects/#{project}"
          end

          ##
          # Create a fully-qualified WorkloadIdentityPool resource string.
          #
          # The resource will be in the following format:
          #
          # `projects/{project}/locations/{location}/workloadIdentityPools/{workload_identity_pool}`
          #
          # @param project [String]
          # @param location [String]
          # @param workload_identity_pool [String]
          #
          # @return [::String]
          def workload_identity_pool_path project:, location:, workload_identity_pool:
            raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
            raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

            "projects/#{project}/locations/#{location}/workloadIdentityPools/#{workload_identity_pool}"
          end

          ##
          # Create a fully-qualified WorkloadIdentityPoolProvider resource string.
          #
          # The resource will be in the following format:
          #
          # `projects/{project}/locations/{location}/workloadIdentityPools/{workload_identity_pool}/providers/{workload_identity_pool_provider}`
          #
          # @param project [String]
          # @param location [String]
          # @param workload_identity_pool [String]
          # @param workload_identity_pool_provider [String]
          #
          # @return [::String]
          def workload_identity_pool_provider_path project:, location:, workload_identity_pool:, workload_identity_pool_provider:
            raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
            raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
            raise ::ArgumentError, "workload_identity_pool cannot contain /" if workload_identity_pool.to_s.include? "/"

            "projects/#{project}/locations/#{location}/workloadIdentityPools/#{workload_identity_pool}/providers/#{workload_identity_pool_provider}"
          end

          extend self
        end
      end
    end
  end
end
