# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/iam/v1beta/workload_identity_pool_pb"

module Google
  module Iam
    module V1beta
      module WorkloadIdentityPools
        ##
        # Client for the WorkloadIdentityPools service.
        #
        # Manages WorkloadIdentityPools.
        #
        class Client
          # @private
          API_VERSION = ""

          # @private
          DEFAULT_ENDPOINT_TEMPLATE = "iam.$UNIVERSE_DOMAIN$"

          include Paths

          # @private
          attr_reader :workload_identity_pools_stub

          ##
          # Configure the WorkloadIdentityPools Client class.
          #
          # See {::Google::Iam::V1beta::WorkloadIdentityPools::Client::Configuration}
          # for a description of the configuration fields.
          #
          # @example
          #
          #   # Modify the configuration for all WorkloadIdentityPools clients
          #   ::Google::Iam::V1beta::WorkloadIdentityPools::Client.configure do |config|
          #     config.timeout = 10.0
          #   end
          #
          # @yield [config] Configure the Client client.
          # @yieldparam config [Client::Configuration]
          #
          # @return [Client::Configuration]
          #
          def self.configure
            @configure ||= begin
              namespace = ["Google", "Iam", "V1beta"]
              parent_config = while namespace.any?
                                parent_name = namespace.join "::"
                                parent_const = const_get parent_name
                                break parent_const.configure if parent_const.respond_to? :configure
                                namespace.pop
                              end
              default_config = Client::Configuration.new parent_config

              default_config.rpcs.list_workload_identity_pools.timeout = 60.0
              default_config.rpcs.list_workload_identity_pools.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.get_workload_identity_pool.timeout = 60.0
              default_config.rpcs.get_workload_identity_pool.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.create_workload_identity_pool.timeout = 60.0
              default_config.rpcs.create_workload_identity_pool.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.update_workload_identity_pool.timeout = 60.0
              default_config.rpcs.update_workload_identity_pool.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.delete_workload_identity_pool.timeout = 60.0
              default_config.rpcs.delete_workload_identity_pool.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.undelete_workload_identity_pool.timeout = 60.0
              default_config.rpcs.undelete_workload_identity_pool.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.list_workload_identity_pool_providers.timeout = 60.0
              default_config.rpcs.list_workload_identity_pool_providers.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.get_workload_identity_pool_provider.timeout = 60.0
              default_config.rpcs.get_workload_identity_pool_provider.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.create_workload_identity_pool_provider.timeout = 60.0
              default_config.rpcs.create_workload_identity_pool_provider.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.update_workload_identity_pool_provider.timeout = 60.0
              default_config.rpcs.update_workload_identity_pool_provider.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.delete_workload_identity_pool_provider.timeout = 60.0
              default_config.rpcs.delete_workload_identity_pool_provider.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config.rpcs.undelete_workload_identity_pool_provider.timeout = 60.0
              default_config.rpcs.undelete_workload_identity_pool_provider.retry_policy = {
                initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14, 4]
              }

              default_config
            end
            yield @configure if block_given?
            @configure
          end

          ##
          # Configure the WorkloadIdentityPools Client instance.
          #
          # The configuration is set to the derived mode, meaning that values can be changed,
          # but structural changes (adding new fields, etc.) are not allowed. Structural changes
          # should be made on {Client.configure}.
          #
          # See {::Google::Iam::V1beta::WorkloadIdentityPools::Client::Configuration}
          # for a description of the configuration fields.
          #
          # @yield [config] Configure the Client client.
          # @yieldparam config [Client::Configuration]
          #
          # @return [Client::Configuration]
          #
          def configure
            yield @config if block_given?
            @config
          end

          ##
          # The effective universe domain
          #
          # @return [String]
          #
          def universe_domain
            @workload_identity_pools_stub.universe_domain
          end

          ##
          # Create a new WorkloadIdentityPools client object.
          #
          # @example
          #
          #   # Create a client using the default configuration
          #   client = ::Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a client using a custom configuration
          #   client = ::Google::Iam::V1beta::WorkloadIdentityPools::Client.new do |config|
          #     config.timeout = 10.0
          #   end
          #
          # @yield [config] Configure the WorkloadIdentityPools client.
          # @yieldparam config [Client::Configuration]
          #
          def initialize
            # These require statements are intentionally placed here to initialize
            # the gRPC module only when it's required.
            # See https://github.com/googleapis/toolkit/issues/446
            require "gapic/grpc"
            require "google/iam/v1beta/workload_identity_pool_services_pb"

            # Create the configuration object
            @config = Configuration.new Client.configure

            # Yield the configuration if needed
            yield @config if block_given?

            # Create credentials
            credentials = @config.credentials
            # Use self-signed JWT if the endpoint is unchanged from default,
            # but only if the default endpoint does not have a region prefix.
            enable_self_signed_jwt = @config.endpoint.nil? ||
                                     (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                     !@config.endpoint.split(".").first.include?("-"))
            credentials ||= Credentials.default scope: @config.scope,
                                                enable_self_signed_jwt: enable_self_signed_jwt
            if credentials.is_a?(::String) || credentials.is_a?(::Hash)
              credentials = Credentials.new credentials, scope: @config.scope
            end
            @quota_project_id = @config.quota_project
            @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

            @operations_client = Operations.new do |config|
              config.credentials = credentials
              config.quota_project = @quota_project_id
              config.endpoint = @config.endpoint
              config.universe_domain = @config.universe_domain
            end

            @workload_identity_pools_stub = ::Gapic::ServiceStub.new(
              ::Google::Iam::V1beta::WorkloadIdentityPools::Stub,
              credentials: credentials,
              endpoint: @config.endpoint,
              endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
              universe_domain: @config.universe_domain,
              channel_args: @config.channel_args,
              interceptors: @config.interceptors,
              channel_pool_config: @config.channel_pool,
              logger: @config.logger
            )

            @workload_identity_pools_stub.stub_logger&.info do |entry|
              entry.set_system_name
              entry.set_service
              entry.message = "Created client for #{entry.service}"
              entry.set_credentials_fields credentials
              entry.set "customEndpoint", @config.endpoint if @config.endpoint
              entry.set "defaultTimeout", @config.timeout if @config.timeout
              entry.set "quotaProject", @quota_project_id if @quota_project_id
            end
          end

          ##
          # Get the associated client for long-running operations.
          #
          # @return [::Google::Iam::V1beta::WorkloadIdentityPools::Operations]
          #
          attr_reader :operations_client

          ##
          # The logger used for request/response debug logging.
          #
          # @return [Logger]
          #
          def logger
            @workload_identity_pools_stub.logger
          end

          # Service calls

          ##
          # Lists all non-deleted
          # {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}s in a
          # project. If `show_deleted` is set to `true`, then deleted pools are also
          # listed.
          #
          # @overload list_workload_identity_pools(request, options = nil)
          #   Pass arguments to `list_workload_identity_pools` via a request object, either of type
          #   {::Google::Iam::V1beta::ListWorkloadIdentityPoolsRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::ListWorkloadIdentityPoolsRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload list_workload_identity_pools(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
          #   Pass arguments to `list_workload_identity_pools` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param parent [::String]
          #     Required. The parent resource to list pools for.
          #   @param page_size [::Integer]
          #     The maximum number of pools to return.
          #     If unspecified, at most 50 pools are returned.
          #     The maximum value is 1000; values above are 1000 truncated to 1000.
          #   @param page_token [::String]
          #     A page token, received from a previous `ListWorkloadIdentityPools`
          #     call. Provide this to retrieve the subsequent page.
          #   @param show_deleted [::Boolean]
          #     Whether to return soft-deleted pools.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::PagedEnumerable<::Google::Iam::V1beta::WorkloadIdentityPool>]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::PagedEnumerable<::Google::Iam::V1beta::WorkloadIdentityPool>]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::ListWorkloadIdentityPoolsRequest.new
          #
          #   # Call the list_workload_identity_pools method.
          #   result = client.list_workload_identity_pools request
          #
          #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
          #   # over elements, and API calls will be issued to fetch pages as needed.
          #   result.each do |item|
          #     # Each element is of type ::Google::Iam::V1beta::WorkloadIdentityPool.
          #     p item
          #   end
          #
          def list_workload_identity_pools request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::ListWorkloadIdentityPoolsRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.list_workload_identity_pools.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.parent
              header_params["parent"] = request.parent
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.list_workload_identity_pools.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.list_workload_identity_pools.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :list_workload_identity_pools, request, options: options do |response, operation|
              response = ::Gapic::PagedEnumerable.new @workload_identity_pools_stub, :list_workload_identity_pools, request, response, operation, options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Gets an individual
          # {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}.
          #
          # @overload get_workload_identity_pool(request, options = nil)
          #   Pass arguments to `get_workload_identity_pool` via a request object, either of type
          #   {::Google::Iam::V1beta::GetWorkloadIdentityPoolRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::GetWorkloadIdentityPoolRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload get_workload_identity_pool(name: nil)
          #   Pass arguments to `get_workload_identity_pool` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param name [::String]
          #     Required. The name of the pool to retrieve.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Google::Iam::V1beta::WorkloadIdentityPool]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Google::Iam::V1beta::WorkloadIdentityPool]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::GetWorkloadIdentityPoolRequest.new
          #
          #   # Call the get_workload_identity_pool method.
          #   result = client.get_workload_identity_pool request
          #
          #   # The returned object is of type Google::Iam::V1beta::WorkloadIdentityPool.
          #   p result
          #
          def get_workload_identity_pool request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::GetWorkloadIdentityPoolRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.get_workload_identity_pool.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.name
              header_params["name"] = request.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.get_workload_identity_pool.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.get_workload_identity_pool.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :get_workload_identity_pool, request, options: options do |response, operation|
              yield response, operation if block_given?
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Creates a new
          # {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}.
          #
          # You cannot reuse the name of a deleted pool until 30 days after deletion.
          #
          # @overload create_workload_identity_pool(request, options = nil)
          #   Pass arguments to `create_workload_identity_pool` via a request object, either of type
          #   {::Google::Iam::V1beta::CreateWorkloadIdentityPoolRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::CreateWorkloadIdentityPoolRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload create_workload_identity_pool(parent: nil, workload_identity_pool: nil, workload_identity_pool_id: nil)
          #   Pass arguments to `create_workload_identity_pool` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param parent [::String]
          #     Required. The parent resource to create the pool in. The only supported
          #     location is `global`.
          #   @param workload_identity_pool [::Google::Iam::V1beta::WorkloadIdentityPool, ::Hash]
          #     Required. The pool to create.
          #   @param workload_identity_pool_id [::String]
          #     Required. The ID to use for the pool, which becomes the
          #     final component of the resource name. This value should be 4-32 characters,
          #     and may contain the characters [a-z0-9-]. The prefix `gcp-` is
          #     reserved for use by Google, and may not be specified.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::CreateWorkloadIdentityPoolRequest.new
          #
          #   # Call the create_workload_identity_pool method.
          #   result = client.create_workload_identity_pool request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def create_workload_identity_pool request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::CreateWorkloadIdentityPoolRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.create_workload_identity_pool.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.parent
              header_params["parent"] = request.parent
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.create_workload_identity_pool.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.create_workload_identity_pool.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :create_workload_identity_pool, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Updates an existing
          # {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}.
          #
          # @overload update_workload_identity_pool(request, options = nil)
          #   Pass arguments to `update_workload_identity_pool` via a request object, either of type
          #   {::Google::Iam::V1beta::UpdateWorkloadIdentityPoolRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::UpdateWorkloadIdentityPoolRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload update_workload_identity_pool(workload_identity_pool: nil, update_mask: nil)
          #   Pass arguments to `update_workload_identity_pool` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param workload_identity_pool [::Google::Iam::V1beta::WorkloadIdentityPool, ::Hash]
          #     Required. The pool to update. The `name` field is used to identify the pool.
          #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
          #     Required. The list of fields update.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::UpdateWorkloadIdentityPoolRequest.new
          #
          #   # Call the update_workload_identity_pool method.
          #   result = client.update_workload_identity_pool request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def update_workload_identity_pool request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::UpdateWorkloadIdentityPoolRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.update_workload_identity_pool.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.workload_identity_pool&.name
              header_params["workload_identity_pool.name"] = request.workload_identity_pool.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.update_workload_identity_pool.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.update_workload_identity_pool.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :update_workload_identity_pool, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Deletes a
          # {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}.
          #
          # You cannot use a deleted pool to exchange external
          # credentials for Google Cloud credentials. However, deletion does
          # not revoke credentials that have already been issued.
          # Credentials issued for a deleted pool do not grant access to resources.
          # If the pool is undeleted, and the credentials are not expired, they
          # grant access again.
          # You can undelete a pool for 30 days. After 30 days, deletion is
          # permanent.
          # You cannot update deleted pools. However, you can view and list them.
          #
          # @overload delete_workload_identity_pool(request, options = nil)
          #   Pass arguments to `delete_workload_identity_pool` via a request object, either of type
          #   {::Google::Iam::V1beta::DeleteWorkloadIdentityPoolRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::DeleteWorkloadIdentityPoolRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload delete_workload_identity_pool(name: nil)
          #   Pass arguments to `delete_workload_identity_pool` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param name [::String]
          #     Required. The name of the pool to delete.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::DeleteWorkloadIdentityPoolRequest.new
          #
          #   # Call the delete_workload_identity_pool method.
          #   result = client.delete_workload_identity_pool request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def delete_workload_identity_pool request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::DeleteWorkloadIdentityPoolRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.delete_workload_identity_pool.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.name
              header_params["name"] = request.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.delete_workload_identity_pool.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.delete_workload_identity_pool.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :delete_workload_identity_pool, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Undeletes a {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool},
          # as long as it was deleted fewer than 30 days ago.
          #
          # @overload undelete_workload_identity_pool(request, options = nil)
          #   Pass arguments to `undelete_workload_identity_pool` via a request object, either of type
          #   {::Google::Iam::V1beta::UndeleteWorkloadIdentityPoolRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::UndeleteWorkloadIdentityPoolRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload undelete_workload_identity_pool(name: nil)
          #   Pass arguments to `undelete_workload_identity_pool` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param name [::String]
          #     Required. The name of the pool to undelete.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::UndeleteWorkloadIdentityPoolRequest.new
          #
          #   # Call the undelete_workload_identity_pool method.
          #   result = client.undelete_workload_identity_pool request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def undelete_workload_identity_pool request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::UndeleteWorkloadIdentityPoolRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.undelete_workload_identity_pool.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.name
              header_params["name"] = request.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.undelete_workload_identity_pool.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.undelete_workload_identity_pool.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :undelete_workload_identity_pool, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Lists all non-deleted
          # {::Google::Iam::V1beta::WorkloadIdentityPoolProvider WorkloadIdentityPoolProvider}s
          # in a {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}.
          # If `show_deleted` is set to `true`, then deleted providers are also listed.
          #
          # @overload list_workload_identity_pool_providers(request, options = nil)
          #   Pass arguments to `list_workload_identity_pool_providers` via a request object, either of type
          #   {::Google::Iam::V1beta::ListWorkloadIdentityPoolProvidersRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::ListWorkloadIdentityPoolProvidersRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload list_workload_identity_pool_providers(parent: nil, page_size: nil, page_token: nil, show_deleted: nil)
          #   Pass arguments to `list_workload_identity_pool_providers` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param parent [::String]
          #     Required. The pool to list providers for.
          #   @param page_size [::Integer]
          #     The maximum number of providers to return.
          #     If unspecified, at most 50 providers are returned.
          #     The maximum value is 100; values above 100 are truncated to 100.
          #   @param page_token [::String]
          #     A page token, received from a previous
          #     `ListWorkloadIdentityPoolProviders` call. Provide this to retrieve the
          #     subsequent page.
          #   @param show_deleted [::Boolean]
          #     Whether to return soft-deleted providers.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::PagedEnumerable<::Google::Iam::V1beta::WorkloadIdentityPoolProvider>]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::PagedEnumerable<::Google::Iam::V1beta::WorkloadIdentityPoolProvider>]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::ListWorkloadIdentityPoolProvidersRequest.new
          #
          #   # Call the list_workload_identity_pool_providers method.
          #   result = client.list_workload_identity_pool_providers request
          #
          #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
          #   # over elements, and API calls will be issued to fetch pages as needed.
          #   result.each do |item|
          #     # Each element is of type ::Google::Iam::V1beta::WorkloadIdentityPoolProvider.
          #     p item
          #   end
          #
          def list_workload_identity_pool_providers request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::ListWorkloadIdentityPoolProvidersRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.list_workload_identity_pool_providers.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.parent
              header_params["parent"] = request.parent
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.list_workload_identity_pool_providers.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.list_workload_identity_pool_providers.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :list_workload_identity_pool_providers, request, options: options do |response, operation|
              response = ::Gapic::PagedEnumerable.new @workload_identity_pools_stub, :list_workload_identity_pool_providers, request, response, operation, options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Gets an individual
          # {::Google::Iam::V1beta::WorkloadIdentityPoolProvider WorkloadIdentityPoolProvider}.
          #
          # @overload get_workload_identity_pool_provider(request, options = nil)
          #   Pass arguments to `get_workload_identity_pool_provider` via a request object, either of type
          #   {::Google::Iam::V1beta::GetWorkloadIdentityPoolProviderRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::GetWorkloadIdentityPoolProviderRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload get_workload_identity_pool_provider(name: nil)
          #   Pass arguments to `get_workload_identity_pool_provider` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param name [::String]
          #     Required. The name of the provider to retrieve.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Google::Iam::V1beta::WorkloadIdentityPoolProvider]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Google::Iam::V1beta::WorkloadIdentityPoolProvider]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::GetWorkloadIdentityPoolProviderRequest.new
          #
          #   # Call the get_workload_identity_pool_provider method.
          #   result = client.get_workload_identity_pool_provider request
          #
          #   # The returned object is of type Google::Iam::V1beta::WorkloadIdentityPoolProvider.
          #   p result
          #
          def get_workload_identity_pool_provider request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::GetWorkloadIdentityPoolProviderRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.get_workload_identity_pool_provider.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.name
              header_params["name"] = request.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.get_workload_identity_pool_provider.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.get_workload_identity_pool_provider.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :get_workload_identity_pool_provider, request, options: options do |response, operation|
              yield response, operation if block_given?
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Creates a new
          # [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider]
          # in a {::Google::Iam::V1beta::WorkloadIdentityPool WorkloadIdentityPool}.
          #
          # You cannot reuse the name of a deleted provider until 30 days after
          # deletion.
          #
          # @overload create_workload_identity_pool_provider(request, options = nil)
          #   Pass arguments to `create_workload_identity_pool_provider` via a request object, either of type
          #   {::Google::Iam::V1beta::CreateWorkloadIdentityPoolProviderRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::CreateWorkloadIdentityPoolProviderRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload create_workload_identity_pool_provider(parent: nil, workload_identity_pool_provider: nil, workload_identity_pool_provider_id: nil)
          #   Pass arguments to `create_workload_identity_pool_provider` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param parent [::String]
          #     Required. The pool to create this provider in.
          #   @param workload_identity_pool_provider [::Google::Iam::V1beta::WorkloadIdentityPoolProvider, ::Hash]
          #     Required. The provider to create.
          #   @param workload_identity_pool_provider_id [::String]
          #     Required. The ID for the provider, which becomes the
          #     final component of the resource name. This value must be 4-32 characters,
          #     and may contain the characters [a-z0-9-]. The prefix `gcp-` is
          #     reserved for use by Google, and may not be specified.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::CreateWorkloadIdentityPoolProviderRequest.new
          #
          #   # Call the create_workload_identity_pool_provider method.
          #   result = client.create_workload_identity_pool_provider request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def create_workload_identity_pool_provider request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::CreateWorkloadIdentityPoolProviderRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.create_workload_identity_pool_provider.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.parent
              header_params["parent"] = request.parent
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.create_workload_identity_pool_provider.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.create_workload_identity_pool_provider.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :create_workload_identity_pool_provider, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Updates an existing
          # [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider].
          #
          # @overload update_workload_identity_pool_provider(request, options = nil)
          #   Pass arguments to `update_workload_identity_pool_provider` via a request object, either of type
          #   {::Google::Iam::V1beta::UpdateWorkloadIdentityPoolProviderRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::UpdateWorkloadIdentityPoolProviderRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload update_workload_identity_pool_provider(workload_identity_pool_provider: nil, update_mask: nil)
          #   Pass arguments to `update_workload_identity_pool_provider` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param workload_identity_pool_provider [::Google::Iam::V1beta::WorkloadIdentityPoolProvider, ::Hash]
          #     Required. The provider to update.
          #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
          #     Required. The list of fields to update.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::UpdateWorkloadIdentityPoolProviderRequest.new
          #
          #   # Call the update_workload_identity_pool_provider method.
          #   result = client.update_workload_identity_pool_provider request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def update_workload_identity_pool_provider request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::UpdateWorkloadIdentityPoolProviderRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.update_workload_identity_pool_provider.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.workload_identity_pool_provider&.name
              header_params["workload_identity_pool_provider.name"] = request.workload_identity_pool_provider.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.update_workload_identity_pool_provider.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.update_workload_identity_pool_provider.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :update_workload_identity_pool_provider, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Deletes a
          # [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider].
          # Deleting a provider does not revoke credentials that have already been
          # issued; they continue to grant access.
          # You can undelete a provider for 30 days. After 30 days, deletion is
          # permanent.
          # You cannot update deleted providers. However, you can view and list them.
          #
          # @overload delete_workload_identity_pool_provider(request, options = nil)
          #   Pass arguments to `delete_workload_identity_pool_provider` via a request object, either of type
          #   {::Google::Iam::V1beta::DeleteWorkloadIdentityPoolProviderRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::DeleteWorkloadIdentityPoolProviderRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload delete_workload_identity_pool_provider(name: nil)
          #   Pass arguments to `delete_workload_identity_pool_provider` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param name [::String]
          #     Required. The name of the provider to delete.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::DeleteWorkloadIdentityPoolProviderRequest.new
          #
          #   # Call the delete_workload_identity_pool_provider method.
          #   result = client.delete_workload_identity_pool_provider request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def delete_workload_identity_pool_provider request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::DeleteWorkloadIdentityPoolProviderRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.delete_workload_identity_pool_provider.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.name
              header_params["name"] = request.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.delete_workload_identity_pool_provider.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.delete_workload_identity_pool_provider.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :delete_workload_identity_pool_provider, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Undeletes a
          # [WorkloadIdentityPoolProvider][google.iam.v1beta.WorkloadIdentityProvider],
          # as long as it was deleted fewer than 30 days ago.
          #
          # @overload undelete_workload_identity_pool_provider(request, options = nil)
          #   Pass arguments to `undelete_workload_identity_pool_provider` via a request object, either of type
          #   {::Google::Iam::V1beta::UndeleteWorkloadIdentityPoolProviderRequest} or an equivalent Hash.
          #
          #   @param request [::Google::Iam::V1beta::UndeleteWorkloadIdentityPoolProviderRequest, ::Hash]
          #     A request object representing the call parameters. Required. To specify no
          #     parameters, or to keep all the default parameter values, pass an empty Hash.
          #   @param options [::Gapic::CallOptions, ::Hash]
          #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
          #
          # @overload undelete_workload_identity_pool_provider(name: nil)
          #   Pass arguments to `undelete_workload_identity_pool_provider` via keyword arguments. Note that at
          #   least one keyword argument is required. To specify no parameters, or to keep all
          #   the default parameter values, pass an empty Hash as a request object (see above).
          #
          #   @param name [::String]
          #     Required. The name of the provider to undelete.
          #
          # @yield [response, operation] Access the result along with the RPC operation
          # @yieldparam response [::Gapic::Operation]
          # @yieldparam operation [::GRPC::ActiveCall::Operation]
          #
          # @return [::Gapic::Operation]
          #
          # @raise [::Google::Cloud::Error] if the RPC is aborted.
          #
          # @example Basic example
          #   require "google/iam/v1beta"
          #
          #   # Create a client object. The client can be reused for multiple calls.
          #   client = Google::Iam::V1beta::WorkloadIdentityPools::Client.new
          #
          #   # Create a request. To set request fields, pass in keyword arguments.
          #   request = Google::Iam::V1beta::UndeleteWorkloadIdentityPoolProviderRequest.new
          #
          #   # Call the undelete_workload_identity_pool_provider method.
          #   result = client.undelete_workload_identity_pool_provider request
          #
          #   # The returned object is of type Gapic::Operation. You can use it to
          #   # check the status of an operation, cancel it, or wait for results.
          #   # Here is how to wait for a response.
          #   result.wait_until_done! timeout: 60
          #   if result.response?
          #     p result.response
          #   else
          #     puts "No response received."
          #   end
          #
          def undelete_workload_identity_pool_provider request, options = nil
            raise ::ArgumentError, "request must be provided" if request.nil?

            request = ::Gapic::Protobuf.coerce request, to: ::Google::Iam::V1beta::UndeleteWorkloadIdentityPoolProviderRequest

            # Converts hash and nil to an options object
            options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

            # Customize the options with defaults
            metadata = @config.rpcs.undelete_workload_identity_pool_provider.metadata.to_h

            # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
            metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
              lib_name: @config.lib_name, lib_version: @config.lib_version,
              gapic_version: ::Google::Iam::V1beta::VERSION
            metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
            metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

            header_params = {}
            if request.name
              header_params["name"] = request.name
            end

            request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
            metadata[:"x-goog-request-params"] ||= request_params_header

            options.apply_defaults timeout:      @config.rpcs.undelete_workload_identity_pool_provider.timeout,
                                   metadata:     metadata,
                                   retry_policy: @config.rpcs.undelete_workload_identity_pool_provider.retry_policy

            options.apply_defaults timeout:      @config.timeout,
                                   metadata:     @config.metadata,
                                   retry_policy: @config.retry_policy

            @workload_identity_pools_stub.call_rpc :undelete_workload_identity_pool_provider, request, options: options do |response, operation|
              response = ::Gapic::Operation.new response, @operations_client, options: options
              yield response, operation if block_given?
              throw :response, response
            end
          rescue ::GRPC::BadStatus => e
            raise ::Google::Cloud::Error.from_error(e)
          end

          ##
          # Configuration class for the WorkloadIdentityPools API.
          #
          # This class represents the configuration for WorkloadIdentityPools,
          # providing control over timeouts, retry behavior, logging, transport
          # parameters, and other low-level controls. Certain parameters can also be
          # applied individually to specific RPCs. See
          # {::Google::Iam::V1beta::WorkloadIdentityPools::Client::Configuration::Rpcs}
          # for a list of RPCs that can be configured independently.
          #
          # Configuration can be applied globally to all clients, or to a single client
          # on construction.
          #
          # @example
          #
          #   # Modify the global config, setting the timeout for
          #   # list_workload_identity_pools to 20 seconds,
          #   # and all remaining timeouts to 10 seconds.
          #   ::Google::Iam::V1beta::WorkloadIdentityPools::Client.configure do |config|
          #     config.timeout = 10.0
          #     config.rpcs.list_workload_identity_pools.timeout = 20.0
          #   end
          #
          #   # Apply the above configuration only to a new client.
          #   client = ::Google::Iam::V1beta::WorkloadIdentityPools::Client.new do |config|
          #     config.timeout = 10.0
          #     config.rpcs.list_workload_identity_pools.timeout = 20.0
          #   end
          #
          # @!attribute [rw] endpoint
          #   A custom service endpoint, as a hostname or hostname:port. The default is
          #   nil, indicating to use the default endpoint in the current universe domain.
          #   @return [::String,nil]
          # @!attribute [rw] credentials
          #   Credentials to send with calls. You may provide any of the following types:
          #    *  (`Google::Auth::Credentials`) A googleauth credentials object
          #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
          #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
          #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
          #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
          #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
          #    *  (`nil`) indicating no credentials
          #
          #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
          #     is deprecated. Providing an unvalidated credential configuration to
          #     Google APIs can compromise the security of your systems and data.
          #
          #   @example
          #
          #     # The recommended way to provide credentials is to use the `make_creds` method
          #     # on the appropriate credentials class for your environment.
          #
          #     require "googleauth"
          #
          #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
          #       json_key_io: ::File.open("/path/to/keyfile.json")
          #     )
          #
          #     client = ::Google::Iam::V1beta::WorkloadIdentityPools::Client.new do |config|
          #       config.credentials = credentials
          #     end
          #
          #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
          #   external source for authentication to Google Cloud, you must validate it before
          #   providing it to a Google API client library. Providing an unvalidated credential
          #   configuration to Google APIs can compromise the security of your systems and data.
          #   For more information, refer to [Validate credential configurations from external
          #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
          #   @return [::Object]
          # @!attribute [rw] scope
          #   The OAuth scopes
          #   @return [::Array<::String>]
          # @!attribute [rw] lib_name
          #   The library name as recorded in instrumentation and logging
          #   @return [::String]
          # @!attribute [rw] lib_version
          #   The library version as recorded in instrumentation and logging
          #   @return [::String]
          # @!attribute [rw] channel_args
          #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
          #   `GRPC::Core::Channel` object is provided as the credential.
          #   @return [::Hash]
          # @!attribute [rw] interceptors
          #   An array of interceptors that are run before calls are executed.
          #   @return [::Array<::GRPC::ClientInterceptor>]
          # @!attribute [rw] timeout
          #   The call timeout in seconds.
          #   @return [::Numeric]
          # @!attribute [rw] metadata
          #   Additional gRPC headers to be sent with the call.
          #   @return [::Hash{::Symbol=>::String}]
          # @!attribute [rw] retry_policy
          #   The retry policy. The value is a hash with the following keys:
          #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
          #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
          #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
          #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
          #       trigger a retry.
          #   @return [::Hash]
          # @!attribute [rw] quota_project
          #   A separate project against which to charge quota.
          #   @return [::String]
          # @!attribute [rw] universe_domain
          #   The universe domain within which to make requests. This determines the
          #   default endpoint URL. The default value of nil uses the environment
          #   universe (usually the default "googleapis.com" universe).
          #   @return [::String,nil]
          # @!attribute [rw] logger
          #   A custom logger to use for request/response debug logging, or the value
          #   `:default` (the default) to construct a default logger, or `nil` to
          #   explicitly disable logging.
          #   @return [::Logger,:default,nil]
          #
          class Configuration
            extend ::Gapic::Config

            # @private
            # The endpoint specific to the default "googleapis.com" universe. Deprecated.
            DEFAULT_ENDPOINT = "iam.googleapis.com"

            config_attr :endpoint,      nil, ::String, nil
            config_attr :credentials,   nil do |value|
              allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
              allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
              allowed.any? { |klass| klass === value }
            end
            config_attr :scope,         nil, ::String, ::Array, nil
            config_attr :lib_name,      nil, ::String, nil
            config_attr :lib_version,   nil, ::String, nil
            config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
            config_attr :interceptors,  nil, ::Array, nil
            config_attr :timeout,       nil, ::Numeric, nil
            config_attr :metadata,      nil, ::Hash, nil
            config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
            config_attr :quota_project, nil, ::String, nil
            config_attr :universe_domain, nil, ::String, nil
            config_attr :logger, :default, ::Logger, nil, :default

            # @private
            def initialize parent_config = nil
              @parent_config = parent_config unless parent_config.nil?

              yield self if block_given?
            end

            ##
            # Configurations for individual RPCs
            # @return [Rpcs]
            #
            def rpcs
              @rpcs ||= begin
                parent_rpcs = nil
                parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                Rpcs.new parent_rpcs
              end
            end

            ##
            # Configuration for the channel pool
            # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
            #
            def channel_pool
              @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
            end

            ##
            # Configuration RPC class for the WorkloadIdentityPools API.
            #
            # Includes fields providing the configuration for each RPC in this service.
            # Each configuration object is of type `Gapic::Config::Method` and includes
            # the following configuration fields:
            #
            #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
            #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
            #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
            #     include the following keys:
            #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #         trigger a retry.
            #
            class Rpcs
              ##
              # RPC-specific configuration for `list_workload_identity_pools`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :list_workload_identity_pools
              ##
              # RPC-specific configuration for `get_workload_identity_pool`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :get_workload_identity_pool
              ##
              # RPC-specific configuration for `create_workload_identity_pool`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :create_workload_identity_pool
              ##
              # RPC-specific configuration for `update_workload_identity_pool`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :update_workload_identity_pool
              ##
              # RPC-specific configuration for `delete_workload_identity_pool`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :delete_workload_identity_pool
              ##
              # RPC-specific configuration for `undelete_workload_identity_pool`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :undelete_workload_identity_pool
              ##
              # RPC-specific configuration for `list_workload_identity_pool_providers`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :list_workload_identity_pool_providers
              ##
              # RPC-specific configuration for `get_workload_identity_pool_provider`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :get_workload_identity_pool_provider
              ##
              # RPC-specific configuration for `create_workload_identity_pool_provider`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :create_workload_identity_pool_provider
              ##
              # RPC-specific configuration for `update_workload_identity_pool_provider`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :update_workload_identity_pool_provider
              ##
              # RPC-specific configuration for `delete_workload_identity_pool_provider`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :delete_workload_identity_pool_provider
              ##
              # RPC-specific configuration for `undelete_workload_identity_pool_provider`
              # @return [::Gapic::Config::Method]
              #
              attr_reader :undelete_workload_identity_pool_provider

              # @private
              def initialize parent_rpcs = nil
                list_workload_identity_pools_config = parent_rpcs.list_workload_identity_pools if parent_rpcs.respond_to? :list_workload_identity_pools
                @list_workload_identity_pools = ::Gapic::Config::Method.new list_workload_identity_pools_config
                get_workload_identity_pool_config = parent_rpcs.get_workload_identity_pool if parent_rpcs.respond_to? :get_workload_identity_pool
                @get_workload_identity_pool = ::Gapic::Config::Method.new get_workload_identity_pool_config
                create_workload_identity_pool_config = parent_rpcs.create_workload_identity_pool if parent_rpcs.respond_to? :create_workload_identity_pool
                @create_workload_identity_pool = ::Gapic::Config::Method.new create_workload_identity_pool_config
                update_workload_identity_pool_config = parent_rpcs.update_workload_identity_pool if parent_rpcs.respond_to? :update_workload_identity_pool
                @update_workload_identity_pool = ::Gapic::Config::Method.new update_workload_identity_pool_config
                delete_workload_identity_pool_config = parent_rpcs.delete_workload_identity_pool if parent_rpcs.respond_to? :delete_workload_identity_pool
                @delete_workload_identity_pool = ::Gapic::Config::Method.new delete_workload_identity_pool_config
                undelete_workload_identity_pool_config = parent_rpcs.undelete_workload_identity_pool if parent_rpcs.respond_to? :undelete_workload_identity_pool
                @undelete_workload_identity_pool = ::Gapic::Config::Method.new undelete_workload_identity_pool_config
                list_workload_identity_pool_providers_config = parent_rpcs.list_workload_identity_pool_providers if parent_rpcs.respond_to? :list_workload_identity_pool_providers
                @list_workload_identity_pool_providers = ::Gapic::Config::Method.new list_workload_identity_pool_providers_config
                get_workload_identity_pool_provider_config = parent_rpcs.get_workload_identity_pool_provider if parent_rpcs.respond_to? :get_workload_identity_pool_provider
                @get_workload_identity_pool_provider = ::Gapic::Config::Method.new get_workload_identity_pool_provider_config
                create_workload_identity_pool_provider_config = parent_rpcs.create_workload_identity_pool_provider if parent_rpcs.respond_to? :create_workload_identity_pool_provider
                @create_workload_identity_pool_provider = ::Gapic::Config::Method.new create_workload_identity_pool_provider_config
                update_workload_identity_pool_provider_config = parent_rpcs.update_workload_identity_pool_provider if parent_rpcs.respond_to? :update_workload_identity_pool_provider
                @update_workload_identity_pool_provider = ::Gapic::Config::Method.new update_workload_identity_pool_provider_config
                delete_workload_identity_pool_provider_config = parent_rpcs.delete_workload_identity_pool_provider if parent_rpcs.respond_to? :delete_workload_identity_pool_provider
                @delete_workload_identity_pool_provider = ::Gapic::Config::Method.new delete_workload_identity_pool_provider_config
                undelete_workload_identity_pool_provider_config = parent_rpcs.undelete_workload_identity_pool_provider if parent_rpcs.respond_to? :undelete_workload_identity_pool_provider
                @undelete_workload_identity_pool_provider = ::Gapic::Config::Method.new undelete_workload_identity_pool_provider_config

                yield self if block_given?
              end
            end
          end
        end
      end
    end
  end
end
