# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/iam/credentials/v1/iamcredentials_pb"
require "google/iam/credentials/v1/iam_credentials"

class ::Google::Iam::Credentials::V1::IAMCredentials::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_generate_access_token
    # Create GRPC objects.
    grpc_response = ::Google::Iam::Credentials::V1::GenerateAccessTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    delegates = ["hello world"]
    scope = ["hello world"]
    lifetime = {}

    generate_access_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_access_token, name
      assert_kind_of ::Google::Iam::Credentials::V1::GenerateAccessTokenRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["delegates"]
      assert_equal ["hello world"], request["scope"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["lifetime"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_access_token_client_stub do
      # Create client
      client = ::Google::Iam::Credentials::V1::IAMCredentials::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_access_token({ name: name, delegates: delegates, scope: scope, lifetime: lifetime }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_access_token name: name, delegates: delegates, scope: scope, lifetime: lifetime do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_access_token ::Google::Iam::Credentials::V1::GenerateAccessTokenRequest.new(name: name, delegates: delegates, scope: scope, lifetime: lifetime) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_access_token({ name: name, delegates: delegates, scope: scope, lifetime: lifetime }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_access_token(::Google::Iam::Credentials::V1::GenerateAccessTokenRequest.new(name: name, delegates: delegates, scope: scope, lifetime: lifetime), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_access_token_client_stub.call_rpc_count
    end
  end

  def test_generate_id_token
    # Create GRPC objects.
    grpc_response = ::Google::Iam::Credentials::V1::GenerateIdTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    delegates = ["hello world"]
    audience = "hello world"
    include_email = true

    generate_id_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_id_token, name
      assert_kind_of ::Google::Iam::Credentials::V1::GenerateIdTokenRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["delegates"]
      assert_equal "hello world", request["audience"]
      assert_equal true, request["include_email"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_id_token_client_stub do
      # Create client
      client = ::Google::Iam::Credentials::V1::IAMCredentials::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_id_token({ name: name, delegates: delegates, audience: audience, include_email: include_email }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_id_token name: name, delegates: delegates, audience: audience, include_email: include_email do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_id_token ::Google::Iam::Credentials::V1::GenerateIdTokenRequest.new(name: name, delegates: delegates, audience: audience, include_email: include_email) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_id_token({ name: name, delegates: delegates, audience: audience, include_email: include_email }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_id_token(::Google::Iam::Credentials::V1::GenerateIdTokenRequest.new(name: name, delegates: delegates, audience: audience, include_email: include_email), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_id_token_client_stub.call_rpc_count
    end
  end

  def test_sign_blob
    # Create GRPC objects.
    grpc_response = ::Google::Iam::Credentials::V1::SignBlobResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    delegates = ["hello world"]
    payload = "hello world"

    sign_blob_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :sign_blob, name
      assert_kind_of ::Google::Iam::Credentials::V1::SignBlobRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["delegates"]
      assert_equal "hello world", request["payload"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, sign_blob_client_stub do
      # Create client
      client = ::Google::Iam::Credentials::V1::IAMCredentials::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.sign_blob({ name: name, delegates: delegates, payload: payload }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.sign_blob name: name, delegates: delegates, payload: payload do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.sign_blob ::Google::Iam::Credentials::V1::SignBlobRequest.new(name: name, delegates: delegates, payload: payload) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.sign_blob({ name: name, delegates: delegates, payload: payload }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.sign_blob(::Google::Iam::Credentials::V1::SignBlobRequest.new(name: name, delegates: delegates, payload: payload), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, sign_blob_client_stub.call_rpc_count
    end
  end

  def test_sign_jwt
    # Create GRPC objects.
    grpc_response = ::Google::Iam::Credentials::V1::SignJwtResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    delegates = ["hello world"]
    payload = "hello world"

    sign_jwt_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :sign_jwt, name
      assert_kind_of ::Google::Iam::Credentials::V1::SignJwtRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["delegates"]
      assert_equal "hello world", request["payload"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, sign_jwt_client_stub do
      # Create client
      client = ::Google::Iam::Credentials::V1::IAMCredentials::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.sign_jwt({ name: name, delegates: delegates, payload: payload }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.sign_jwt name: name, delegates: delegates, payload: payload do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.sign_jwt ::Google::Iam::Credentials::V1::SignJwtRequest.new(name: name, delegates: delegates, payload: payload) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.sign_jwt({ name: name, delegates: delegates, payload: payload }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.sign_jwt(::Google::Iam::Credentials::V1::SignJwtRequest.new(name: name, delegates: delegates, payload: payload), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, sign_jwt_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Iam::Credentials::V1::IAMCredentials::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Iam::Credentials::V1::IAMCredentials::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Iam::Credentials::V1::IAMCredentials::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Iam::Credentials::V1::IAMCredentials::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
