# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/iam/credentials/v1/iamcredentials.proto for package 'google.iam.credentials.v1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/iam/credentials/v1/iamcredentials_pb'

module Google
  module Iam
    module Credentials
      module V1
        module IAMCredentials
          # A service account is a special type of Google account that belongs to your
          # application or a virtual machine (VM), instead of to an individual end user.
          # Your application assumes the identity of the service account to call Google
          # APIs, so that the users aren't directly involved.
          #
          # Service account credentials are used to temporarily assume the identity
          # of the service account. Supported credential types include OAuth 2.0 access
          # tokens, OpenID Connect ID tokens, self-signed JSON Web Tokens (JWTs), and
          # more.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.iam.credentials.v1.IAMCredentials'

            # Generates an OAuth 2.0 access token for a service account.
            rpc :GenerateAccessToken, ::Google::Iam::Credentials::V1::GenerateAccessTokenRequest, ::Google::Iam::Credentials::V1::GenerateAccessTokenResponse
            # Generates an OpenID Connect ID token for a service account.
            rpc :GenerateIdToken, ::Google::Iam::Credentials::V1::GenerateIdTokenRequest, ::Google::Iam::Credentials::V1::GenerateIdTokenResponse
            # Signs a blob using a service account's system-managed private key.
            rpc :SignBlob, ::Google::Iam::Credentials::V1::SignBlobRequest, ::Google::Iam::Credentials::V1::SignBlobResponse
            # Signs a JWT using a service account's system-managed private key.
            rpc :SignJwt, ::Google::Iam::Credentials::V1::SignJwtRequest, ::Google::Iam::Credentials::V1::SignJwtResponse
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
