# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/workstations/v1beta/workstations_pb"
require "google/cloud/workstations/v1beta/workstations"

class ::Google::Cloud::Workstations::V1beta::Workstations::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_workstation_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::WorkstationCluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workstation_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_workstation_cluster, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::GetWorkstationClusterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_workstation_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_workstation_cluster({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_workstation_cluster name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_workstation_cluster ::Google::Cloud::Workstations::V1beta::GetWorkstationClusterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_workstation_cluster({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_workstation_cluster(::Google::Cloud::Workstations::V1beta::GetWorkstationClusterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_workstation_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_workstation_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::ListWorkstationClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workstation_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_workstation_clusters, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::ListWorkstationClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_workstation_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_workstation_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_workstation_clusters parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_workstation_clusters ::Google::Cloud::Workstations::V1beta::ListWorkstationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_workstation_clusters({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_workstation_clusters(::Google::Cloud::Workstations::V1beta::ListWorkstationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_workstation_clusters_client_stub.call_rpc_count
    end
  end

  def test_create_workstation_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workstation_cluster_id = "hello world"
    workstation_cluster = {}
    validate_only = true

    create_workstation_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_workstation_cluster, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::CreateWorkstationClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["workstation_cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Workstations::V1beta::WorkstationCluster), request["workstation_cluster"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_workstation_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_workstation_cluster({ parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_workstation_cluster parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_workstation_cluster ::Google::Cloud::Workstations::V1beta::CreateWorkstationClusterRequest.new(parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_workstation_cluster({ parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_workstation_cluster(::Google::Cloud::Workstations::V1beta::CreateWorkstationClusterRequest.new(parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_workstation_cluster_client_stub.call_rpc_count
    end
  end

  def test_update_workstation_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workstation_cluster = {}
    update_mask = {}
    validate_only = true
    allow_missing = true

    update_workstation_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_workstation_cluster, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::UpdateWorkstationClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Workstations::V1beta::WorkstationCluster), request["workstation_cluster"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_workstation_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_workstation_cluster({ workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_workstation_cluster workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_workstation_cluster ::Google::Cloud::Workstations::V1beta::UpdateWorkstationClusterRequest.new(workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_workstation_cluster({ workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_workstation_cluster(::Google::Cloud::Workstations::V1beta::UpdateWorkstationClusterRequest.new(workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_workstation_cluster_client_stub.call_rpc_count
    end
  end

  def test_delete_workstation_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"
    force = true

    delete_workstation_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_workstation_cluster, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::DeleteWorkstationClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_workstation_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_workstation_cluster({ name: name, validate_only: validate_only, etag: etag, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_workstation_cluster name: name, validate_only: validate_only, etag: etag, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_workstation_cluster ::Google::Cloud::Workstations::V1beta::DeleteWorkstationClusterRequest.new(name: name, validate_only: validate_only, etag: etag, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_workstation_cluster({ name: name, validate_only: validate_only, etag: etag, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_workstation_cluster(::Google::Cloud::Workstations::V1beta::DeleteWorkstationClusterRequest.new(name: name, validate_only: validate_only, etag: etag, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_workstation_cluster_client_stub.call_rpc_count
    end
  end

  def test_get_workstation_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::WorkstationConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workstation_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_workstation_config, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::GetWorkstationConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_workstation_config_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_workstation_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_workstation_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_workstation_config ::Google::Cloud::Workstations::V1beta::GetWorkstationConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_workstation_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_workstation_config(::Google::Cloud::Workstations::V1beta::GetWorkstationConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_workstation_config_client_stub.call_rpc_count
    end
  end

  def test_list_workstation_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workstation_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_workstation_configs, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_workstation_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_workstation_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_workstation_configs ::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_workstation_configs(::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_workstation_configs_client_stub.call_rpc_count
    end
  end

  def test_list_usable_workstation_configs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_usable_workstation_configs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_usable_workstation_configs, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_usable_workstation_configs_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_usable_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_usable_workstation_configs parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_usable_workstation_configs ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_usable_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_usable_workstation_configs(::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_usable_workstation_configs_client_stub.call_rpc_count
    end
  end

  def test_create_workstation_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workstation_config_id = "hello world"
    workstation_config = {}
    validate_only = true

    create_workstation_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_workstation_config, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::CreateWorkstationConfigRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["workstation_config_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Workstations::V1beta::WorkstationConfig), request["workstation_config"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_workstation_config_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_workstation_config({ parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_workstation_config parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_workstation_config ::Google::Cloud::Workstations::V1beta::CreateWorkstationConfigRequest.new(parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_workstation_config({ parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_workstation_config(::Google::Cloud::Workstations::V1beta::CreateWorkstationConfigRequest.new(parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_workstation_config_client_stub.call_rpc_count
    end
  end

  def test_update_workstation_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workstation_config = {}
    update_mask = {}
    validate_only = true
    allow_missing = true

    update_workstation_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_workstation_config, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::UpdateWorkstationConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Workstations::V1beta::WorkstationConfig), request["workstation_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_workstation_config_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_workstation_config({ workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_workstation_config workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_workstation_config ::Google::Cloud::Workstations::V1beta::UpdateWorkstationConfigRequest.new(workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_workstation_config({ workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_workstation_config(::Google::Cloud::Workstations::V1beta::UpdateWorkstationConfigRequest.new(workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_workstation_config_client_stub.call_rpc_count
    end
  end

  def test_delete_workstation_config
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"
    force = true

    delete_workstation_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_workstation_config, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::DeleteWorkstationConfigRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_workstation_config_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_workstation_config({ name: name, validate_only: validate_only, etag: etag, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_workstation_config name: name, validate_only: validate_only, etag: etag, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_workstation_config ::Google::Cloud::Workstations::V1beta::DeleteWorkstationConfigRequest.new(name: name, validate_only: validate_only, etag: etag, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_workstation_config({ name: name, validate_only: validate_only, etag: etag, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_workstation_config(::Google::Cloud::Workstations::V1beta::DeleteWorkstationConfigRequest.new(name: name, validate_only: validate_only, etag: etag, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_workstation_config_client_stub.call_rpc_count
    end
  end

  def test_get_workstation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::Workstation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workstation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_workstation, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::GetWorkstationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_workstation_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_workstation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_workstation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_workstation ::Google::Cloud::Workstations::V1beta::GetWorkstationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_workstation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_workstation(::Google::Cloud::Workstations::V1beta::GetWorkstationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_workstation_client_stub.call_rpc_count
    end
  end

  def test_list_workstations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::ListWorkstationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workstations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_workstations, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::ListWorkstationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_workstations_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_workstations({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_workstations parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_workstations ::Google::Cloud::Workstations::V1beta::ListWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_workstations({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_workstations(::Google::Cloud::Workstations::V1beta::ListWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_workstations_client_stub.call_rpc_count
    end
  end

  def test_list_usable_workstations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_usable_workstations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_usable_workstations, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_usable_workstations_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_usable_workstations({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_usable_workstations parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_usable_workstations ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_usable_workstations({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_usable_workstations(::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_usable_workstations_client_stub.call_rpc_count
    end
  end

  def test_create_workstation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workstation_id = "hello world"
    workstation = {}
    validate_only = true

    create_workstation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_workstation, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::CreateWorkstationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["workstation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Workstations::V1beta::Workstation), request["workstation"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_workstation_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_workstation({ parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_workstation parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_workstation ::Google::Cloud::Workstations::V1beta::CreateWorkstationRequest.new(parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_workstation({ parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_workstation(::Google::Cloud::Workstations::V1beta::CreateWorkstationRequest.new(parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_workstation_client_stub.call_rpc_count
    end
  end

  def test_update_workstation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    workstation = {}
    update_mask = {}
    validate_only = true
    allow_missing = true

    update_workstation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_workstation, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::UpdateWorkstationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Workstations::V1beta::Workstation), request["workstation"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_workstation_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_workstation({ workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_workstation workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_workstation ::Google::Cloud::Workstations::V1beta::UpdateWorkstationRequest.new(workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_workstation({ workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_workstation(::Google::Cloud::Workstations::V1beta::UpdateWorkstationRequest.new(workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_workstation_client_stub.call_rpc_count
    end
  end

  def test_delete_workstation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    delete_workstation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_workstation, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::DeleteWorkstationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_workstation_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_workstation({ name: name, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_workstation name: name, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_workstation ::Google::Cloud::Workstations::V1beta::DeleteWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_workstation({ name: name, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_workstation(::Google::Cloud::Workstations::V1beta::DeleteWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_workstation_client_stub.call_rpc_count
    end
  end

  def test_start_workstation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    start_workstation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :start_workstation, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::StartWorkstationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, start_workstation_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.start_workstation({ name: name, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.start_workstation name: name, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.start_workstation ::Google::Cloud::Workstations::V1beta::StartWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.start_workstation({ name: name, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.start_workstation(::Google::Cloud::Workstations::V1beta::StartWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, start_workstation_client_stub.call_rpc_count
    end
  end

  def test_stop_workstation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    stop_workstation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :stop_workstation, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::StopWorkstationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stop_workstation_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stop_workstation({ name: name, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stop_workstation name: name, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stop_workstation ::Google::Cloud::Workstations::V1beta::StopWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stop_workstation({ name: name, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stop_workstation(::Google::Cloud::Workstations::V1beta::StopWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stop_workstation_client_stub.call_rpc_count
    end
  end

  def test_generate_access_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Workstations::V1beta::GenerateAccessTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    expire_time = {}
    workstation = "hello world"

    generate_access_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_access_token, name
      assert_kind_of ::Google::Cloud::Workstations::V1beta::GenerateAccessTokenRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["expire_time"]
      assert_equal :expire_time, request.expiration
      assert_equal "hello world", request["workstation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_access_token_client_stub do
      # Create client
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_access_token({ expire_time: expire_time, workstation: workstation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_access_token expire_time: expire_time, workstation: workstation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_access_token ::Google::Cloud::Workstations::V1beta::GenerateAccessTokenRequest.new(expire_time: expire_time, workstation: workstation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_access_token({ expire_time: expire_time, workstation: workstation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_access_token(::Google::Cloud::Workstations::V1beta::GenerateAccessTokenRequest.new(expire_time: expire_time, workstation: workstation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_access_token_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Workstations::V1beta::Workstations::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Workstations::V1beta::Workstations::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Workstations::V1beta::Workstations::Operations, client.operations_client
  end
end
