# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/workstations/v1beta/workstations_pb"
require "google/cloud/workstations/v1beta/workstations/rest"


class ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_workstation_cluster
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::WorkstationCluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workstation_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_get_workstation_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workstation_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workstation_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workstation_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workstation_cluster ::Google::Cloud::Workstations::V1beta::GetWorkstationClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workstation_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workstation_cluster(::Google::Cloud::Workstations::V1beta::GetWorkstationClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workstation_cluster_client_stub.call_count
      end
    end
  end

  def test_list_workstation_clusters
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::ListWorkstationClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workstation_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_list_workstation_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workstation_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workstation_clusters({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workstation_clusters parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workstation_clusters ::Google::Cloud::Workstations::V1beta::ListWorkstationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workstation_clusters({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workstation_clusters(::Google::Cloud::Workstations::V1beta::ListWorkstationClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workstation_clusters_client_stub.call_count
      end
    end
  end

  def test_create_workstation_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workstation_cluster_id = "hello world"
    workstation_cluster = {}
    validate_only = true

    create_workstation_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_create_workstation_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workstation_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workstation_cluster({ parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workstation_cluster parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workstation_cluster ::Google::Cloud::Workstations::V1beta::CreateWorkstationClusterRequest.new(parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workstation_cluster({ parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workstation_cluster(::Google::Cloud::Workstations::V1beta::CreateWorkstationClusterRequest.new(parent: parent, workstation_cluster_id: workstation_cluster_id, workstation_cluster: workstation_cluster, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workstation_cluster_client_stub.call_count
      end
    end
  end

  def test_update_workstation_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workstation_cluster = {}
    update_mask = {}
    validate_only = true
    allow_missing = true

    update_workstation_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_update_workstation_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_workstation_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_workstation_cluster({ workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_workstation_cluster workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_workstation_cluster ::Google::Cloud::Workstations::V1beta::UpdateWorkstationClusterRequest.new(workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_workstation_cluster({ workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_workstation_cluster(::Google::Cloud::Workstations::V1beta::UpdateWorkstationClusterRequest.new(workstation_cluster: workstation_cluster, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_workstation_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_workstation_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"
    force = true

    delete_workstation_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_delete_workstation_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workstation_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workstation_cluster({ name: name, validate_only: validate_only, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workstation_cluster name: name, validate_only: validate_only, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workstation_cluster ::Google::Cloud::Workstations::V1beta::DeleteWorkstationClusterRequest.new(name: name, validate_only: validate_only, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workstation_cluster({ name: name, validate_only: validate_only, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workstation_cluster(::Google::Cloud::Workstations::V1beta::DeleteWorkstationClusterRequest.new(name: name, validate_only: validate_only, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workstation_cluster_client_stub.call_count
      end
    end
  end

  def test_get_workstation_config
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::WorkstationConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workstation_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_get_workstation_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workstation_config_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workstation_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workstation_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workstation_config ::Google::Cloud::Workstations::V1beta::GetWorkstationConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workstation_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workstation_config(::Google::Cloud::Workstations::V1beta::GetWorkstationConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workstation_config_client_stub.call_count
      end
    end
  end

  def test_list_workstation_configs
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workstation_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_list_workstation_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workstation_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workstation_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workstation_configs ::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workstation_configs(::Google::Cloud::Workstations::V1beta::ListWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workstation_configs_client_stub.call_count
      end
    end
  end

  def test_list_usable_workstation_configs
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_usable_workstation_configs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_list_usable_workstation_configs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_usable_workstation_configs_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_usable_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_usable_workstation_configs parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_usable_workstation_configs ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_usable_workstation_configs({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_usable_workstation_configs(::Google::Cloud::Workstations::V1beta::ListUsableWorkstationConfigsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_usable_workstation_configs_client_stub.call_count
      end
    end
  end

  def test_create_workstation_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workstation_config_id = "hello world"
    workstation_config = {}
    validate_only = true

    create_workstation_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_create_workstation_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workstation_config_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workstation_config({ parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workstation_config parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workstation_config ::Google::Cloud::Workstations::V1beta::CreateWorkstationConfigRequest.new(parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workstation_config({ parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workstation_config(::Google::Cloud::Workstations::V1beta::CreateWorkstationConfigRequest.new(parent: parent, workstation_config_id: workstation_config_id, workstation_config: workstation_config, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workstation_config_client_stub.call_count
      end
    end
  end

  def test_update_workstation_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workstation_config = {}
    update_mask = {}
    validate_only = true
    allow_missing = true

    update_workstation_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_update_workstation_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_workstation_config_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_workstation_config({ workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_workstation_config workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_workstation_config ::Google::Cloud::Workstations::V1beta::UpdateWorkstationConfigRequest.new(workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_workstation_config({ workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_workstation_config(::Google::Cloud::Workstations::V1beta::UpdateWorkstationConfigRequest.new(workstation_config: workstation_config, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_workstation_config_client_stub.call_count
      end
    end
  end

  def test_delete_workstation_config
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"
    force = true

    delete_workstation_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_delete_workstation_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workstation_config_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workstation_config({ name: name, validate_only: validate_only, etag: etag, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workstation_config name: name, validate_only: validate_only, etag: etag, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workstation_config ::Google::Cloud::Workstations::V1beta::DeleteWorkstationConfigRequest.new(name: name, validate_only: validate_only, etag: etag, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workstation_config({ name: name, validate_only: validate_only, etag: etag, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workstation_config(::Google::Cloud::Workstations::V1beta::DeleteWorkstationConfigRequest.new(name: name, validate_only: validate_only, etag: etag, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workstation_config_client_stub.call_count
      end
    end
  end

  def test_get_workstation
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::Workstation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_workstation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_get_workstation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_workstation_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_workstation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_workstation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_workstation ::Google::Cloud::Workstations::V1beta::GetWorkstationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_workstation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_workstation(::Google::Cloud::Workstations::V1beta::GetWorkstationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_workstation_client_stub.call_count
      end
    end
  end

  def test_list_workstations
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::ListWorkstationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_workstations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_list_workstations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_workstations_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_workstations({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_workstations parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_workstations ::Google::Cloud::Workstations::V1beta::ListWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_workstations({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_workstations(::Google::Cloud::Workstations::V1beta::ListWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_workstations_client_stub.call_count
      end
    end
  end

  def test_list_usable_workstations
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_usable_workstations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_list_usable_workstations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_usable_workstations_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_usable_workstations({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_usable_workstations parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_usable_workstations ::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_usable_workstations({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_usable_workstations(::Google::Cloud::Workstations::V1beta::ListUsableWorkstationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_usable_workstations_client_stub.call_count
      end
    end
  end

  def test_create_workstation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    workstation_id = "hello world"
    workstation = {}
    validate_only = true

    create_workstation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_create_workstation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_workstation_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_workstation({ parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_workstation parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_workstation ::Google::Cloud::Workstations::V1beta::CreateWorkstationRequest.new(parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_workstation({ parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_workstation(::Google::Cloud::Workstations::V1beta::CreateWorkstationRequest.new(parent: parent, workstation_id: workstation_id, workstation: workstation, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_workstation_client_stub.call_count
      end
    end
  end

  def test_update_workstation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    workstation = {}
    update_mask = {}
    validate_only = true
    allow_missing = true

    update_workstation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_update_workstation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_workstation_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_workstation({ workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_workstation workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_workstation ::Google::Cloud::Workstations::V1beta::UpdateWorkstationRequest.new(workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_workstation({ workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_workstation(::Google::Cloud::Workstations::V1beta::UpdateWorkstationRequest.new(workstation: workstation, update_mask: update_mask, validate_only: validate_only, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_workstation_client_stub.call_count
      end
    end
  end

  def test_delete_workstation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    delete_workstation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_delete_workstation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_workstation_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_workstation({ name: name, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_workstation name: name, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_workstation ::Google::Cloud::Workstations::V1beta::DeleteWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_workstation({ name: name, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_workstation(::Google::Cloud::Workstations::V1beta::DeleteWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_workstation_client_stub.call_count
      end
    end
  end

  def test_start_workstation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    start_workstation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_start_workstation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_workstation_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_workstation({ name: name, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_workstation name: name, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_workstation ::Google::Cloud::Workstations::V1beta::StartWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_workstation({ name: name, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_workstation(::Google::Cloud::Workstations::V1beta::StartWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_workstation_client_stub.call_count
      end
    end
  end

  def test_stop_workstation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true
    etag = "hello world"

    stop_workstation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_stop_workstation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_workstation_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_workstation({ name: name, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_workstation name: name, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_workstation ::Google::Cloud::Workstations::V1beta::StopWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_workstation({ name: name, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_workstation(::Google::Cloud::Workstations::V1beta::StopWorkstationRequest.new(name: name, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_workstation_client_stub.call_count
      end
    end
  end

  def test_generate_access_token
    # Create test objects.
    client_result = ::Google::Cloud::Workstations::V1beta::GenerateAccessTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    expire_time = {}
    workstation = "hello world"

    generate_access_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Workstations::V1beta::Workstations::Rest::ServiceStub.stub :transcode_generate_access_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_access_token_client_stub do
        # Create client
        client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_access_token({ expire_time: expire_time, workstation: workstation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_access_token expire_time: expire_time, workstation: workstation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_access_token ::Google::Cloud::Workstations::V1beta::GenerateAccessTokenRequest.new(expire_time: expire_time, workstation: workstation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_access_token({ expire_time: expire_time, workstation: workstation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_access_token(::Google::Cloud::Workstations::V1beta::GenerateAccessTokenRequest.new(expire_time: expire_time, workstation: workstation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_access_token_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Workstations::V1beta::Workstations::Rest::Client::Configuration, config
  end
end
