# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/workstations/v1beta/workstations"

class ::Google::Cloud::Workstations::V1beta::Workstations::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_workstation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workstation_path project: "value0", location: "value1", workstation_cluster: "value2", workstation_config: "value3", workstation: "value4"
      assert_equal "projects/value0/locations/value1/workstationClusters/value2/workstationConfigs/value3/workstations/value4", path
    end
  end

  def test_workstation_cluster_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workstation_cluster_path project: "value0", location: "value1", workstation_cluster: "value2"
      assert_equal "projects/value0/locations/value1/workstationClusters/value2", path
    end
  end

  def test_workstation_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Workstations::V1beta::Workstations::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.workstation_config_path project: "value0", location: "value1", workstation_cluster: "value2", workstation_config: "value3"
      assert_equal "projects/value0/locations/value1/workstationClusters/value2/workstationConfigs/value3", path
    end
  end
end
