# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Workstations
      module V1
        # A workstation cluster resource in the Cloud Workstations API.
        #
        # Defines a group of workstations in a particular region and the
        # VPC network they're attached to.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full name of this workstation cluster.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Human-readable name for this workstation cluster.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A system-assigned unique identifier for this workstation
        #     cluster.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates whether this workstation cluster is currently being
        #     updated to match its intended state.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Client-specified annotations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional.
        #     [Labels](https://cloud.google.com/workstations/docs/label-resources) that
        #     are applied to the workstation cluster and that are also propagated to the
        #     underlying Compute Engine resources.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation cluster was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation cluster was most recently updated.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation cluster was soft-deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Checksum computed by the server. May be sent on update and delete
        #     requests to make sure that the client has an up-to-date value before
        #     proceeding.
        # @!attribute [rw] network
        #   @return [::String]
        #     Immutable. Name of the Compute Engine network in which instances associated
        #     with this workstation cluster will be created.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Immutable. Name of the Compute Engine subnetwork in which instances
        #     associated with this workstation cluster will be created. Must be part of
        #     the subnetwork specified for this workstation cluster.
        # @!attribute [r] control_plane_ip
        #   @return [::String]
        #     Output only. The private IP address of the control plane for this
        #     workstation cluster. Workstation VMs need access to this IP address to work
        #     with the service, so make sure that your firewall rules allow egress from
        #     the workstation VMs to this address.
        # @!attribute [rw] private_cluster_config
        #   @return [::Google::Cloud::Workstations::V1::WorkstationCluster::PrivateClusterConfig]
        #     Optional. Configuration for private workstation cluster.
        # @!attribute [r] degraded
        #   @return [::Boolean]
        #     Output only. Whether this workstation cluster is in degraded mode, in which
        #     case it may require user action to restore full functionality. Details can
        #     be found in
        #     {::Google::Cloud::Workstations::V1::WorkstationCluster#conditions conditions}.
        # @!attribute [r] conditions
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Status conditions describing the workstation cluster's current
        #     state.
        class WorkstationCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration options for private workstation clusters.
          # @!attribute [rw] enable_private_endpoint
          #   @return [::Boolean]
          #     Immutable. Whether Workstations endpoint is private.
          # @!attribute [r] cluster_hostname
          #   @return [::String]
          #     Output only. Hostname for the workstation cluster. This field will be
          #     populated only when private endpoint is enabled. To access workstations
          #     in the workstation cluster, create a new DNS zone mapping this domain
          #     name to an internal IP address and a forwarding rule mapping that address
          #     to the service attachment.
          # @!attribute [r] service_attachment_uri
          #   @return [::String]
          #     Output only. Service attachment URI for the workstation cluster. The
          #     service attachemnt is created when private endpoint is enabled. To access
          #     workstations in the workstation cluster, configure access to the managed
          #     service using [Private Service
          #     Connect](https://cloud.google.com/vpc/docs/configure-private-service-connect-services).
          # @!attribute [rw] allowed_projects
          #   @return [::Array<::String>]
          #     Optional. Additional projects that are allowed to attach to the
          #     workstation cluster's service attachment. By default, the workstation
          #     cluster's project and the VPC host project (if different) are allowed.
          class PrivateClusterConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A workstation configuration resource in the Cloud Workstations API.
        #
        # Workstation configurations act as templates for workstations. The workstation
        # configuration defines details such as the workstation virtual machine (VM)
        # instance type, persistent storage, container image defining environment,
        # which IDE or Code Editor to use, and more. Administrators and platform teams
        # can also use [Identity and Access Management
        # (IAM)](https://cloud.google.com/iam/docs/overview) rules to grant access to
        # teams or to individual developers.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full name of this workstation configuration.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Human-readable name for this workstation configuration.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A system-assigned unique identifier for this workstation
        #     configuration.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates whether this workstation configuration is currently
        #     being updated to match its intended state.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Client-specified annotations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional.
        #     [Labels](https://cloud.google.com/workstations/docs/label-resources) that
        #     are applied to the workstation configuration and that are also propagated
        #     to the underlying Compute Engine resources.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation configuration was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation configuration was most recently
        #     updated.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation configuration was soft-deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Checksum computed by the server. May be sent on update and delete
        #     requests to make sure that the client has an up-to-date value before
        #     proceeding.
        # @!attribute [rw] idle_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Number of seconds to wait before automatically stopping a
        #     workstation after it last received user traffic.
        #
        #     A value of `"0s"` indicates that Cloud Workstations VMs created with this
        #     configuration should never time out due to idleness.
        #     Provide
        #     [duration](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#duration)
        #     terminated by `s` for seconds—for example, `"7200s"` (2 hours).
        #     The default is `"1200s"` (20 minutes).
        # @!attribute [rw] running_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Number of seconds that a workstation can run until it is
        #     automatically shut down. We recommend that workstations be shut down daily
        #     to reduce costs and so that security updates can be applied upon restart.
        #     The
        #     {::Google::Cloud::Workstations::V1::WorkstationConfig#idle_timeout idle_timeout}
        #     and
        #     {::Google::Cloud::Workstations::V1::WorkstationConfig#running_timeout running_timeout}
        #     fields are independent of each other. Note that the
        #     {::Google::Cloud::Workstations::V1::WorkstationConfig#running_timeout running_timeout}
        #     field shuts down VMs after the specified time, regardless of whether or not
        #     the VMs are idle.
        #
        #     Provide duration terminated by `s` for seconds—for example, `"54000s"`
        #     (15 hours). Defaults to `"43200s"` (12 hours). A value of `"0s"` indicates
        #     that workstations using this configuration should never time out. If
        #     {::Google::Cloud::Workstations::V1::WorkstationConfig#encryption_key encryption_key}
        #     is set, it must be greater than `"0s"` and less than
        #     `"86400s"` (24 hours).
        #
        #     Warning: A value of `"0s"` indicates that Cloud Workstations VMs created
        #     with this configuration have no maximum running time. This is strongly
        #     discouraged because you incur costs and will not pick up security updates.
        # @!attribute [rw] host
        #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::Host]
        #     Optional. Runtime host for the workstation.
        # @!attribute [rw] persistent_directories
        #   @return [::Array<::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory>]
        #     Optional. Directories to persist across workstation sessions.
        # @!attribute [rw] container
        #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::Container]
        #     Optional. Container that runs upon startup for each workstation using this
        #     workstation configuration.
        # @!attribute [rw] encryption_key
        #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::CustomerEncryptionKey]
        #     Immutable. Encrypts resources of this workstation configuration using a
        #     customer-managed encryption key (CMEK).
        #
        #     If specified, the boot disk of the Compute Engine instance and the
        #     persistent disk are encrypted using this encryption key. If
        #     this field is not set, the disks are encrypted using a generated
        #     key. Customer-managed encryption keys do not protect disk metadata.
        #
        #     If the customer-managed encryption key is rotated, when the workstation
        #     instance is stopped, the system attempts to recreate the
        #     persistent disk with the new version of the key. Be sure to keep
        #     older versions of the key until the persistent disk is recreated.
        #     Otherwise, data on the persistent disk might be lost.
        #
        #     If the encryption key is revoked, the workstation session automatically
        #     stops within 7 hours.
        #
        #     Immutable after the workstation configuration is created.
        # @!attribute [rw] readiness_checks
        #   @return [::Array<::Google::Cloud::Workstations::V1::WorkstationConfig::ReadinessCheck>]
        #     Optional. Readiness checks to perform when starting a workstation using
        #     this workstation configuration. Mark a workstation as running only after
        #     all specified readiness checks return 200 status codes.
        # @!attribute [rw] replica_zones
        #   @return [::Array<::String>]
        #     Optional. Immutable. Specifies the zones used to replicate the VM and disk
        #     resources within the region. If set, exactly two zones within the
        #     workstation cluster's region must be specified—for example,
        #     `['us-central1-a', 'us-central1-f']`. If this field is empty, two default
        #     zones within the region are used.
        #
        #     Immutable after the workstation configuration is created.
        # @!attribute [r] degraded
        #   @return [::Boolean]
        #     Output only. Whether this resource is degraded, in which case it may
        #     require user action to restore full functionality. See also the
        #     {::Google::Cloud::Workstations::V1::WorkstationConfig#conditions conditions}
        #     field.
        # @!attribute [r] conditions
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Status conditions describing the current resource state.
        class WorkstationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Runtime host for a workstation.
          # @!attribute [rw] gce_instance
          #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::Host::GceInstance]
          #     Specifies a Compute Engine instance as the host.
          class Host
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A runtime using a Compute Engine instance.
            # @!attribute [rw] machine_type
            #   @return [::String]
            #     Optional. The type of machine to use for VM instances—for example,
            #     `"e2-standard-4"`. For more information about machine types that
            #     Cloud Workstations supports, see the list of
            #     [available machine
            #     types](https://cloud.google.com/workstations/docs/available-machine-types).
            # @!attribute [rw] service_account
            #   @return [::String]
            #     Optional. The email address of the service account for Cloud
            #     Workstations VMs created with this configuration. When specified, be
            #     sure that the service account has `logginglogEntries.create` permission
            #     on the project so it can write logs out to Cloud Logging. If using a
            #     custom container image, the service account must have permissions to
            #     pull the specified image.
            #
            #     If you as the administrator want to be able to `ssh` into the
            #     underlying VM, you need to set this value to a service account
            #     for which you have the `iam.serviceAccounts.actAs` permission.
            #     Conversely, if you don't want anyone to be able to `ssh` into the
            #     underlying VM, use a service account where no one has that
            #     permission.
            #
            #     If not set, VMs run with a service account provided by the
            #     Cloud Workstations service, and the image must be publicly
            #     accessible.
            # @!attribute [rw] service_account_scopes
            #   @return [::Array<::String>]
            #     Optional. Scopes to grant to the
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::Host::GceInstance#service_account service_account}.
            #     Various scopes are automatically added based on feature usage. When
            #     specified, users of workstations under this configuration must have
            #     `iam.serviceAccounts.actAs` on the service account.
            # @!attribute [rw] tags
            #   @return [::Array<::String>]
            #     Optional. Network tags to add to the Compute Engine VMs backing the
            #     workstations. This option applies
            #     [network
            #     tags](https://cloud.google.com/vpc/docs/add-remove-network-tags) to VMs
            #     created with this configuration. These network tags enable the creation
            #     of [firewall
            #     rules](https://cloud.google.com/workstations/docs/configure-firewall-rules).
            # @!attribute [rw] pool_size
            #   @return [::Integer]
            #     Optional. The number of VMs that the system should keep idle so that
            #     new workstations can be started quickly for new users. Defaults to `0`
            #     in the API.
            # @!attribute [r] pooled_instances
            #   @return [::Integer]
            #     Output only. Number of instances currently available in the pool for
            #     faster workstation startup.
            # @!attribute [rw] disable_public_ip_addresses
            #   @return [::Boolean]
            #     Optional. When set to true, disables public IP addresses for VMs. If
            #     you disable public IP addresses, you must set up Private Google Access
            #     or Cloud NAT on your network. If you use Private Google Access and you
            #     use `private.googleapis.com` or `restricted.googleapis.com` for
            #     Container Registry and Artifact Registry, make sure that you set
            #     up DNS records for domains `*.gcr.io` and `*.pkg.dev`.
            #     Defaults to false (VMs have public IP addresses).
            # @!attribute [rw] enable_nested_virtualization
            #   @return [::Boolean]
            #     Optional. Whether to enable nested virtualization on Cloud Workstations
            #     VMs created under this workstation configuration.
            #
            #     Nested virtualization lets you run virtual machine (VM) instances
            #     inside your workstation. Before enabling nested virtualization,
            #     consider the following important considerations. Cloud Workstations
            #     instances are subject to the [same restrictions as Compute Engine
            #     instances](https://cloud.google.com/compute/docs/instances/nested-virtualization/overview#restrictions):
            #
            #     * **Organization policy**: projects, folders, or
            #     organizations may be restricted from creating nested VMs if the
            #     **Disable VM nested virtualization** constraint is enforced in
            #     the organization policy. For more information, see the
            #     Compute Engine section,
            #     [Checking whether nested virtualization is
            #     allowed](https://cloud.google.com/compute/docs/instances/nested-virtualization/managing-constraint#checking_whether_nested_virtualization_is_allowed).
            #     * **Performance**: nested VMs might experience a 10% or greater
            #     decrease in performance for workloads that are CPU-bound and
            #     possibly greater than a 10% decrease for workloads that are
            #     input/output bound.
            #     * **Machine Type**: nested virtualization can only be enabled on
            #     workstation configurations that specify a
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::Host::GceInstance#machine_type machine_type}
            #     in the N1 or N2 machine series.
            #     * **GPUs**: nested virtualization may not be enabled on workstation
            #     configurations with accelerators.
            #     * **Operating System**: Because
            #     [Container-Optimized
            #     OS](https://cloud.google.com/compute/docs/images/os-details#container-optimized_os_cos)
            #     does not support nested virtualization, when nested virtualization is
            #     enabled, the underlying Compute Engine VM instances boot from an
            #     [Ubuntu
            #     LTS](https://cloud.google.com/compute/docs/images/os-details#ubuntu_lts)
            #     image.
            # @!attribute [rw] shielded_instance_config
            #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::Host::GceInstance::GceShieldedInstanceConfig]
            #     Optional. A set of Compute Engine Shielded instance options.
            # @!attribute [rw] confidential_instance_config
            #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::Host::GceInstance::GceConfidentialInstanceConfig]
            #     Optional. A set of Compute Engine Confidential VM instance options.
            # @!attribute [rw] boot_disk_size_gb
            #   @return [::Integer]
            #     Optional. The size of the boot disk for the VM in gigabytes (GB).
            #     The minimum boot disk size is `30` GB. Defaults to `50` GB.
            class GceInstance
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # A set of Compute Engine Shielded instance options.
              # @!attribute [rw] enable_secure_boot
              #   @return [::Boolean]
              #     Optional. Whether the instance has Secure Boot enabled.
              # @!attribute [rw] enable_vtpm
              #   @return [::Boolean]
              #     Optional. Whether the instance has the vTPM enabled.
              # @!attribute [rw] enable_integrity_monitoring
              #   @return [::Boolean]
              #     Optional. Whether the instance has integrity monitoring enabled.
              class GceShieldedInstanceConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # A set of Compute Engine Confidential VM instance options.
              # @!attribute [rw] enable_confidential_compute
              #   @return [::Boolean]
              #     Optional. Whether the instance has confidential compute enabled.
              class GceConfidentialInstanceConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # A directory to persist across workstation sessions.
          # @!attribute [rw] gce_pd
          #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk]
          #     A PersistentDirectory backed by a Compute Engine persistent disk.
          # @!attribute [rw] mount_path
          #   @return [::String]
          #     Optional. Location of this directory in the running workstation.
          class PersistentDirectory
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A PersistentDirectory backed by a Compute Engine regional persistent
            # disk. The
            # {::Google::Cloud::Workstations::V1::WorkstationConfig#persistent_directories persistent_directories}
            # field is repeated, but it may contain only one entry. It creates a
            # [persistent
            # disk](https://cloud.google.com/compute/docs/disks/persistent-disks) that
            # mounts to the workstation VM at `/home` when the session starts and
            # detaches when the session ends. If this field is empty, workstations
            # created with this configuration do not have a persistent home
            # directory.
            # @!attribute [rw] size_gb
            #   @return [::Integer]
            #     Optional. The GB capacity of a persistent home directory for each
            #     workstation created with this configuration. Must be empty if
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk#source_snapshot source_snapshot}
            #     is set.
            #
            #     Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`.
            #     Defaults to `200`. If less than `200` GB, the
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk#disk_type disk_type}
            #     must be
            #     `"pd-balanced"` or `"pd-ssd"`.
            # @!attribute [rw] fs_type
            #   @return [::String]
            #     Optional. Type of file system that the disk should be formatted with.
            #     The workstation image must support this file system type. Must be empty
            #     if
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk#source_snapshot source_snapshot}
            #     is set. Defaults to `"ext4"`.
            # @!attribute [rw] disk_type
            #   @return [::String]
            #     Optional. The [type of the persistent
            #     disk](https://cloud.google.com/compute/docs/disks#disk-types) for the
            #     home directory. Defaults to `"pd-standard"`.
            # @!attribute [rw] source_snapshot
            #   @return [::String]
            #     Optional. Name of the snapshot to use as the source for the disk. If
            #     set,
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk#size_gb size_gb}
            #     and
            #     {::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk#fs_type fs_type}
            #     must be empty.
            # @!attribute [rw] reclaim_policy
            #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig::PersistentDirectory::GceRegionalPersistentDisk::ReclaimPolicy]
            #     Optional. Whether the persistent disk should be deleted when the
            #     workstation is deleted. Valid values are `DELETE` and `RETAIN`.
            #     Defaults to `DELETE`.
            class GceRegionalPersistentDisk
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Value representing what should happen to the disk after the workstation
              # is deleted.
              module ReclaimPolicy
                # Do not use.
                RECLAIM_POLICY_UNSPECIFIED = 0

                # Delete the persistent disk when deleting the workstation.
                DELETE = 1

                # Keep the persistent disk when deleting the workstation.
                # An administrator must manually delete the disk.
                RETAIN = 2
              end
            end
          end

          # A Docker container.
          # @!attribute [rw] image
          #   @return [::String]
          #     Optional. A Docker container image that defines a custom environment.
          #
          #     Cloud Workstations provides a number of
          #     [preconfigured
          #     images](https://cloud.google.com/workstations/docs/preconfigured-base-images),
          #     but you can create your own
          #     [custom container
          #     images](https://cloud.google.com/workstations/docs/custom-container-images).
          #     If using a private image, the `host.gceInstance.serviceAccount` field
          #     must be specified in the workstation configuration and must have
          #     permission to pull the specified image. Otherwise, the image must be
          #     publicly accessible.
          # @!attribute [rw] command
          #   @return [::Array<::String>]
          #     Optional. If set, overrides the default ENTRYPOINT specified by the
          #     image.
          # @!attribute [rw] args
          #   @return [::Array<::String>]
          #     Optional. Arguments passed to the entrypoint.
          # @!attribute [rw] env
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Environment variables passed to the container's entrypoint.
          # @!attribute [rw] working_dir
          #   @return [::String]
          #     Optional. If set, overrides the default DIR specified by the image.
          # @!attribute [rw] run_as_user
          #   @return [::Integer]
          #     Optional. If set, overrides the USER specified in the image with the
          #     given uid.
          class Container
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class EnvEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A customer-managed encryption key (CMEK) for the Compute Engine
          # resources of the associated workstation configuration. Specify the name of
          # your Cloud KMS encryption key and the default service account.
          # We recommend that you use a separate service account and follow
          # [Cloud KMS best
          # practices](https://cloud.google.com/kms/docs/separation-of-duties).
          # @!attribute [rw] kms_key
          #   @return [::String]
          #     Immutable. The name of the Google Cloud KMS encryption key. For example,
          #     `"projects/PROJECT_ID/locations/REGION/keyRings/KEY_RING/cryptoKeys/KEY_NAME"`.
          #     The key must be in the same region as the workstation configuration.
          # @!attribute [rw] kms_key_service_account
          #   @return [::String]
          #     Immutable. The service account to use with the specified
          #     KMS key. We recommend that you use a separate service account
          #     and follow KMS best practices. For more information, see
          #     [Separation of
          #     duties](https://cloud.google.com/kms/docs/separation-of-duties) and
          #     `gcloud kms keys add-iam-policy-binding`
          #     [`--member`](https://cloud.google.com/sdk/gcloud/reference/kms/keys/add-iam-policy-binding#--member).
          class CustomerEncryptionKey
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A readiness check to be performed on a workstation.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. Path to which the request should be sent.
          # @!attribute [rw] port
          #   @return [::Integer]
          #     Optional. Port to which the request should be sent.
          class ReadinessCheck
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A single instance of a developer workstation with its own persistent storage.
        # @!attribute [rw] name
        #   @return [::String]
        #     Full name of this workstation.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Human-readable name for this workstation.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A system-assigned unique identifier for this workstation.
        # @!attribute [r] reconciling
        #   @return [::Boolean]
        #     Output only. Indicates whether this workstation is currently being updated
        #     to match its intended state.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Client-specified annotations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional.
        #     [Labels](https://cloud.google.com/workstations/docs/label-resources) that
        #     are applied to the workstation and that are also propagated to the
        #     underlying Compute Engine resources.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation was most recently updated.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation was most recently successfully
        #     started, regardless of the workstation's initial state.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when this workstation was soft-deleted.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Checksum computed by the server. May be sent on update and delete
        #     requests to make sure that the client has an up-to-date value before
        #     proceeding.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Workstations::V1::Workstation::State]
        #     Output only. Current state of the workstation.
        # @!attribute [r] host
        #   @return [::String]
        #     Output only. Host to which clients can send HTTPS traffic that will be
        #     received by the workstation. Authorized traffic will be received to the
        #     workstation as HTTP on port 80. To send traffic to a different port,
        #     clients may prefix the host with the destination port in the format
        #     `{port}-{host}`.
        class Workstation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Whether a workstation is running and ready to receive user requests.
          module State
            # Do not use.
            STATE_UNSPECIFIED = 0

            # The workstation is not yet ready to accept requests from users but will
            # be soon.
            STATE_STARTING = 1

            # The workstation is ready to accept requests from users.
            STATE_RUNNING = 2

            # The workstation is being stopped.
            STATE_STOPPING = 3

            # The workstation is stopped and will not be able to receive requests until
            # it is started.
            STATE_STOPPED = 4
          end
        end

        # Request message for GetWorkstationCluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the requested resource.
        class GetWorkstationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListWorkstationClusters.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. next_page_token value returned from a previous List request, if
        #     any.
        class ListWorkstationClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListWorkstationClusters.
        # @!attribute [rw] workstation_clusters
        #   @return [::Array<::Google::Cloud::Workstations::V1::WorkstationCluster>]
        #     The requested workstation clusters.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListWorkstationClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a CreateWorkstationCluster.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] workstation_cluster_id
        #   @return [::String]
        #     Required. ID to use for the workstation cluster.
        # @!attribute [rw] workstation_cluster
        #   @return [::Google::Cloud::Workstations::V1::WorkstationCluster]
        #     Required. Workstation cluster to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        class CreateWorkstationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateWorkstationCluster.
        # @!attribute [rw] workstation_cluster
        #   @return [::Google::Cloud::Workstations::V1::WorkstationCluster]
        #     Required. Workstation cluster to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask that specifies which fields in the workstation cluster
        #     should be updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set, and the workstation cluster is not found, a new
        #     workstation cluster will be created. In this situation, update_mask is
        #     ignored.
        class UpdateWorkstationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a workstation cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workstation cluster to delete.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     apply it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If set, the request will be rejected if the latest version of the
        #     workstation cluster on the server does not have this ETag.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set, any workstation configurations and workstations in the
        #     workstation cluster are also deleted. Otherwise, the request only
        #     works if the workstation cluster has no configurations or workstations.
        class DeleteWorkstationClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetWorkstationConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the requested resource.
        class GetWorkstationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListWorkstationConfigs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. next_page_token value returned from a previous List request, if
        #     any.
        class ListWorkstationConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListWorkstationConfigs.
        # @!attribute [rw] workstation_configs
        #   @return [::Array<::Google::Cloud::Workstations::V1::WorkstationConfig>]
        #     The requested configs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListWorkstationConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListUsableWorkstationConfigs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. next_page_token value returned from a previous List request, if
        #     any.
        class ListUsableWorkstationConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListUsableWorkstationConfigs.
        # @!attribute [rw] workstation_configs
        #   @return [::Array<::Google::Cloud::Workstations::V1::WorkstationConfig>]
        #     The requested configs.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListUsableWorkstationConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a CreateWorkstationConfig.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] workstation_config_id
        #   @return [::String]
        #     Required. ID to use for the workstation configuration.
        # @!attribute [rw] workstation_config
        #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig]
        #     Required. Config to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        class CreateWorkstationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateWorkstationConfig.
        # @!attribute [rw] workstation_config
        #   @return [::Google::Cloud::Workstations::V1::WorkstationConfig]
        #     Required. Config to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask specifying which fields in the workstation configuration
        #     should be updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set and the workstation configuration is not found, a new
        #     workstation configuration will be created. In this situation,
        #     update_mask is ignored.
        class UpdateWorkstationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for deleting a workstation configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workstation configuration to delete.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If set, the request is rejected if the latest version of the
        #     workstation configuration on the server does not have this ETag.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set, any workstations in the workstation configuration are
        #     also deleted. Otherwise, the request works only if the workstation
        #     configuration has no workstations.
        class DeleteWorkstationConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetWorkstation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the requested resource.
        class GetWorkstationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListWorkstations.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. next_page_token value returned from a previous List request, if
        #     any.
        class ListWorkstationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListWorkstations.
        # @!attribute [rw] workstations
        #   @return [::Array<::Google::Cloud::Workstations::V1::Workstation>]
        #     The requested workstations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Optional. Token to retrieve the next page of results, or empty if there are
        #     no more results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Optional. Unreachable resources.
        class ListWorkstationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListUsableWorkstations.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. next_page_token value returned from a previous List request, if
        #     any.
        class ListUsableWorkstationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListUsableWorkstations.
        # @!attribute [rw] workstations
        #   @return [::Array<::Google::Cloud::Workstations::V1::Workstation>]
        #     The requested workstations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListUsableWorkstationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for creating a CreateWorkstation.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        # @!attribute [rw] workstation_id
        #   @return [::String]
        #     Required. ID to use for the workstation.
        # @!attribute [rw] workstation
        #   @return [::Google::Cloud::Workstations::V1::Workstation]
        #     Required. Workstation to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        class CreateWorkstationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateWorkstation.
        # @!attribute [rw] workstation
        #   @return [::Google::Cloud::Workstations::V1::Workstation]
        #     Required. Workstation to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask specifying which fields in the workstation configuration
        #     should be updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set and the workstation configuration is not found, a new
        #     workstation configuration is created. In this situation, update_mask
        #     is ignored.
        class UpdateWorkstationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteWorkstation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workstation to delete.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If set, the request will be rejected if the latest version of the
        #     workstation on the server does not have this ETag.
        class DeleteWorkstationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for StartWorkstation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workstation to start.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If set, the request will be rejected if the latest version of the
        #     workstation on the server does not have this ETag.
        class StartWorkstationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for StopWorkstation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workstation to stop.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually apply it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If set, the request will be rejected if the latest version of the
        #     workstation on the server does not have this ETag.
        class StopWorkstationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GenerateAccessToken.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Desired expiration time of the access token. This value must
        #     be at most 24 hours in the future. If a value is not specified, the
        #     token's expiration time will be set to a default value of 1 hour in the
        #     future.
        #
        #     Note: The following fields are mutually exclusive: `expire_time`, `ttl`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ttl
        #   @return [::Google::Protobuf::Duration]
        #     Desired lifetime duration of the access token. This value must
        #     be at most 24 hours. If a value is not specified, the token's lifetime
        #     will be set to a default value of 1 hour.
        #
        #     Note: The following fields are mutually exclusive: `ttl`, `expire_time`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] workstation
        #   @return [::String]
        #     Required. Name of the workstation for which the access token should be
        #     generated.
        class GenerateAccessTokenRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for GenerateAccessToken.
        # @!attribute [rw] access_token
        #   @return [::String]
        #     The generated bearer access token. To use this token, include it in an
        #     Authorization header of an HTTP request sent to the associated
        #     workstation's hostname—for example, `Authorization: Bearer
        #     <access_token>`.
        # @!attribute [rw] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time at which the generated token will expire.
        class GenerateAccessTokenResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for long-running operations.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time that the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time that the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
