# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/workstations/v1/workstations_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Workstations
      module V1
        module Workstations
          ##
          # Client for the Workstations service.
          #
          # Service for interacting with Cloud Workstations.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "workstations.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :workstations_stub

            ##
            # Configure the Workstations Client class.
            #
            # See {::Google::Cloud::Workstations::V1::Workstations::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Workstations clients
            #   ::Google::Cloud::Workstations::V1::Workstations::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Workstations", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.get_workstation_cluster.timeout = 60.0
                default_config.rpcs.get_workstation_cluster.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_workstation_clusters.timeout = 60.0
                default_config.rpcs.list_workstation_clusters.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_workstation_cluster.timeout = 60.0

                default_config.rpcs.update_workstation_cluster.timeout = 60.0

                default_config.rpcs.delete_workstation_cluster.timeout = 60.0

                default_config.rpcs.get_workstation_config.timeout = 60.0
                default_config.rpcs.get_workstation_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_workstation_configs.timeout = 60.0
                default_config.rpcs.list_workstation_configs.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_usable_workstation_configs.timeout = 60.0
                default_config.rpcs.list_usable_workstation_configs.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_workstation_config.timeout = 60.0

                default_config.rpcs.update_workstation_config.timeout = 60.0

                default_config.rpcs.delete_workstation_config.timeout = 60.0

                default_config.rpcs.get_workstation.timeout = 60.0
                default_config.rpcs.get_workstation.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_workstations.timeout = 60.0
                default_config.rpcs.list_workstations.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_usable_workstations.timeout = 60.0
                default_config.rpcs.list_usable_workstations.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_workstation.timeout = 60.0

                default_config.rpcs.update_workstation.timeout = 60.0

                default_config.rpcs.delete_workstation.timeout = 60.0

                default_config.rpcs.start_workstation.timeout = 60.0

                default_config.rpcs.stop_workstation.timeout = 60.0

                default_config.rpcs.generate_access_token.timeout = 60.0
                default_config.rpcs.generate_access_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Workstations Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Workstations::V1::Workstations::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @workstations_stub.universe_domain
            end

            ##
            # Create a new Workstations client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Workstations::V1::Workstations::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Workstations client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/workstations/v1/workstations_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @workstations_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Workstations::V1::Workstations::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @workstations_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @workstations_stub.endpoint
                config.universe_domain = @workstations_stub.universe_domain
                config.logger = @workstations_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @workstations_stub.endpoint
                config.universe_domain = @workstations_stub.universe_domain
                config.logger = @workstations_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Workstations::V1::Workstations::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @workstations_stub.logger
            end

            # Service calls

            ##
            # Returns the requested workstation cluster.
            #
            # @overload get_workstation_cluster(request, options = nil)
            #   Pass arguments to `get_workstation_cluster` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::GetWorkstationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::GetWorkstationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workstation_cluster(name: nil)
            #   Pass arguments to `get_workstation_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the requested resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Workstations::V1::WorkstationCluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Workstations::V1::WorkstationCluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::GetWorkstationClusterRequest.new
            #
            #   # Call the get_workstation_cluster method.
            #   result = client.get_workstation_cluster request
            #
            #   # The returned object is of type Google::Cloud::Workstations::V1::WorkstationCluster.
            #   p result
            #
            def get_workstation_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::GetWorkstationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workstation_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workstation_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workstation_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :get_workstation_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns all workstation clusters in the specified location.
            #
            # @overload list_workstation_clusters(request, options = nil)
            #   Pass arguments to `list_workstation_clusters` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::ListWorkstationClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::ListWorkstationClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workstation_clusters(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_workstation_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of items to return.
            #   @param page_token [::String]
            #     Optional. next_page_token value returned from a previous List request, if
            #     any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::WorkstationCluster>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::WorkstationCluster>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::ListWorkstationClustersRequest.new
            #
            #   # Call the list_workstation_clusters method.
            #   result = client.list_workstation_clusters request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Workstations::V1::WorkstationCluster.
            #     p item
            #   end
            #
            def list_workstation_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::ListWorkstationClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workstation_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workstation_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workstation_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :list_workstation_clusters, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @workstations_stub, :list_workstation_clusters, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new workstation cluster.
            #
            # @overload create_workstation_cluster(request, options = nil)
            #   Pass arguments to `create_workstation_cluster` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::CreateWorkstationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::CreateWorkstationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workstation_cluster(parent: nil, workstation_cluster_id: nil, workstation_cluster: nil, validate_only: nil)
            #   Pass arguments to `create_workstation_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param workstation_cluster_id [::String]
            #     Required. ID to use for the workstation cluster.
            #   @param workstation_cluster [::Google::Cloud::Workstations::V1::WorkstationCluster, ::Hash]
            #     Required. Workstation cluster to create.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::CreateWorkstationClusterRequest.new
            #
            #   # Call the create_workstation_cluster method.
            #   result = client.create_workstation_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_workstation_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::CreateWorkstationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workstation_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workstation_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workstation_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :create_workstation_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing workstation cluster.
            #
            # @overload update_workstation_cluster(request, options = nil)
            #   Pass arguments to `update_workstation_cluster` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::UpdateWorkstationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::UpdateWorkstationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_workstation_cluster(workstation_cluster: nil, update_mask: nil, validate_only: nil, allow_missing: nil)
            #   Pass arguments to `update_workstation_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workstation_cluster [::Google::Cloud::Workstations::V1::WorkstationCluster, ::Hash]
            #     Required. Workstation cluster to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask that specifies which fields in the workstation cluster
            #     should be updated.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param allow_missing [::Boolean]
            #     Optional. If set, and the workstation cluster is not found, a new
            #     workstation cluster will be created. In this situation, update_mask is
            #     ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::UpdateWorkstationClusterRequest.new
            #
            #   # Call the update_workstation_cluster method.
            #   result = client.update_workstation_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_workstation_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::UpdateWorkstationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_workstation_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workstation_cluster&.name
                header_params["workstation_cluster.name"] = request.workstation_cluster.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_workstation_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_workstation_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :update_workstation_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified workstation cluster.
            #
            # @overload delete_workstation_cluster(request, options = nil)
            #   Pass arguments to `delete_workstation_cluster` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::DeleteWorkstationClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::DeleteWorkstationClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workstation_cluster(name: nil, validate_only: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_workstation_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the workstation cluster to delete.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     apply it.
            #   @param etag [::String]
            #     Optional. If set, the request will be rejected if the latest version of the
            #     workstation cluster on the server does not have this ETag.
            #   @param force [::Boolean]
            #     Optional. If set, any workstation configurations and workstations in the
            #     workstation cluster are also deleted. Otherwise, the request only
            #     works if the workstation cluster has no configurations or workstations.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::DeleteWorkstationClusterRequest.new
            #
            #   # Call the delete_workstation_cluster method.
            #   result = client.delete_workstation_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_workstation_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::DeleteWorkstationClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workstation_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workstation_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workstation_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :delete_workstation_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested workstation configuration.
            #
            # @overload get_workstation_config(request, options = nil)
            #   Pass arguments to `get_workstation_config` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::GetWorkstationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::GetWorkstationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workstation_config(name: nil)
            #   Pass arguments to `get_workstation_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the requested resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Workstations::V1::WorkstationConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Workstations::V1::WorkstationConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::GetWorkstationConfigRequest.new
            #
            #   # Call the get_workstation_config method.
            #   result = client.get_workstation_config request
            #
            #   # The returned object is of type Google::Cloud::Workstations::V1::WorkstationConfig.
            #   p result
            #
            def get_workstation_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::GetWorkstationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workstation_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workstation_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workstation_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :get_workstation_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns all workstation configurations in the specified cluster.
            #
            # @overload list_workstation_configs(request, options = nil)
            #   Pass arguments to `list_workstation_configs` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::ListWorkstationConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::ListWorkstationConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workstation_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_workstation_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of items to return.
            #   @param page_token [::String]
            #     Optional. next_page_token value returned from a previous List request, if
            #     any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::WorkstationConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::WorkstationConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::ListWorkstationConfigsRequest.new
            #
            #   # Call the list_workstation_configs method.
            #   result = client.list_workstation_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Workstations::V1::WorkstationConfig.
            #     p item
            #   end
            #
            def list_workstation_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::ListWorkstationConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workstation_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workstation_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workstation_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :list_workstation_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @workstations_stub, :list_workstation_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns all workstation configurations in the specified cluster on which
            # the caller has the "workstations.workstation.create" permission.
            #
            # @overload list_usable_workstation_configs(request, options = nil)
            #   Pass arguments to `list_usable_workstation_configs` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::ListUsableWorkstationConfigsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::ListUsableWorkstationConfigsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_usable_workstation_configs(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_usable_workstation_configs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of items to return.
            #   @param page_token [::String]
            #     Optional. next_page_token value returned from a previous List request, if
            #     any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::WorkstationConfig>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::WorkstationConfig>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::ListUsableWorkstationConfigsRequest.new
            #
            #   # Call the list_usable_workstation_configs method.
            #   result = client.list_usable_workstation_configs request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Workstations::V1::WorkstationConfig.
            #     p item
            #   end
            #
            def list_usable_workstation_configs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::ListUsableWorkstationConfigsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_usable_workstation_configs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_usable_workstation_configs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_usable_workstation_configs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :list_usable_workstation_configs, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @workstations_stub, :list_usable_workstation_configs, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new workstation configuration.
            #
            # @overload create_workstation_config(request, options = nil)
            #   Pass arguments to `create_workstation_config` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::CreateWorkstationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::CreateWorkstationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workstation_config(parent: nil, workstation_config_id: nil, workstation_config: nil, validate_only: nil)
            #   Pass arguments to `create_workstation_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param workstation_config_id [::String]
            #     Required. ID to use for the workstation configuration.
            #   @param workstation_config [::Google::Cloud::Workstations::V1::WorkstationConfig, ::Hash]
            #     Required. Config to create.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::CreateWorkstationConfigRequest.new
            #
            #   # Call the create_workstation_config method.
            #   result = client.create_workstation_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_workstation_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::CreateWorkstationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workstation_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workstation_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workstation_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :create_workstation_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing workstation configuration.
            #
            # @overload update_workstation_config(request, options = nil)
            #   Pass arguments to `update_workstation_config` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::UpdateWorkstationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::UpdateWorkstationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_workstation_config(workstation_config: nil, update_mask: nil, validate_only: nil, allow_missing: nil)
            #   Pass arguments to `update_workstation_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workstation_config [::Google::Cloud::Workstations::V1::WorkstationConfig, ::Hash]
            #     Required. Config to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask specifying which fields in the workstation configuration
            #     should be updated.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param allow_missing [::Boolean]
            #     Optional. If set and the workstation configuration is not found, a new
            #     workstation configuration will be created. In this situation,
            #     update_mask is ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::UpdateWorkstationConfigRequest.new
            #
            #   # Call the update_workstation_config method.
            #   result = client.update_workstation_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_workstation_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::UpdateWorkstationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_workstation_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workstation_config&.name
                header_params["workstation_config.name"] = request.workstation_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_workstation_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_workstation_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :update_workstation_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified workstation configuration.
            #
            # @overload delete_workstation_config(request, options = nil)
            #   Pass arguments to `delete_workstation_config` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::DeleteWorkstationConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::DeleteWorkstationConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workstation_config(name: nil, validate_only: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_workstation_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the workstation configuration to delete.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param etag [::String]
            #     Optional. If set, the request is rejected if the latest version of the
            #     workstation configuration on the server does not have this ETag.
            #   @param force [::Boolean]
            #     Optional. If set, any workstations in the workstation configuration are
            #     also deleted. Otherwise, the request works only if the workstation
            #     configuration has no workstations.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::DeleteWorkstationConfigRequest.new
            #
            #   # Call the delete_workstation_config method.
            #   result = client.delete_workstation_config request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_workstation_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::DeleteWorkstationConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workstation_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workstation_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workstation_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :delete_workstation_config, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns the requested workstation.
            #
            # @overload get_workstation(request, options = nil)
            #   Pass arguments to `get_workstation` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::GetWorkstationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::GetWorkstationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_workstation(name: nil)
            #   Pass arguments to `get_workstation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the requested resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Workstations::V1::Workstation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Workstations::V1::Workstation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::GetWorkstationRequest.new
            #
            #   # Call the get_workstation method.
            #   result = client.get_workstation request
            #
            #   # The returned object is of type Google::Cloud::Workstations::V1::Workstation.
            #   p result
            #
            def get_workstation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::GetWorkstationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_workstation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_workstation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_workstation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :get_workstation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns all Workstations using the specified workstation configuration.
            #
            # @overload list_workstations(request, options = nil)
            #   Pass arguments to `list_workstations` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::ListWorkstationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::ListWorkstationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_workstations(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_workstations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of items to return.
            #   @param page_token [::String]
            #     Optional. next_page_token value returned from a previous List request, if
            #     any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::Workstation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::Workstation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::ListWorkstationsRequest.new
            #
            #   # Call the list_workstations method.
            #   result = client.list_workstations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Workstations::V1::Workstation.
            #     p item
            #   end
            #
            def list_workstations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::ListWorkstationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_workstations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_workstations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_workstations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :list_workstations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @workstations_stub, :list_workstations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns all workstations using the specified workstation configuration
            # on which the caller has the "workstations.workstations.use" permission.
            #
            # @overload list_usable_workstations(request, options = nil)
            #   Pass arguments to `list_usable_workstations` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::ListUsableWorkstationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::ListUsableWorkstationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_usable_workstations(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_usable_workstations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of items to return.
            #   @param page_token [::String]
            #     Optional. next_page_token value returned from a previous List request, if
            #     any.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::Workstation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Workstations::V1::Workstation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::ListUsableWorkstationsRequest.new
            #
            #   # Call the list_usable_workstations method.
            #   result = client.list_usable_workstations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Workstations::V1::Workstation.
            #     p item
            #   end
            #
            def list_usable_workstations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::ListUsableWorkstationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_usable_workstations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_usable_workstations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_usable_workstations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :list_usable_workstations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @workstations_stub, :list_usable_workstations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new workstation.
            #
            # @overload create_workstation(request, options = nil)
            #   Pass arguments to `create_workstation` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::CreateWorkstationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::CreateWorkstationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_workstation(parent: nil, workstation_id: nil, workstation: nil, validate_only: nil)
            #   Pass arguments to `create_workstation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent resource name.
            #   @param workstation_id [::String]
            #     Required. ID to use for the workstation.
            #   @param workstation [::Google::Cloud::Workstations::V1::Workstation, ::Hash]
            #     Required. Workstation to create.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::CreateWorkstationRequest.new
            #
            #   # Call the create_workstation method.
            #   result = client.create_workstation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_workstation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::CreateWorkstationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_workstation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_workstation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_workstation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :create_workstation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates an existing workstation.
            #
            # @overload update_workstation(request, options = nil)
            #   Pass arguments to `update_workstation` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::UpdateWorkstationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::UpdateWorkstationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_workstation(workstation: nil, update_mask: nil, validate_only: nil, allow_missing: nil)
            #   Pass arguments to `update_workstation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param workstation [::Google::Cloud::Workstations::V1::Workstation, ::Hash]
            #     Required. Workstation to update.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask specifying which fields in the workstation configuration
            #     should be updated.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param allow_missing [::Boolean]
            #     Optional. If set and the workstation configuration is not found, a new
            #     workstation configuration is created. In this situation, update_mask
            #     is ignored.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::UpdateWorkstationRequest.new
            #
            #   # Call the update_workstation method.
            #   result = client.update_workstation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_workstation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::UpdateWorkstationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_workstation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workstation&.name
                header_params["workstation.name"] = request.workstation.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_workstation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_workstation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :update_workstation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the specified workstation.
            #
            # @overload delete_workstation(request, options = nil)
            #   Pass arguments to `delete_workstation` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::DeleteWorkstationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::DeleteWorkstationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_workstation(name: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `delete_workstation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the workstation to delete.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param etag [::String]
            #     Optional. If set, the request will be rejected if the latest version of the
            #     workstation on the server does not have this ETag.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::DeleteWorkstationRequest.new
            #
            #   # Call the delete_workstation method.
            #   result = client.delete_workstation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_workstation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::DeleteWorkstationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_workstation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_workstation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_workstation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :delete_workstation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Starts running a workstation so that users can connect to it.
            #
            # @overload start_workstation(request, options = nil)
            #   Pass arguments to `start_workstation` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::StartWorkstationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::StartWorkstationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload start_workstation(name: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `start_workstation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the workstation to start.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param etag [::String]
            #     Optional. If set, the request will be rejected if the latest version of the
            #     workstation on the server does not have this ETag.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::StartWorkstationRequest.new
            #
            #   # Call the start_workstation method.
            #   result = client.start_workstation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def start_workstation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::StartWorkstationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.start_workstation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.start_workstation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.start_workstation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :start_workstation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Stops running a workstation, reducing costs.
            #
            # @overload stop_workstation(request, options = nil)
            #   Pass arguments to `stop_workstation` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::StopWorkstationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::StopWorkstationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload stop_workstation(name: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `stop_workstation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the workstation to stop.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     actually apply it.
            #   @param etag [::String]
            #     Optional. If set, the request will be rejected if the latest version of the
            #     workstation on the server does not have this ETag.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::StopWorkstationRequest.new
            #
            #   # Call the stop_workstation method.
            #   result = client.stop_workstation request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def stop_workstation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::StopWorkstationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.stop_workstation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.stop_workstation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.stop_workstation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :stop_workstation, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Returns a short-lived credential that can be used to send authenticated and
            # authorized traffic to a workstation.
            #
            # @overload generate_access_token(request, options = nil)
            #   Pass arguments to `generate_access_token` via a request object, either of type
            #   {::Google::Cloud::Workstations::V1::GenerateAccessTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Workstations::V1::GenerateAccessTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_access_token(expire_time: nil, ttl: nil, workstation: nil)
            #   Pass arguments to `generate_access_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param expire_time [::Google::Protobuf::Timestamp, ::Hash]
            #     Desired expiration time of the access token. This value must
            #     be at most 24 hours in the future. If a value is not specified, the
            #     token's expiration time will be set to a default value of 1 hour in the
            #     future.
            #
            #     Note: The following parameters are mutually exclusive: `expire_time`, `ttl`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param ttl [::Google::Protobuf::Duration, ::Hash]
            #     Desired lifetime duration of the access token. This value must
            #     be at most 24 hours. If a value is not specified, the token's lifetime
            #     will be set to a default value of 1 hour.
            #
            #     Note: The following parameters are mutually exclusive: `ttl`, `expire_time`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param workstation [::String]
            #     Required. Name of the workstation for which the access token should be
            #     generated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Workstations::V1::GenerateAccessTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Workstations::V1::GenerateAccessTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/workstations/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Workstations::V1::Workstations::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Workstations::V1::GenerateAccessTokenRequest.new
            #
            #   # Call the generate_access_token method.
            #   result = client.generate_access_token request
            #
            #   # The returned object is of type Google::Cloud::Workstations::V1::GenerateAccessTokenResponse.
            #   p result
            #
            def generate_access_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Workstations::V1::GenerateAccessTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_access_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Workstations::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.workstation
                header_params["workstation"] = request.workstation
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_access_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_access_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @workstations_stub.call_rpc :generate_access_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Workstations API.
            #
            # This class represents the configuration for Workstations,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Workstations::V1::Workstations::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_workstation_cluster to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Workstations::V1::Workstations::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_workstation_cluster.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Workstations::V1::Workstations::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_workstation_cluster.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Workstations::V1::Workstations::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "workstations.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Workstations API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_workstation_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workstation_cluster
                ##
                # RPC-specific configuration for `list_workstation_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workstation_clusters
                ##
                # RPC-specific configuration for `create_workstation_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workstation_cluster
                ##
                # RPC-specific configuration for `update_workstation_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_workstation_cluster
                ##
                # RPC-specific configuration for `delete_workstation_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workstation_cluster
                ##
                # RPC-specific configuration for `get_workstation_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workstation_config
                ##
                # RPC-specific configuration for `list_workstation_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workstation_configs
                ##
                # RPC-specific configuration for `list_usable_workstation_configs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_usable_workstation_configs
                ##
                # RPC-specific configuration for `create_workstation_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workstation_config
                ##
                # RPC-specific configuration for `update_workstation_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_workstation_config
                ##
                # RPC-specific configuration for `delete_workstation_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workstation_config
                ##
                # RPC-specific configuration for `get_workstation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_workstation
                ##
                # RPC-specific configuration for `list_workstations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_workstations
                ##
                # RPC-specific configuration for `list_usable_workstations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_usable_workstations
                ##
                # RPC-specific configuration for `create_workstation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_workstation
                ##
                # RPC-specific configuration for `update_workstation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_workstation
                ##
                # RPC-specific configuration for `delete_workstation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_workstation
                ##
                # RPC-specific configuration for `start_workstation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :start_workstation
                ##
                # RPC-specific configuration for `stop_workstation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :stop_workstation
                ##
                # RPC-specific configuration for `generate_access_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_access_token

                # @private
                def initialize parent_rpcs = nil
                  get_workstation_cluster_config = parent_rpcs.get_workstation_cluster if parent_rpcs.respond_to? :get_workstation_cluster
                  @get_workstation_cluster = ::Gapic::Config::Method.new get_workstation_cluster_config
                  list_workstation_clusters_config = parent_rpcs.list_workstation_clusters if parent_rpcs.respond_to? :list_workstation_clusters
                  @list_workstation_clusters = ::Gapic::Config::Method.new list_workstation_clusters_config
                  create_workstation_cluster_config = parent_rpcs.create_workstation_cluster if parent_rpcs.respond_to? :create_workstation_cluster
                  @create_workstation_cluster = ::Gapic::Config::Method.new create_workstation_cluster_config
                  update_workstation_cluster_config = parent_rpcs.update_workstation_cluster if parent_rpcs.respond_to? :update_workstation_cluster
                  @update_workstation_cluster = ::Gapic::Config::Method.new update_workstation_cluster_config
                  delete_workstation_cluster_config = parent_rpcs.delete_workstation_cluster if parent_rpcs.respond_to? :delete_workstation_cluster
                  @delete_workstation_cluster = ::Gapic::Config::Method.new delete_workstation_cluster_config
                  get_workstation_config_config = parent_rpcs.get_workstation_config if parent_rpcs.respond_to? :get_workstation_config
                  @get_workstation_config = ::Gapic::Config::Method.new get_workstation_config_config
                  list_workstation_configs_config = parent_rpcs.list_workstation_configs if parent_rpcs.respond_to? :list_workstation_configs
                  @list_workstation_configs = ::Gapic::Config::Method.new list_workstation_configs_config
                  list_usable_workstation_configs_config = parent_rpcs.list_usable_workstation_configs if parent_rpcs.respond_to? :list_usable_workstation_configs
                  @list_usable_workstation_configs = ::Gapic::Config::Method.new list_usable_workstation_configs_config
                  create_workstation_config_config = parent_rpcs.create_workstation_config if parent_rpcs.respond_to? :create_workstation_config
                  @create_workstation_config = ::Gapic::Config::Method.new create_workstation_config_config
                  update_workstation_config_config = parent_rpcs.update_workstation_config if parent_rpcs.respond_to? :update_workstation_config
                  @update_workstation_config = ::Gapic::Config::Method.new update_workstation_config_config
                  delete_workstation_config_config = parent_rpcs.delete_workstation_config if parent_rpcs.respond_to? :delete_workstation_config
                  @delete_workstation_config = ::Gapic::Config::Method.new delete_workstation_config_config
                  get_workstation_config = parent_rpcs.get_workstation if parent_rpcs.respond_to? :get_workstation
                  @get_workstation = ::Gapic::Config::Method.new get_workstation_config
                  list_workstations_config = parent_rpcs.list_workstations if parent_rpcs.respond_to? :list_workstations
                  @list_workstations = ::Gapic::Config::Method.new list_workstations_config
                  list_usable_workstations_config = parent_rpcs.list_usable_workstations if parent_rpcs.respond_to? :list_usable_workstations
                  @list_usable_workstations = ::Gapic::Config::Method.new list_usable_workstations_config
                  create_workstation_config = parent_rpcs.create_workstation if parent_rpcs.respond_to? :create_workstation
                  @create_workstation = ::Gapic::Config::Method.new create_workstation_config
                  update_workstation_config = parent_rpcs.update_workstation if parent_rpcs.respond_to? :update_workstation
                  @update_workstation = ::Gapic::Config::Method.new update_workstation_config
                  delete_workstation_config = parent_rpcs.delete_workstation if parent_rpcs.respond_to? :delete_workstation
                  @delete_workstation = ::Gapic::Config::Method.new delete_workstation_config
                  start_workstation_config = parent_rpcs.start_workstation if parent_rpcs.respond_to? :start_workstation
                  @start_workstation = ::Gapic::Config::Method.new start_workstation_config
                  stop_workstation_config = parent_rpcs.stop_workstation if parent_rpcs.respond_to? :stop_workstation
                  @stop_workstation = ::Gapic::Config::Method.new stop_workstation_config
                  generate_access_token_config = parent_rpcs.generate_access_token if parent_rpcs.respond_to? :generate_access_token
                  @generate_access_token = ::Gapic::Config::Method.new generate_access_token_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
