# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/workflows/v1beta/version"

require "google/cloud/workflows/v1beta/workflows/credentials"
require "google/cloud/workflows/v1beta/workflows/paths"
require "google/cloud/workflows/v1beta/workflows/operations"
require "google/cloud/workflows/v1beta/workflows/client"
require "google/cloud/workflows/v1beta/workflows/rest"

module Google
  module Cloud
    module Workflows
      module V1beta
        ##
        # Workflows is used to deploy and execute workflow programs.
        # Workflows makes sure the program executes reliably, despite hardware and
        # networking interruptions.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/workflows/v1beta/workflows"
        #     client = ::Google::Cloud::Workflows::V1beta::Workflows::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/workflows/v1beta/workflows/rest"
        #     client = ::Google::Cloud::Workflows::V1beta::Workflows::Rest::Client.new
        #
        module Workflows
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "workflows", "helpers.rb"
require "google/cloud/workflows/v1beta/workflows/helpers" if ::File.file? helper_path
