# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Workflows
      module V1
        # Workflow program to be executed by Workflows.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the workflow.
        #     Format: projects/\\{project}/locations/\\{location}/workflows/\\{workflow}.
        #     This is a workflow-wide field and is not tied to a specific revision.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the workflow provided by the user.
        #     Must be at most 1000 Unicode characters long.
        #     This is a workflow-wide field and is not tied to a specific revision.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Workflows::V1::Workflow::State]
        #     Output only. State of the workflow deployment.
        # @!attribute [r] revision_id
        #   @return [::String]
        #     Output only. The revision of the workflow.
        #     A new revision of a workflow is created as a result of updating the
        #     following properties of a workflow:
        #
        #     - {::Google::Cloud::Workflows::V1::Workflow#service_account Service account}
        #     - [Workflow code to be
        #     executed][google.cloud.workflows.v1.Workflow.source_contents]
        #
        #     The format is "000001-a4d", where the first six characters define
        #     the zero-padded revision ordinal number. They are followed by a hyphen and
        #     three hexadecimal random characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp for when the workflow was created.
        #     This is a workflow-wide field and is not tied to a specific revision.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp for when the workflow was last updated.
        #     This is a workflow-wide field and is not tied to a specific revision.
        # @!attribute [r] revision_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp for the latest revision of the workflow's
        #     creation.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this workflow.
        #     Labels can contain at most 64 entries. Keys and values can be no longer
        #     than 63 characters and can only contain lowercase letters, numeric
        #     characters, underscores, and dashes. Label keys must start with a letter.
        #     International characters are allowed.
        #     This is a workflow-wide field and is not tied to a specific revision.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account associated with the latest workflow version.
        #     This service account represents the identity of the workflow and determines
        #     what permissions the workflow has.
        #     Format: projects/\\{project}/serviceAccounts/\\{account} or \\{account}
        #
        #     Using `-` as a wildcard for the `{project}` or not providing one at all
        #     will infer the project from the account. The `{account}` value can be the
        #     `email` address or the `unique_id` of the service account.
        #
        #     If not provided, workflow will use the project's default service account.
        #     Modifying this field for an existing workflow results in a new workflow
        #     revision.
        # @!attribute [rw] source_contents
        #   @return [::String]
        #     Workflow code to be executed. The size limit is 128KB.
        # @!attribute [rw] crypto_key_name
        #   @return [::String]
        #     Optional. The resource name of a KMS crypto key used to encrypt or decrypt
        #     the data associated with the workflow.
        #
        #     Format:
        #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyRing}/cryptoKeys/\\{cryptoKey}
        #
        #     Using `-` as a wildcard for the `{project}` or not providing one at all
        #     will infer the project from the account.
        #
        #     If not provided, data associated with the workflow will not be
        #     CMEK-encrypted.
        # @!attribute [r] state_error
        #   @return [::Google::Cloud::Workflows::V1::Workflow::StateError]
        #     Output only. Error regarding the state of the workflow. For example, this
        #     field will have error details if the execution data is unavailable due to
        #     revoked KMS key permissions.
        # @!attribute [rw] call_log_level
        #   @return [::Google::Cloud::Workflows::V1::Workflow::CallLogLevel]
        #     Optional. Describes the level of platform logging to apply to calls and
        #     call responses during executions of this workflow. If both the workflow and
        #     the execution specify a logging level, the execution level takes
        #     precedence.
        # @!attribute [rw] user_env_vars
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined environment variables associated with this workflow
        #     revision. This map has a maximum length of 20. Each string can take up to
        #     4KiB. Keys cannot be empty strings and cannot start with "GOOGLE" or
        #     "WORKFLOWS".
        # @!attribute [rw] execution_history_level
        #   @return [::Google::Cloud::Workflows::V1::ExecutionHistoryLevel]
        #     Optional. Describes the execution history level to apply to this workflow.
        # @!attribute [r] all_kms_keys
        #   @return [::Array<::String>]
        #     Output only. A list of all KMS crypto keys used to encrypt or decrypt the
        #     data associated with the workflow.
        # @!attribute [r] all_kms_keys_versions
        #   @return [::Array<::String>]
        #     Output only. A list of all KMS crypto key versions used to encrypt or
        #     decrypt the data associated with the workflow.
        # @!attribute [r] crypto_key_version
        #   @return [::String]
        #     Output only. The resource name of a KMS crypto key version used to encrypt
        #     or decrypt the data associated with the workflow.
        #
        #     Format:
        #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyRing}/cryptoKeys/\\{cryptoKey}/cryptoKeyVersions/\\{cryptoKeyVersion}
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tags associated with this workflow.
        class Workflow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes an error related to the current state of the workflow.
          # @!attribute [rw] details
          #   @return [::String]
          #     Provides specifics about the error.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Workflows::V1::Workflow::StateError::Type]
          #     The type of this state error.
          class StateError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describes the possibled types of a state error.
            module Type
              # No type specified.
              TYPE_UNSPECIFIED = 0

              # Caused by an issue with KMS.
              KMS_ERROR = 1
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class UserEnvVarsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes the current state of workflow deployment.
          module State
            # Invalid state.
            STATE_UNSPECIFIED = 0

            # The workflow has been deployed successfully and is serving.
            ACTIVE = 1

            # Workflow data is unavailable. See the `state_error` field.
            UNAVAILABLE = 2
          end

          # Describes the level of platform logging to apply to calls and call
          # responses during workflow executions.
          module CallLogLevel
            # No call logging level specified.
            CALL_LOG_LEVEL_UNSPECIFIED = 0

            # Log all call steps within workflows, all call returns, and all exceptions
            # raised.
            LOG_ALL_CALLS = 1

            # Log only exceptions that are raised from call steps within workflows.
            LOG_ERRORS_ONLY = 2

            # Explicitly log nothing.
            LOG_NONE = 3
          end
        end

        # Request for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#list_workflows ListWorkflows}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project and location from which the workflows should be listed.
        #     Format: projects/\\{project}/locations/\\{location}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of workflows to return per call. The service might return
        #     fewer than this value even if not at the end of the collection. If a value
        #     is not specified, a default value of 500 is used. The maximum permitted
        #     value is 1000 and values greater than 1000 are coerced down to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListWorkflows` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListWorkflows` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter to restrict results to specific workflows.
        #     For details, see <a href="https://google.aip.dev/160"
        #     class="external">AIP-160</a>.
        #
        #     For example, if you are using the Google APIs Explorer:
        #
        #     `state="SUCCEEDED"`
        #
        #     or
        #
        #     `createTime>"2023-08-01" AND state="FAILED"`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields that specify the order of the results.
        #     Default sorting order for a field is ascending. To specify descending order
        #     for a field, append a "desc" suffix.
        #     If not specified, the results are returned in an unspecified order.
        class ListWorkflowsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#list_workflows ListWorkflows}
        # method.
        # @!attribute [rw] workflows
        #   @return [::Array<::Google::Cloud::Workflows::V1::Workflow>]
        #     The workflows that match the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListWorkflowsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#get_workflow GetWorkflow} method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workflow for which information should be retrieved.
        #     Format: projects/\\{project}/locations/\\{location}/workflows/\\{workflow}
        # @!attribute [rw] revision_id
        #   @return [::String]
        #     Optional. The revision of the workflow to retrieve. If the revision_id is
        #     empty, the latest revision is retrieved.
        #     The format is "000001-a4d", where the first six characters define
        #     the zero-padded decimal revision number. They are followed by a hyphen and
        #     three hexadecimal characters.
        class GetWorkflowRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#create_workflow CreateWorkflow}
        # method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Project and location in which the workflow should be created.
        #     Format:  projects/\\{project}/locations/\\{location}
        # @!attribute [rw] workflow
        #   @return [::Google::Cloud::Workflows::V1::Workflow]
        #     Required. Workflow to be created.
        # @!attribute [rw] workflow_id
        #   @return [::String]
        #     Required. The ID of the workflow to be created. It has to fulfill the
        #     following requirements:
        #
        #     * Must contain only letters, numbers, underscores and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-64 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the customer project and location.
        class CreateWorkflowRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#delete_workflow DeleteWorkflow}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the workflow to be deleted.
        #     Format: projects/\\{project}/locations/\\{location}/workflows/\\{workflow}
        class DeleteWorkflowRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#update_workflow UpdateWorkflow}
        # method.
        # @!attribute [rw] workflow
        #   @return [::Google::Cloud::Workflows::V1::Workflow]
        #     Required. Workflow to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     List of fields to be updated. If not present, the entire workflow
        #     will be updated.
        class UpdateWorkflowRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was created.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation finished running.
        # @!attribute [rw] target
        #   @return [::String]
        #     Server-defined resource path for the target of the operation.
        # @!attribute [rw] verb
        #   @return [::String]
        #     Name of the verb executed by the operation.
        # @!attribute [rw] api_version
        #   @return [::String]
        #     API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#list_workflow_revisions ListWorkflowRevisions}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Workflow for which the revisions should be listed.
        #     Format: projects/\\{project}/locations/\\{location}/workflows/\\{workflow}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of revisions to return per page. If a value is not
        #     specified, a default value of 20 is used. The maximum permitted value is
        #     100. Values greater than 100 are coerced down to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The page token, received from a previous ListWorkflowRevisions call.
        #     Provide this to retrieve the subsequent page.
        class ListWorkflowRevisionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for the
        # {::Google::Cloud::Workflows::V1::Workflows::Client#list_workflow_revisions ListWorkflowRevisions}
        # method.
        # @!attribute [rw] workflows
        #   @return [::Array<::Google::Cloud::Workflows::V1::Workflow>]
        #     The revisions of the workflow, ordered in reverse chronological order.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListWorkflowRevisionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Define possible options for enabling the execution history level.
        module ExecutionHistoryLevel
          # The default/unset value.
          EXECUTION_HISTORY_LEVEL_UNSPECIFIED = 0

          # Enable execution history basic feature.
          EXECUTION_HISTORY_BASIC = 1

          # Enable execution history detailed feature.
          EXECUTION_HISTORY_DETAILED = 2
        end
      end
    end
  end
end
