# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/workflows/executions/v1/version"

require "google/cloud/workflows/executions/v1/executions/credentials"
require "google/cloud/workflows/executions/v1/executions/paths"
require "google/cloud/workflows/executions/v1/executions/client"
require "google/cloud/workflows/executions/v1/executions/rest"

module Google
  module Cloud
    module Workflows
      module Executions
        module V1
          ##
          # Executions is used to start and manage running instances of
          # [Workflows][google.cloud.workflows.v1.Workflow] called executions.
          #
          # @example Load this service and instantiate a gRPC client
          #
          #     require "google/cloud/workflows/executions/v1/executions"
          #     client = ::Google::Cloud::Workflows::Executions::V1::Executions::Client.new
          #
          # @example Load this service and instantiate a REST client
          #
          #     require "google/cloud/workflows/executions/v1/executions/rest"
          #     client = ::Google::Cloud::Workflows::Executions::V1::Executions::Rest::Client.new
          #
          module Executions
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "executions", "helpers.rb"
require "google/cloud/workflows/executions/v1/executions/helpers" if ::File.file? helper_path
