# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module WebSecurityScanner
      module V1beta
        # ! Information about a vulnerability with an HTML.
        # @!attribute [rw] action_uri
        #   @return [::String]
        #     ! The URI where to send the form when it's submitted.
        # @!attribute [rw] fields
        #   @return [::Array<::String>]
        #     ! The names of form fields related to the vulnerability.
        class Form
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information reported for an outdated library.
        # @!attribute [rw] library_name
        #   @return [::String]
        #     The name of the outdated library.
        # @!attribute [rw] version
        #   @return [::String]
        #     The version number.
        # @!attribute [rw] learn_more_urls
        #   @return [::Array<::String>]
        #     URLs to learn more information about the vulnerabilities in the library.
        class OutdatedLibrary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information regarding any resource causing the vulnerability such
        # as JavaScript sources, image, audio files, etc.
        # @!attribute [rw] content_type
        #   @return [::String]
        #     The MIME type of this resource.
        # @!attribute [rw] resource_url
        #   @return [::String]
        #     URL of this violating resource.
        class ViolatingResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about vulnerable request parameters.
        # @!attribute [rw] parameter_names
        #   @return [::Array<::String>]
        #     The vulnerable parameter names.
        class VulnerableParameters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about vulnerable or missing HTTP Headers.
        # @!attribute [rw] headers
        #   @return [::Array<::Google::Cloud::WebSecurityScanner::V1beta::VulnerableHeaders::Header>]
        #     List of vulnerable headers.
        # @!attribute [rw] missing_headers
        #   @return [::Array<::Google::Cloud::WebSecurityScanner::V1beta::VulnerableHeaders::Header>]
        #     List of missing headers.
        class VulnerableHeaders
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes a HTTP Header.
          # @!attribute [rw] name
          #   @return [::String]
          #     Header name.
          # @!attribute [rw] value
          #   @return [::String]
          #     Header value.
          class Header
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Information reported for an XSS.
        # @!attribute [rw] stack_traces
        #   @return [::Array<::String>]
        #     Stack traces leading to the point where the XSS occurred.
        # @!attribute [rw] error_message
        #   @return [::String]
        #     An error message generated by a javascript breakage.
        class Xss
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
