# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module WebSecurityScanner
      module V1beta
        module WebSecurityScanner
          # Path helper methods for the WebSecurityScanner API.
          module Paths
            ##
            # Create a fully-qualified Finding resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/scanConfigs/{scan_config}/scanRuns/{scan_run}/findings/{finding}`
            #
            # @param project [String]
            # @param scan_config [String]
            # @param scan_run [String]
            # @param finding [String]
            #
            # @return [::String]
            def finding_path project:, scan_config:, scan_run:, finding:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "scan_config cannot contain /" if scan_config.to_s.include? "/"
              raise ::ArgumentError, "scan_run cannot contain /" if scan_run.to_s.include? "/"

              "projects/#{project}/scanConfigs/#{scan_config}/scanRuns/#{scan_run}/findings/#{finding}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            ##
            # Create a fully-qualified ScanConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/scanConfigs/{scan_config}`
            #
            # @param project [String]
            # @param scan_config [String]
            #
            # @return [::String]
            def scan_config_path project:, scan_config:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/scanConfigs/#{scan_config}"
            end

            ##
            # Create a fully-qualified ScanRun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/scanConfigs/{scan_config}/scanRuns/{scan_run}`
            #
            # @param project [String]
            # @param scan_config [String]
            # @param scan_run [String]
            #
            # @return [::String]
            def scan_run_path project:, scan_config:, scan_run:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "scan_config cannot contain /" if scan_config.to_s.include? "/"

              "projects/#{project}/scanConfigs/#{scan_config}/scanRuns/#{scan_run}"
            end

            extend self
          end
        end
      end
    end
  end
end
