# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/websecurityscanner/v1/web_security_scanner_pb"
require "google/cloud/web_security_scanner/v1/web_security_scanner/rest/service_stub"

module Google
  module Cloud
    module WebSecurityScanner
      module V1
        module WebSecurityScanner
          module Rest
            ##
            # REST client for the WebSecurityScanner service.
            #
            # Web Security Scanner Service identifies security vulnerabilities in web
            # applications hosted on Google Cloud. It crawls your application, and
            # attempts to exercise as many user inputs and event handlers as possible.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "websecurityscanner.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :web_security_scanner_stub

              ##
              # Configure the WebSecurityScanner Client class.
              #
              # See {::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all WebSecurityScanner clients
              #   ::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "WebSecurityScanner", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_scan_config.timeout = 600.0

                  default_config.rpcs.delete_scan_config.timeout = 600.0
                  default_config.rpcs.delete_scan_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_scan_config.timeout = 600.0
                  default_config.rpcs.get_scan_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_scan_configs.timeout = 600.0
                  default_config.rpcs.list_scan_configs.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.update_scan_config.timeout = 600.0

                  default_config.rpcs.start_scan_run.timeout = 600.0

                  default_config.rpcs.get_scan_run.timeout = 600.0
                  default_config.rpcs.get_scan_run.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_scan_runs.timeout = 600.0
                  default_config.rpcs.list_scan_runs.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.stop_scan_run.timeout = 600.0

                  default_config.rpcs.list_crawled_urls.timeout = 600.0
                  default_config.rpcs.list_crawled_urls.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.get_finding.timeout = 600.0
                  default_config.rpcs.get_finding.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_findings.timeout = 600.0
                  default_config.rpcs.list_findings.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.list_finding_type_stats.timeout = 600.0
                  default_config.rpcs.list_finding_type_stats.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the WebSecurityScanner Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @web_security_scanner_stub.universe_domain
              end

              ##
              # Create a new WebSecurityScanner REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the WebSecurityScanner client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @web_security_scanner_stub = ::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @web_security_scanner_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @web_security_scanner_stub.logger
              end

              # Service calls

              ##
              # Creates a new ScanConfig.
              #
              # @overload create_scan_config(request, options = nil)
              #   Pass arguments to `create_scan_config` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::CreateScanConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::CreateScanConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_scan_config(parent: nil, scan_config: nil)
              #   Pass arguments to `create_scan_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name where the scan is created, which should be a
              #     project resource name in the format 'projects/\\{projectId}'.
              #   @param scan_config [::Google::Cloud::WebSecurityScanner::V1::ScanConfig, ::Hash]
              #     Required. The ScanConfig to be created.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ScanConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ScanConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::CreateScanConfigRequest.new
              #
              #   # Call the create_scan_config method.
              #   result = client.create_scan_config request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ScanConfig.
              #   p result
              #
              def create_scan_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::CreateScanConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_scan_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_scan_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_scan_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.create_scan_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an existing ScanConfig and its child resources.
              #
              # @overload delete_scan_config(request, options = nil)
              #   Pass arguments to `delete_scan_config` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::DeleteScanConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::DeleteScanConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_scan_config(name: nil)
              #   Pass arguments to `delete_scan_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ScanConfig to be deleted. The name follows the
              #     format of 'projects/\\{projectId}/scanConfigs/\\{scanConfigId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::DeleteScanConfigRequest.new
              #
              #   # Call the delete_scan_config method.
              #   result = client.delete_scan_config request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_scan_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::DeleteScanConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_scan_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_scan_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_scan_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.delete_scan_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a ScanConfig.
              #
              # @overload get_scan_config(request, options = nil)
              #   Pass arguments to `get_scan_config` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::GetScanConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::GetScanConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_scan_config(name: nil)
              #   Pass arguments to `get_scan_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ScanConfig to be returned. The name follows the
              #     format of 'projects/\\{projectId}/scanConfigs/\\{scanConfigId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ScanConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ScanConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::GetScanConfigRequest.new
              #
              #   # Call the get_scan_config method.
              #   result = client.get_scan_config request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ScanConfig.
              #   p result
              #
              def get_scan_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::GetScanConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_scan_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_scan_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_scan_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.get_scan_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ScanConfigs under a given project.
              #
              # @overload list_scan_configs(request, options = nil)
              #   Pass arguments to `list_scan_configs` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::ListScanConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::ListScanConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_scan_configs(parent: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_scan_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, which should be a project resource name in the
              #     format 'projects/\\{projectId}'.
              #   @param page_token [::String]
              #     A token identifying a page of results to be returned. This should be a
              #     `next_page_token` value returned from a previous List request.
              #     If unspecified, the first page of results is returned.
              #   @param page_size [::Integer]
              #     The maximum number of ScanConfigs to return, can be limited by server.
              #     If not specified or not positive, the implementation will select a
              #     reasonable value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::ScanConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::ScanConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::ListScanConfigsRequest.new
              #
              #   # Call the list_scan_configs method.
              #   result = client.list_scan_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::WebSecurityScanner::V1::ScanConfig.
              #     p item
              #   end
              #
              def list_scan_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::ListScanConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_scan_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_scan_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_scan_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.list_scan_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @web_security_scanner_stub, :list_scan_configs, "scan_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a ScanConfig. This method support partial update of a ScanConfig.
              #
              # @overload update_scan_config(request, options = nil)
              #   Pass arguments to `update_scan_config` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::UpdateScanConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::UpdateScanConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_scan_config(scan_config: nil, update_mask: nil)
              #   Pass arguments to `update_scan_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param scan_config [::Google::Cloud::WebSecurityScanner::V1::ScanConfig, ::Hash]
              #     Required. The ScanConfig to be updated. The name field must be set to identify the
              #     resource to be updated. The values of fields not covered by the mask
              #     will be ignored.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The update mask applies to the resource. For the `FieldMask` definition,
              #     see
              #     https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ScanConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ScanConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::UpdateScanConfigRequest.new
              #
              #   # Call the update_scan_config method.
              #   result = client.update_scan_config request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ScanConfig.
              #   p result
              #
              def update_scan_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::UpdateScanConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_scan_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_scan_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_scan_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.update_scan_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Start a ScanRun according to the given ScanConfig.
              #
              # @overload start_scan_run(request, options = nil)
              #   Pass arguments to `start_scan_run` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::StartScanRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::StartScanRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_scan_run(name: nil)
              #   Pass arguments to `start_scan_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ScanConfig to be used. The name follows the
              #     format of 'projects/\\{projectId}/scanConfigs/\\{scanConfigId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ScanRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ScanRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::StartScanRunRequest.new
              #
              #   # Call the start_scan_run method.
              #   result = client.start_scan_run request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ScanRun.
              #   p result
              #
              def start_scan_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::StartScanRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_scan_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_scan_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_scan_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.start_scan_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a ScanRun.
              #
              # @overload get_scan_run(request, options = nil)
              #   Pass arguments to `get_scan_run` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::GetScanRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::GetScanRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_scan_run(name: nil)
              #   Pass arguments to `get_scan_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ScanRun to be returned. The name follows the
              #     format of
              #     'projects/\\{projectId}/scanConfigs/\\{scanConfigId}/scanRuns/\\{scanRunId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ScanRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ScanRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::GetScanRunRequest.new
              #
              #   # Call the get_scan_run method.
              #   result = client.get_scan_run request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ScanRun.
              #   p result
              #
              def get_scan_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::GetScanRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_scan_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_scan_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_scan_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.get_scan_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists ScanRuns under a given ScanConfig, in descending order of ScanRun
              # stop time.
              #
              # @overload list_scan_runs(request, options = nil)
              #   Pass arguments to `list_scan_runs` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::ListScanRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::ListScanRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_scan_runs(parent: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_scan_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, which should be a scan resource name in the
              #     format 'projects/\\{projectId}/scanConfigs/\\{scanConfigId}'.
              #   @param page_token [::String]
              #     A token identifying a page of results to be returned. This should be a
              #     `next_page_token` value returned from a previous List request.
              #     If unspecified, the first page of results is returned.
              #   @param page_size [::Integer]
              #     The maximum number of ScanRuns to return, can be limited by server.
              #     If not specified or not positive, the implementation will select a
              #     reasonable value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::ScanRun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::ScanRun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::ListScanRunsRequest.new
              #
              #   # Call the list_scan_runs method.
              #   result = client.list_scan_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::WebSecurityScanner::V1::ScanRun.
              #     p item
              #   end
              #
              def list_scan_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::ListScanRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_scan_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_scan_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_scan_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.list_scan_runs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @web_security_scanner_stub, :list_scan_runs, "scan_runs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a ScanRun. The stopped ScanRun is returned.
              #
              # @overload stop_scan_run(request, options = nil)
              #   Pass arguments to `stop_scan_run` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::StopScanRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::StopScanRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_scan_run(name: nil)
              #   Pass arguments to `stop_scan_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the ScanRun to be stopped. The name follows the
              #     format of
              #     'projects/\\{projectId}/scanConfigs/\\{scanConfigId}/scanRuns/\\{scanRunId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ScanRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ScanRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::StopScanRunRequest.new
              #
              #   # Call the stop_scan_run method.
              #   result = client.stop_scan_run request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ScanRun.
              #   p result
              #
              def stop_scan_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::StopScanRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_scan_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_scan_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_scan_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.stop_scan_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List CrawledUrls under a given ScanRun.
              #
              # @overload list_crawled_urls(request, options = nil)
              #   Pass arguments to `list_crawled_urls` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::ListCrawledUrlsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::ListCrawledUrlsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_crawled_urls(parent: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_crawled_urls` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, which should be a scan run resource name in the
              #     format
              #     'projects/\\{projectId}/scanConfigs/\\{scanConfigId}/scanRuns/\\{scanRunId}'.
              #   @param page_token [::String]
              #     A token identifying a page of results to be returned. This should be a
              #     `next_page_token` value returned from a previous List request.
              #     If unspecified, the first page of results is returned.
              #   @param page_size [::Integer]
              #     The maximum number of CrawledUrls to return, can be limited by server.
              #     If not specified or not positive, the implementation will select a
              #     reasonable value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::CrawledUrl>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::CrawledUrl>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::ListCrawledUrlsRequest.new
              #
              #   # Call the list_crawled_urls method.
              #   result = client.list_crawled_urls request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::WebSecurityScanner::V1::CrawledUrl.
              #     p item
              #   end
              #
              def list_crawled_urls request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::ListCrawledUrlsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_crawled_urls.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_crawled_urls.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_crawled_urls.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.list_crawled_urls request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @web_security_scanner_stub, :list_crawled_urls, "crawled_urls", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a Finding.
              #
              # @overload get_finding(request, options = nil)
              #   Pass arguments to `get_finding` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::GetFindingRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::GetFindingRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_finding(name: nil)
              #   Pass arguments to `get_finding` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the Finding to be returned. The name follows the
              #     format of
              #     'projects/\\{projectId}/scanConfigs/\\{scanConfigId}/scanRuns/\\{scanRunId}/findings/\\{findingId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::Finding]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::Finding]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::GetFindingRequest.new
              #
              #   # Call the get_finding method.
              #   result = client.get_finding request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::Finding.
              #   p result
              #
              def get_finding request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::GetFindingRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_finding.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_finding.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_finding.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.get_finding request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List Findings under a given ScanRun.
              #
              # @overload list_findings(request, options = nil)
              #   Pass arguments to `list_findings` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::ListFindingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::ListFindingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_findings(parent: nil, filter: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_findings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, which should be a scan run resource name in the
              #     format
              #     'projects/\\{projectId}/scanConfigs/\\{scanConfigId}/scanRuns/\\{scanRunId}'.
              #   @param filter [::String]
              #     The filter expression. The expression must be in the format: <field>
              #     <operator> <value>.
              #     Supported field: 'finding_type'.
              #     Supported operator: '='.
              #   @param page_token [::String]
              #     A token identifying a page of results to be returned. This should be a
              #     `next_page_token` value returned from a previous List request.
              #     If unspecified, the first page of results is returned.
              #   @param page_size [::Integer]
              #     The maximum number of Findings to return, can be limited by server.
              #     If not specified or not positive, the implementation will select a
              #     reasonable value.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::Finding>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::WebSecurityScanner::V1::Finding>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::ListFindingsRequest.new
              #
              #   # Call the list_findings method.
              #   result = client.list_findings request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::WebSecurityScanner::V1::Finding.
              #     p item
              #   end
              #
              def list_findings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::ListFindingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_findings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_findings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_findings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.list_findings request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @web_security_scanner_stub, :list_findings, "findings", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List all FindingTypeStats under a given ScanRun.
              #
              # @overload list_finding_type_stats(request, options = nil)
              #   Pass arguments to `list_finding_type_stats` via a request object, either of type
              #   {::Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_finding_type_stats(parent: nil)
              #   Pass arguments to `list_finding_type_stats` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource name, which should be a scan run resource name in the
              #     format
              #     'projects/\\{projectId}/scanConfigs/\\{scanConfigId}/scanRuns/\\{scanRunId}'.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_security_scanner/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsRequest.new
              #
              #   # Call the list_finding_type_stats method.
              #   result = client.list_finding_type_stats request
              #
              #   # The returned object is of type Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsResponse.
              #   p result
              #
              def list_finding_type_stats request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebSecurityScanner::V1::ListFindingTypeStatsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_finding_type_stats.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebSecurityScanner::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_finding_type_stats.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_finding_type_stats.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_security_scanner_stub.list_finding_type_stats request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the WebSecurityScanner REST API.
              #
              # This class represents the configuration for WebSecurityScanner REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_scan_config to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_scan_config.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::WebSecurityScanner::V1::WebSecurityScanner::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_scan_config.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "websecurityscanner.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the WebSecurityScanner API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_scan_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_scan_config
                  ##
                  # RPC-specific configuration for `delete_scan_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_scan_config
                  ##
                  # RPC-specific configuration for `get_scan_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_scan_config
                  ##
                  # RPC-specific configuration for `list_scan_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_scan_configs
                  ##
                  # RPC-specific configuration for `update_scan_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_scan_config
                  ##
                  # RPC-specific configuration for `start_scan_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_scan_run
                  ##
                  # RPC-specific configuration for `get_scan_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_scan_run
                  ##
                  # RPC-specific configuration for `list_scan_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_scan_runs
                  ##
                  # RPC-specific configuration for `stop_scan_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_scan_run
                  ##
                  # RPC-specific configuration for `list_crawled_urls`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_crawled_urls
                  ##
                  # RPC-specific configuration for `get_finding`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_finding
                  ##
                  # RPC-specific configuration for `list_findings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_findings
                  ##
                  # RPC-specific configuration for `list_finding_type_stats`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_finding_type_stats

                  # @private
                  def initialize parent_rpcs = nil
                    create_scan_config_config = parent_rpcs.create_scan_config if parent_rpcs.respond_to? :create_scan_config
                    @create_scan_config = ::Gapic::Config::Method.new create_scan_config_config
                    delete_scan_config_config = parent_rpcs.delete_scan_config if parent_rpcs.respond_to? :delete_scan_config
                    @delete_scan_config = ::Gapic::Config::Method.new delete_scan_config_config
                    get_scan_config_config = parent_rpcs.get_scan_config if parent_rpcs.respond_to? :get_scan_config
                    @get_scan_config = ::Gapic::Config::Method.new get_scan_config_config
                    list_scan_configs_config = parent_rpcs.list_scan_configs if parent_rpcs.respond_to? :list_scan_configs
                    @list_scan_configs = ::Gapic::Config::Method.new list_scan_configs_config
                    update_scan_config_config = parent_rpcs.update_scan_config if parent_rpcs.respond_to? :update_scan_config
                    @update_scan_config = ::Gapic::Config::Method.new update_scan_config_config
                    start_scan_run_config = parent_rpcs.start_scan_run if parent_rpcs.respond_to? :start_scan_run
                    @start_scan_run = ::Gapic::Config::Method.new start_scan_run_config
                    get_scan_run_config = parent_rpcs.get_scan_run if parent_rpcs.respond_to? :get_scan_run
                    @get_scan_run = ::Gapic::Config::Method.new get_scan_run_config
                    list_scan_runs_config = parent_rpcs.list_scan_runs if parent_rpcs.respond_to? :list_scan_runs
                    @list_scan_runs = ::Gapic::Config::Method.new list_scan_runs_config
                    stop_scan_run_config = parent_rpcs.stop_scan_run if parent_rpcs.respond_to? :stop_scan_run
                    @stop_scan_run = ::Gapic::Config::Method.new stop_scan_run_config
                    list_crawled_urls_config = parent_rpcs.list_crawled_urls if parent_rpcs.respond_to? :list_crawled_urls
                    @list_crawled_urls = ::Gapic::Config::Method.new list_crawled_urls_config
                    get_finding_config = parent_rpcs.get_finding if parent_rpcs.respond_to? :get_finding
                    @get_finding = ::Gapic::Config::Method.new get_finding_config
                    list_findings_config = parent_rpcs.list_findings if parent_rpcs.respond_to? :list_findings
                    @list_findings = ::Gapic::Config::Method.new list_findings_config
                    list_finding_type_stats_config = parent_rpcs.list_finding_type_stats if parent_rpcs.respond_to? :list_finding_type_stats
                    @list_finding_type_stats = ::Gapic::Config::Method.new list_finding_type_stats_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
