# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/webrisk/v1/webrisk_pb"
require "google/cloud/web_risk/v1/web_risk_service"

class ::Google::Cloud::WebRisk::V1::WebRiskService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_compute_threat_list_diff
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    threat_type = :THREAT_TYPE_UNSPECIFIED
    version_token = "hello world"
    constraints = {}

    compute_threat_list_diff_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :compute_threat_list_diff, name
      assert_kind_of ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest, request
      assert_equal :THREAT_TYPE_UNSPECIFIED, request["threat_type"]
      assert_equal "hello world", request["version_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest::Constraints), request["constraints"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, compute_threat_list_diff_client_stub do
      # Create client
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.compute_threat_list_diff({ threat_type: threat_type, version_token: version_token, constraints: constraints }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.compute_threat_list_diff threat_type: threat_type, version_token: version_token, constraints: constraints do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.compute_threat_list_diff ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest.new(threat_type: threat_type, version_token: version_token, constraints: constraints) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.compute_threat_list_diff({ threat_type: threat_type, version_token: version_token, constraints: constraints }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.compute_threat_list_diff(::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest.new(threat_type: threat_type, version_token: version_token, constraints: constraints), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, compute_threat_list_diff_client_stub.call_rpc_count
    end
  end

  def test_search_uris
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::WebRisk::V1::SearchUrisResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    uri = "hello world"
    threat_types = [:THREAT_TYPE_UNSPECIFIED]

    search_uris_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_uris, name
      assert_kind_of ::Google::Cloud::WebRisk::V1::SearchUrisRequest, request
      assert_equal "hello world", request["uri"]
      assert_equal [:THREAT_TYPE_UNSPECIFIED], request["threat_types"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_uris_client_stub do
      # Create client
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_uris({ uri: uri, threat_types: threat_types }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_uris uri: uri, threat_types: threat_types do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_uris ::Google::Cloud::WebRisk::V1::SearchUrisRequest.new(uri: uri, threat_types: threat_types) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_uris({ uri: uri, threat_types: threat_types }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_uris(::Google::Cloud::WebRisk::V1::SearchUrisRequest.new(uri: uri, threat_types: threat_types), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_uris_client_stub.call_rpc_count
    end
  end

  def test_search_hashes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::WebRisk::V1::SearchHashesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    hash_prefix = "hello world"
    threat_types = [:THREAT_TYPE_UNSPECIFIED]

    search_hashes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_hashes, name
      assert_kind_of ::Google::Cloud::WebRisk::V1::SearchHashesRequest, request
      assert_equal "hello world", request["hash_prefix"]
      assert_equal [:THREAT_TYPE_UNSPECIFIED], request["threat_types"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_hashes_client_stub do
      # Create client
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_hashes({ hash_prefix: hash_prefix, threat_types: threat_types }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_hashes hash_prefix: hash_prefix, threat_types: threat_types do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_hashes ::Google::Cloud::WebRisk::V1::SearchHashesRequest.new(hash_prefix: hash_prefix, threat_types: threat_types) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_hashes({ hash_prefix: hash_prefix, threat_types: threat_types }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_hashes(::Google::Cloud::WebRisk::V1::SearchHashesRequest.new(hash_prefix: hash_prefix, threat_types: threat_types), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_hashes_client_stub.call_rpc_count
    end
  end

  def test_create_submission
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::WebRisk::V1::Submission.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    submission = {}

    create_submission_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_submission, name
      assert_kind_of ::Google::Cloud::WebRisk::V1::CreateSubmissionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::WebRisk::V1::Submission), request["submission"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_submission_client_stub do
      # Create client
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_submission({ parent: parent, submission: submission }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_submission parent: parent, submission: submission do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_submission ::Google::Cloud::WebRisk::V1::CreateSubmissionRequest.new(parent: parent, submission: submission) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_submission({ parent: parent, submission: submission }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_submission(::Google::Cloud::WebRisk::V1::CreateSubmissionRequest.new(parent: parent, submission: submission), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_submission_client_stub.call_rpc_count
    end
  end

  def test_submit_uri
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    submission = {}
    threat_info = {}
    threat_discovery = {}

    submit_uri_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :submit_uri, name
      assert_kind_of ::Google::Cloud::WebRisk::V1::SubmitUriRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::WebRisk::V1::Submission), request["submission"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::WebRisk::V1::ThreatInfo), request["threat_info"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::WebRisk::V1::ThreatDiscovery), request["threat_discovery"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, submit_uri_client_stub do
      # Create client
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.submit_uri({ parent: parent, submission: submission, threat_info: threat_info, threat_discovery: threat_discovery }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.submit_uri parent: parent, submission: submission, threat_info: threat_info, threat_discovery: threat_discovery do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.submit_uri ::Google::Cloud::WebRisk::V1::SubmitUriRequest.new(parent: parent, submission: submission, threat_info: threat_info, threat_discovery: threat_discovery) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.submit_uri({ parent: parent, submission: submission, threat_info: threat_info, threat_discovery: threat_discovery }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.submit_uri(::Google::Cloud::WebRisk::V1::SubmitUriRequest.new(parent: parent, submission: submission, threat_info: threat_info, threat_discovery: threat_discovery), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, submit_uri_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::WebRisk::V1::WebRiskService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::WebRisk::V1::WebRiskService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::WebRisk::V1::WebRiskService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::WebRisk::V1::WebRiskService::Operations, client.operations_client
  end
end
