# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module WebRisk
      module V1
        # Describes an API diff request.
        # @!attribute [rw] threat_type
        #   @return [::Google::Cloud::WebRisk::V1::ThreatType]
        #     Required. The threat list to update. Only a single ThreatType should be
        #     specified per request. If you want to handle multiple ThreatTypes, you must
        #     make one request per ThreatType.
        # @!attribute [rw] version_token
        #   @return [::String]
        #     The current version token of the client for the requested list (the
        #     client version that was received from the last successful diff).
        #     If the client does not have a version token (this is the first time calling
        #     ComputeThreatListDiff), this may be left empty and a full database
        #     snapshot will be returned.
        # @!attribute [rw] constraints
        #   @return [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest::Constraints]
        #     Required. The constraints associated with this request.
        class ComputeThreatListDiffRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The constraints for this diff.
          # @!attribute [rw] max_diff_entries
          #   @return [::Integer]
          #     The maximum size in number of entries. The diff will not contain more
          #     entries than this value.  This should be a power of 2 between 2**10 and
          #     2**20.  If zero, no diff size limit is set.
          # @!attribute [rw] max_database_entries
          #   @return [::Integer]
          #     Sets the maximum number of entries that the client is willing to have
          #     in the local database. This should be a power of 2 between 2**10 and
          #     2**20. If zero, no database size limit is set.
          # @!attribute [rw] supported_compressions
          #   @return [::Array<::Google::Cloud::WebRisk::V1::CompressionType>]
          #     The compression types supported by the client.
          class Constraints
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] response_type
        #   @return [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse::ResponseType]
        #     The type of response. This may indicate that an action must be taken by the
        #     client when the response is received.
        # @!attribute [rw] additions
        #   @return [::Google::Cloud::WebRisk::V1::ThreatEntryAdditions]
        #     A set of entries to add to a local threat type's list.
        # @!attribute [rw] removals
        #   @return [::Google::Cloud::WebRisk::V1::ThreatEntryRemovals]
        #     A set of entries to remove from a local threat type's list.
        #     This field may be empty.
        # @!attribute [rw] new_version_token
        #   @return [::String]
        #     The new opaque client version token. This should be retained by the client
        #     and passed into the next call of ComputeThreatListDiff as 'version_token'.
        #     A separate version token should be stored and used for each threatList.
        # @!attribute [rw] checksum
        #   @return [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse::Checksum]
        #     The expected SHA256 hash of the client state; that is, of the sorted list
        #     of all hashes present in the database after applying the provided diff.
        #     If the client state doesn't match the expected state, the client must
        #     discard this diff and retry later.
        # @!attribute [rw] recommended_next_diff
        #   @return [::Google::Protobuf::Timestamp]
        #     The soonest the client should wait before issuing any diff
        #     request. Querying sooner is unlikely to produce a meaningful diff.
        #     Waiting longer is acceptable considering the use case.
        #     If this field is not set clients may update as soon as they want.
        class ComputeThreatListDiffResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The expected state of a client's local database.
          # @!attribute [rw] sha256
          #   @return [::String]
          #     The SHA256 hash of the client state; that is, of the sorted list of all
          #     hashes present in the database.
          class Checksum
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The type of response sent to the client.
          module ResponseType
            # Unknown.
            RESPONSE_TYPE_UNSPECIFIED = 0

            # Partial updates are applied to the client's existing local database.
            DIFF = 1

            # Full updates resets the client's entire local database. This means
            # that either the client had no state, was seriously out-of-date,
            # or the client is believed to be corrupt.
            RESET = 2
          end
        end

        # Request to check URI entries against threatLists.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The URI to be checked for matches.
        # @!attribute [rw] threat_types
        #   @return [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
        #     Required. The ThreatLists to search in. Multiple ThreatLists may be
        #     specified.
        class SearchUrisRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] threat
        #   @return [::Google::Cloud::WebRisk::V1::SearchUrisResponse::ThreatUri]
        #     The threat list matches. This might be empty if the URI is on no list.
        class SearchUrisResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains threat information on a matching uri.
          # @!attribute [rw] threat_types
          #   @return [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
          #     The ThreatList this threat belongs to.
          # @!attribute [rw] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The cache lifetime for the returned match. Clients must not cache this
          #     response past this timestamp to avoid false positives.
          class ThreatUri
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request to return full hashes matched by the provided hash prefixes.
        # @!attribute [rw] hash_prefix
        #   @return [::String]
        #     A hash prefix, consisting of the most significant 4-32 bytes of a SHA256
        #     hash. For JSON requests, this field is base64-encoded.
        #     Note that if this parameter is provided by a URI, it must be encoded using
        #     the web safe base64 variant (RFC 4648).
        # @!attribute [rw] threat_types
        #   @return [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
        #     Required. The ThreatLists to search in. Multiple ThreatLists may be
        #     specified.
        class SearchHashesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] threats
        #   @return [::Array<::Google::Cloud::WebRisk::V1::SearchHashesResponse::ThreatHash>]
        #     The full hashes that matched the requested prefixes.
        #     The hash will be populated in the key.
        # @!attribute [rw] negative_expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     For requested entities that did not match the threat list, how long to
        #     cache the response until.
        class SearchHashesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains threat information on a matching hash.
          # @!attribute [rw] threat_types
          #   @return [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
          #     The ThreatList this threat belongs to.
          #     This must contain at least one entry.
          # @!attribute [rw] hash
          #   @return [::String]
          #     A 32 byte SHA256 hash. This field is in binary format. For JSON
          #     requests, hashes are base64-encoded.
          # @!attribute [rw] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The cache lifetime for the returned match. Clients must not cache this
          #     response past this timestamp to avoid false positives.
          class ThreatHash
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains the set of entries to add to a local database.
        # May contain a combination of compressed and raw data in a single response.
        # @!attribute [rw] raw_hashes
        #   @return [::Array<::Google::Cloud::WebRisk::V1::RawHashes>]
        #     The raw SHA256-formatted entries.
        #     Repeated to allow returning sets of hashes with different prefix sizes.
        # @!attribute [rw] rice_hashes
        #   @return [::Google::Cloud::WebRisk::V1::RiceDeltaEncoding]
        #     The encoded 4-byte prefixes of SHA256-formatted entries, using a
        #     Golomb-Rice encoding. The hashes are converted to uint32, sorted in
        #     ascending order, then delta encoded and stored as encoded_data.
        class ThreatEntryAdditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the set of entries to remove from a local database.
        # @!attribute [rw] raw_indices
        #   @return [::Google::Cloud::WebRisk::V1::RawIndices]
        #     The raw removal indices for a local list.
        # @!attribute [rw] rice_indices
        #   @return [::Google::Cloud::WebRisk::V1::RiceDeltaEncoding]
        #     The encoded local, lexicographically-sorted list indices, using a
        #     Golomb-Rice encoding. Used for sending compressed removal indices. The
        #     removal indices (uint32) are sorted in ascending order, then delta encoded
        #     and stored as encoded_data.
        class ThreatEntryRemovals
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of raw indices to remove from a local list.
        # @!attribute [rw] indices
        #   @return [::Array<::Integer>]
        #     The indices to remove from a lexicographically-sorted local list.
        class RawIndices
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The uncompressed threat entries in hash format.
        # Hashes can be anywhere from 4 to 32 bytes in size. A large majority are 4
        # bytes, but some hashes are lengthened if they collide with the hash of a
        # popular URI.
        #
        # Used for sending ThreatEntryAdditons to clients that do not support
        # compression, or when sending non-4-byte hashes to clients that do support
        # compression.
        # @!attribute [rw] prefix_size
        #   @return [::Integer]
        #     The number of bytes for each prefix encoded below.  This field can be
        #     anywhere from 4 (shortest prefix) to 32 (full SHA256 hash).
        #     In practice this is almost always 4, except in exceptional circumstances.
        # @!attribute [rw] raw_hashes
        #   @return [::String]
        #     The hashes, in binary format, concatenated into one long string. Hashes are
        #     sorted in lexicographic order. For JSON API users, hashes are
        #     base64-encoded.
        class RawHashes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The Rice-Golomb encoded data. Used for sending compressed 4-byte hashes or
        # compressed removal indices.
        # @!attribute [rw] first_value
        #   @return [::Integer]
        #     The offset of the first entry in the encoded data, or, if only a single
        #     integer was encoded, that single integer's value. If the field is empty or
        #     missing, assume zero.
        # @!attribute [rw] rice_parameter
        #   @return [::Integer]
        #     The Golomb-Rice parameter, which is a number between 2 and 28. This field
        #     is missing (that is, zero) if `num_entries` is zero.
        # @!attribute [rw] entry_count
        #   @return [::Integer]
        #     The number of entries that are delta encoded in the encoded data. If only a
        #     single integer was encoded, this will be zero and the single value will be
        #     stored in `first_value`.
        # @!attribute [rw] encoded_data
        #   @return [::String]
        #     The encoded deltas that are encoded using the Golomb-Rice coder.
        class RiceDeltaEncoding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Wraps a URI that might be displaying malicious content.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The URI that is being reported for malicious content to be
        #     analyzed.
        # @!attribute [r] threat_types
        #   @return [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
        #     Output only. ThreatTypes found to be associated with the submitted URI
        #     after reviewing it. This might be empty if the URI was not added to any
        #     list.
        class Submission
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Context about the submission including the type of abuse found on the URI and
        # supporting details.
        # @!attribute [rw] abuse_type
        #   @return [::Google::Cloud::WebRisk::V1::ThreatInfo::AbuseType]
        #     The type of abuse.
        # @!attribute [rw] threat_confidence
        #   @return [::Google::Cloud::WebRisk::V1::ThreatInfo::Confidence]
        #     Confidence that the URI is unsafe.
        # @!attribute [rw] threat_justification
        #   @return [::Google::Cloud::WebRisk::V1::ThreatInfo::ThreatJustification]
        #     Context about why the URI is unsafe.
        class ThreatInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Confidence that a URI is unsafe.
          # @!attribute [rw] score
          #   @return [::Float]
          #     A decimal representation of confidence in the range of 0
          #     to 1 where 0 indicates no confidence and 1 indicates
          #     complete confidence.
          #
          #     Note: The following fields are mutually exclusive: `score`, `level`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] level
          #   @return [::Google::Cloud::WebRisk::V1::ThreatInfo::Confidence::ConfidenceLevel]
          #     Enum representation of confidence.
          #
          #     Note: The following fields are mutually exclusive: `level`, `score`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Confidence
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum representation of confidence.
            module ConfidenceLevel
              # Default.
              CONFIDENCE_LEVEL_UNSPECIFIED = 0

              # Less than 60% confidence that the URI is unsafe.
              LOW = 1

              # Between 60% and 80% confidence that the URI is unsafe.
              MEDIUM = 2

              # Greater than 80% confidence that the URI is unsafe.
              HIGH = 3
            end
          end

          # Context about why the URI is unsafe.
          # @!attribute [rw] labels
          #   @return [::Array<::Google::Cloud::WebRisk::V1::ThreatInfo::ThreatJustification::JustificationLabel>]
          #     Labels associated with this URI that explain how it was classified.
          # @!attribute [rw] comments
          #   @return [::Array<::String>]
          #     Free-form context on why this URI is unsafe.
          class ThreatJustification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Labels that explain how the URI was classified.
            module JustificationLabel
              # Default.
              JUSTIFICATION_LABEL_UNSPECIFIED = 0

              # The submitter manually verified that the submission is unsafe.
              MANUAL_VERIFICATION = 1

              # The submitter received the submission from an end user.
              USER_REPORT = 2

              # The submitter received the submission from an automated system.
              AUTOMATED_REPORT = 3
            end
          end

          # The abuse type found on the URI.
          module AbuseType
            # Default.
            ABUSE_TYPE_UNSPECIFIED = 0

            # The URI contains malware.
            MALWARE = 1

            # The URI contains social engineering.
            SOCIAL_ENGINEERING = 2

            # The URI contains unwanted software.
            UNWANTED_SOFTWARE = 3
          end
        end

        # Details about how the threat was discovered.
        # @!attribute [rw] platform
        #   @return [::Google::Cloud::WebRisk::V1::ThreatDiscovery::Platform]
        #     Platform on which the threat was discovered.
        # @!attribute [rw] region_codes
        #   @return [::Array<::String>]
        #     CLDR region code of the countries/regions the URI poses a threat ordered
        #     from most impact to least impact. Example: "US" for United States.
        class ThreatDiscovery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Platform types.
          module Platform
            # Default.
            PLATFORM_UNSPECIFIED = 0

            # General Android platform.
            ANDROID = 1

            # General iOS platform.
            IOS = 2

            # General macOS platform.
            MACOS = 3

            # General Windows platform.
            WINDOWS = 4
          end
        end

        # Request to send a potentially phishy URI to WebRisk.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project that is making the submission. This
        #     string is in the format "projects/\\{project_number}".
        # @!attribute [rw] submission
        #   @return [::Google::Cloud::WebRisk::V1::Submission]
        #     Required. The submission that contains the content of the phishing report.
        class CreateSubmissionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to send a potentially malicious URI to WebRisk.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the project that is making the submission. This
        #     string is in the format "projects/\\{project_number}".
        # @!attribute [rw] submission
        #   @return [::Google::Cloud::WebRisk::V1::Submission]
        #     Required. The submission that contains the URI to be scanned.
        # @!attribute [rw] threat_info
        #   @return [::Google::Cloud::WebRisk::V1::ThreatInfo]
        #     Provides additional information about the submission.
        # @!attribute [rw] threat_discovery
        #   @return [::Google::Cloud::WebRisk::V1::ThreatDiscovery]
        #     Provides additional information about how the submission was discovered.
        class SubmitUriRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for the Submit URI long-running operation.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::WebRisk::V1::SubmitUriMetadata::State]
        #     The state of the operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Latest update time of the operation.
        class SubmitUriMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum that represents the state of the long-running operation.
          module State
            # Default unspecified state.
            STATE_UNSPECIFIED = 0

            # The operation is currently running.
            RUNNING = 1

            # The operation finished with a success status.
            SUCCEEDED = 2

            # The operation was cancelled.
            CANCELLED = 3

            # The operation finished with a failure status.
            FAILED = 4

            # The operation was closed with no action taken.
            CLOSED = 5
          end
        end

        # The type of threat. This maps directly to the threat list a threat may
        # belong to.
        module ThreatType
          # No entries should match this threat type. This threat type is unused.
          THREAT_TYPE_UNSPECIFIED = 0

          # Malware targeting any platform.
          MALWARE = 1

          # Social engineering targeting any platform.
          SOCIAL_ENGINEERING = 2

          # Unwanted software targeting any platform.
          UNWANTED_SOFTWARE = 3

          # A list of extended coverage social engineering URIs targeting any
          # platform.
          SOCIAL_ENGINEERING_EXTENDED_COVERAGE = 4
        end

        # The ways in which threat entry sets can be compressed.
        module CompressionType
          # Unknown.
          COMPRESSION_TYPE_UNSPECIFIED = 0

          # Raw, uncompressed data.
          RAW = 1

          # Rice-Golomb encoded data.
          RICE = 2
        end
      end
    end
  end
end
