# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/webrisk/v1/webrisk.proto for package 'Google.Cloud.WebRisk.V1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/webrisk/v1/webrisk_pb'

module Google
  module Cloud
    module WebRisk
      module V1
        module WebRiskService
          # Web Risk API defines an interface to detect malicious URLs on your
          # website and in client applications.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.webrisk.v1.WebRiskService'

            # Gets the most recent threat list diffs. These diffs should be applied to
            # a local database of hashes to keep it up-to-date. If the local database is
            # empty or excessively out-of-date, a complete snapshot of the database will
            # be returned. This Method only updates a single ThreatList at a time. To
            # update multiple ThreatList databases, this method needs to be called once
            # for each list.
            rpc :ComputeThreatListDiff, ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest, ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse
            # This method is used to check whether a URI is on a given threatList.
            # Multiple threatLists may be searched in a single query.
            # The response will list all requested threatLists the URI was found to
            # match. If the URI is not found on any of the requested ThreatList an
            # empty response will be returned.
            rpc :SearchUris, ::Google::Cloud::WebRisk::V1::SearchUrisRequest, ::Google::Cloud::WebRisk::V1::SearchUrisResponse
            # Gets the full hashes that match the requested hash prefix.
            # This is used after a hash prefix is looked up in a threatList
            # and there is a match. The client side threatList only holds partial hashes
            # so the client must query this method to determine if there is a full
            # hash match of a threat.
            rpc :SearchHashes, ::Google::Cloud::WebRisk::V1::SearchHashesRequest, ::Google::Cloud::WebRisk::V1::SearchHashesResponse
            # Creates a Submission of a URI suspected of containing phishing content to
            # be reviewed. If the result verifies the existence of malicious phishing
            # content, the site will be added to the [Google's Social Engineering
            # lists](https://support.google.com/webmasters/answer/6350487/) in order to
            # protect users that could get exposed to this threat in the future. Only
            # allowlisted projects can use this method during Early Access. Please reach
            # out to Sales or your customer engineer to obtain access.
            rpc :CreateSubmission, ::Google::Cloud::WebRisk::V1::CreateSubmissionRequest, ::Google::Cloud::WebRisk::V1::Submission
            # Submits a URI suspected of containing malicious content to be reviewed.
            # Returns a google.longrunning.Operation which, once the review is complete,
            # is updated with its result. You can use the [Pub/Sub API]
            # (https://cloud.google.com/pubsub) to receive notifications for the returned
            # Operation. If the result verifies the existence of malicious content, the
            # site will be added to the [Google's Social Engineering lists]
            # (https://support.google.com/webmasters/answer/6350487/) in order to
            # protect users that could get exposed to this threat in the future. Only
            # allowlisted projects can use this method during Early Access. Please reach
            # out to Sales or your customer engineer to obtain access.
            rpc :SubmitUri, ::Google::Cloud::WebRisk::V1::SubmitUriRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
