# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/webrisk/v1/webrisk_pb"
require "google/cloud/web_risk/v1/web_risk_service/rest/service_stub"

module Google
  module Cloud
    module WebRisk
      module V1
        module WebRiskService
          module Rest
            ##
            # REST client for the WebRiskService service.
            #
            # Web Risk API defines an interface to detect malicious URLs on your
            # website and in client applications.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "webrisk.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :web_risk_service_stub

              ##
              # Configure the WebRiskService Client class.
              #
              # See {::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all WebRiskService clients
              #   ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "WebRisk", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.compute_threat_list_diff.timeout = 600.0
                  default_config.rpcs.compute_threat_list_diff.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.search_uris.timeout = 600.0
                  default_config.rpcs.search_uris.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.search_hashes.timeout = 600.0
                  default_config.rpcs.search_hashes.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 14]
                  }

                  default_config.rpcs.create_submission.timeout = 600.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the WebRiskService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @web_risk_service_stub.universe_domain
              end

              ##
              # Create a new WebRiskService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the WebRiskService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @web_risk_service_stub = ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @web_risk_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @web_risk_service_stub.logger
              end

              # Service calls

              ##
              # Gets the most recent threat list diffs. These diffs should be applied to
              # a local database of hashes to keep it up-to-date. If the local database is
              # empty or excessively out-of-date, a complete snapshot of the database will
              # be returned. This Method only updates a single ThreatList at a time. To
              # update multiple ThreatList databases, this method needs to be called once
              # for each list.
              #
              # @overload compute_threat_list_diff(request, options = nil)
              #   Pass arguments to `compute_threat_list_diff` via a request object, either of type
              #   {::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload compute_threat_list_diff(threat_type: nil, version_token: nil, constraints: nil)
              #   Pass arguments to `compute_threat_list_diff` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param threat_type [::Google::Cloud::WebRisk::V1::ThreatType]
              #     Required. The threat list to update. Only a single ThreatType should be
              #     specified per request. If you want to handle multiple ThreatTypes, you must
              #     make one request per ThreatType.
              #   @param version_token [::String]
              #     The current version token of the client for the requested list (the
              #     client version that was received from the last successful diff).
              #     If the client does not have a version token (this is the first time calling
              #     ComputeThreatListDiff), this may be left empty and a full database
              #     snapshot will be returned.
              #   @param constraints [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest::Constraints, ::Hash]
              #     Required. The constraints associated with this request.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_risk/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest.new
              #
              #   # Call the compute_threat_list_diff method.
              #   result = client.compute_threat_list_diff request
              #
              #   # The returned object is of type Google::Cloud::WebRisk::V1::ComputeThreatListDiffResponse.
              #   p result
              #
              def compute_threat_list_diff request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebRisk::V1::ComputeThreatListDiffRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.compute_threat_list_diff.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebRisk::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.compute_threat_list_diff.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.compute_threat_list_diff.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_risk_service_stub.compute_threat_list_diff request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # This method is used to check whether a URI is on a given threatList.
              # Multiple threatLists may be searched in a single query.
              # The response will list all requested threatLists the URI was found to
              # match. If the URI is not found on any of the requested ThreatList an
              # empty response will be returned.
              #
              # @overload search_uris(request, options = nil)
              #   Pass arguments to `search_uris` via a request object, either of type
              #   {::Google::Cloud::WebRisk::V1::SearchUrisRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebRisk::V1::SearchUrisRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_uris(uri: nil, threat_types: nil)
              #   Pass arguments to `search_uris` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param uri [::String]
              #     Required. The URI to be checked for matches.
              #   @param threat_types [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
              #     Required. The ThreatLists to search in. Multiple ThreatLists may be
              #     specified.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebRisk::V1::SearchUrisResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebRisk::V1::SearchUrisResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_risk/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebRisk::V1::SearchUrisRequest.new
              #
              #   # Call the search_uris method.
              #   result = client.search_uris request
              #
              #   # The returned object is of type Google::Cloud::WebRisk::V1::SearchUrisResponse.
              #   p result
              #
              def search_uris request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebRisk::V1::SearchUrisRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_uris.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebRisk::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_uris.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_uris.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_risk_service_stub.search_uris request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the full hashes that match the requested hash prefix.
              # This is used after a hash prefix is looked up in a threatList
              # and there is a match. The client side threatList only holds partial hashes
              # so the client must query this method to determine if there is a full
              # hash match of a threat.
              #
              # @overload search_hashes(request, options = nil)
              #   Pass arguments to `search_hashes` via a request object, either of type
              #   {::Google::Cloud::WebRisk::V1::SearchHashesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebRisk::V1::SearchHashesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_hashes(hash_prefix: nil, threat_types: nil)
              #   Pass arguments to `search_hashes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param hash_prefix [::String]
              #     A hash prefix, consisting of the most significant 4-32 bytes of a SHA256
              #     hash. For JSON requests, this field is base64-encoded.
              #     Note that if this parameter is provided by a URI, it must be encoded using
              #     the web safe base64 variant (RFC 4648).
              #   @param threat_types [::Array<::Google::Cloud::WebRisk::V1::ThreatType>]
              #     Required. The ThreatLists to search in. Multiple ThreatLists may be
              #     specified.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebRisk::V1::SearchHashesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebRisk::V1::SearchHashesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_risk/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebRisk::V1::SearchHashesRequest.new
              #
              #   # Call the search_hashes method.
              #   result = client.search_hashes request
              #
              #   # The returned object is of type Google::Cloud::WebRisk::V1::SearchHashesResponse.
              #   p result
              #
              def search_hashes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebRisk::V1::SearchHashesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_hashes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebRisk::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_hashes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_hashes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_risk_service_stub.search_hashes request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a Submission of a URI suspected of containing phishing content to
              # be reviewed. If the result verifies the existence of malicious phishing
              # content, the site will be added to the [Google's Social Engineering
              # lists](https://support.google.com/webmasters/answer/6350487/) in order to
              # protect users that could get exposed to this threat in the future. Only
              # allowlisted projects can use this method during Early Access. Please reach
              # out to Sales or your customer engineer to obtain access.
              #
              # @overload create_submission(request, options = nil)
              #   Pass arguments to `create_submission` via a request object, either of type
              #   {::Google::Cloud::WebRisk::V1::CreateSubmissionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebRisk::V1::CreateSubmissionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_submission(parent: nil, submission: nil)
              #   Pass arguments to `create_submission` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project that is making the submission. This
              #     string is in the format "projects/\\{project_number}".
              #   @param submission [::Google::Cloud::WebRisk::V1::Submission, ::Hash]
              #     Required. The submission that contains the content of the phishing report.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::WebRisk::V1::Submission]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::WebRisk::V1::Submission]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_risk/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebRisk::V1::CreateSubmissionRequest.new
              #
              #   # Call the create_submission method.
              #   result = client.create_submission request
              #
              #   # The returned object is of type Google::Cloud::WebRisk::V1::Submission.
              #   p result
              #
              def create_submission request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebRisk::V1::CreateSubmissionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_submission.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebRisk::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_submission.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_submission.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_risk_service_stub.create_submission request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Submits a URI suspected of containing malicious content to be reviewed.
              # Returns a google.longrunning.Operation which, once the review is complete,
              # is updated with its result. You can use the [Pub/Sub API]
              # (https://cloud.google.com/pubsub) to receive notifications for the returned
              # Operation. If the result verifies the existence of malicious content, the
              # site will be added to the [Google's Social Engineering lists]
              # (https://support.google.com/webmasters/answer/6350487/) in order to
              # protect users that could get exposed to this threat in the future. Only
              # allowlisted projects can use this method during Early Access. Please reach
              # out to Sales or your customer engineer to obtain access.
              #
              # @overload submit_uri(request, options = nil)
              #   Pass arguments to `submit_uri` via a request object, either of type
              #   {::Google::Cloud::WebRisk::V1::SubmitUriRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::WebRisk::V1::SubmitUriRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload submit_uri(parent: nil, submission: nil, threat_info: nil, threat_discovery: nil)
              #   Pass arguments to `submit_uri` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The name of the project that is making the submission. This
              #     string is in the format "projects/\\{project_number}".
              #   @param submission [::Google::Cloud::WebRisk::V1::Submission, ::Hash]
              #     Required. The submission that contains the URI to be scanned.
              #   @param threat_info [::Google::Cloud::WebRisk::V1::ThreatInfo, ::Hash]
              #     Provides additional information about the submission.
              #   @param threat_discovery [::Google::Cloud::WebRisk::V1::ThreatDiscovery, ::Hash]
              #     Provides additional information about how the submission was discovered.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/web_risk/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::WebRisk::V1::SubmitUriRequest.new
              #
              #   # Call the submit_uri method.
              #   result = client.submit_uri request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def submit_uri request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::WebRisk::V1::SubmitUriRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.submit_uri.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::WebRisk::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.submit_uri.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.submit_uri.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @web_risk_service_stub.submit_uri request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the WebRiskService REST API.
              #
              # This class represents the configuration for WebRiskService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # compute_threat_list_diff to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.compute_threat_list_diff.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::WebRisk::V1::WebRiskService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.compute_threat_list_diff.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "webrisk.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the WebRiskService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `compute_threat_list_diff`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :compute_threat_list_diff
                  ##
                  # RPC-specific configuration for `search_uris`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_uris
                  ##
                  # RPC-specific configuration for `search_hashes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_hashes
                  ##
                  # RPC-specific configuration for `create_submission`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_submission
                  ##
                  # RPC-specific configuration for `submit_uri`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :submit_uri

                  # @private
                  def initialize parent_rpcs = nil
                    compute_threat_list_diff_config = parent_rpcs.compute_threat_list_diff if parent_rpcs.respond_to? :compute_threat_list_diff
                    @compute_threat_list_diff = ::Gapic::Config::Method.new compute_threat_list_diff_config
                    search_uris_config = parent_rpcs.search_uris if parent_rpcs.respond_to? :search_uris
                    @search_uris = ::Gapic::Config::Method.new search_uris_config
                    search_hashes_config = parent_rpcs.search_hashes if parent_rpcs.respond_to? :search_hashes
                    @search_hashes = ::Gapic::Config::Method.new search_hashes_config
                    create_submission_config = parent_rpcs.create_submission if parent_rpcs.respond_to? :create_submission
                    @create_submission = ::Gapic::Config::Method.new create_submission_config
                    submit_uri_config = parent_rpcs.submit_uri if parent_rpcs.respond_to? :submit_uri
                    @submit_uri = ::Gapic::Config::Method.new submit_uri_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
