# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VpcAccess
      module V1
        # Definition of a Serverless VPC Access connector.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name in the format `projects/*/locations/*/connectors/*`.
        # @!attribute [rw] network
        #   @return [::String]
        #     Name of a VPC network.
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     The range of internal addresses that follows RFC 4632 notation.
        #     Example: `10.132.0.0/28`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VpcAccess::V1::Connector::State]
        #     Output only. State of the VPC access connector.
        # @!attribute [rw] min_throughput
        #   @return [::Integer]
        #     Minimum throughput of the connector in Mbps. Default and min is 200.
        # @!attribute [rw] max_throughput
        #   @return [::Integer]
        #     Maximum throughput of the connector in Mbps. Default is 300, max is 1000.
        # @!attribute [r] connected_projects
        #   @return [::Array<::String>]
        #     Output only. List of projects using the connector.
        # @!attribute [rw] subnet
        #   @return [::Google::Cloud::VpcAccess::V1::Connector::Subnet]
        #     The subnet in which to house the VPC Access Connector.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Machine type of VM Instance underlying connector. Default is e2-micro
        # @!attribute [rw] min_instances
        #   @return [::Integer]
        #     Minimum value of instances in autoscaling group underlying the connector.
        # @!attribute [rw] max_instances
        #   @return [::Integer]
        #     Maximum value of instances in autoscaling group underlying the connector.
        class Connector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The subnet in which to house the connector
          # @!attribute [rw] name
          #   @return [::String]
          #     Subnet name (relative, not fully qualified).
          #     E.g. if the full subnet selfLink is
          #     https://compute.googleapis.com/compute/v1/projects/\\{project}/regions/\\{region}/subnetworks/\\{subnetName}
          #     the correct input for this field would be \\{subnetName}
          # @!attribute [rw] project_id
          #   @return [::String]
          #     Project in which the subnet exists.
          #     If not set, this project is assumed to be the project for which
          #     the connector create request was issued.
          class Subnet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # State of a connector.
          module State
            # Invalid state.
            STATE_UNSPECIFIED = 0

            # Connector is deployed and ready to receive traffic.
            READY = 1

            # An Insert operation is in progress. Transient condition.
            CREATING = 2

            # A Delete operation is in progress. Transient condition.
            DELETING = 3

            # Connector is in a bad state, manual deletion recommended.
            ERROR = 4

            # The connector is being updated.
            UPDATING = 5
          end
        end

        # Request for creating a Serverless VPC Access connector.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location in which the configuration should be created,
        #     specified in the format `projects/*/locations/*`.
        # @!attribute [rw] connector_id
        #   @return [::String]
        #     Required. The ID to use for this connector.
        # @!attribute [rw] connector
        #   @return [::Google::Cloud::VpcAccess::V1::Connector]
        #     Required. Resource to create.
        class CreateConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for getting a Serverless VPC Access connector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of a Serverless VPC Access connector to get.
        class GetConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for listing Serverless VPC Access connectors in a location.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location from which the routes should be listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Maximum number of functions to return per call.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Continuation token.
        class ListConnectorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for listing Serverless VPC Access connectors.
        # @!attribute [rw] connectors
        #   @return [::Array<::Google::Cloud::VpcAccess::V1::Connector>]
        #     List of Serverless VPC Access connectors.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Continuation token.
        class ListConnectorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting a Serverless VPC Access connector.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of a Serverless VPC Access connector to delete.
        class DeleteConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata for google.longrunning.Operation.
        # @!attribute [r] method
        #   @return [::String]
        #     Output only. Method that initiated the operation e.g.
        #     google.cloud.vpcaccess.v1.Connectors.CreateConnector.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the operation completed.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Name of the resource that this operation is acting on e.g.
        #     projects/my-project/locations/us-central1/connectors/v1.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
