# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/vmwareengine/v1/vmwareengine_pb"
require "google/cloud/vmware_engine/v1/vmware_engine"

class ::Google::Cloud::VmwareEngine::V1::VmwareEngine::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_private_clouds
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_clouds_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_private_clouds, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_private_clouds_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_private_clouds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_private_clouds parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_private_clouds ::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_private_clouds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_private_clouds(::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_private_clouds_client_stub.call_rpc_count
    end
  end

  def test_get_private_cloud
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::PrivateCloud.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_cloud_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_private_cloud, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_private_cloud_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_private_cloud({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_private_cloud name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_private_cloud ::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_private_cloud({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_private_cloud(::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_private_cloud_client_stub.call_rpc_count
    end
  end

  def test_create_private_cloud
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_cloud_id = "hello world"
    private_cloud = {}
    request_id = "hello world"
    validate_only = true

    create_private_cloud_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_private_cloud, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["private_cloud_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::PrivateCloud), request["private_cloud"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_private_cloud_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_private_cloud({ parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_private_cloud parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_private_cloud ::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest.new(parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_private_cloud({ parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_private_cloud(::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest.new(parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_private_cloud_client_stub.call_rpc_count
    end
  end

  def test_update_private_cloud
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    private_cloud = {}
    update_mask = {}
    request_id = "hello world"

    update_private_cloud_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_private_cloud, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::PrivateCloud), request["private_cloud"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_private_cloud_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_private_cloud({ private_cloud: private_cloud, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_private_cloud private_cloud: private_cloud, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_private_cloud ::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest.new(private_cloud: private_cloud, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_private_cloud({ private_cloud: private_cloud, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_private_cloud(::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest.new(private_cloud: private_cloud, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_private_cloud_client_stub.call_rpc_count
    end
  end

  def test_delete_private_cloud
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    delay_hours = 42

    delete_private_cloud_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_private_cloud, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      assert_equal 42, request["delay_hours"]
      assert request.has_delay_hours?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_private_cloud_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_private_cloud({ name: name, request_id: request_id, force: force, delay_hours: delay_hours }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_private_cloud name: name, request_id: request_id, force: force, delay_hours: delay_hours do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_private_cloud ::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest.new(name: name, request_id: request_id, force: force, delay_hours: delay_hours) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_private_cloud({ name: name, request_id: request_id, force: force, delay_hours: delay_hours }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_private_cloud(::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest.new(name: name, request_id: request_id, force: force, delay_hours: delay_hours), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_private_cloud_client_stub.call_rpc_count
    end
  end

  def test_undelete_private_cloud
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    undelete_private_cloud_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undelete_private_cloud, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undelete_private_cloud_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undelete_private_cloud({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undelete_private_cloud name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undelete_private_cloud ::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undelete_private_cloud({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undelete_private_cloud(::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undelete_private_cloud_client_stub.call_rpc_count
    end
  end

  def test_list_clusters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListClustersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clusters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_clusters, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListClustersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_clusters_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_clusters ::Google::Cloud::VmwareEngine::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_clusters(::Google::Cloud::VmwareEngine::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_clusters_client_stub.call_rpc_count
    end
  end

  def test_get_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::Cluster.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_cluster, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetClusterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_cluster({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_cluster name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_cluster ::Google::Cloud::VmwareEngine::V1::GetClusterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_cluster({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_cluster(::Google::Cloud::VmwareEngine::V1::GetClusterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_cluster_client_stub.call_rpc_count
    end
  end

  def test_create_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"
    validate_only = true

    create_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_cluster, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateClusterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["cluster_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::Cluster), request["cluster"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_cluster parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_cluster ::Google::Cloud::VmwareEngine::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_cluster(::Google::Cloud::VmwareEngine::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_cluster_client_stub.call_rpc_count
    end
  end

  def test_update_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    cluster = {}
    request_id = "hello world"
    validate_only = true

    update_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_cluster, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::Cluster), request["cluster"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_cluster update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_cluster ::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_cluster(::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_cluster_client_stub.call_rpc_count
    end
  end

  def test_delete_cluster
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_cluster_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_cluster, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_cluster_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_cluster({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_cluster name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_cluster ::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_cluster({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_cluster(::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_cluster_client_stub.call_rpc_count
    end
  end

  def test_list_nodes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListNodesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_nodes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_nodes, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListNodesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_nodes_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_nodes({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_nodes parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_nodes ::Google::Cloud::VmwareEngine::V1::ListNodesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_nodes({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_nodes(::Google::Cloud::VmwareEngine::V1::ListNodesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_nodes_client_stub.call_rpc_count
    end
  end

  def test_get_node
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::Node.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_node, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetNodeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_node_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_node({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_node name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_node ::Google::Cloud::VmwareEngine::V1::GetNodeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_node({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_node(::Google::Cloud::VmwareEngine::V1::GetNodeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_node_client_stub.call_rpc_count
    end
  end

  def test_list_external_addresses
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListExternalAddressesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_external_addresses_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_external_addresses, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_external_addresses_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_external_addresses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_external_addresses parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_external_addresses ::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_external_addresses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_external_addresses(::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_external_addresses_client_stub.call_rpc_count
    end
  end

  def test_fetch_network_policy_external_addresses
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    network_policy = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_network_policy_external_addresses_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_network_policy_external_addresses, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest, request
      assert_equal "hello world", request["network_policy"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_network_policy_external_addresses_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_network_policy_external_addresses({ network_policy: network_policy, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_network_policy_external_addresses network_policy: network_policy, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_network_policy_external_addresses ::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest.new(network_policy: network_policy, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_network_policy_external_addresses({ network_policy: network_policy, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_network_policy_external_addresses(::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest.new(network_policy: network_policy, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_network_policy_external_addresses_client_stub.call_rpc_count
    end
  end

  def test_get_external_address
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ExternalAddress.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_external_address_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_external_address, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_external_address_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_external_address({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_external_address name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_external_address ::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_external_address({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_external_address(::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_external_address_client_stub.call_rpc_count
    end
  end

  def test_create_external_address
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    external_address = {}
    external_address_id = "hello world"
    request_id = "hello world"

    create_external_address_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_external_address, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::ExternalAddress), request["external_address"]
      assert_equal "hello world", request["external_address_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_external_address_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_external_address({ parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_external_address parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_external_address ::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest.new(parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_external_address({ parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_external_address(::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest.new(parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_external_address_client_stub.call_rpc_count
    end
  end

  def test_update_external_address
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    external_address = {}
    request_id = "hello world"

    update_external_address_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_external_address, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::ExternalAddress), request["external_address"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_external_address_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_external_address({ update_mask: update_mask, external_address: external_address, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_external_address update_mask: update_mask, external_address: external_address, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_external_address ::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest.new(update_mask: update_mask, external_address: external_address, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_external_address({ update_mask: update_mask, external_address: external_address, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_external_address(::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest.new(update_mask: update_mask, external_address: external_address, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_external_address_client_stub.call_rpc_count
    end
  end

  def test_delete_external_address
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_external_address_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_external_address, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_external_address_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_external_address({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_external_address name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_external_address ::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_external_address({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_external_address(::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_external_address_client_stub.call_rpc_count
    end
  end

  def test_list_subnets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListSubnetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subnets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subnets, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subnets_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subnets parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subnets ::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subnets(::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subnets_client_stub.call_rpc_count
    end
  end

  def test_get_subnet
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::Subnet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subnet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subnet, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetSubnetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subnet_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subnet({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subnet name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subnet ::Google::Cloud::VmwareEngine::V1::GetSubnetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subnet({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subnet(::Google::Cloud::VmwareEngine::V1::GetSubnetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subnet_client_stub.call_rpc_count
    end
  end

  def test_update_subnet
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    subnet = {}

    update_subnet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_subnet, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::Subnet), request["subnet"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_subnet_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_subnet({ update_mask: update_mask, subnet: subnet }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_subnet update_mask: update_mask, subnet: subnet do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_subnet ::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_subnet({ update_mask: update_mask, subnet: subnet }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_subnet(::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_subnet_client_stub.call_rpc_count
    end
  end

  def test_list_external_access_rules
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_external_access_rules_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_external_access_rules, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_external_access_rules_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_external_access_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_external_access_rules parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_external_access_rules ::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_external_access_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_external_access_rules(::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_external_access_rules_client_stub.call_rpc_count
    end
  end

  def test_get_external_access_rule
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ExternalAccessRule.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_external_access_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_external_access_rule, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_external_access_rule_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_external_access_rule({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_external_access_rule name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_external_access_rule ::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_external_access_rule({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_external_access_rule(::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_external_access_rule_client_stub.call_rpc_count
    end
  end

  def test_create_external_access_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    external_access_rule = {}
    external_access_rule_id = "hello world"
    request_id = "hello world"

    create_external_access_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_external_access_rule, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::ExternalAccessRule), request["external_access_rule"]
      assert_equal "hello world", request["external_access_rule_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_external_access_rule_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_external_access_rule({ parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_external_access_rule parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_external_access_rule ::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest.new(parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_external_access_rule({ parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_external_access_rule(::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest.new(parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_external_access_rule_client_stub.call_rpc_count
    end
  end

  def test_update_external_access_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    external_access_rule = {}
    request_id = "hello world"

    update_external_access_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_external_access_rule, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::ExternalAccessRule), request["external_access_rule"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_external_access_rule_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_external_access_rule({ update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_external_access_rule update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_external_access_rule ::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest.new(update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_external_access_rule({ update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_external_access_rule(::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest.new(update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_external_access_rule_client_stub.call_rpc_count
    end
  end

  def test_delete_external_access_rule
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_external_access_rule_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_external_access_rule, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_external_access_rule_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_external_access_rule({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_external_access_rule name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_external_access_rule ::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_external_access_rule({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_external_access_rule(::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_external_access_rule_client_stub.call_rpc_count
    end
  end

  def test_list_logging_servers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListLoggingServersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_logging_servers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_logging_servers, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_logging_servers_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_logging_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_logging_servers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_logging_servers ::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_logging_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_logging_servers(::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_logging_servers_client_stub.call_rpc_count
    end
  end

  def test_get_logging_server
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::LoggingServer.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_logging_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_logging_server, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_logging_server_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_logging_server({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_logging_server name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_logging_server ::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_logging_server({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_logging_server(::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_logging_server_client_stub.call_rpc_count
    end
  end

  def test_create_logging_server
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    logging_server = {}
    logging_server_id = "hello world"
    request_id = "hello world"

    create_logging_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_logging_server, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::LoggingServer), request["logging_server"]
      assert_equal "hello world", request["logging_server_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_logging_server_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_logging_server({ parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_logging_server parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_logging_server ::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest.new(parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_logging_server({ parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_logging_server(::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest.new(parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_logging_server_client_stub.call_rpc_count
    end
  end

  def test_update_logging_server
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    logging_server = {}
    request_id = "hello world"

    update_logging_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_logging_server, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::LoggingServer), request["logging_server"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_logging_server_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_logging_server({ update_mask: update_mask, logging_server: logging_server, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_logging_server update_mask: update_mask, logging_server: logging_server, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_logging_server ::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest.new(update_mask: update_mask, logging_server: logging_server, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_logging_server({ update_mask: update_mask, logging_server: logging_server, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_logging_server(::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest.new(update_mask: update_mask, logging_server: logging_server, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_logging_server_client_stub.call_rpc_count
    end
  end

  def test_delete_logging_server
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_logging_server_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_logging_server, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_logging_server_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_logging_server({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_logging_server name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_logging_server ::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_logging_server({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_logging_server(::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_logging_server_client_stub.call_rpc_count
    end
  end

  def test_list_node_types
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListNodeTypesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_node_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_node_types, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_node_types_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_node_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_node_types parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_node_types ::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_node_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_node_types(::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_node_types_client_stub.call_rpc_count
    end
  end

  def test_get_node_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::NodeType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_node_type, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_node_type_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_node_type({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_node_type name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_node_type ::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_node_type({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_node_type(::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_node_type_client_stub.call_rpc_count
    end
  end

  def test_show_nsx_credentials
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::Credentials.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"

    show_nsx_credentials_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :show_nsx_credentials, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest, request
      assert_equal "hello world", request["private_cloud"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, show_nsx_credentials_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.show_nsx_credentials({ private_cloud: private_cloud }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.show_nsx_credentials private_cloud: private_cloud do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.show_nsx_credentials ::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest.new(private_cloud: private_cloud) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.show_nsx_credentials({ private_cloud: private_cloud }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.show_nsx_credentials(::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest.new(private_cloud: private_cloud), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, show_nsx_credentials_client_stub.call_rpc_count
    end
  end

  def test_show_vcenter_credentials
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::Credentials.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"
    username = "hello world"

    show_vcenter_credentials_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :show_vcenter_credentials, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest, request
      assert_equal "hello world", request["private_cloud"]
      assert_equal "hello world", request["username"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, show_vcenter_credentials_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.show_vcenter_credentials({ private_cloud: private_cloud, username: username }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.show_vcenter_credentials private_cloud: private_cloud, username: username do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.show_vcenter_credentials ::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest.new(private_cloud: private_cloud, username: username) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.show_vcenter_credentials({ private_cloud: private_cloud, username: username }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.show_vcenter_credentials(::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest.new(private_cloud: private_cloud, username: username), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, show_vcenter_credentials_client_stub.call_rpc_count
    end
  end

  def test_reset_nsx_credentials
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"
    request_id = "hello world"

    reset_nsx_credentials_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_nsx_credentials, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest, request
      assert_equal "hello world", request["private_cloud"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_nsx_credentials_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_nsx_credentials({ private_cloud: private_cloud, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_nsx_credentials private_cloud: private_cloud, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_nsx_credentials ::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_nsx_credentials({ private_cloud: private_cloud, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_nsx_credentials(::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_nsx_credentials_client_stub.call_rpc_count
    end
  end

  def test_reset_vcenter_credentials
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"
    request_id = "hello world"
    username = "hello world"

    reset_vcenter_credentials_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_vcenter_credentials, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest, request
      assert_equal "hello world", request["private_cloud"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["username"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_vcenter_credentials_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_vcenter_credentials({ private_cloud: private_cloud, request_id: request_id, username: username }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_vcenter_credentials private_cloud: private_cloud, request_id: request_id, username: username do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_vcenter_credentials ::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id, username: username) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_vcenter_credentials({ private_cloud: private_cloud, request_id: request_id, username: username }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_vcenter_credentials(::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id, username: username), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_vcenter_credentials_client_stub.call_rpc_count
    end
  end

  def test_get_dns_forwarding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::DnsForwarding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dns_forwarding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_dns_forwarding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_dns_forwarding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_dns_forwarding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_dns_forwarding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_dns_forwarding ::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_dns_forwarding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_dns_forwarding(::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_dns_forwarding_client_stub.call_rpc_count
    end
  end

  def test_update_dns_forwarding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    dns_forwarding = {}
    update_mask = {}
    request_id = "hello world"

    update_dns_forwarding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_dns_forwarding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::DnsForwarding), request["dns_forwarding"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_dns_forwarding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_dns_forwarding({ dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_dns_forwarding dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_dns_forwarding ::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest.new(dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_dns_forwarding({ dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_dns_forwarding(::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest.new(dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_dns_forwarding_client_stub.call_rpc_count
    end
  end

  def test_get_network_peering
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::NetworkPeering.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_peering_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_network_peering, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_network_peering_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_network_peering({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_network_peering name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_network_peering ::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_network_peering({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_network_peering(::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_network_peering_client_stub.call_rpc_count
    end
  end

  def test_list_network_peerings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_network_peerings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_network_peerings, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_network_peerings_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_network_peerings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_network_peerings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_network_peerings ::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_network_peerings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_network_peerings(::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_network_peerings_client_stub.call_rpc_count
    end
  end

  def test_create_network_peering
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    network_peering_id = "hello world"
    network_peering = {}
    request_id = "hello world"

    create_network_peering_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_network_peering, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["network_peering_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::NetworkPeering), request["network_peering"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_network_peering_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_network_peering({ parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_network_peering parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_network_peering ::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest.new(parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_network_peering({ parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_network_peering(::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest.new(parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_network_peering_client_stub.call_rpc_count
    end
  end

  def test_delete_network_peering
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_network_peering_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_network_peering, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_network_peering_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_network_peering({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_network_peering name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_network_peering ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_network_peering({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_network_peering(::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_network_peering_client_stub.call_rpc_count
    end
  end

  def test_update_network_peering
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    network_peering = {}
    update_mask = {}
    request_id = "hello world"

    update_network_peering_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_network_peering, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::NetworkPeering), request["network_peering"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_network_peering_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_network_peering({ network_peering: network_peering, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_network_peering network_peering: network_peering, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_network_peering ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest.new(network_peering: network_peering, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_network_peering({ network_peering: network_peering, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_network_peering(::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest.new(network_peering: network_peering, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_network_peering_client_stub.call_rpc_count
    end
  end

  def test_list_peering_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_peering_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_peering_routes, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_peering_routes_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_peering_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_peering_routes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_peering_routes ::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_peering_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_peering_routes(::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_peering_routes_client_stub.call_rpc_count
    end
  end

  def test_create_hcx_activation_key
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hcx_activation_key = {}
    hcx_activation_key_id = "hello world"
    request_id = "hello world"

    create_hcx_activation_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_hcx_activation_key, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::HcxActivationKey), request["hcx_activation_key"]
      assert_equal "hello world", request["hcx_activation_key_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_hcx_activation_key_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_hcx_activation_key({ parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_hcx_activation_key parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_hcx_activation_key ::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest.new(parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_hcx_activation_key({ parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_hcx_activation_key(::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest.new(parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_hcx_activation_key_client_stub.call_rpc_count
    end
  end

  def test_list_hcx_activation_keys
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_hcx_activation_keys_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hcx_activation_keys, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hcx_activation_keys_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hcx_activation_keys({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hcx_activation_keys parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hcx_activation_keys ::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hcx_activation_keys({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hcx_activation_keys(::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hcx_activation_keys_client_stub.call_rpc_count
    end
  end

  def test_get_hcx_activation_key
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::HcxActivationKey.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hcx_activation_key_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hcx_activation_key, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hcx_activation_key_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hcx_activation_key({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hcx_activation_key name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hcx_activation_key ::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hcx_activation_key({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hcx_activation_key(::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hcx_activation_key_client_stub.call_rpc_count
    end
  end

  def test_get_network_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::NetworkPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_network_policy, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_network_policy_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_network_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_network_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_network_policy ::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_network_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_network_policy(::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_network_policy_client_stub.call_rpc_count
    end
  end

  def test_list_network_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_network_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_network_policies, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_network_policies_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_network_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_network_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_network_policies ::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_network_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_network_policies(::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_network_policies_client_stub.call_rpc_count
    end
  end

  def test_create_network_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    network_policy_id = "hello world"
    network_policy = {}
    request_id = "hello world"

    create_network_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_network_policy, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["network_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::NetworkPolicy), request["network_policy"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_network_policy_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_network_policy({ parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_network_policy parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_network_policy ::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest.new(parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_network_policy({ parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_network_policy(::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest.new(parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_network_policy_client_stub.call_rpc_count
    end
  end

  def test_update_network_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    network_policy = {}
    update_mask = {}
    request_id = "hello world"

    update_network_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_network_policy, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::NetworkPolicy), request["network_policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_network_policy_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_network_policy({ network_policy: network_policy, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_network_policy network_policy: network_policy, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_network_policy ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest.new(network_policy: network_policy, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_network_policy({ network_policy: network_policy, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_network_policy(::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest.new(network_policy: network_policy, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_network_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_network_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_network_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_network_policy, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_network_policy_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_network_policy({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_network_policy name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_network_policy ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_network_policy({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_network_policy(::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_network_policy_client_stub.call_rpc_count
    end
  end

  def test_list_management_dns_zone_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_management_dns_zone_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_management_dns_zone_bindings, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_management_dns_zone_bindings_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_management_dns_zone_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_management_dns_zone_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_management_dns_zone_bindings ::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_management_dns_zone_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_management_dns_zone_bindings(::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_management_dns_zone_bindings_client_stub.call_rpc_count
    end
  end

  def test_get_management_dns_zone_binding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_management_dns_zone_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_management_dns_zone_binding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_management_dns_zone_binding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_management_dns_zone_binding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_management_dns_zone_binding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_management_dns_zone_binding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_management_dns_zone_binding_client_stub.call_rpc_count
    end
  end

  def test_create_management_dns_zone_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    management_dns_zone_binding = {}
    management_dns_zone_binding_id = "hello world"
    request_id = "hello world"

    create_management_dns_zone_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_management_dns_zone_binding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding), request["management_dns_zone_binding"]
      assert_equal "hello world", request["management_dns_zone_binding_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_management_dns_zone_binding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_management_dns_zone_binding({ parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_management_dns_zone_binding parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest.new(parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_management_dns_zone_binding({ parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest.new(parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_management_dns_zone_binding_client_stub.call_rpc_count
    end
  end

  def test_update_management_dns_zone_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    management_dns_zone_binding = {}
    request_id = "hello world"

    update_management_dns_zone_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_management_dns_zone_binding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding), request["management_dns_zone_binding"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_management_dns_zone_binding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_management_dns_zone_binding({ update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_management_dns_zone_binding update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest.new(update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_management_dns_zone_binding({ update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest.new(update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_management_dns_zone_binding_client_stub.call_rpc_count
    end
  end

  def test_delete_management_dns_zone_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_management_dns_zone_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_management_dns_zone_binding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_management_dns_zone_binding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_management_dns_zone_binding({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_management_dns_zone_binding name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_management_dns_zone_binding({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_management_dns_zone_binding_client_stub.call_rpc_count
    end
  end

  def test_repair_management_dns_zone_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    repair_management_dns_zone_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :repair_management_dns_zone_binding, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, repair_management_dns_zone_binding_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.repair_management_dns_zone_binding({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.repair_management_dns_zone_binding name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.repair_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.repair_management_dns_zone_binding({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.repair_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, repair_management_dns_zone_binding_client_stub.call_rpc_count
    end
  end

  def test_create_vmware_engine_network
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vmware_engine_network_id = "hello world"
    vmware_engine_network = {}
    request_id = "hello world"

    create_vmware_engine_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_vmware_engine_network, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["vmware_engine_network_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork), request["vmware_engine_network"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_vmware_engine_network_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_vmware_engine_network({ parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_vmware_engine_network parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest.new(parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_vmware_engine_network({ parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest.new(parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_vmware_engine_network_client_stub.call_rpc_count
    end
  end

  def test_update_vmware_engine_network
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    vmware_engine_network = {}
    update_mask = {}
    request_id = "hello world"

    update_vmware_engine_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_vmware_engine_network, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork), request["vmware_engine_network"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_vmware_engine_network_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_vmware_engine_network({ vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_vmware_engine_network vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest.new(vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_vmware_engine_network({ vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest.new(vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_vmware_engine_network_client_stub.call_rpc_count
    end
  end

  def test_delete_vmware_engine_network
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_vmware_engine_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_vmware_engine_network, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_vmware_engine_network_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_vmware_engine_network({ name: name, request_id: request_id, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_vmware_engine_network name: name, request_id: request_id, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest.new(name: name, request_id: request_id, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_vmware_engine_network({ name: name, request_id: request_id, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest.new(name: name, request_id: request_id, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_vmware_engine_network_client_stub.call_rpc_count
    end
  end

  def test_get_vmware_engine_network
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vmware_engine_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vmware_engine_network, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vmware_engine_network_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vmware_engine_network({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vmware_engine_network name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vmware_engine_network({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vmware_engine_network_client_stub.call_rpc_count
    end
  end

  def test_list_vmware_engine_networks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_vmware_engine_networks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vmware_engine_networks, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vmware_engine_networks_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vmware_engine_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vmware_engine_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vmware_engine_networks ::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vmware_engine_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vmware_engine_networks(::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vmware_engine_networks_client_stub.call_rpc_count
    end
  end

  def test_create_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_connection_id = "hello world"
    private_connection = {}
    request_id = "hello world"

    create_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_private_connection, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["private_connection_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::PrivateConnection), request["private_connection"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_private_connection parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_private_connection ::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_private_connection(::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_private_connection_client_stub.call_rpc_count
    end
  end

  def test_get_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::PrivateConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_private_connection, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_private_connection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_private_connection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_private_connection ::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_private_connection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_private_connection(::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_private_connection_client_stub.call_rpc_count
    end
  end

  def test_list_private_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_private_connections, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_private_connections_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_private_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_private_connections ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_private_connections(::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_private_connections_client_stub.call_rpc_count
    end
  end

  def test_update_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    private_connection = {}
    update_mask = {}
    request_id = "hello world"

    update_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_private_connection, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::PrivateConnection), request["private_connection"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_private_connection({ private_connection: private_connection, update_mask: update_mask, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_private_connection private_connection: private_connection, update_mask: update_mask, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_private_connection ::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest.new(private_connection: private_connection, update_mask: update_mask, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_private_connection({ private_connection: private_connection, update_mask: update_mask, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_private_connection(::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest.new(private_connection: private_connection, update_mask: update_mask, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_private_connection_client_stub.call_rpc_count
    end
  end

  def test_delete_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_private_connection, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_private_connection({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_private_connection name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_private_connection ::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_private_connection({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_private_connection(::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_private_connection_client_stub.call_rpc_count
    end
  end

  def test_list_private_connection_peering_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_private_connection_peering_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_private_connection_peering_routes, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_private_connection_peering_routes_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_private_connection_peering_routes({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_private_connection_peering_routes parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_private_connection_peering_routes ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_private_connection_peering_routes({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_private_connection_peering_routes(::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_private_connection_peering_routes_client_stub.call_rpc_count
    end
  end

  def test_grant_dns_bind_permission
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    principal = {}
    request_id = "hello world"

    grant_dns_bind_permission_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :grant_dns_bind_permission, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::Principal), request["principal"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, grant_dns_bind_permission_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.grant_dns_bind_permission({ name: name, principal: principal, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.grant_dns_bind_permission name: name, principal: principal, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.grant_dns_bind_permission ::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.grant_dns_bind_permission({ name: name, principal: principal, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.grant_dns_bind_permission(::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, grant_dns_bind_permission_client_stub.call_rpc_count
    end
  end

  def test_get_dns_bind_permission
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::VmwareEngine::V1::DnsBindPermission.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dns_bind_permission_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_dns_bind_permission, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_dns_bind_permission_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_dns_bind_permission({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_dns_bind_permission name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_dns_bind_permission ::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_dns_bind_permission({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_dns_bind_permission(::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_dns_bind_permission_client_stub.call_rpc_count
    end
  end

  def test_revoke_dns_bind_permission
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    principal = {}
    request_id = "hello world"

    revoke_dns_bind_permission_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :revoke_dns_bind_permission, name
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::VmwareEngine::V1::Principal), request["principal"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, revoke_dns_bind_permission_client_stub do
      # Create client
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.revoke_dns_bind_permission({ name: name, principal: principal, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.revoke_dns_bind_permission name: name, principal: principal, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.revoke_dns_bind_permission ::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.revoke_dns_bind_permission({ name: name, principal: principal, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.revoke_dns_bind_permission(::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, revoke_dns_bind_permission_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Operations, client.operations_client
  end
end
