# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/vmwareengine/v1/vmwareengine_pb"
require "google/cloud/vmware_engine/v1/vmware_engine/rest"


class ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_private_clouds
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_clouds_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_private_clouds_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_private_clouds_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_private_clouds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_private_clouds parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_private_clouds ::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_private_clouds({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_private_clouds(::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_private_clouds_client_stub.call_count
      end
    end
  end

  def test_get_private_cloud
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::PrivateCloud.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_cloud_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_private_cloud_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_private_cloud_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_private_cloud({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_private_cloud name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_private_cloud ::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_private_cloud({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_private_cloud(::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_private_cloud_client_stub.call_count
      end
    end
  end

  def test_create_private_cloud
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_cloud_id = "hello world"
    private_cloud = {}
    request_id = "hello world"
    validate_only = true

    create_private_cloud_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_private_cloud_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_private_cloud_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_private_cloud({ parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_private_cloud parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_private_cloud ::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest.new(parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_private_cloud({ parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_private_cloud(::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest.new(parent: parent, private_cloud_id: private_cloud_id, private_cloud: private_cloud, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_private_cloud_client_stub.call_count
      end
    end
  end

  def test_update_private_cloud
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    private_cloud = {}
    update_mask = {}
    request_id = "hello world"

    update_private_cloud_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_private_cloud_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_private_cloud_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_private_cloud({ private_cloud: private_cloud, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_private_cloud private_cloud: private_cloud, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_private_cloud ::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest.new(private_cloud: private_cloud, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_private_cloud({ private_cloud: private_cloud, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_private_cloud(::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest.new(private_cloud: private_cloud, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_private_cloud_client_stub.call_count
      end
    end
  end

  def test_delete_private_cloud
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true
    delay_hours = 42

    delete_private_cloud_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_private_cloud_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_private_cloud_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_private_cloud({ name: name, request_id: request_id, force: force, delay_hours: delay_hours }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_private_cloud name: name, request_id: request_id, force: force, delay_hours: delay_hours do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_private_cloud ::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest.new(name: name, request_id: request_id, force: force, delay_hours: delay_hours) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_private_cloud({ name: name, request_id: request_id, force: force, delay_hours: delay_hours }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_private_cloud(::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest.new(name: name, request_id: request_id, force: force, delay_hours: delay_hours), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_private_cloud_client_stub.call_count
      end
    end
  end

  def test_undelete_private_cloud
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    undelete_private_cloud_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_undelete_private_cloud_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undelete_private_cloud_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undelete_private_cloud({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undelete_private_cloud name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undelete_private_cloud ::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undelete_private_cloud({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undelete_private_cloud(::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undelete_private_cloud_client_stub.call_count
      end
    end
  end

  def test_list_clusters
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_clusters ::Google::Cloud::VmwareEngine::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_clusters(::Google::Cloud::VmwareEngine::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_clusters_client_stub.call_count
      end
    end
  end

  def test_get_cluster
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::Cluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cluster ::Google::Cloud::VmwareEngine::V1::GetClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cluster(::Google::Cloud::VmwareEngine::V1::GetClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cluster_client_stub.call_count
      end
    end
  end

  def test_create_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"
    validate_only = true

    create_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cluster parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cluster ::Google::Cloud::VmwareEngine::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cluster(::Google::Cloud::VmwareEngine::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cluster_client_stub.call_count
      end
    end
  end

  def test_update_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    cluster = {}
    request_id = "hello world"
    validate_only = true

    update_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_cluster update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_cluster ::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_cluster(::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_cluster({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_cluster name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_cluster ::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_cluster({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_cluster(::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_cluster_client_stub.call_count
      end
    end
  end

  def test_list_nodes
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListNodesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_nodes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_nodes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_nodes_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_nodes({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_nodes parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_nodes ::Google::Cloud::VmwareEngine::V1::ListNodesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_nodes({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_nodes(::Google::Cloud::VmwareEngine::V1::ListNodesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_nodes_client_stub.call_count
      end
    end
  end

  def test_get_node
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::Node.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_node_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_node_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_node({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_node name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_node ::Google::Cloud::VmwareEngine::V1::GetNodeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_node({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_node(::Google::Cloud::VmwareEngine::V1::GetNodeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_node_client_stub.call_count
      end
    end
  end

  def test_list_external_addresses
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListExternalAddressesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_external_addresses_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_external_addresses_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_external_addresses_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_external_addresses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_external_addresses parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_external_addresses ::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_external_addresses({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_external_addresses(::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_external_addresses_client_stub.call_count
      end
    end
  end

  def test_fetch_network_policy_external_addresses
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    network_policy = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_network_policy_external_addresses_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_fetch_network_policy_external_addresses_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_network_policy_external_addresses_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_network_policy_external_addresses({ network_policy: network_policy, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_network_policy_external_addresses network_policy: network_policy, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_network_policy_external_addresses ::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest.new(network_policy: network_policy, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_network_policy_external_addresses({ network_policy: network_policy, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_network_policy_external_addresses(::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest.new(network_policy: network_policy, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_network_policy_external_addresses_client_stub.call_count
      end
    end
  end

  def test_get_external_address
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ExternalAddress.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_external_address_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_external_address_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_external_address_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_external_address({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_external_address name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_external_address ::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_external_address({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_external_address(::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_external_address_client_stub.call_count
      end
    end
  end

  def test_create_external_address
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    external_address = {}
    external_address_id = "hello world"
    request_id = "hello world"

    create_external_address_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_external_address_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_external_address_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_external_address({ parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_external_address parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_external_address ::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest.new(parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_external_address({ parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_external_address(::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest.new(parent: parent, external_address: external_address, external_address_id: external_address_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_external_address_client_stub.call_count
      end
    end
  end

  def test_update_external_address
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    external_address = {}
    request_id = "hello world"

    update_external_address_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_external_address_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_external_address_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_external_address({ update_mask: update_mask, external_address: external_address, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_external_address update_mask: update_mask, external_address: external_address, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_external_address ::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest.new(update_mask: update_mask, external_address: external_address, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_external_address({ update_mask: update_mask, external_address: external_address, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_external_address(::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest.new(update_mask: update_mask, external_address: external_address, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_external_address_client_stub.call_count
      end
    end
  end

  def test_delete_external_address
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_external_address_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_external_address_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_external_address_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_external_address({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_external_address name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_external_address ::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_external_address({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_external_address(::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_external_address_client_stub.call_count
      end
    end
  end

  def test_list_subnets
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListSubnetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_subnets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_subnets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subnets_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subnets parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subnets ::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subnets(::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subnets_client_stub.call_count
      end
    end
  end

  def test_get_subnet
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::Subnet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_subnet({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_subnet name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_subnet ::Google::Cloud::VmwareEngine::V1::GetSubnetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_subnet({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_subnet(::Google::Cloud::VmwareEngine::V1::GetSubnetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_subnet_client_stub.call_count
      end
    end
  end

  def test_update_subnet
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    subnet = {}

    update_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_subnet({ update_mask: update_mask, subnet: subnet }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_subnet update_mask: update_mask, subnet: subnet do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_subnet ::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_subnet({ update_mask: update_mask, subnet: subnet }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_subnet(::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_subnet_client_stub.call_count
      end
    end
  end

  def test_list_external_access_rules
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_external_access_rules_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_external_access_rules_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_external_access_rules_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_external_access_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_external_access_rules parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_external_access_rules ::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_external_access_rules({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_external_access_rules(::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_external_access_rules_client_stub.call_count
      end
    end
  end

  def test_get_external_access_rule
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ExternalAccessRule.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_external_access_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_external_access_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_external_access_rule_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_external_access_rule({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_external_access_rule name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_external_access_rule ::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_external_access_rule({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_external_access_rule(::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_external_access_rule_client_stub.call_count
      end
    end
  end

  def test_create_external_access_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    external_access_rule = {}
    external_access_rule_id = "hello world"
    request_id = "hello world"

    create_external_access_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_external_access_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_external_access_rule_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_external_access_rule({ parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_external_access_rule parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_external_access_rule ::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest.new(parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_external_access_rule({ parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_external_access_rule(::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest.new(parent: parent, external_access_rule: external_access_rule, external_access_rule_id: external_access_rule_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_external_access_rule_client_stub.call_count
      end
    end
  end

  def test_update_external_access_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    external_access_rule = {}
    request_id = "hello world"

    update_external_access_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_external_access_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_external_access_rule_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_external_access_rule({ update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_external_access_rule update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_external_access_rule ::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest.new(update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_external_access_rule({ update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_external_access_rule(::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest.new(update_mask: update_mask, external_access_rule: external_access_rule, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_external_access_rule_client_stub.call_count
      end
    end
  end

  def test_delete_external_access_rule
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_external_access_rule_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_external_access_rule_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_external_access_rule_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_external_access_rule({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_external_access_rule name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_external_access_rule ::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_external_access_rule({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_external_access_rule(::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_external_access_rule_client_stub.call_count
      end
    end
  end

  def test_list_logging_servers
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListLoggingServersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_logging_servers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_logging_servers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_logging_servers_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_logging_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_logging_servers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_logging_servers ::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_logging_servers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_logging_servers(::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_logging_servers_client_stub.call_count
      end
    end
  end

  def test_get_logging_server
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::LoggingServer.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_logging_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_logging_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_logging_server_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_logging_server({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_logging_server name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_logging_server ::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_logging_server({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_logging_server(::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_logging_server_client_stub.call_count
      end
    end
  end

  def test_create_logging_server
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    logging_server = {}
    logging_server_id = "hello world"
    request_id = "hello world"

    create_logging_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_logging_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_logging_server_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_logging_server({ parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_logging_server parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_logging_server ::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest.new(parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_logging_server({ parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_logging_server(::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest.new(parent: parent, logging_server: logging_server, logging_server_id: logging_server_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_logging_server_client_stub.call_count
      end
    end
  end

  def test_update_logging_server
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    logging_server = {}
    request_id = "hello world"

    update_logging_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_logging_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_logging_server_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_logging_server({ update_mask: update_mask, logging_server: logging_server, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_logging_server update_mask: update_mask, logging_server: logging_server, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_logging_server ::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest.new(update_mask: update_mask, logging_server: logging_server, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_logging_server({ update_mask: update_mask, logging_server: logging_server, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_logging_server(::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest.new(update_mask: update_mask, logging_server: logging_server, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_logging_server_client_stub.call_count
      end
    end
  end

  def test_delete_logging_server
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_logging_server_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_logging_server_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_logging_server_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_logging_server({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_logging_server name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_logging_server ::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_logging_server({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_logging_server(::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_logging_server_client_stub.call_count
      end
    end
  end

  def test_list_node_types
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListNodeTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_node_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_node_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_node_types_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_node_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_node_types parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_node_types ::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_node_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_node_types(::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_node_types_client_stub.call_count
      end
    end
  end

  def test_get_node_type
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::NodeType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_node_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_node_type_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_node_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_node_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_node_type ::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_node_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_node_type(::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_node_type_client_stub.call_count
      end
    end
  end

  def test_show_nsx_credentials
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::Credentials.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"

    show_nsx_credentials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_show_nsx_credentials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, show_nsx_credentials_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.show_nsx_credentials({ private_cloud: private_cloud }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.show_nsx_credentials private_cloud: private_cloud do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.show_nsx_credentials ::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest.new(private_cloud: private_cloud) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.show_nsx_credentials({ private_cloud: private_cloud }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.show_nsx_credentials(::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest.new(private_cloud: private_cloud), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, show_nsx_credentials_client_stub.call_count
      end
    end
  end

  def test_show_vcenter_credentials
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::Credentials.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"
    username = "hello world"

    show_vcenter_credentials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_show_vcenter_credentials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, show_vcenter_credentials_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.show_vcenter_credentials({ private_cloud: private_cloud, username: username }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.show_vcenter_credentials private_cloud: private_cloud, username: username do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.show_vcenter_credentials ::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest.new(private_cloud: private_cloud, username: username) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.show_vcenter_credentials({ private_cloud: private_cloud, username: username }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.show_vcenter_credentials(::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest.new(private_cloud: private_cloud, username: username), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, show_vcenter_credentials_client_stub.call_count
      end
    end
  end

  def test_reset_nsx_credentials
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"
    request_id = "hello world"

    reset_nsx_credentials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_reset_nsx_credentials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_nsx_credentials_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset_nsx_credentials({ private_cloud: private_cloud, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset_nsx_credentials private_cloud: private_cloud, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset_nsx_credentials ::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset_nsx_credentials({ private_cloud: private_cloud, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset_nsx_credentials(::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_nsx_credentials_client_stub.call_count
      end
    end
  end

  def test_reset_vcenter_credentials
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    private_cloud = "hello world"
    request_id = "hello world"
    username = "hello world"

    reset_vcenter_credentials_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_reset_vcenter_credentials_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_vcenter_credentials_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset_vcenter_credentials({ private_cloud: private_cloud, request_id: request_id, username: username }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset_vcenter_credentials private_cloud: private_cloud, request_id: request_id, username: username do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset_vcenter_credentials ::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id, username: username) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset_vcenter_credentials({ private_cloud: private_cloud, request_id: request_id, username: username }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset_vcenter_credentials(::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest.new(private_cloud: private_cloud, request_id: request_id, username: username), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_vcenter_credentials_client_stub.call_count
      end
    end
  end

  def test_get_dns_forwarding
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::DnsForwarding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dns_forwarding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_dns_forwarding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dns_forwarding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dns_forwarding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dns_forwarding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dns_forwarding ::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dns_forwarding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dns_forwarding(::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dns_forwarding_client_stub.call_count
      end
    end
  end

  def test_update_dns_forwarding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dns_forwarding = {}
    update_mask = {}
    request_id = "hello world"

    update_dns_forwarding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_dns_forwarding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dns_forwarding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dns_forwarding({ dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dns_forwarding dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dns_forwarding ::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest.new(dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dns_forwarding({ dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dns_forwarding(::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest.new(dns_forwarding: dns_forwarding, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dns_forwarding_client_stub.call_count
      end
    end
  end

  def test_get_network_peering
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::NetworkPeering.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_peering_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_network_peering_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_network_peering_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_network_peering({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_network_peering name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_network_peering ::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_network_peering({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_network_peering(::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_network_peering_client_stub.call_count
      end
    end
  end

  def test_list_network_peerings
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_network_peerings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_network_peerings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_network_peerings_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_network_peerings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_network_peerings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_network_peerings ::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_network_peerings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_network_peerings(::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_network_peerings_client_stub.call_count
      end
    end
  end

  def test_create_network_peering
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    network_peering_id = "hello world"
    network_peering = {}
    request_id = "hello world"

    create_network_peering_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_network_peering_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_network_peering_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_network_peering({ parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_network_peering parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_network_peering ::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest.new(parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_network_peering({ parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_network_peering(::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest.new(parent: parent, network_peering_id: network_peering_id, network_peering: network_peering, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_network_peering_client_stub.call_count
      end
    end
  end

  def test_delete_network_peering
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_network_peering_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_network_peering_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_network_peering_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_network_peering({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_network_peering name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_network_peering ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_network_peering({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_network_peering(::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_network_peering_client_stub.call_count
      end
    end
  end

  def test_update_network_peering
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    network_peering = {}
    update_mask = {}
    request_id = "hello world"

    update_network_peering_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_network_peering_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_network_peering_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_network_peering({ network_peering: network_peering, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_network_peering network_peering: network_peering, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_network_peering ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest.new(network_peering: network_peering, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_network_peering({ network_peering: network_peering, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_network_peering(::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest.new(network_peering: network_peering, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_network_peering_client_stub.call_count
      end
    end
  end

  def test_list_peering_routes
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_peering_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_peering_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_peering_routes_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_peering_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_peering_routes parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_peering_routes ::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_peering_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_peering_routes(::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_peering_routes_client_stub.call_count
      end
    end
  end

  def test_create_hcx_activation_key
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hcx_activation_key = {}
    hcx_activation_key_id = "hello world"
    request_id = "hello world"

    create_hcx_activation_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_hcx_activation_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_hcx_activation_key_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_hcx_activation_key({ parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_hcx_activation_key parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_hcx_activation_key ::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest.new(parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_hcx_activation_key({ parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_hcx_activation_key(::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest.new(parent: parent, hcx_activation_key: hcx_activation_key, hcx_activation_key_id: hcx_activation_key_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_hcx_activation_key_client_stub.call_count
      end
    end
  end

  def test_list_hcx_activation_keys
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_hcx_activation_keys_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_hcx_activation_keys_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_hcx_activation_keys_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_hcx_activation_keys({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_hcx_activation_keys parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_hcx_activation_keys ::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_hcx_activation_keys({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_hcx_activation_keys(::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_hcx_activation_keys_client_stub.call_count
      end
    end
  end

  def test_get_hcx_activation_key
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::HcxActivationKey.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hcx_activation_key_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_hcx_activation_key_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_hcx_activation_key_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_hcx_activation_key({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_hcx_activation_key name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_hcx_activation_key ::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_hcx_activation_key({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_hcx_activation_key(::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_hcx_activation_key_client_stub.call_count
      end
    end
  end

  def test_get_network_policy
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::NetworkPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_network_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_network_policy_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_network_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_network_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_network_policy ::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_network_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_network_policy(::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_network_policy_client_stub.call_count
      end
    end
  end

  def test_list_network_policies
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_network_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_network_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_network_policies_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_network_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_network_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_network_policies ::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_network_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_network_policies(::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_network_policies_client_stub.call_count
      end
    end
  end

  def test_create_network_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    network_policy_id = "hello world"
    network_policy = {}
    request_id = "hello world"

    create_network_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_network_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_network_policy_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_network_policy({ parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_network_policy parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_network_policy ::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest.new(parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_network_policy({ parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_network_policy(::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest.new(parent: parent, network_policy_id: network_policy_id, network_policy: network_policy, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_network_policy_client_stub.call_count
      end
    end
  end

  def test_update_network_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    network_policy = {}
    update_mask = {}
    request_id = "hello world"

    update_network_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_network_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_network_policy_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_network_policy({ network_policy: network_policy, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_network_policy network_policy: network_policy, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_network_policy ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest.new(network_policy: network_policy, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_network_policy({ network_policy: network_policy, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_network_policy(::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest.new(network_policy: network_policy, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_network_policy_client_stub.call_count
      end
    end
  end

  def test_delete_network_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_network_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_network_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_network_policy_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_network_policy({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_network_policy name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_network_policy ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_network_policy({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_network_policy(::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_network_policy_client_stub.call_count
      end
    end
  end

  def test_list_management_dns_zone_bindings
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_management_dns_zone_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_management_dns_zone_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_management_dns_zone_bindings_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_management_dns_zone_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_management_dns_zone_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_management_dns_zone_bindings ::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_management_dns_zone_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_management_dns_zone_bindings(::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_management_dns_zone_bindings_client_stub.call_count
      end
    end
  end

  def test_get_management_dns_zone_binding
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_management_dns_zone_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_management_dns_zone_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_management_dns_zone_binding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_management_dns_zone_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_management_dns_zone_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_management_dns_zone_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_management_dns_zone_binding_client_stub.call_count
      end
    end
  end

  def test_create_management_dns_zone_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    management_dns_zone_binding = {}
    management_dns_zone_binding_id = "hello world"
    request_id = "hello world"

    create_management_dns_zone_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_management_dns_zone_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_management_dns_zone_binding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_management_dns_zone_binding({ parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_management_dns_zone_binding parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest.new(parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_management_dns_zone_binding({ parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest.new(parent: parent, management_dns_zone_binding: management_dns_zone_binding, management_dns_zone_binding_id: management_dns_zone_binding_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_management_dns_zone_binding_client_stub.call_count
      end
    end
  end

  def test_update_management_dns_zone_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    management_dns_zone_binding = {}
    request_id = "hello world"

    update_management_dns_zone_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_management_dns_zone_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_management_dns_zone_binding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_management_dns_zone_binding({ update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_management_dns_zone_binding update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest.new(update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_management_dns_zone_binding({ update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest.new(update_mask: update_mask, management_dns_zone_binding: management_dns_zone_binding, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_management_dns_zone_binding_client_stub.call_count
      end
    end
  end

  def test_delete_management_dns_zone_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_management_dns_zone_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_management_dns_zone_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_management_dns_zone_binding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_management_dns_zone_binding({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_management_dns_zone_binding name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_management_dns_zone_binding({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_management_dns_zone_binding_client_stub.call_count
      end
    end
  end

  def test_repair_management_dns_zone_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    repair_management_dns_zone_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_repair_management_dns_zone_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, repair_management_dns_zone_binding_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.repair_management_dns_zone_binding({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.repair_management_dns_zone_binding name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.repair_management_dns_zone_binding ::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.repair_management_dns_zone_binding({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.repair_management_dns_zone_binding(::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, repair_management_dns_zone_binding_client_stub.call_count
      end
    end
  end

  def test_create_vmware_engine_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vmware_engine_network_id = "hello world"
    vmware_engine_network = {}
    request_id = "hello world"

    create_vmware_engine_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_vmware_engine_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_vmware_engine_network_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_vmware_engine_network({ parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_vmware_engine_network parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest.new(parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_vmware_engine_network({ parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest.new(parent: parent, vmware_engine_network_id: vmware_engine_network_id, vmware_engine_network: vmware_engine_network, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_vmware_engine_network_client_stub.call_count
      end
    end
  end

  def test_update_vmware_engine_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    vmware_engine_network = {}
    update_mask = {}
    request_id = "hello world"

    update_vmware_engine_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_vmware_engine_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_vmware_engine_network_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_vmware_engine_network({ vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_vmware_engine_network vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest.new(vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_vmware_engine_network({ vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest.new(vmware_engine_network: vmware_engine_network, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_vmware_engine_network_client_stub.call_count
      end
    end
  end

  def test_delete_vmware_engine_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    etag = "hello world"

    delete_vmware_engine_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_vmware_engine_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_vmware_engine_network_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_vmware_engine_network({ name: name, request_id: request_id, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_vmware_engine_network name: name, request_id: request_id, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest.new(name: name, request_id: request_id, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_vmware_engine_network({ name: name, request_id: request_id, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest.new(name: name, request_id: request_id, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_vmware_engine_network_client_stub.call_count
      end
    end
  end

  def test_get_vmware_engine_network
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vmware_engine_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_vmware_engine_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_vmware_engine_network_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_vmware_engine_network({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_vmware_engine_network name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_vmware_engine_network ::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_vmware_engine_network({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_vmware_engine_network(::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_vmware_engine_network_client_stub.call_count
      end
    end
  end

  def test_list_vmware_engine_networks
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_vmware_engine_networks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_vmware_engine_networks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_vmware_engine_networks_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_vmware_engine_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_vmware_engine_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_vmware_engine_networks ::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_vmware_engine_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_vmware_engine_networks(::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_vmware_engine_networks_client_stub.call_count
      end
    end
  end

  def test_create_private_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_connection_id = "hello world"
    private_connection = {}
    request_id = "hello world"

    create_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_create_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_private_connection parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_private_connection ::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_private_connection(::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_private_connection_client_stub.call_count
      end
    end
  end

  def test_get_private_connection
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::PrivateConnection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_private_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_private_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_private_connection ::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_private_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_private_connection(::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_private_connection_client_stub.call_count
      end
    end
  end

  def test_list_private_connections
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_private_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_private_connections_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_private_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_private_connections ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_private_connections(::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_private_connections_client_stub.call_count
      end
    end
  end

  def test_update_private_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    private_connection = {}
    update_mask = {}
    request_id = "hello world"

    update_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_update_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_private_connection({ private_connection: private_connection, update_mask: update_mask, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_private_connection private_connection: private_connection, update_mask: update_mask, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_private_connection ::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest.new(private_connection: private_connection, update_mask: update_mask, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_private_connection({ private_connection: private_connection, update_mask: update_mask, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_private_connection(::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest.new(private_connection: private_connection, update_mask: update_mask, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_private_connection_client_stub.call_count
      end
    end
  end

  def test_delete_private_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_delete_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_private_connection({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_private_connection name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_private_connection ::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_private_connection({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_private_connection(::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_private_connection_client_stub.call_count
      end
    end
  end

  def test_list_private_connection_peering_routes
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_private_connection_peering_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_list_private_connection_peering_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_private_connection_peering_routes_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_private_connection_peering_routes({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_private_connection_peering_routes parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_private_connection_peering_routes ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_private_connection_peering_routes({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_private_connection_peering_routes(::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_private_connection_peering_routes_client_stub.call_count
      end
    end
  end

  def test_grant_dns_bind_permission
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    principal = {}
    request_id = "hello world"

    grant_dns_bind_permission_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_grant_dns_bind_permission_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, grant_dns_bind_permission_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.grant_dns_bind_permission({ name: name, principal: principal, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.grant_dns_bind_permission name: name, principal: principal, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.grant_dns_bind_permission ::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.grant_dns_bind_permission({ name: name, principal: principal, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.grant_dns_bind_permission(::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, grant_dns_bind_permission_client_stub.call_count
      end
    end
  end

  def test_get_dns_bind_permission
    # Create test objects.
    client_result = ::Google::Cloud::VmwareEngine::V1::DnsBindPermission.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_dns_bind_permission_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_get_dns_bind_permission_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dns_bind_permission_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dns_bind_permission({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dns_bind_permission name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dns_bind_permission ::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dns_bind_permission({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dns_bind_permission(::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dns_bind_permission_client_stub.call_count
      end
    end
  end

  def test_revoke_dns_bind_permission
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    principal = {}
    request_id = "hello world"

    revoke_dns_bind_permission_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::ServiceStub.stub :transcode_revoke_dns_bind_permission_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, revoke_dns_bind_permission_client_stub do
        # Create client
        client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.revoke_dns_bind_permission({ name: name, principal: principal, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.revoke_dns_bind_permission name: name, principal: principal, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.revoke_dns_bind_permission ::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.revoke_dns_bind_permission({ name: name, principal: principal, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.revoke_dns_bind_permission(::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest.new(name: name, principal: principal, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, revoke_dns_bind_permission_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Rest::Client::Configuration, config
  end
end
