# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/vmware_engine/v1/vmware_engine"

class ::Google::Cloud::VmwareEngine::V1::VmwareEngine::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_cluster_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.cluster_path project: "value0", location: "value1", private_cloud: "value2", cluster: "value3"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/clusters/value3", path
    end
  end

  def test_dns_bind_permission_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dns_bind_permission_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/dnsBindPermission", path
    end
  end

  def test_dns_forwarding_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dns_forwarding_path project: "value0", location: "value1", private_cloud: "value2"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/dnsForwarding", path
    end
  end

  def test_external_access_rule_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.external_access_rule_path project: "value0", location: "value1", network_policy: "value2", external_access_rule: "value3"
      assert_equal "projects/value0/locations/value1/networkPolicies/value2/externalAccessRules/value3", path
    end
  end

  def test_external_address_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.external_address_path project: "value0", location: "value1", private_cloud: "value2", external_address: "value3"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/externalAddresses/value3", path
    end
  end

  def test_hcx_activation_key_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.hcx_activation_key_path project: "value0", location: "value1", private_cloud: "value2", hcx_activation_key: "value3"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/hcxActivationKeys/value3", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_logging_server_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.logging_server_path project: "value0", location: "value1", private_cloud: "value2", logging_server: "value3"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/loggingServers/value3", path
    end
  end

  def test_management_dns_zone_binding_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.management_dns_zone_binding_path project: "value0", location: "value1", private_cloud: "value2", management_dns_zone_binding: "value3"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/managementDnsZoneBindings/value3", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_network_peering_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_peering_path project: "value0", location: "value1", network_peering: "value2"
      assert_equal "projects/value0/locations/value1/networkPeerings/value2", path
    end
  end

  def test_network_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_policy_path project: "value0", location: "value1", network_policy: "value2"
      assert_equal "projects/value0/locations/value1/networkPolicies/value2", path
    end
  end

  def test_node_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.node_path project: "value0", location: "value1", private_cloud: "value2", cluster: "value3", node: "value4"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/clusters/value3/nodes/value4", path
    end
  end

  def test_node_type_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.node_type_path project: "value0", location: "value1", node_type: "value2"
      assert_equal "projects/value0/locations/value1/nodeTypes/value2", path
    end
  end

  def test_private_cloud_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.private_cloud_path project: "value0", location: "value1", private_cloud: "value2"
      assert_equal "projects/value0/locations/value1/privateClouds/value2", path
    end
  end

  def test_private_connection_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.private_connection_path project: "value0", location: "value1", private_connection: "value2"
      assert_equal "projects/value0/locations/value1/privateConnections/value2", path
    end
  end

  def test_subnet_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.subnet_path project: "value0", location: "value1", private_cloud: "value2", subnet: "value3"
      assert_equal "projects/value0/locations/value1/privateClouds/value2/subnets/value3", path
    end
  end

  def test_vmware_engine_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.vmware_engine_network_path project: "value0", location: "value1", vmware_engine_network: "value2"
      assert_equal "projects/value0/locations/value1/vmwareEngineNetworks/value2", path
    end
  end
end
