# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VmwareEngine
      module V1
        # Network configuration in the consumer project
        # with which the peering has to be done.
        # @!attribute [rw] management_cidr
        #   @return [::String]
        #     Required. Management CIDR used by VMware management appliances.
        # @!attribute [rw] vmware_engine_network
        #   @return [::String]
        #     Optional. The relative resource name of the VMware Engine network attached
        #     to the private cloud. Specify the name in the following form:
        #     `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        #     where `{project}` can either be a project number or a project ID.
        # @!attribute [r] vmware_engine_network_canonical
        #   @return [::String]
        #     Output only. The canonical name of the VMware Engine network in the form:
        #     `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        # @!attribute [r] management_ip_address_layout_version
        #   @return [::Integer]
        #     Output only. The IP address layout version of the management IP address
        #     range. Possible versions include:
        #     * `managementIpAddressLayoutVersion=1`: Indicates the legacy IP address
        #     layout used by some existing private clouds. This is no longer supported
        #     for new private clouds as it does not support all features.
        #     * `managementIpAddressLayoutVersion=2`: Indicates the latest IP address
        #     layout used by all newly created private clouds. This version supports all
        #     current features.
        # @!attribute [r] dns_server_ip
        #   @return [::String]
        #     Output only. DNS Server IP of the Private Cloud.
        #     All DNS queries can be forwarded to this address for name resolution of
        #     Private Cloud's management entities like vCenter, NSX-T Manager and
        #     ESXi hosts.
        class NetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the type and number of nodes associated with the cluster.
        # @!attribute [rw] node_count
        #   @return [::Integer]
        #     Required. The number of nodes of this type in the cluster
        # @!attribute [rw] custom_core_count
        #   @return [::Integer]
        #     Optional. Customized number of cores available to each node of the type.
        #     This number must always be one of `nodeType.availableCustomCoreCounts`.
        #     If zero is provided max value from `nodeType.availableCustomCoreCounts`
        #     will be used.
        class NodeTypeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of a stretched cluster.
        # @!attribute [rw] preferred_location
        #   @return [::String]
        #     Required. Zone that will remain operational when connection between the two
        #     zones is lost. Specify the resource name of a zone that belongs to the
        #     region of the private cloud. For example:
        #     `projects/{project}/locations/europe-west3-a` where `{project}` can either
        #     be a project number or a project ID.
        # @!attribute [rw] secondary_location
        #   @return [::String]
        #     Required. Additional zone for a higher level of availability and load
        #     balancing. Specify the resource name of a zone that belongs to the region
        #     of the private cloud. For example:
        #     `projects/{project}/locations/europe-west3-b` where `{project}` can either
        #     be a project number or a project ID.
        class StretchedClusterConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a private cloud resource. Private clouds of type `STANDARD` and
        # `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
        # regional.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this private cloud.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [r] delete_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the resource was scheduled for deletion.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the resource will be irreversibly deleted.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateCloud::State]
        #     Output only. State of the resource. New values may be added to this enum
        #     when appropriate.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkConfig]
        #     Required. Network configuration of the private cloud.
        # @!attribute [rw] management_cluster
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateCloud::ManagementCluster]
        #     Required. Input only. The management cluster for this private cloud.
        #     This field is required during creation of the private cloud to provide
        #     details for the default cluster.
        #
        #     The following fields can't be changed after private cloud creation:
        #     `ManagementCluster.clusterId`, `ManagementCluster.nodeTypeId`.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description for this private cloud.
        # @!attribute [r] hcx
        #   @return [::Google::Cloud::VmwareEngine::V1::Hcx]
        #     Output only. HCX appliance.
        # @!attribute [r] nsx
        #   @return [::Google::Cloud::VmwareEngine::V1::Nsx]
        #     Output only. NSX appliance.
        # @!attribute [r] vcenter
        #   @return [::Google::Cloud::VmwareEngine::V1::Vcenter]
        #     Output only. Vcenter appliance.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateCloud::Type]
        #     Optional. Type of the private cloud. Defaults to STANDARD.
        class PrivateCloud
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Management cluster configuration.
          # @!attribute [rw] cluster_id
          #   @return [::String]
          #     Required. The user-provided identifier of the new `Cluster`.
          #     The identifier must meet the following requirements:
          #
          #     * Only contains 1-63 alphanumeric characters and hyphens
          #     * Begins with an alphabetical character
          #     * Ends with a non-hyphen character
          #     * Not formatted as a UUID
          #     * Complies with [RFC
          #     1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
          # @!attribute [rw] node_type_configs
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::VmwareEngine::V1::NodeTypeConfig}]
          #     Required. The map of cluster node types in this cluster, where the key is
          #     canonical identifier of the node type (corresponds to the `NodeType`).
          # @!attribute [rw] stretched_cluster_config
          #   @return [::Google::Cloud::VmwareEngine::V1::StretchedClusterConfig]
          #     Optional. Configuration of a stretched cluster. Required for STRETCHED
          #     private clouds.
          class ManagementCluster
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::VmwareEngine::V1::NodeTypeConfig]
            class NodeTypeConfigsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Enum State defines possible states of private clouds.
          module State
            # The default value. This value should never be used.
            STATE_UNSPECIFIED = 0

            # The private cloud is ready.
            ACTIVE = 1

            # The private cloud is being created.
            CREATING = 2

            # The private cloud is being updated.
            UPDATING = 3

            # The private cloud is in failed state.
            FAILED = 5

            # The private cloud is scheduled for deletion. The deletion process can be
            # cancelled by using the corresponding undelete method.
            DELETED = 6

            # The private cloud is irreversibly deleted and is being removed from the
            # system.
            PURGING = 7
          end

          # Enum Type defines private cloud type.
          module Type
            # Standard private is a zonal resource, with 3+ nodes. Default type.
            STANDARD = 0

            # Time limited private cloud is a zonal resource, can have only 1 node and
            # has limited life span. Will be deleted after defined period of time,
            # can be converted into standard private cloud by expanding it up to 3
            # or more nodes.
            TIME_LIMITED = 1

            # Stretched private cloud is a regional resource with redundancy,
            # with a minimum of 6 nodes, nodes count has to be even.
            STRETCHED = 2
          end
        end

        # A cluster in a private cloud.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this cluster.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::Cluster::State]
        #     Output only. State of the resource.
        # @!attribute [r] management
        #   @return [::Boolean]
        #     Output only. True if the cluster is a management cluster; false otherwise.
        #     There can only be one management cluster in a private cloud
        #     and it has to be the first one.
        # @!attribute [rw] autoscaling_settings
        #   @return [::Google::Cloud::VmwareEngine::V1::AutoscalingSettings]
        #     Optional. Configuration of the autoscaling applied to this cluster.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] node_type_configs
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::VmwareEngine::V1::NodeTypeConfig}]
        #     Required. The map of cluster node types in this cluster, where the key is
        #     canonical identifier of the node type (corresponds to the `NodeType`).
        # @!attribute [rw] stretched_cluster_config
        #   @return [::Google::Cloud::VmwareEngine::V1::StretchedClusterConfig]
        #     Optional. Configuration of a stretched cluster. Required for clusters that
        #     belong to a STRETCHED private cloud.
        class Cluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::VmwareEngine::V1::NodeTypeConfig]
          class NodeTypeConfigsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enum State defines possible states of private cloud clusters.
          module State
            # The default value. This value should never be used.
            STATE_UNSPECIFIED = 0

            # The Cluster is operational and can be used by the user.
            ACTIVE = 1

            # The Cluster is being deployed.
            CREATING = 2

            # Adding or removing of a node to the cluster, any other cluster specific
            # updates.
            UPDATING = 3

            # The Cluster is being deleted.
            DELETING = 4

            # The Cluster is undergoing maintenance, for example: a failed node is
            # getting replaced.
            REPAIRING = 5
          end
        end

        # Node in a cluster.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this node.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster/nodes/my-node
        # @!attribute [r] fqdn
        #   @return [::String]
        #     Output only. Fully qualified domain name of the node.
        # @!attribute [r] internal_ip
        #   @return [::String]
        #     Output only. Internal IP address of the node.
        # @!attribute [r] node_type_id
        #   @return [::String]
        #     Output only. The canonical identifier of the node type (corresponds to the
        #     `NodeType`).
        #     For example: standard-72.
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. The version number of the VMware ESXi
        #     management component in this cluster.
        # @!attribute [r] custom_core_count
        #   @return [::Integer]
        #     Output only. Customized number of cores
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::Node::State]
        #     Output only. The state of the appliance.
        class Node
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum State defines possible states of a node in a cluster.
          module State
            # The default value. This value should never be used.
            STATE_UNSPECIFIED = 0

            # Node is operational and can be used by the user.
            ACTIVE = 1

            # Node is being provisioned.
            CREATING = 2

            # Node is in a failed state.
            FAILED = 3

            # Node is undergoing maintenance, e.g.: during private cloud upgrade.
            UPGRADING = 4
          end
        end

        # Represents an allocated external IP address and its corresponding internal IP
        # address in a private cloud.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this external IP address.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-address`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] internal_ip
        #   @return [::String]
        #     The internal IP address of a workload VM.
        # @!attribute [r] external_ip
        #   @return [::String]
        #     Output only. The external IP address of a workload VM.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAddress::State]
        #     Output only. The state of the resource.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description for this resource.
        class ExternalAddress
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum State defines possible states of external addresses.
          module State
            # The default value. This value should never be used.
            STATE_UNSPECIFIED = 0

            # The address is ready.
            ACTIVE = 1

            # The address is being created.
            CREATING = 2

            # The address is being updated.
            UPDATING = 3

            # The address is being deleted.
            DELETING = 4
          end
        end

        # Subnet in a private cloud. Either `management` subnets (such as vMotion) that
        # are read-only, or `userDefined`, which can also be updated.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this subnet.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
        # @!attribute [rw] ip_cidr_range
        #   @return [::String]
        #     The IP address range of the subnet in CIDR format '10.0.0.0/24'.
        # @!attribute [rw] gateway_ip
        #   @return [::String]
        #     The IP address of the gateway of this subnet.
        #     Must fall within the IP prefix defined above.
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. The type of the subnet. For example "management" or
        #     "userDefined".
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::Subnet::State]
        #     Output only. The state of the resource.
        # @!attribute [r] vlan_id
        #   @return [::Integer]
        #     Output only. VLAN ID of the VLAN on which the subnet is configured
        class Subnet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines possible states of subnets.
          module State
            # The default value. This value should never be used.
            STATE_UNSPECIFIED = 0

            # The subnet is ready.
            ACTIVE = 1

            # The subnet is being created.
            CREATING = 2

            # The subnet is being updated.
            UPDATING = 3

            # The subnet is being deleted.
            DELETING = 4

            # Changes requested in the last operation are being propagated.
            RECONCILING = 5

            # Last operation on the subnet did not succeed. Subnet's payload is
            # reverted back to its most recent working state.
            FAILED = 6
          end
        end

        # External access firewall rules for filtering incoming traffic destined to
        # `ExternalAddress` resources.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this external access rule.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description for this external access rule.
        # @!attribute [rw] priority
        #   @return [::Integer]
        #     External access rule priority, which determines the external access rule to
        #     use when multiple rules apply. If multiple rules have the same priority,
        #     their ordering is non-deterministic. If specific ordering is required,
        #     assign unique priorities to enforce such ordering. The external access rule
        #     priority is an integer from 100 to 4096, both inclusive. Lower integers
        #     indicate higher precedence. For example, a rule with priority `100` has
        #     higher precedence than a rule with priority `101`.
        # @!attribute [rw] action
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule::Action]
        #     The action that the external access rule performs.
        # @!attribute [rw] ip_protocol
        #   @return [::String]
        #     The IP protocol to which the external access rule applies. This value can
        #     be one of the following three protocol strings (not case-sensitive):
        #     `tcp`, `udp`, or `icmp`.
        # @!attribute [rw] source_ip_ranges
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::ExternalAccessRule::IpRange>]
        #     If source ranges are specified, the external access rule applies only to
        #     traffic that has a source IP address in these ranges. These ranges can
        #     either be expressed in the CIDR format or as an IP address. As only inbound
        #     rules are supported, `ExternalAddress` resources cannot be the source IP
        #     addresses of an external access rule. To match all source addresses,
        #     specify `0.0.0.0/0`.
        # @!attribute [rw] source_ports
        #   @return [::Array<::String>]
        #     A list of source ports to which the external access rule applies. This
        #     field is only applicable for the UDP or TCP protocol.
        #     Each entry must be either an integer or a range. For example: `["22"]`,
        #     `["80","443"]`, or `["12345-12349"]`. To match all source ports, specify
        #     `["0-65535"]`.
        # @!attribute [rw] destination_ip_ranges
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::ExternalAccessRule::IpRange>]
        #     If destination ranges are specified, the external access rule applies only
        #     to the traffic that has a destination IP address in these ranges. The
        #     specified IP addresses must have reserved external IP addresses in the
        #     scope of the parent network policy. To match all external IP addresses in
        #     the scope of the parent network policy, specify `0.0.0.0/0`. To match a
        #     specific external IP address, specify it using the
        #     `IpRange.external_address` property.
        # @!attribute [rw] destination_ports
        #   @return [::Array<::String>]
        #     A list of destination ports to which the external access rule applies. This
        #     field is only applicable for the UDP or TCP protocol.
        #     Each entry must be either an integer or a range. For example: `["22"]`,
        #     `["80","443"]`, or `["12345-12349"]`. To match all destination ports,
        #     specify `["0-65535"]`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule::State]
        #     Output only. The state of the resource.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        class ExternalAccessRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # An IP range provided in any one of the supported formats.
          # @!attribute [rw] ip_address
          #   @return [::String]
          #     A single IP address. For example: `10.0.0.5`.
          #
          #     Note: The following fields are mutually exclusive: `ip_address`, `ip_address_range`, `external_address`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] ip_address_range
          #   @return [::String]
          #     An IP address range in the CIDR format. For example: `10.0.0.0/24`.
          #
          #     Note: The following fields are mutually exclusive: `ip_address_range`, `ip_address`, `external_address`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] external_address
          #   @return [::String]
          #     The name of an `ExternalAddress` resource. The external address must
          #     have been reserved in the scope of this external access rule's parent
          #     network policy.  Provide the external address name in the form of
          #     `projects/{project}/locations/{location}/privateClouds/{private_cloud}/externalAddresses/{external_address}`.
          #     For example:
          #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-address`.
          #
          #     Note: The following fields are mutually exclusive: `external_address`, `ip_address`, `ip_address_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class IpRange
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Action determines whether the external access rule permits or blocks
          # traffic, subject to the other components of the rule matching the traffic.
          module Action
            # Defaults to allow.
            ACTION_UNSPECIFIED = 0

            # Allows connections that match the other specified components.
            ALLOW = 1

            # Blocks connections that match the other specified components.
            DENY = 2
          end

          # Defines possible states of external access firewall rules.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The rule is ready.
            ACTIVE = 1

            # The rule is being created.
            CREATING = 2

            # The rule is being updated.
            UPDATING = 3

            # The rule is being deleted.
            DELETING = 4
          end
        end

        # Logging server to receive vCenter or ESXi logs.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this logging server.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Fully-qualified domain name (FQDN) or IP Address of the logging
        #     server.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Required. Port number at which the logging server receives logs.
        # @!attribute [rw] protocol
        #   @return [::Google::Cloud::VmwareEngine::V1::LoggingServer::Protocol]
        #     Required. Protocol used by vCenter to send logs to a logging server.
        # @!attribute [rw] source_type
        #   @return [::Google::Cloud::VmwareEngine::V1::LoggingServer::SourceType]
        #     Required. The type of component that produces logs that will be forwarded
        #     to this logging server.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        class LoggingServer
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Defines possible protocols used to send logs to
          # a logging server.
          module Protocol
            # Unspecified communications protocol. This is the default value.
            PROTOCOL_UNSPECIFIED = 0

            # UDP
            UDP = 1

            # TCP
            TCP = 2

            # TLS
            TLS = 3

            # SSL
            SSL = 4

            # RELP
            RELP = 5
          end

          # Defines possible types of component that produces logs.
          module SourceType
            # The default value. This value should never be used.
            SOURCE_TYPE_UNSPECIFIED = 0

            # Logs produced by ESXI hosts
            ESXI = 1

            # Logs produced by vCenter server
            VCSA = 2
          end
        end

        # Describes node type.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this node type.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
        # @!attribute [r] node_type_id
        #   @return [::String]
        #     Output only. The canonical identifier of the node type
        #     (corresponds to the `NodeType`). For example: standard-72.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. The friendly name for this node type.
        #     For example: ve1-standard-72
        # @!attribute [r] virtual_cpu_count
        #   @return [::Integer]
        #     Output only. The total number of virtual CPUs in a single node.
        # @!attribute [r] total_core_count
        #   @return [::Integer]
        #     Output only. The total number of CPU cores in a single node.
        # @!attribute [r] memory_gb
        #   @return [::Integer]
        #     Output only. The amount of physical memory available, defined in GB.
        # @!attribute [r] disk_size_gb
        #   @return [::Integer]
        #     Output only. The amount of storage available, defined in GB.
        # @!attribute [r] available_custom_core_counts
        #   @return [::Array<::Integer>]
        #     Output only. List of possible values of custom core count.
        # @!attribute [r] kind
        #   @return [::Google::Cloud::VmwareEngine::V1::NodeType::Kind]
        #     Output only. The type of the resource.
        # @!attribute [r] families
        #   @return [::Array<::String>]
        #     Output only. Families of the node type.
        #     For node types to be in the same cluster
        #     they must share at least one element in the `families`.
        # @!attribute [r] capabilities
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::NodeType::Capability>]
        #     Output only. Capabilities of this node type.
        class NodeType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum Kind defines possible types of a NodeType.
          module Kind
            # The default value. This value should never be used.
            KIND_UNSPECIFIED = 0

            # Standard HCI node.
            STANDARD = 1

            # Storage only Node.
            STORAGE_ONLY = 2
          end

          # Capability of a node type.
          module Capability
            # The default value. This value is used if the capability is omitted or
            # unknown.
            CAPABILITY_UNSPECIFIED = 0

            # This node type supports stretch clusters.
            STRETCHED_CLUSTERS = 1
          end
        end

        # Credentials for a private cloud.
        # @!attribute [rw] username
        #   @return [::String]
        #     Initial username.
        # @!attribute [rw] password
        #   @return [::String]
        #     Initial password.
        class Credentials
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # HCX activation key. A default key is created during
        # private cloud provisioning, but this behavior is subject to change
        # and you should always verify active keys.
        # Use
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_hcx_activation_keys VmwareEngine.ListHcxActivationKeys}
        # to retrieve existing keys and
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_hcx_activation_key VmwareEngine.CreateHcxActivationKey}
        # to create new ones.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this HcxActivationKey.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of HCX activation key.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::HcxActivationKey::State]
        #     Output only. State of HCX activation key.
        # @!attribute [r] activation_key
        #   @return [::String]
        #     Output only. HCX activation key.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        class HcxActivationKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of HCX activation key
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # State of a newly generated activation key.
            AVAILABLE = 1

            # State of key when it has been used to activate HCX appliance.
            CONSUMED = 2

            # State of key when it is being created.
            CREATING = 3
          end
        end

        # Details about a HCX Cloud Manager appliance.
        # @!attribute [rw] internal_ip
        #   @return [::String]
        #     Internal IP address of the appliance.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the appliance.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::Hcx::State]
        #     Output only. The state of the appliance.
        # @!attribute [rw] fqdn
        #   @return [::String]
        #     Fully qualified domain name of the appliance.
        class Hcx
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the appliance
          module State
            # Unspecified appliance state. This is the default value.
            STATE_UNSPECIFIED = 0

            # The appliance is operational and can be used.
            ACTIVE = 1

            # The appliance is being deployed.
            CREATING = 2

            # The appliance is being activated.
            ACTIVATING = 3
          end
        end

        # Details about a NSX Manager appliance.
        # @!attribute [rw] internal_ip
        #   @return [::String]
        #     Internal IP address of the appliance.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the appliance.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::Nsx::State]
        #     Output only. The state of the appliance.
        # @!attribute [rw] fqdn
        #   @return [::String]
        #     Fully qualified domain name of the appliance.
        class Nsx
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the appliance
          module State
            # Unspecified appliance state. This is the default value.
            STATE_UNSPECIFIED = 0

            # The appliance is operational and can be used.
            ACTIVE = 1

            # The appliance is being deployed.
            CREATING = 2
          end
        end

        # Details about a vCenter Server management appliance.
        # @!attribute [rw] internal_ip
        #   @return [::String]
        #     Internal IP address of the appliance.
        # @!attribute [rw] version
        #   @return [::String]
        #     Version of the appliance.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::Vcenter::State]
        #     Output only. The state of the appliance.
        # @!attribute [rw] fqdn
        #   @return [::String]
        #     Fully qualified domain name of the appliance.
        class Vcenter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the appliance
          module State
            # Unspecified appliance state. This is the default value.
            STATE_UNSPECIFIED = 0

            # The appliance is operational and can be used.
            ACTIVE = 1

            # The appliance is being deployed.
            CREATING = 2
          end
        end

        # Autoscaling settings define the rules used by VMware Engine to
        # automatically scale-out and scale-in the clusters in a private cloud.
        # @!attribute [rw] autoscaling_policies
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::VmwareEngine::V1::AutoscalingSettings::AutoscalingPolicy}]
        #     Required. The map with autoscaling policies applied to the cluster.
        #     The key is the identifier of the policy.
        #     It must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC
        #     1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        #
        #     Currently there map must contain only one element
        #     that describes the autoscaling policy for compute nodes.
        # @!attribute [rw] min_cluster_node_count
        #   @return [::Integer]
        #     Optional. Minimum number of nodes of any type in a cluster.
        #     If not specified the default limits apply.
        # @!attribute [rw] max_cluster_node_count
        #   @return [::Integer]
        #     Optional. Maximum number of nodes of any type in a cluster.
        #     If not specified the default limits apply.
        # @!attribute [rw] cool_down_period
        #   @return [::Google::Protobuf::Duration]
        #     Optional. The minimum duration between consecutive autoscale operations.
        #     It starts once addition or removal of nodes is fully completed.
        #     Defaults to 30 minutes if not specified. Cool down period must be in whole
        #     minutes (for example, 30, 31, 50, 180 minutes).
        class AutoscalingSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Thresholds define the utilization of resources triggering
          # scale-out and scale-in operations.
          # @!attribute [rw] scale_out
          #   @return [::Integer]
          #     Required. The utilization triggering the scale-out operation in percent.
          # @!attribute [rw] scale_in
          #   @return [::Integer]
          #     Required. The utilization triggering the scale-in operation in percent.
          class Thresholds
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Autoscaling policy describes the behavior of the autoscaling
          # with respect to the resource utilization.
          # The scale-out operation is initiated if the utilization
          # exceeds ANY of the respective thresholds.
          # The scale-in operation is initiated if the utilization
          # is below ALL of the respective thresholds.
          # @!attribute [rw] node_type_id
          #   @return [::String]
          #     Required. The canonical identifier of the node type to add or remove.
          #     Corresponds to the `NodeType`.
          # @!attribute [rw] scale_out_size
          #   @return [::Integer]
          #     Required. Number of nodes to add to a cluster during a scale-out
          #     operation. Must be divisible by 2 for stretched clusters. During a
          #     scale-in operation only one node (or 2 for stretched clusters) are
          #     removed in a single iteration.
          # @!attribute [rw] cpu_thresholds
          #   @return [::Google::Cloud::VmwareEngine::V1::AutoscalingSettings::Thresholds]
          #     Optional. Utilization thresholds pertaining to CPU utilization.
          # @!attribute [rw] granted_memory_thresholds
          #   @return [::Google::Cloud::VmwareEngine::V1::AutoscalingSettings::Thresholds]
          #     Optional. Utilization thresholds pertaining to amount of granted memory.
          # @!attribute [rw] consumed_memory_thresholds
          #   @return [::Google::Cloud::VmwareEngine::V1::AutoscalingSettings::Thresholds]
          #     Optional. Utilization thresholds pertaining to amount of consumed memory.
          # @!attribute [rw] storage_thresholds
          #   @return [::Google::Cloud::VmwareEngine::V1::AutoscalingSettings::Thresholds]
          #     Optional. Utilization thresholds pertaining to amount of consumed
          #     storage.
          class AutoscalingPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::VmwareEngine::V1::AutoscalingSettings::AutoscalingPolicy]
          class AutoscalingPoliciesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # DNS forwarding config.
        # This config defines a list of domain to name server mappings,
        # and is attached to the private cloud for custom domain resolution.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this DNS profile.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] forwarding_rules
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::DnsForwarding::ForwardingRule>]
        #     Required. List of domain mappings to configure
        class DnsForwarding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A forwarding rule is a mapping of a `domain` to `name_servers`.
          # This mapping allows VMware Engine to resolve domains for attached private
          # clouds by forwarding DNS requests for a given domain to the specified
          # nameservers.
          # @!attribute [rw] domain
          #   @return [::String]
          #     Required. Domain used to resolve a `name_servers` list.
          # @!attribute [rw] name_servers
          #   @return [::Array<::String>]
          #     Required. List of DNS servers to use for domain resolution
          class ForwardingRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Details of a network peering.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the network peering. NetworkPeering is a
        #     global resource and location can only be global. Resource names are
        #     scheme-less URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/global/networkPeerings/my-peering`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] peer_network
        #   @return [::String]
        #     Required. The relative resource name of the network to peer with
        #     a standard VMware Engine network. The provided network can be a
        #     consumer VPC network or another standard VMware Engine network. If the
        #     `peer_network_type` is VMWARE_ENGINE_NETWORK, specify the name in the form:
        #     `projects/{project}/locations/global/vmwareEngineNetworks/{vmware_engine_network_id}`.
        #     Otherwise specify the name in the form:
        #     `projects/{project}/global/networks/{network_id}`, where
        #     `{project}` can either be a project number or a project ID.
        # @!attribute [rw] export_custom_routes
        #   @return [::Boolean]
        #     Optional. True if custom routes are exported to the peered network;
        #     false otherwise. The default value is true.
        # @!attribute [rw] import_custom_routes
        #   @return [::Boolean]
        #     Optional. True if custom routes are imported from the peered network;
        #     false otherwise. The default value is true.
        # @!attribute [rw] exchange_subnet_routes
        #   @return [::Boolean]
        #     Optional. True if full mesh connectivity is created and managed
        #     automatically between peered networks; false otherwise. Currently this
        #     field is always true because Google Compute Engine automatically creates
        #     and manages subnetwork routes between two VPC networks when peering state
        #     is 'ACTIVE'.
        # @!attribute [rw] export_custom_routes_with_public_ip
        #   @return [::Boolean]
        #     Optional. True if all subnet routes with a public IP address range are
        #     exported; false otherwise. The default value is true. IPv4 special-use
        #     ranges (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always
        #     exported to peers and are not controlled by this field.
        # @!attribute [rw] import_custom_routes_with_public_ip
        #   @return [::Boolean]
        #     Optional. True if all subnet routes with public IP address range are
        #     imported; false otherwise. The default value is true. IPv4 special-use
        #     ranges (https://en.wikipedia.org/wiki/IPv4#Special_addresses) are always
        #     imported to peers and are not controlled by this field.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPeering::State]
        #     Output only. State of the network peering. This field
        #     has a value of 'ACTIVE' when there's a matching configuration in the peer
        #     network. New values may be added to this enum when appropriate.
        # @!attribute [r] state_details
        #   @return [::String]
        #     Output only. Output Only. Details about the current state of the network
        #     peering.
        # @!attribute [rw] peer_mtu
        #   @return [::Integer]
        #     Optional. Maximum transmission unit (MTU) in bytes.
        #     The default value is `1500`. If a value of `0` is provided for this field,
        #     VMware Engine uses the default value instead.
        # @!attribute [rw] peer_network_type
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPeering::PeerNetworkType]
        #     Required. The type of the network to peer with the VMware Engine network.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] vmware_engine_network
        #   @return [::String]
        #     Required. The relative resource name of the VMware Engine network.
        #     Specify the name in the following form:
        #     `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        #     where `{project}` can either be a project number or a project ID.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-provided description for this network peering.
        class NetworkPeering
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of a network peering.
          module State
            # Unspecified network peering state. This is the default value.
            STATE_UNSPECIFIED = 0

            # The peering is not active.
            INACTIVE = 1

            # The peering is active.
            ACTIVE = 2

            # The peering is being created.
            CREATING = 3

            # The peering is being deleted.
            DELETING = 4
          end

          # Type or purpose of the network peering connection.
          module PeerNetworkType
            # Unspecified
            PEER_NETWORK_TYPE_UNSPECIFIED = 0

            # Peering connection used for connecting to another VPC network established
            # by the same user. For example, a peering connection to another VPC
            # network in the same project or to an on-premises network.
            STANDARD = 1

            # Peering connection used for connecting to another VMware Engine network.
            VMWARE_ENGINE_NETWORK = 2

            # Peering connection used for establishing [private services
            # access](https://cloud.google.com/vpc/docs/private-services-access).
            PRIVATE_SERVICES_ACCESS = 3

            # Peering connection used for connecting to NetApp Cloud Volumes.
            NETAPP_CLOUD_VOLUMES = 4

            # Peering connection used for connecting to third-party services. Most
            # third-party services require manual setup of reverse peering on the VPC
            # network associated with the third-party service.
            THIRD_PARTY_SERVICE = 5

            # Peering connection used for connecting to Dell PowerScale Filers
            DELL_POWERSCALE = 6

            # Peering connection used for connecting to Google Cloud NetApp Volumes.
            GOOGLE_CLOUD_NETAPP_VOLUMES = 7
          end
        end

        # Exchanged network peering route.
        # @!attribute [r] dest_range
        #   @return [::String]
        #     Output only. Destination range of the peering route in CIDR notation.
        # @!attribute [r] type
        #   @return [::Google::Cloud::VmwareEngine::V1::PeeringRoute::Type]
        #     Output only. Type of the route in the peer VPC network.
        # @!attribute [r] next_hop_region
        #   @return [::String]
        #     Output only. Region containing the next hop of the peering route. This
        #     field only applies to dynamic routes in the peer VPC network.
        # @!attribute [r] priority
        #   @return [::Integer]
        #     Output only. The priority of the peering route.
        # @!attribute [r] imported
        #   @return [::Boolean]
        #     Output only. True if the peering route has been imported from a peered
        #     VPC network; false otherwise. The import happens if the field
        #     `NetworkPeering.importCustomRoutes` is true for this network,
        #     `NetworkPeering.exportCustomRoutes` is true for the peer VPC network, and
        #     the import does not result in a route conflict.
        # @!attribute [r] direction
        #   @return [::Google::Cloud::VmwareEngine::V1::PeeringRoute::Direction]
        #     Output only. Direction of the routes exchanged with the peer network, from
        #     the VMware Engine network perspective:
        #
        #     * Routes of direction `INCOMING` are imported from the peer network.
        #     * Routes of direction `OUTGOING` are exported from the intranet VPC network
        #     of the VMware Engine network.
        class PeeringRoute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the peering route.
          module Type
            # Unspecified peering route type. This is the default value.
            TYPE_UNSPECIFIED = 0

            # Dynamic routes in the peer network.
            DYNAMIC_PEERING_ROUTE = 1

            # Static routes in the peer network.
            STATIC_PEERING_ROUTE = 2

            # Created, updated, and removed automatically by Google Cloud when subnets
            # are created, modified, or deleted in the peer network.
            SUBNET_PEERING_ROUTE = 3
          end

          # The direction of the exchanged routes.
          module Direction
            # Unspecified exchanged routes direction. This is default.
            DIRECTION_UNSPECIFIED = 0

            # Routes imported from the peer network.
            INCOMING = 1

            # Routes exported to the peer network.
            OUTGOING = 2
          end
        end

        # Represents a network policy resource. Network policies are regional
        # resources. You can use a network policy to enable or disable internet access
        # and external IP access. Network policies are associated with a VMware Engine
        # network, which might span across regions. For a given region, a network
        # policy applies to all private clouds in the VMware Engine network associated
        # with the policy.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this network policy.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] internet_access
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPolicy::NetworkService]
        #     Network service that allows VMware workloads to access the internet.
        # @!attribute [rw] external_ip
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPolicy::NetworkService]
        #     Network service that allows External IP addresses to be assigned to VMware
        #     workloads. This service can only be enabled when `internet_access` is also
        #     enabled.
        # @!attribute [rw] edge_services_cidr
        #   @return [::String]
        #     Required. IP address range in CIDR notation used to create internet access
        #     and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
        #     required. The range cannot overlap with any prefixes either in the consumer
        #     VPC network or in use by the private clouds attached to that VPC network.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] vmware_engine_network
        #   @return [::String]
        #     Optional. The relative resource name of the VMware Engine network.
        #     Specify the name in the following form:
        #     `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        #     where `{project}` can either be a project number or a project ID.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-provided description for this network policy.
        # @!attribute [r] vmware_engine_network_canonical
        #   @return [::String]
        #     Output only. The canonical name of the VMware Engine network in the form:
        #     `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        class NetworkPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a network service that is managed by a `NetworkPolicy` resource.
          # A network service provides a way to control an aspect of external access to
          # VMware workloads. For example, whether the VMware workloads in the
          # private clouds governed by a network policy can access or be accessed from
          # the internet.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     True if the service is enabled; false otherwise.
          # @!attribute [r] state
          #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPolicy::NetworkService::State]
          #     Output only. State of the service. New values may be added to this enum
          #     when appropriate.
          class NetworkService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum State defines possible states of a network policy controlled
            # service.
            module State
              # Unspecified service state. This is the default value.
              STATE_UNSPECIFIED = 0

              # Service is not provisioned.
              UNPROVISIONED = 1

              # Service is in the process of being provisioned/deprovisioned.
              RECONCILING = 2

              # Service is active.
              ACTIVE = 3
            end
          end
        end

        # Represents a binding between a network and the management DNS zone.
        # A management DNS zone is the Cloud DNS cross-project binding zone that
        # VMware Engine creates for each private cloud. It contains FQDNs and
        # corresponding IP addresses for the private cloud's ESXi hosts and management
        # VM appliances like vCenter and NSX Manager.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of this binding.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding::State]
        #     Output only. The state of the resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description for this resource.
        # @!attribute [rw] vpc_network
        #   @return [::String]
        #     Network to bind is a standard consumer VPC.
        #     Specify the name in the following form for consumer
        #     VPC network: `projects/{project}/global/networks/{network_id}`.
        #     `{project}` can either be a project number or a project ID.
        #
        #     Note: The following fields are mutually exclusive: `vpc_network`, `vmware_engine_network`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vmware_engine_network
        #   @return [::String]
        #     Network to bind is a VMware Engine network.
        #     Specify the name in the following form for VMware engine network:
        #     `projects/{project}/locations/global/vmwareEngineNetworks/{vmware_engine_network_id}`.
        #     `{project}` can either be a project number or a project ID.
        #
        #     Note: The following fields are mutually exclusive: `vmware_engine_network`, `vpc_network`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        class ManagementDnsZoneBinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum State defines possible states of binding between the consumer VPC
          # network and the management DNS zone.
          module State
            # The default value. This value should never be used.
            STATE_UNSPECIFIED = 0

            # The binding is ready.
            ACTIVE = 1

            # The binding is being created.
            CREATING = 2

            # The binding is being updated.
            UPDATING = 3

            # The binding is being deleted.
            DELETING = 4

            # The binding has failed.
            FAILED = 5
          end
        end

        # VMware Engine network resource that provides connectivity for VMware Engine
        # private clouds.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the VMware Engine network.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description for this VMware Engine network.
        # @!attribute [r] vpc_networks
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork::VpcNetwork>]
        #     Output only. VMware Engine service VPC networks that provide connectivity
        #     from a private cloud to customer projects, the internet, and other Google
        #     Cloud services.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork::State]
        #     Output only. State of the VMware Engine network.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork::Type]
        #     Required. VMware Engine network type.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Checksum that may be sent on update and delete requests to ensure that the
        #     user-provided value is up to date before the server processes a request.
        #     The server computes checksums based on the value of other fields in the
        #     request.
        class VmwareEngineNetwork
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a VMware Engine VPC network that is managed by a
          # VMware Engine network resource.
          # @!attribute [r] type
          #   @return [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork::VpcNetwork::Type]
          #     Output only. Type of VPC network (INTRANET, INTERNET, or
          #     GOOGLE_CLOUD)
          # @!attribute [r] network
          #   @return [::String]
          #     Output only. The relative resource name of the service VPC network this
          #     VMware Engine network is attached to. For example:
          #     `projects/123123/global/networks/my-network`
          class VpcNetwork
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Enum Type defines possible types of a VMware Engine network controlled
            # service.
            module Type
              # The default value. This value should never be used.
              TYPE_UNSPECIFIED = 0

              # VPC network that will be peered with a consumer VPC network or the
              # intranet VPC of another VMware Engine network. Access a private cloud
              # through Compute Engine VMs on a peered VPC network or an on-premises
              # resource connected to a peered consumer VPC network.
              INTRANET = 1

              # VPC network used for internet access to and from a private cloud.
              INTERNET = 2

              # VPC network used for access to Google Cloud services like
              # Cloud Storage.
              GOOGLE_CLOUD = 3
            end
          end

          # Enum State defines possible states of VMware Engine network.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The VMware Engine network is being created.
            CREATING = 1

            # The VMware Engine network is ready.
            ACTIVE = 2

            # The VMware Engine network is being updated.
            UPDATING = 3

            # The VMware Engine network is being deleted.
            DELETING = 4
          end

          # Enum Type defines possible types of VMware Engine network.
          module Type
            # The default value. This value should never be used.
            TYPE_UNSPECIFIED = 0

            # Network type used by private clouds created in projects without a network
            # of type `STANDARD`. This network type is no longer used for new VMware
            # Engine private cloud deployments.
            LEGACY = 1

            # Standard network type used for private cloud connectivity.
            STANDARD = 2
          end
        end

        # Private connection resource that provides connectivity for VMware Engine
        # private clouds.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the private connection.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateConnections/my-connection`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Creation time of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last update time of this resource.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. User-provided description for this private connection.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection::State]
        #     Output only. State of the private connection.
        # @!attribute [rw] vmware_engine_network
        #   @return [::String]
        #     Required. The relative resource name of Legacy VMware Engine network.
        #     Specify the name in the following form:
        #     `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        #     where `{project}`, `{location}` will be same as specified in private
        #     connection resource name and `{vmware_engine_network_id}` will be in the
        #     form of `{location}`-default e.g.
        #     projects/project/locations/us-central1/vmwareEngineNetworks/us-central1-default.
        # @!attribute [r] vmware_engine_network_canonical
        #   @return [::String]
        #     Output only. The canonical name of the VMware Engine network in the form:
        #     `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection::Type]
        #     Required. Private connection type.
        # @!attribute [r] peering_id
        #   @return [::String]
        #     Output only. VPC network peering id between given network VPC and
        #     VMwareEngineNetwork.
        # @!attribute [rw] routing_mode
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection::RoutingMode]
        #     Optional. Routing Mode.
        #     Default value is set to GLOBAL.
        #     For type = PRIVATE_SERVICE_ACCESS, this field can be set to GLOBAL or
        #     REGIONAL, for other types only GLOBAL is supported.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System-generated unique identifier for the resource.
        # @!attribute [rw] service_network
        #   @return [::String]
        #     Required. Service network to create private connection.
        #     Specify the name in the following form:
        #     `projects/{project}/global/networks/{network_id}`
        #     For type = PRIVATE_SERVICE_ACCESS, this field represents servicenetworking
        #     VPC, e.g. projects/project-tp/global/networks/servicenetworking.
        #     For type = NETAPP_CLOUD_VOLUME, this field represents NetApp service VPC,
        #     e.g. projects/project-tp/global/networks/netapp-tenant-vpc.
        #     For type = DELL_POWERSCALE, this field represent Dell service VPC, e.g.
        #     projects/project-tp/global/networks/dell-tenant-vpc.
        #     For type= THIRD_PARTY_SERVICE, this field could represent a consumer VPC or
        #     any other producer VPC to which the VMware Engine Network needs to be
        #     connected, e.g. projects/project/global/networks/vpc.
        # @!attribute [r] peering_state
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection::PeeringState]
        #     Output only. Peering state between service network and VMware Engine
        #     network.
        class PrivateConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum State defines possible states of private connection.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The private connection is being created.
            CREATING = 1

            # The private connection is ready.
            ACTIVE = 2

            # The private connection is being updated.
            UPDATING = 3

            # The private connection is being deleted.
            DELETING = 4

            # The private connection is not provisioned, since no private cloud is
            # present for which this private connection is needed.
            UNPROVISIONED = 5

            # The private connection is in failed state.
            FAILED = 6
          end

          # Enum Type defines possible types of private connection.
          module Type
            # The default value. This value should never be used.
            TYPE_UNSPECIFIED = 0

            # Connection used for establishing [private services
            # access](https://cloud.google.com/vpc/docs/private-services-access).
            PRIVATE_SERVICE_ACCESS = 1

            # Connection used for connecting to NetApp Cloud Volumes.
            NETAPP_CLOUD_VOLUMES = 2

            # Connection used for connecting to Dell PowerScale.
            DELL_POWERSCALE = 3

            # Connection used for connecting to third-party services.
            THIRD_PARTY_SERVICE = 4
          end

          # Possible types for RoutingMode
          module RoutingMode
            # The default value. This value should never be used.
            ROUTING_MODE_UNSPECIFIED = 0

            # Global Routing Mode
            GLOBAL = 1

            # Regional Routing Mode
            REGIONAL = 2
          end

          # Enum PeeringState defines the possible states of peering between service
          # network and the vpc network peered to service network
          module PeeringState
            # The default value. This value is used if the peering state is omitted or
            # unknown.
            PEERING_STATE_UNSPECIFIED = 0

            # The peering is in active state.
            PEERING_ACTIVE = 1

            # The peering is in inactive state.
            PEERING_INACTIVE = 2
          end
        end

        # VmwareEngine specific metadata for the given
        # [google.cloud.location.Location][google.cloud.location.Location]. It is
        # returned as a content of the `google.cloud.location.Location.metadata` field.
        # @!attribute [r] capabilities
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::LocationMetadata::Capability>]
        #     Output only. Capabilities of this location.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Capability of a location.
          module Capability
            # The default value. This value is used if the capability is omitted or
            # unknown.
            CAPABILITY_UNSPECIFIED = 0

            # Stretch clusters are supported in this location.
            STRETCHED_CLUSTERS = 1
          end
        end

        # DnsBindPermission resource that contains the accounts having the consumer DNS
        # bind permission on the corresponding intranet VPC of the consumer project.
        # @!attribute [r] name
        #   @return [::String]
        #     Required. Output only. The name of the resource which stores the
        #     users/service accounts having the permission to bind to the corresponding
        #     intranet VPC of the consumer project. DnsBindPermission is a global
        #     resource and location can only be global. Resource names are schemeless
        #     URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/global/dnsBindPermission`
        # @!attribute [r] principals
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::Principal>]
        #     Output only. Users/Service accounts which have access for binding on the
        #     intranet VPC project corresponding to the consumer project.
        class DnsBindPermission
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Users/Service accounts which have access for DNS binding on the intranet
        # VPC corresponding to the consumer project.
        # @!attribute [rw] user
        #   @return [::String]
        #     The user who needs to be granted permission.
        #
        #     Note: The following fields are mutually exclusive: `user`, `service_account`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account which needs to be granted the permission.
        #
        #     Note: The following fields are mutually exclusive: `service_account`, `user`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Principal
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
