# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VmwareEngine
      module V1
        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_private_clouds VmwareEngine.ListPrivateClouds}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to be queried for
        #     clusters. Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of private clouds to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListPrivateClouds` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListPrivateClouds` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison operator, and the
        #     value that you want to use for filtering. The value must be a string, a
        #     number, or a boolean. The comparison operator must be `=`, `!=`, `>`, or
        #     `<`.
        #
        #     For example, if you are filtering a list of private clouds, you can exclude
        #     the ones named `example-pc` by specifying `name != "example-pc"`.
        #
        #     You can also filter nested fields. For example, you could specify
        #     `networkConfig.managementCidr = "192.168.0.0/24"` to include private clouds
        #     only if they have a matching address in their network configuration.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-pc")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you can
        #     include `AND` and `OR` expressions explicitly. For example:
        #     ```
        #     (name = "private-cloud-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "private-cloud-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results are
        #     ordered by `name` in ascending order. You can also sort results in
        #     descending order based on the `name` value using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListPrivateCloudsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_private_clouds VmwareEngine.ListPrivateClouds}
        # @!attribute [rw] private_clouds
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::PrivateCloud>]
        #     A list of private clouds.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListPrivateCloudsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_private_cloud VmwareEngine.GetPrivateCloud}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the private cloud to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        class GetPrivateCloudRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_private_cloud VmwareEngine.CreatePrivateCloud}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to create the new
        #     private cloud in. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a`
        # @!attribute [rw] private_cloud_id
        #   @return [::String]
        #     Required. The user-provided identifier of the private cloud to be created.
        #     This identifier must be unique among each `PrivateCloud` within the parent
        #     and becomes the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] private_cloud
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateCloud]
        #     Required. The initial description of the new private cloud.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. True if you want the request to be validated and not executed;
        #     false otherwise.
        class CreatePrivateCloudRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_private_cloud VmwareEngine.UpdatePrivateCloud}
        # @!attribute [rw] private_cloud
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateCloud]
        #     Required. Private cloud description.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `PrivateCloud` resource by the update. The fields specified in `updateMask`
        #     are relative to the resource, not the full request. A field will be
        #     overwritten if it is in the mask. If the user does not provide a mask then
        #     all fields will be overwritten.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        class UpdatePrivateCloudRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_private_cloud VmwareEngine.DeletePrivateCloud}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the private cloud to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, cascade delete is enabled and all children of
        #     this private cloud resource are also deleted. When this flag is set to
        #     false, the private cloud will not be deleted if there are any children
        #     other than the management cluster. The management cluster is always
        #     deleted.
        # @!attribute [rw] delay_hours
        #   @return [::Integer]
        #     Optional. Time delay of the deletion specified in hours. The default value
        #     is `3`. Specifying a non-zero value for this field changes the value of
        #     `PrivateCloud.state` to `DELETED` and sets `expire_time` to the planned
        #     deletion time. Deletion can be cancelled before `expire_time` elapses using
        #     {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#undelete_private_cloud VmwareEngine.UndeletePrivateCloud}.
        #     Specifying a value of `0` for this field instead begins the deletion
        #     process and ceases billing immediately. During the final deletion process,
        #     the value of `PrivateCloud.state` becomes `PURGING`.
        class DeletePrivateCloudRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#undelete_private_cloud VmwareEngine.UndeletePrivateCloud}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the private cloud scheduled for deletion.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        class UndeletePrivateCloudRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_clusters VmwareEngine.ListClusters}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to query for clusters.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of clusters to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListClusters` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListClusters`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-cluster")
        #     (nodeCount = "3")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you can
        #     include `AND` and `OR` expressions explicitly. For example:
        #     ```
        #     (name = "example-cluster-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-cluster-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results are
        #     ordered by `name` in ascending order. You can also sort results in
        #     descending order based on the `name` value using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListClustersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_clusters VmwareEngine.ListClusters}
        # @!attribute [rw] clusters
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::Cluster>]
        #     A list of private cloud clusters.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListClustersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_cluster VmwareEngine.GetCluster}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The cluster resource name to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
        class GetClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_cluster VmwareEngine.CreateCluster}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to create a new cluster
        #     in. Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] cluster_id
        #   @return [::String]
        #     Required. The user-provided identifier of the new `Cluster`.
        #     This identifier must be unique among clusters within the parent and becomes
        #     the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::VmwareEngine::V1::Cluster]
        #     Required. The initial description of the new cluster.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. True if you want the request to be validated and not executed;
        #     false otherwise.
        class CreateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_cluster VmwareEngine.UpdateCluster}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Cluster` resource by the update. The fields specified in the `updateMask`
        #     are relative to the resource, not the full request. A field will be
        #     overwritten if it is in the mask. If the user does not provide a mask then
        #     all fields will be overwritten.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::VmwareEngine::V1::Cluster]
        #     Required. The description of the cluster.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that
        #     zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. True if you want the request to be validated and not executed;
        #     false otherwise.
        class UpdateClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_cluster VmwareEngine.DeleteCluster}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the cluster to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. The request ID must be a valid UUID with the exception that zero
        #     UUID is not supported (00000000-0000-0000-0000-000000000000).
        class DeleteClusterRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_nodes VmwareEngine.ListNodes}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the cluster to be queried for nodes.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of nodes to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListNodes` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListNodes` must match the call that provided the page
        #     token.
        class ListNodesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_nodes VmwareEngine.ListNodes}
        # @!attribute [rw] nodes
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::Node>]
        #     The nodes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListNodesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_node VmwareEngine.GetNode}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the node to retrieve.
        #     For example:
        #     `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}`
        class GetNodeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_external_addresses VmwareEngine.ListExternalAddresses}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to be queried for
        #     external IP addresses.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of external IP addresses to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListExternalAddresses` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListExternalAddresses` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of IP addresses, you can
        #     exclude the ones named `example-ip` by specifying
        #     `name != "example-ip"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-ip")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-ip-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-ip-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListExternalAddressesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_external_addresses VmwareEngine.ListExternalAddresses}
        # @!attribute [rw] external_addresses
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::ExternalAddress>]
        #     A list of external IP addresses.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListExternalAddressesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#fetch_network_policy_external_addresses VmwareEngine.FetchNetworkPolicyExternalAddresses}
        # @!attribute [rw] network_policy
        #   @return [::String]
        #     Required. The resource name of the network policy to query for assigned
        #     external IP addresses. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-policy`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of external IP addresses to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     `FetchNetworkPolicyExternalAddresses` call. Provide this to retrieve the
        #     subsequent page.
        #
        #     When paginating, all parameters provided to
        #     `FetchNetworkPolicyExternalAddresses`, except for `page_size` and
        #     `page_token`, must match the call that provided the page token.
        class FetchNetworkPolicyExternalAddressesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#fetch_network_policy_external_addresses VmwareEngine.FetchNetworkPolicyExternalAddresses}
        # @!attribute [rw] external_addresses
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::ExternalAddress>]
        #     A list of external IP addresses assigned to VMware workload VMs within the
        #     scope of the given network policy.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class FetchNetworkPolicyExternalAddressesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_external_address VmwareEngine.GetExternalAddress}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the external IP address to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
        class GetExternalAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_external_address VmwareEngine.CreateExternalAddress}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to create a new external IP address in.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] external_address
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAddress]
        #     Required. The initial description of a new external IP address.
        # @!attribute [rw] external_address_id
        #   @return [::String]
        #     Required. The user-provided identifier of the `ExternalAddress` to be
        #     created. This identifier must be unique among `ExternalAddress` resources
        #     within the parent and becomes the final token in the name URI. The
        #     identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateExternalAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_external_address VmwareEngine.UpdateExternalAddress}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `ExternalAddress` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] external_address
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAddress]
        #     Required. External IP address description.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateExternalAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_external_address VmwareEngine.DeleteExternalAddress}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the external IP address to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteExternalAddressRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_subnets VmwareEngine.ListSubnets}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to be queried for
        #     subnets.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of subnets to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListSubnetsRequest` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListSubnetsRequest` must match the call that provided the page token.
        class ListSubnetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_subnets VmwareEngine.ListSubnets}
        # @!attribute [rw] subnets
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::Subnet>]
        #     A list of subnets.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListSubnetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_subnet VmwareEngine.GetSubnet}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the subnet to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
        class GetSubnetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_subnet VmwareEngine.UpdateSubnet}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `Subnet` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] subnet
        #   @return [::Google::Cloud::VmwareEngine::V1::Subnet]
        #     Required. Subnet description.
        class UpdateSubnetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_external_access_rules VmwareEngine.ListExternalAccessRules}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the network policy to query for external
        #     access firewall rules. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-policy`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of external access rules to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListExternalAccessRulesRequest`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListExternalAccessRulesRequest` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of external access rules, you can
        #     exclude the ones named `example-rule` by specifying
        #     `name != "example-rule"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-rule")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-rule-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-rule-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListExternalAccessRulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_external_access_rules VmwareEngine.ListExternalAccessRules}
        # @!attribute [rw] external_access_rules
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::ExternalAccessRule>]
        #     A list of external access firewall rules.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListExternalAccessRulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_external_access_rule VmwareEngine.GetExternalAccessRule}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the external access firewall rule to
        #     retrieve. Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
        class GetExternalAccessRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_external_access_rule VmwareEngine.CreateExternalAccessRule}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the network policy
        #     to create a new external access firewall rule in.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-policy`
        # @!attribute [rw] external_access_rule
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule]
        #     Required. The initial description of a new external access rule.
        # @!attribute [rw] external_access_rule_id
        #   @return [::String]
        #     Required. The user-provided identifier of the `ExternalAccessRule` to be
        #     created. This identifier must be unique among `ExternalAccessRule`
        #     resources within the parent and becomes the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateExternalAccessRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_external_access_rule VmwareEngine.UpdateExternalAccessRule}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `ExternalAccessRule` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] external_access_rule
        #   @return [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule]
        #     Required. Description of the external access rule.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateExternalAccessRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_external_access_rule VmwareEngine.DeleteExternalAccessRule}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the external access firewall rule to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteExternalAccessRuleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_logging_servers VmwareEngine.ListLoggingServers}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to be queried for
        #     logging servers.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of logging servers to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListLoggingServersRequest` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListLoggingServersRequest` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of logging servers, you can
        #     exclude the ones named `example-server` by specifying
        #     `name != "example-server"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-server")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-server-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-server-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListLoggingServersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_logging_servers VmwareEngine.ListLoggingServers}
        # @!attribute [rw] logging_servers
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::LoggingServer>]
        #     A list of Logging Servers.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be send as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListLoggingServersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_logging_server VmwareEngine.GetLoggingServer}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Logging Server to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
        class GetLoggingServerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_logging_server VmwareEngine.CreateLoggingServer}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to create a new Logging Server in.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] logging_server
        #   @return [::Google::Cloud::VmwareEngine::V1::LoggingServer]
        #     Required. The initial description of a new logging server.
        # @!attribute [rw] logging_server_id
        #   @return [::String]
        #     Required. The user-provided identifier of the `LoggingServer` to be
        #     created. This identifier must be unique among `LoggingServer` resources
        #     within the parent and becomes the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateLoggingServerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_logging_server VmwareEngine.UpdateLoggingServer}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `LoggingServer` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] logging_server
        #   @return [::Google::Cloud::VmwareEngine::V1::LoggingServer]
        #     Required. Logging server description.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateLoggingServerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_logging_server VmwareEngine.DeleteLoggingServer}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the logging server to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteLoggingServerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. True if the user has requested cancellation
        #     of the operation; false otherwise.
        #     Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_node_types VmwareEngine.ListNodeTypes}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to be queried for node types.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of node types to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListNodeTypes` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListNodeTypes` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of node types, you can
        #     exclude the ones named `standard-72` by specifying
        #     `name != "standard-72"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "standard-72")
        #     (virtual_cpu_count > 2)
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "standard-96") AND
        #     (virtual_cpu_count > 2) OR
        #     (name = "standard-72")
        #     ```
        class ListNodeTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_node_types VmwareEngine.ListNodeTypes}
        # @!attribute [rw] node_types
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::NodeType>]
        #     A list of Node Types.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListNodeTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_node_type VmwareEngine.GetNodeType}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the node type to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
        class GetNodeTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#show_nsx_credentials VmwareEngine.ShowNsxCredentials}
        # @!attribute [rw] private_cloud
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to be queried for credentials.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        class ShowNsxCredentialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#show_vcenter_credentials VmwareEngine.ShowVcenterCredentials}
        # @!attribute [rw] private_cloud
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to be queried for credentials.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] username
        #   @return [::String]
        #     Optional. The username of the user to be queried for credentials.
        #     The default value of this field is CloudOwner@gve.local.
        #     The provided value must be one of the following:
        #     CloudOwner@gve.local,
        #     solution-user-01@gve.local,
        #     solution-user-02@gve.local,
        #     solution-user-03@gve.local,
        #     solution-user-04@gve.local,
        #     solution-user-05@gve.local,
        #     zertoadmin@gve.local.
        class ShowVcenterCredentialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#reset_nsx_credentials VmwareEngine.ResetNsxCredentials}
        # @!attribute [rw] private_cloud
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to reset credentials for.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class ResetNsxCredentialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#reset_vcenter_credentials VmwareEngine.ResetVcenterCredentials}
        # @!attribute [rw] private_cloud
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to reset credentials for.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] username
        #   @return [::String]
        #     Optional. The username of the user to be to reset the credentials.
        #     The default value of this field is CloudOwner@gve.local.
        #     The provided value should be one of the following:
        #     solution-user-01@gve.local,
        #     solution-user-02@gve.local,
        #     solution-user-03@gve.local,
        #     solution-user-04@gve.local,
        #     solution-user-05@gve.local,
        #     zertoadmin@gve.local.
        class ResetVcenterCredentialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_hcx_activation_keys VmwareEngine.ListHcxActivationKeys}
        # @!attribute [rw] hcx_activation_keys
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::HcxActivationKey>]
        #     List of HCX activation keys.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListHcxActivationKeysResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_hcx_activation_keys VmwareEngine.ListHcxActivationKeys}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to be queried for HCX activation keys.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateClouds/my-cloud`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of HCX activation keys to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListHcxActivationKeys` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListHcxActivationKeys` must match the call that provided the page
        #     token.
        class ListHcxActivationKeysRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [VmwareEngine.GetHcxActivationKeys][]
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the HCX activation key to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
        class GetHcxActivationKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_hcx_activation_key VmwareEngine.CreateHcxActivationKey}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to create the key for.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateClouds/my-cloud`
        # @!attribute [rw] hcx_activation_key
        #   @return [::Google::Cloud::VmwareEngine::V1::HcxActivationKey]
        #     Required. The initial description of a new HCX activation key. When
        #     creating a new key, this field must be an empty object.
        # @!attribute [rw] hcx_activation_key_id
        #   @return [::String]
        #     Required. The user-provided identifier of the `HcxActivationKey` to be
        #     created. This identifier must be unique among `HcxActivationKey` resources
        #     within the parent and becomes the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateHcxActivationKeyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_dns_forwarding VmwareEngine.GetDnsForwarding}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of a `DnsForwarding` to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`
        class GetDnsForwardingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_dns_forwarding VmwareEngine.UpdateDnsForwarding}
        # @!attribute [rw] dns_forwarding
        #   @return [::Google::Cloud::VmwareEngine::V1::DnsForwarding]
        #     Required. DnsForwarding config details.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `DnsForwarding` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateDnsForwardingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_network_peering VmwareEngine.CreateNetworkPeering}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to create the new network
        #     peering in. This value is always `global`, because `NetworkPeering` is a
        #     global resource. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example: `projects/my-project/locations/global`
        # @!attribute [rw] network_peering_id
        #   @return [::String]
        #     Required. The user-provided identifier of the new `NetworkPeering`.
        #     This identifier must be unique among `NetworkPeering` resources within the
        #     parent and becomes the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] network_peering
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPeering]
        #     Required. The initial description of the new network peering.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateNetworkPeeringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_network_peering VmwareEngine.DeleteNetworkPeering}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the network peering to be deleted.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/global/networkPeerings/my-peering`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteNetworkPeeringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_network_peering VmwareEngine.GetNetworkPeering}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the network peering to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/global/networkPeerings/my-peering`
        class GetNetworkPeeringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_network_peerings VmwareEngine.ListNetworkPeerings}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location (global) to query for
        #     network peerings. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example: `projects/my-project/locations/global`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of network peerings to return in one page.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListNetworkPeerings` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListNetworkPeerings` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of network peerings, you can
        #     exclude the ones named `example-peering` by specifying
        #     `name != "example-peering"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-peering")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-peering-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-peering-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListNetworkPeeringsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_network_peering VmwareEngine.UpdateNetworkPeering}
        # @!attribute [rw] network_peering
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPeering]
        #     Required. Network peering description.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `NetworkPeering` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateNetworkPeeringRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_network_peerings VmwareEngine.ListNetworkPeerings}
        # @!attribute [rw] network_peerings
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::NetworkPeering>]
        #     A list of network peerings.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListNetworkPeeringsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_peering_routes VmwareEngine.ListPeeringRoutes}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the network peering to retrieve peering
        #     routes from. Resource names are schemeless URIs that follow the conventions
        #     in https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/global/networkPeerings/my-peering`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of peering routes to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListPeeringRoutes` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListPeeringRoutes` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     Currently, only filtering on the `direction` field is supported. To return
        #     routes imported from the peer network, provide "direction=INCOMING". To
        #     return routes exported from the VMware Engine network, provide
        #     "direction=OUTGOING". Other filter expressions return an error.
        class ListPeeringRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_peering_routes VmwareEngine.ListPeeringRoutes}
        # @!attribute [rw] peering_routes
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::PeeringRoute>]
        #     A list of peering routes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListPeeringRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_network_policies VmwareEngine.ListNetworkPolicies}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location (region) to query for
        #     network policies. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example: `projects/my-project/locations/us-central1`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of network policies to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListNetworkPolicies` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListNetworkPolicies` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of network policies, you can
        #     exclude the ones named `example-policy` by specifying
        #     `name != "example-policy"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-policy")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-policy-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-policy-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListNetworkPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_network_policies VmwareEngine.ListNetworkPolicies}
        # @!attribute [rw] network_policies
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::NetworkPolicy>]
        #     A list of network policies.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be send as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListNetworkPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_network_policy VmwareEngine.GetNetworkPolicy}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the network policy to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
        class GetNetworkPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_network_policy VmwareEngine.UpdateNetworkPolicy}
        # @!attribute [rw] network_policy
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPolicy]
        #     Required. Network policy description.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `NetworkPolicy` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateNetworkPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_network_policy VmwareEngine.CreateNetworkPolicy}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location (region)
        #     to create the new network policy in.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #      `projects/my-project/locations/us-central1`
        # @!attribute [rw] network_policy_id
        #   @return [::String]
        #     Required. The user-provided identifier of the network policy to be created.
        #     This identifier must be unique within parent
        #     `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
        #     the final token in the name URI.
        #     The identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] network_policy
        #   @return [::Google::Cloud::VmwareEngine::V1::NetworkPolicy]
        #     Required. The network policy configuration to use in the request.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateNetworkPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_network_policy VmwareEngine.DeleteNetworkPolicy}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the network policy to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteNetworkPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_management_dns_zone_bindings VmwareEngine.ListManagementDnsZoneBindings}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud to be queried for
        #     management DNS zone bindings.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of management DNS zone bindings to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListManagementDnsZoneBindings`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListManagementDnsZoneBindings` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of Management DNS Zone Bindings,
        #     you can exclude the ones named `example-management-dns-zone-binding` by
        #     specifying `name != "example-management-dns-zone-binding"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-management-dns-zone-binding")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-management-dns-zone-binding-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-management-dns-zone-binding-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListManagementDnsZoneBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_management_dns_zone_bindings VmwareEngine.ListManagementDnsZoneBindings}
        # @!attribute [rw] management_dns_zone_bindings
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding>]
        #     A list of management DNS zone bindings.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached when making an aggregated query using
        #     wildcards.
        class ListManagementDnsZoneBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_management_dns_zone_binding VmwareEngine.GetManagementDnsZoneBinding}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the management DNS zone binding to
        #     retrieve. Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
        class GetManagementDnsZoneBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [VmwareEngine.CreateManagementDnsZoneBindings][]
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private cloud
        #     to create a new management DNS zone binding for.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
        # @!attribute [rw] management_dns_zone_binding
        #   @return [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding]
        #     Required. The initial values for a new management DNS zone binding.
        # @!attribute [rw] management_dns_zone_binding_id
        #   @return [::String]
        #     Required. The user-provided identifier of the `ManagementDnsZoneBinding`
        #     resource to be created. This identifier must be unique among
        #     `ManagementDnsZoneBinding` resources within the parent and becomes the
        #     final token in the name URI. The identifier must meet the following
        #     requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateManagementDnsZoneBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_management_dns_zone_binding VmwareEngine.UpdateManagementDnsZoneBinding}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `ManagementDnsZoneBinding` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] management_dns_zone_binding
        #   @return [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding]
        #     Required. New values to update the management DNS zone binding with.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateManagementDnsZoneBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_management_dns_zone_binding VmwareEngine.DeleteManagementDnsZoneBinding}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the management DNS zone binding to delete.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if the original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteManagementDnsZoneBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [VmwareEngine.RepairManagementDnsZoneBindings][]
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the management DNS zone binding to repair.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if the original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class RepairManagementDnsZoneBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_vmware_engine_network VmwareEngine.CreateVmwareEngineNetwork}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to create the new VMware Engine
        #     network in. A VMware Engine network of type
        #     `LEGACY` is a regional resource, and a VMware
        #     Engine network of type `STANDARD` is a global resource.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/global`
        # @!attribute [rw] vmware_engine_network_id
        #   @return [::String]
        #     Required. The user-provided identifier of the new VMware Engine network.
        #     This identifier must be unique among VMware Engine network resources
        #     within the parent and becomes the final token in the name URI. The
        #     identifier must meet the following requirements:
        #
        #     * For networks of type LEGACY, adheres to the format:
        #     `{region-id}-default`. Replace `{region-id}` with the region where you want
        #     to create the VMware Engine network. For example, "us-central1-default".
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] vmware_engine_network
        #   @return [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork]
        #     Required. The initial description of the new VMware Engine network.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateVmwareEngineNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_vmware_engine_network VmwareEngine.UpdateVmwareEngineNetwork}
        # @!attribute [rw] vmware_engine_network
        #   @return [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork]
        #     Required. VMware Engine network description.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     VMware Engine network resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten. Only the
        #     following fields can be updated: `description`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateVmwareEngineNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_vmware_engine_network VmwareEngine.DeleteVmwareEngineNetwork}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the VMware Engine network to be deleted.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Checksum used to ensure that the user-provided value is up to
        #     date before the server processes the request. The server compares provided
        #     checksum with the current checksum of the resource. If the user-provided
        #     value is out of date, this request returns an `ABORTED` error.
        class DeleteVmwareEngineNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_vmware_engine_network VmwareEngine.GetVmwareEngineNetwork}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the VMware Engine network to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
        class GetVmwareEngineNetworkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_vmware_engine_networks VmwareEngine.ListVmwareEngineNetworks}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to query for
        #     VMware Engine networks. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example: `projects/my-project/locations/global`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of results to return in one page.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListVmwareEngineNetworks` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListVmwareEngineNetworks` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of network peerings, you can
        #     exclude the ones named `example-network` by specifying
        #     `name != "example-network"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-network")
        #     (createTime > "2021-04-12T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-network-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-network-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListVmwareEngineNetworksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_vmware_engine_networks VmwareEngine.ListVmwareEngineNetworks}
        # @!attribute [rw] vmware_engine_networks
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork>]
        #     A list of VMware Engine networks.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListVmwareEngineNetworksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#create_private_connection VmwareEngine.CreatePrivateConnection}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to create the new private
        #     connection in. Private connection is a regional resource.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/us-central1`
        # @!attribute [rw] private_connection_id
        #   @return [::String]
        #     Required. The user-provided identifier of the new private connection.
        #     This identifier must be unique among private connection resources
        #     within the parent and becomes the final token in the name URI. The
        #     identifier must meet the following requirements:
        #
        #     * Only contains 1-63 alphanumeric characters and hyphens
        #     * Begins with an alphabetical character
        #     * Ends with a non-hyphen character
        #     * Not formatted as a UUID
        #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
        #     (section 3.5)
        # @!attribute [rw] private_connection
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection]
        #     Required. The initial description of the new private connection.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreatePrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_private_connection VmwareEngine.GetPrivateConnection}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the private connection to retrieve.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateConnections/my-connection`
        class GetPrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_private_connections VmwareEngine.ListPrivateConnections}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the location to query for
        #     private connections. Resource names are schemeless URIs that follow the
        #     conventions in https://cloud.google.com/apis/design/resource_names. For
        #     example: `projects/my-project/locations/us-central1`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of private connections to return in one page.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListPrivateConnections` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListPrivateConnections` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     A filter expression that matches resources returned in the response.
        #     The expression must specify the field name, a comparison
        #     operator, and the value that you want to use for filtering. The value
        #     must be a string, a number, or a boolean. The comparison operator
        #     must be `=`, `!=`, `>`, or `<`.
        #
        #     For example, if you are filtering a list of private connections, you can
        #     exclude the ones named `example-connection` by specifying
        #     `name != "example-connection"`.
        #
        #     To filter on multiple expressions, provide each separate expression within
        #     parentheses. For example:
        #     ```
        #     (name = "example-connection")
        #     (createTime > "2022-09-22T08:15:10.40Z")
        #     ```
        #
        #     By default, each expression is an `AND` expression. However, you
        #     can include `AND` and `OR` expressions explicitly.
        #     For example:
        #     ```
        #     (name = "example-connection-1") AND
        #     (createTime > "2021-04-12T08:15:10.40Z") OR
        #     (name = "example-connection-2")
        #     ```
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sorts list results by a certain order. By default, returned results
        #     are ordered by `name` in ascending order.
        #     You can also sort results in descending order based on the `name` value
        #     using `orderBy="name desc"`.
        #     Currently, only ordering by `name` is supported.
        class ListPrivateConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_private_connections VmwareEngine.ListPrivateConnections}
        # @!attribute [rw] private_connections
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::PrivateConnection>]
        #     A list of private connections.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unreachable resources.
        class ListPrivateConnectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#update_private_connection VmwareEngine.UpdatePrivateConnection}
        # @!attribute [rw] private_connection
        #   @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection]
        #     Required. Private connection description.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     `PrivateConnection` resource by the update.
        #     The fields specified in the `update_mask` are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdatePrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#delete_private_connection VmwareEngine.DeletePrivateConnection}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the private connection to be deleted.
        #     Resource names are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names.
        #     For example:
        #     `projects/my-project/locations/us-central1/privateConnections/my-connection`
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeletePrivateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_private_connection_peering_routes VmwareEngine.ListPrivateConnectionPeeringRoutes}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the private connection to retrieve peering
        #     routes from. Resource names are schemeless URIs that follow the conventions
        #     in https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/us-west1/privateConnections/my-connection`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of peering routes to return in one page.
        #     The service may return fewer than this value.
        #     The maximum value is coerced to 1000.
        #     The default value of this field is 500.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListPrivateConnectionPeeringRoutes`
        #     call. Provide this to retrieve the subsequent page. When paginating, all
        #     other parameters provided to `ListPrivateConnectionPeeringRoutes` must
        #     match the call that provided the page token.
        class ListPrivateConnectionPeeringRoutesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#list_private_connection_peering_routes VmwareEngine.ListPrivateConnectionPeeringRoutes}
        # @!attribute [rw] peering_routes
        #   @return [::Array<::Google::Cloud::VmwareEngine::V1::PeeringRoute>]
        #     A list of peering routes.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListPrivateConnectionPeeringRoutesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#grant_dns_bind_permission VmwareEngine.GrantDnsBindPermission}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource which stores the users/service accounts
        #     having the permission to bind to the corresponding intranet VPC of the
        #     consumer project. DnsBindPermission is a global resource. Resource names
        #     are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/global/dnsBindPermission`
        # @!attribute [rw] principal
        #   @return [::Google::Cloud::VmwareEngine::V1::Principal]
        #     Required. The consumer provided user/service account which needs to be
        #     granted permission to bind with the intranet VPC corresponding to the
        #     consumer project.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class GrantDnsBindPermissionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#revoke_dns_bind_permission VmwareEngine.RevokeDnsBindPermission}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource which stores the users/service accounts
        #     having the permission to bind to the corresponding intranet VPC of the
        #     consumer project. DnsBindPermission is a global resource. Resource names
        #     are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/global/dnsBindPermission`
        # @!attribute [rw] principal
        #   @return [::Google::Cloud::VmwareEngine::V1::Principal]
        #     Required. The consumer provided user/service account which needs to be
        #     granted permission to bind with the intranet VPC corresponding to the
        #     consumer project.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server guarantees that a
        #     request doesn't result in creation of duplicate commitments for at least 60
        #     minutes.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class RevokeDnsBindPermissionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#get_dns_bind_permission VmwareEngine.GetDnsBindPermission}
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the resource which stores the users/service accounts
        #     having the permission to bind to the corresponding intranet VPC of the
        #     consumer project. DnsBindPermission is a global resource. Resource names
        #     are schemeless URIs that follow the conventions in
        #     https://cloud.google.com/apis/design/resource_names. For example:
        #     `projects/my-project/locations/global/dnsBindPermission`
        class GetDnsBindPermissionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
