# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VmwareEngine
      module V1
        module VmwareEngine
          # Path helper methods for the VmwareEngine API.
          module Paths
            ##
            # Create a fully-qualified Cluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param cluster [String]
            #
            # @return [::String]
            def cluster_path project:, location:, private_cloud:, cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/clusters/#{cluster}"
            end

            ##
            # Create a fully-qualified DnsBindPermission resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/dnsBindPermission`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def dns_bind_permission_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}/dnsBindPermission"
            end

            ##
            # Create a fully-qualified DnsForwarding resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/dnsForwarding`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            #
            # @return [::String]
            def dns_forwarding_path project:, location:, private_cloud:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/dnsForwarding"
            end

            ##
            # Create a fully-qualified ExternalAccessRule resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/networkPolicies/{network_policy}/externalAccessRules/{external_access_rule}`
            #
            # @param project [String]
            # @param location [String]
            # @param network_policy [String]
            # @param external_access_rule [String]
            #
            # @return [::String]
            def external_access_rule_path project:, location:, network_policy:, external_access_rule:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "network_policy cannot contain /" if network_policy.to_s.include? "/"

              "projects/#{project}/locations/#{location}/networkPolicies/#{network_policy}/externalAccessRules/#{external_access_rule}"
            end

            ##
            # Create a fully-qualified ExternalAddress resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/externalAddresses/{external_address}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param external_address [String]
            #
            # @return [::String]
            def external_address_path project:, location:, private_cloud:, external_address:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/externalAddresses/#{external_address}"
            end

            ##
            # Create a fully-qualified HcxActivationKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/hcxActivationKeys/{hcx_activation_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param hcx_activation_key [String]
            #
            # @return [::String]
            def hcx_activation_key_path project:, location:, private_cloud:, hcx_activation_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/hcxActivationKeys/#{hcx_activation_key}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified LoggingServer resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/loggingServers/{logging_server}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param logging_server [String]
            #
            # @return [::String]
            def logging_server_path project:, location:, private_cloud:, logging_server:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/loggingServers/#{logging_server}"
            end

            ##
            # Create a fully-qualified ManagementDnsZoneBinding resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/managementDnsZoneBindings/{management_dns_zone_binding}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param management_dns_zone_binding [String]
            #
            # @return [::String]
            def management_dns_zone_binding_path project:, location:, private_cloud:, management_dns_zone_binding:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/managementDnsZoneBindings/#{management_dns_zone_binding}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/global/networks/{network}`
            #
            # @param project [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/global/networks/#{network}"
            end

            ##
            # Create a fully-qualified NetworkPeering resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/networkPeerings/{network_peering}`
            #
            # @param project [String]
            # @param location [String]
            # @param network_peering [String]
            #
            # @return [::String]
            def network_peering_path project:, location:, network_peering:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/networkPeerings/#{network_peering}"
            end

            ##
            # Create a fully-qualified NetworkPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/networkPolicies/{network_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param network_policy [String]
            #
            # @return [::String]
            def network_policy_path project:, location:, network_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/networkPolicies/#{network_policy}"
            end

            ##
            # Create a fully-qualified Node resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param cluster [String]
            # @param node [String]
            #
            # @return [::String]
            def node_path project:, location:, private_cloud:, cluster:, node:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/clusters/#{cluster}/nodes/#{node}"
            end

            ##
            # Create a fully-qualified NodeType resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/nodeTypes/{node_type}`
            #
            # @param project [String]
            # @param location [String]
            # @param node_type [String]
            #
            # @return [::String]
            def node_type_path project:, location:, node_type:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/nodeTypes/#{node_type}"
            end

            ##
            # Create a fully-qualified PrivateCloud resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            #
            # @return [::String]
            def private_cloud_path project:, location:, private_cloud:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}"
            end

            ##
            # Create a fully-qualified PrivateConnection resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateConnections/{private_connection}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_connection [String]
            #
            # @return [::String]
            def private_connection_path project:, location:, private_connection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateConnections/#{private_connection}"
            end

            ##
            # Create a fully-qualified Subnet resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/privateClouds/{private_cloud}/subnets/{subnet}`
            #
            # @param project [String]
            # @param location [String]
            # @param private_cloud [String]
            # @param subnet [String]
            #
            # @return [::String]
            def subnet_path project:, location:, private_cloud:, subnet:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "private_cloud cannot contain /" if private_cloud.to_s.include? "/"

              "projects/#{project}/locations/#{location}/privateClouds/#{private_cloud}/subnets/#{subnet}"
            end

            ##
            # Create a fully-qualified VmwareEngineNetwork resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network}`
            #
            # @param project [String]
            # @param location [String]
            # @param vmware_engine_network [String]
            #
            # @return [::String]
            def vmware_engine_network_path project:, location:, vmware_engine_network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/vmwareEngineNetworks/#{vmware_engine_network}"
            end

            extend self
          end
        end
      end
    end
  end
end
