# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/vmwareengine/v1/vmwareengine_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module VmwareEngine
      module V1
        module VmwareEngine
          ##
          # Client for the VmwareEngine service.
          #
          # VMwareEngine manages VMware's private clusters in the Cloud.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "vmwareengine.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :vmware_engine_stub

            ##
            # Configure the VmwareEngine Client class.
            #
            # See {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all VmwareEngine clients
            #   ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "VmwareEngine", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.timeout = 120.0

                default_config.rpcs.list_private_clouds.timeout = 120.0
                default_config.rpcs.list_private_clouds.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_private_cloud.timeout = 120.0
                default_config.rpcs.get_private_cloud.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_clusters.timeout = 120.0
                default_config.rpcs.list_clusters.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_cluster.timeout = 120.0
                default_config.rpcs.get_cluster.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_nodes.timeout = 120.0
                default_config.rpcs.list_nodes.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_node.timeout = 120.0
                default_config.rpcs.get_node.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_external_addresses.timeout = 120.0
                default_config.rpcs.list_external_addresses.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_external_address.timeout = 120.0
                default_config.rpcs.get_external_address.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_subnets.timeout = 120.0
                default_config.rpcs.list_subnets.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_subnet.timeout = 120.0
                default_config.rpcs.get_subnet.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_subnet.timeout = 60.0

                default_config.rpcs.list_external_access_rules.timeout = 120.0
                default_config.rpcs.list_external_access_rules.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_external_access_rule.timeout = 120.0
                default_config.rpcs.get_external_access_rule.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_logging_servers.timeout = 120.0
                default_config.rpcs.list_logging_servers.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_logging_server.timeout = 120.0
                default_config.rpcs.get_logging_server.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_node_types.timeout = 120.0
                default_config.rpcs.list_node_types.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_node_type.timeout = 120.0
                default_config.rpcs.get_node_type.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.show_nsx_credentials.timeout = 120.0
                default_config.rpcs.show_nsx_credentials.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.show_vcenter_credentials.timeout = 120.0
                default_config.rpcs.show_vcenter_credentials.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_dns_forwarding.timeout = 120.0
                default_config.rpcs.get_dns_forwarding.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_network_peering.timeout = 120.0
                default_config.rpcs.get_network_peering.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_network_peerings.timeout = 120.0
                default_config.rpcs.list_network_peerings.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_peering_routes.timeout = 120.0
                default_config.rpcs.list_peering_routes.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_hcx_activation_keys.timeout = 120.0
                default_config.rpcs.list_hcx_activation_keys.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_hcx_activation_key.timeout = 120.0
                default_config.rpcs.get_hcx_activation_key.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_network_policy.timeout = 120.0
                default_config.rpcs.get_network_policy.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_network_policies.timeout = 120.0
                default_config.rpcs.list_network_policies.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_management_dns_zone_bindings.timeout = 120.0
                default_config.rpcs.list_management_dns_zone_bindings.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_management_dns_zone_binding.timeout = 120.0
                default_config.rpcs.get_management_dns_zone_binding.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_vmware_engine_network.timeout = 120.0
                default_config.rpcs.get_vmware_engine_network.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_vmware_engine_networks.timeout = 120.0
                default_config.rpcs.list_vmware_engine_networks.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_private_connection.timeout = 120.0
                default_config.rpcs.get_private_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_private_connections.timeout = 120.0
                default_config.rpcs.list_private_connections.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_private_connection_peering_routes.timeout = 120.0
                default_config.rpcs.list_private_connection_peering_routes.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_dns_bind_permission.timeout = 120.0
                default_config.rpcs.get_dns_bind_permission.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the VmwareEngine Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @vmware_engine_stub.universe_domain
            end

            ##
            # Create a new VmwareEngine client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the VmwareEngine client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/vmwareengine/v1/vmwareengine_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @vmware_engine_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @vmware_engine_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @vmware_engine_stub.endpoint
                config.universe_domain = @vmware_engine_stub.universe_domain
                config.logger = @vmware_engine_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @vmware_engine_stub.endpoint
                config.universe_domain = @vmware_engine_stub.universe_domain
                config.logger = @vmware_engine_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::VmwareEngine::V1::VmwareEngine::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @vmware_engine_stub.logger
            end

            # Service calls

            ##
            # Lists `PrivateCloud` resources in a given project and location.
            #
            # @overload list_private_clouds(request, options = nil)
            #   Pass arguments to `list_private_clouds` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_private_clouds(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_private_clouds` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to be queried for
            #     clusters. Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a`
            #   @param page_size [::Integer]
            #     The maximum number of private clouds to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListPrivateClouds` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListPrivateClouds` must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison operator, and the
            #     value that you want to use for filtering. The value must be a string, a
            #     number, or a boolean. The comparison operator must be `=`, `!=`, `>`, or
            #     `<`.
            #
            #     For example, if you are filtering a list of private clouds, you can exclude
            #     the ones named `example-pc` by specifying `name != "example-pc"`.
            #
            #     You can also filter nested fields. For example, you could specify
            #     `networkConfig.managementCidr = "192.168.0.0/24"` to include private clouds
            #     only if they have a matching address in their network configuration.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-pc")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you can
            #     include `AND` and `OR` expressions explicitly. For example:
            #     ```
            #     (name = "private-cloud-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "private-cloud-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results are
            #     ordered by `name` in ascending order. You can also sort results in
            #     descending order based on the `name` value using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PrivateCloud>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PrivateCloud>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest.new
            #
            #   # Call the list_private_clouds method.
            #   result = client.list_private_clouds request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::PrivateCloud.
            #     p item
            #   end
            #
            def list_private_clouds request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListPrivateCloudsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_private_clouds.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_private_clouds.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_private_clouds.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_private_clouds, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_private_clouds, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `PrivateCloud` resource by its resource name.
            #
            # @overload get_private_cloud(request, options = nil)
            #   Pass arguments to `get_private_cloud` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_private_cloud(name: nil)
            #   Pass arguments to `get_private_cloud` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the private cloud to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::PrivateCloud]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::PrivateCloud]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest.new
            #
            #   # Call the get_private_cloud method.
            #   result = client.get_private_cloud request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::PrivateCloud.
            #   p result
            #
            def get_private_cloud request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetPrivateCloudRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_private_cloud.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_private_cloud.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_private_cloud.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_private_cloud, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new `PrivateCloud` resource in a given project and location.
            # Private clouds of type `STANDARD` and
            # `TIME_LIMITED` are zonal resources, `STRETCHED` private clouds are
            # regional.
            # Creating a private cloud also creates a [management
            # cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
            # for that private cloud.
            #
            # @overload create_private_cloud(request, options = nil)
            #   Pass arguments to `create_private_cloud` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_private_cloud(parent: nil, private_cloud_id: nil, private_cloud: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `create_private_cloud` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to create the new
            #     private cloud in. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a`
            #   @param private_cloud_id [::String]
            #     Required. The user-provided identifier of the private cloud to be created.
            #     This identifier must be unique among each `PrivateCloud` within the parent
            #     and becomes the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param private_cloud [::Google::Cloud::VmwareEngine::V1::PrivateCloud, ::Hash]
            #     Required. The initial description of the new private cloud.
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that zero
            #     UUID is not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. True if you want the request to be validated and not executed;
            #     false otherwise.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest.new
            #
            #   # Call the create_private_cloud method.
            #   result = client.create_private_cloud request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_private_cloud request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreatePrivateCloudRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_private_cloud.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_private_cloud.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_private_cloud.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_private_cloud, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a `PrivateCloud` resource. Only the following fields can be
            # updated: `description`.
            # Only fields specified in `updateMask` are applied.
            #
            # During operation processing, the resource is temporarily in the `ACTIVE`
            # state before the operation fully completes. For that period of time, you
            # can't update the resource. Use the operation status to determine when the
            # processing fully completes.
            #
            # @overload update_private_cloud(request, options = nil)
            #   Pass arguments to `update_private_cloud` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_private_cloud(private_cloud: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_private_cloud` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param private_cloud [::Google::Cloud::VmwareEngine::V1::PrivateCloud, ::Hash]
            #     Required. Private cloud description.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `PrivateCloud` resource by the update. The fields specified in `updateMask`
            #     are relative to the resource, not the full request. A field will be
            #     overwritten if it is in the mask. If the user does not provide a mask then
            #     all fields will be overwritten.
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that zero
            #     UUID is not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest.new
            #
            #   # Call the update_private_cloud method.
            #   result = client.update_private_cloud request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_private_cloud request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdatePrivateCloudRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_private_cloud.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.private_cloud&.name
                header_params["private_cloud.name"] = request.private_cloud.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_private_cloud.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_private_cloud.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_private_cloud, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Schedules a `PrivateCloud` resource for deletion.
            #
            # A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
            # set to `DELETED` and `expireTime` set to the time when deletion is final
            # and can no longer be reversed. The delete operation is marked as done
            # as soon as the `PrivateCloud` is successfully scheduled for deletion
            # (this also applies when `delayHours` is set to zero), and the operation is
            # not kept in pending state until `PrivateCloud` is purged.
            # `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
            # the `expireTime` elapses. When `expireTime` is reached, deletion is final
            # and all private cloud resources are irreversibly removed and billing stops.
            # During the final removal process, `PrivateCloud.state` is set to `PURGING`.
            # `PrivateCloud` can be polled using standard `GET` method for the whole
            # period of deletion and purging. It will not be returned only
            # when it is completely purged.
            #
            # @overload delete_private_cloud(request, options = nil)
            #   Pass arguments to `delete_private_cloud` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_private_cloud(name: nil, request_id: nil, force: nil, delay_hours: nil)
            #   Pass arguments to `delete_private_cloud` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the private cloud to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that zero
            #     UUID is not supported (00000000-0000-0000-0000-000000000000).
            #   @param force [::Boolean]
            #     Optional. If set to true, cascade delete is enabled and all children of
            #     this private cloud resource are also deleted. When this flag is set to
            #     false, the private cloud will not be deleted if there are any children
            #     other than the management cluster. The management cluster is always
            #     deleted.
            #   @param delay_hours [::Integer]
            #     Optional. Time delay of the deletion specified in hours. The default value
            #     is `3`. Specifying a non-zero value for this field changes the value of
            #     `PrivateCloud.state` to `DELETED` and sets `expire_time` to the planned
            #     deletion time. Deletion can be cancelled before `expire_time` elapses using
            #     {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client#undelete_private_cloud VmwareEngine.UndeletePrivateCloud}.
            #     Specifying a value of `0` for this field instead begins the deletion
            #     process and ceases billing immediately. During the final deletion process,
            #     the value of `PrivateCloud.state` becomes `PURGING`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest.new
            #
            #   # Call the delete_private_cloud method.
            #   result = client.delete_private_cloud request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_private_cloud request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeletePrivateCloudRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_private_cloud.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_private_cloud.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_private_cloud.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_private_cloud, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Restores a private cloud that was previously scheduled for deletion by
            # `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
            # `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
            # the time when deletion can no longer be reversed.
            #
            # @overload undelete_private_cloud(request, options = nil)
            #   Pass arguments to `undelete_private_cloud` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undelete_private_cloud(name: nil, request_id: nil)
            #   Pass arguments to `undelete_private_cloud` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the private cloud scheduled for deletion.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that zero
            #     UUID is not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest.new
            #
            #   # Call the undelete_private_cloud method.
            #   result = client.undelete_private_cloud request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undelete_private_cloud request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UndeletePrivateCloudRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undelete_private_cloud.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undelete_private_cloud.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undelete_private_cloud.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :undelete_private_cloud, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `Cluster` resources in a given private cloud.
            #
            # @overload list_clusters(request, options = nil)
            #   Pass arguments to `list_clusters` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to query for clusters.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param page_size [::Integer]
            #     The maximum number of clusters to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListClusters` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListClusters`
            #     must match the call that provided the page token.
            #   @param filter [::String]
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-cluster")
            #     (nodeCount = "3")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you can
            #     include `AND` and `OR` expressions explicitly. For example:
            #     ```
            #     (name = "example-cluster-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-cluster-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results are
            #     ordered by `name` in ascending order. You can also sort results in
            #     descending order based on the `name` value using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::Cluster>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::Cluster>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListClustersRequest.new
            #
            #   # Call the list_clusters method.
            #   result = client.list_clusters request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::Cluster.
            #     p item
            #   end
            #
            def list_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_clusters, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_clusters, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `Cluster` resource by its resource name.
            #
            # @overload get_cluster(request, options = nil)
            #   Pass arguments to `get_cluster` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_cluster(name: nil)
            #   Pass arguments to `get_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The cluster resource name to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::Cluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::Cluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetClusterRequest.new
            #
            #   # Call the get_cluster method.
            #   result = client.get_cluster request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::Cluster.
            #   p result
            #
            def get_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new cluster in a given private cloud.
            # Creating a new cluster provides additional nodes for
            # use in the parent private cloud and requires sufficient [node
            # quota](https://cloud.google.com/vmware-engine/quotas).
            #
            # @overload create_cluster(request, options = nil)
            #   Pass arguments to `create_cluster` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_cluster(parent: nil, cluster_id: nil, cluster: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `create_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to create a new cluster
            #     in. Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param cluster_id [::String]
            #     Required. The user-provided identifier of the new `Cluster`.
            #     This identifier must be unique among clusters within the parent and becomes
            #     the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param cluster [::Google::Cloud::VmwareEngine::V1::Cluster, ::Hash]
            #     Required. The initial description of the new cluster.
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that zero
            #     UUID is not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. True if you want the request to be validated and not executed;
            #     false otherwise.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateClusterRequest.new
            #
            #   # Call the create_cluster method.
            #   result = client.create_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a `Cluster` resource. Only fields specified in `updateMask` are
            # applied.
            #
            # During operation processing, the resource is temporarily in the `ACTIVE`
            # state before the operation fully completes. For that period of time, you
            # can't update the resource. Use the operation status to determine when the
            # processing fully completes.
            #
            # @overload update_cluster(request, options = nil)
            #   Pass arguments to `update_cluster` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_cluster(update_mask: nil, cluster: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `update_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `Cluster` resource by the update. The fields specified in the `updateMask`
            #     are relative to the resource, not the full request. A field will be
            #     overwritten if it is in the mask. If the user does not provide a mask then
            #     all fields will be overwritten.
            #   @param cluster [::Google::Cloud::VmwareEngine::V1::Cluster, ::Hash]
            #     Required. The description of the cluster.
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that
            #     zero UUID is not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. True if you want the request to be validated and not executed;
            #     false otherwise.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateClusterRequest.new
            #
            #   # Call the update_cluster method.
            #   result = client.update_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.cluster&.name
                header_params["cluster.name"] = request.cluster.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
            # gracefully shut down any workloads running on the cluster before deletion.
            # You cannot delete the management cluster of a private cloud using this
            # method.
            #
            # @overload delete_cluster(request, options = nil)
            #   Pass arguments to `delete_cluster` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_cluster(name: nil, request_id: nil)
            #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the cluster to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
            #   @param request_id [::String]
            #     Optional. The request ID must be a valid UUID with the exception that zero
            #     UUID is not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteClusterRequest.new
            #
            #   # Call the delete_cluster method.
            #   result = client.delete_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists nodes in a given cluster.
            #
            # @overload list_nodes(request, options = nil)
            #   Pass arguments to `list_nodes` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListNodesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListNodesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_nodes(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_nodes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the cluster to be queried for nodes.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
            #   @param page_size [::Integer]
            #     The maximum number of nodes to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListNodes` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListNodes` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::Node>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::Node>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListNodesRequest.new
            #
            #   # Call the list_nodes method.
            #   result = client.list_nodes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::Node.
            #     p item
            #   end
            #
            def list_nodes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListNodesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_nodes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_nodes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_nodes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_nodes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_nodes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single node.
            #
            # @overload get_node(request, options = nil)
            #   Pass arguments to `get_node` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetNodeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetNodeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_node(name: nil)
            #   Pass arguments to `get_node` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the node to retrieve.
            #     For example:
            #     `projects/{project}/locations/{location}/privateClouds/{private_cloud}/clusters/{cluster}/nodes/{node}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::Node]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::Node]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetNodeRequest.new
            #
            #   # Call the get_node method.
            #   result = client.get_node request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::Node.
            #   p result
            #
            def get_node request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetNodeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_node.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_node.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_node.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_node, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists external IP addresses assigned to VMware workload VMs in a given
            # private cloud.
            #
            # @overload list_external_addresses(request, options = nil)
            #   Pass arguments to `list_external_addresses` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_external_addresses(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_external_addresses` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to be queried for
            #     external IP addresses.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param page_size [::Integer]
            #     The maximum number of external IP addresses to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListExternalAddresses` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListExternalAddresses` must match the call that provided the page token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of IP addresses, you can
            #     exclude the ones named `example-ip` by specifying
            #     `name != "example-ip"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-ip")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-ip-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-ip-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ExternalAddress>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ExternalAddress>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest.new
            #
            #   # Call the list_external_addresses method.
            #   result = client.list_external_addresses request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::ExternalAddress.
            #     p item
            #   end
            #
            def list_external_addresses request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListExternalAddressesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_external_addresses.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_external_addresses.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_external_addresses.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_external_addresses, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_external_addresses, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists external IP addresses assigned to VMware workload VMs within the
            # scope of the given network policy.
            #
            # @overload fetch_network_policy_external_addresses(request, options = nil)
            #   Pass arguments to `fetch_network_policy_external_addresses` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_network_policy_external_addresses(network_policy: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_network_policy_external_addresses` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param network_policy [::String]
            #     Required. The resource name of the network policy to query for assigned
            #     external IP addresses. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-policy`
            #   @param page_size [::Integer]
            #     The maximum number of external IP addresses to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous
            #     `FetchNetworkPolicyExternalAddresses` call. Provide this to retrieve the
            #     subsequent page.
            #
            #     When paginating, all parameters provided to
            #     `FetchNetworkPolicyExternalAddresses`, except for `page_size` and
            #     `page_token`, must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ExternalAddress>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ExternalAddress>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest.new
            #
            #   # Call the fetch_network_policy_external_addresses method.
            #   result = client.fetch_network_policy_external_addresses request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::ExternalAddress.
            #     p item
            #   end
            #
            def fetch_network_policy_external_addresses request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::FetchNetworkPolicyExternalAddressesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_network_policy_external_addresses.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.network_policy
                header_params["network_policy"] = request.network_policy
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_network_policy_external_addresses.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_network_policy_external_addresses.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :fetch_network_policy_external_addresses, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :fetch_network_policy_external_addresses, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single external IP address.
            #
            # @overload get_external_address(request, options = nil)
            #   Pass arguments to `get_external_address` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_external_address(name: nil)
            #   Pass arguments to `get_external_address` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the external IP address to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::ExternalAddress]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::ExternalAddress]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest.new
            #
            #   # Call the get_external_address method.
            #   result = client.get_external_address request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::ExternalAddress.
            #   p result
            #
            def get_external_address request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetExternalAddressRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_external_address.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_external_address.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_external_address.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_external_address, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new `ExternalAddress` resource in a given private cloud. The
            # network policy that corresponds to the private cloud must have the external
            # IP address network service enabled (`NetworkPolicy.external_ip`).
            #
            # @overload create_external_address(request, options = nil)
            #   Pass arguments to `create_external_address` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_external_address(parent: nil, external_address: nil, external_address_id: nil, request_id: nil)
            #   Pass arguments to `create_external_address` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud
            #     to create a new external IP address in.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param external_address [::Google::Cloud::VmwareEngine::V1::ExternalAddress, ::Hash]
            #     Required. The initial description of a new external IP address.
            #   @param external_address_id [::String]
            #     Required. The user-provided identifier of the `ExternalAddress` to be
            #     created. This identifier must be unique among `ExternalAddress` resources
            #     within the parent and becomes the final token in the name URI. The
            #     identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest.new
            #
            #   # Call the create_external_address method.
            #   result = client.create_external_address request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_external_address request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateExternalAddressRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_external_address.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_external_address.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_external_address.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_external_address, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single external IP address.
            # Only fields specified in `update_mask` are applied.
            #
            # During operation processing, the resource is temporarily in the `ACTIVE`
            # state before the operation fully completes. For that period of time, you
            # can't update the resource. Use the operation status to determine when the
            # processing fully completes.
            #
            # @overload update_external_address(request, options = nil)
            #   Pass arguments to `update_external_address` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_external_address(update_mask: nil, external_address: nil, request_id: nil)
            #   Pass arguments to `update_external_address` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `ExternalAddress` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param external_address [::Google::Cloud::VmwareEngine::V1::ExternalAddress, ::Hash]
            #     Required. External IP address description.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest.new
            #
            #   # Call the update_external_address method.
            #   result = client.update_external_address request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_external_address request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateExternalAddressRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_external_address.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.external_address&.name
                header_params["external_address.name"] = request.external_address.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_external_address.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_external_address.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_external_address, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single external IP address. When you delete an external IP
            # address, connectivity between the external IP address and the corresponding
            # internal IP address is lost.
            #
            # @overload delete_external_address(request, options = nil)
            #   Pass arguments to `delete_external_address` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_external_address(name: nil, request_id: nil)
            #   Pass arguments to `delete_external_address` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the external IP address to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/externalAddresses/my-ip`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if the original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest.new
            #
            #   # Call the delete_external_address method.
            #   result = client.delete_external_address request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_external_address request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteExternalAddressRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_external_address.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_external_address.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_external_address.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_external_address, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists subnets in a given private cloud.
            #
            # @overload list_subnets(request, options = nil)
            #   Pass arguments to `list_subnets` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_subnets(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_subnets` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to be queried for
            #     subnets.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param page_size [::Integer]
            #     The maximum number of subnets to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListSubnetsRequest` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListSubnetsRequest` must match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::Subnet>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::Subnet>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListSubnetsRequest.new
            #
            #   # Call the list_subnets method.
            #   result = client.list_subnets request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::Subnet.
            #     p item
            #   end
            #
            def list_subnets request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListSubnetsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_subnets.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_subnets.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_subnets.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_subnets, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_subnets, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single subnet.
            #
            # @overload get_subnet(request, options = nil)
            #   Pass arguments to `get_subnet` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetSubnetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetSubnetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_subnet(name: nil)
            #   Pass arguments to `get_subnet` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the subnet to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::Subnet]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::Subnet]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetSubnetRequest.new
            #
            #   # Call the get_subnet method.
            #   result = client.get_subnet request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::Subnet.
            #   p result
            #
            def get_subnet request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetSubnetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_subnet.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_subnet.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_subnet.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_subnet, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single subnet. Only fields specified in
            # `update_mask` are applied.
            #
            # *Note*: This API is synchronous and always returns a successful
            # `google.longrunning.Operation` (LRO). The returned LRO will only have
            # `done` and `response` fields.
            #
            # @overload update_subnet(request, options = nil)
            #   Pass arguments to `update_subnet` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_subnet(update_mask: nil, subnet: nil)
            #   Pass arguments to `update_subnet` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `Subnet` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param subnet [::Google::Cloud::VmwareEngine::V1::Subnet, ::Hash]
            #     Required. Subnet description.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest.new
            #
            #   # Call the update_subnet method.
            #   result = client.update_subnet request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_subnet request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateSubnetRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_subnet.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.subnet&.name
                header_params["subnet.name"] = request.subnet.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_subnet.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_subnet.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_subnet, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `ExternalAccessRule` resources in the specified network policy.
            #
            # @overload list_external_access_rules(request, options = nil)
            #   Pass arguments to `list_external_access_rules` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_external_access_rules(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_external_access_rules` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the network policy to query for external
            #     access firewall rules. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-policy`
            #   @param page_size [::Integer]
            #     The maximum number of external access rules to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListExternalAccessRulesRequest`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListExternalAccessRulesRequest` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of external access rules, you can
            #     exclude the ones named `example-rule` by specifying
            #     `name != "example-rule"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-rule")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-rule-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-rule-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ExternalAccessRule>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ExternalAccessRule>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest.new
            #
            #   # Call the list_external_access_rules method.
            #   result = client.list_external_access_rules request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::ExternalAccessRule.
            #     p item
            #   end
            #
            def list_external_access_rules request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListExternalAccessRulesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_external_access_rules.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_external_access_rules.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_external_access_rules.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_external_access_rules, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_external_access_rules, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single external access rule.
            #
            # @overload get_external_access_rule(request, options = nil)
            #   Pass arguments to `get_external_access_rule` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_external_access_rule(name: nil)
            #   Pass arguments to `get_external_access_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the external access firewall rule to
            #     retrieve. Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest.new
            #
            #   # Call the get_external_access_rule method.
            #   result = client.get_external_access_rule request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::ExternalAccessRule.
            #   p result
            #
            def get_external_access_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetExternalAccessRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_external_access_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_external_access_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_external_access_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_external_access_rule, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new external access rule in a given network policy.
            #
            # @overload create_external_access_rule(request, options = nil)
            #   Pass arguments to `create_external_access_rule` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_external_access_rule(parent: nil, external_access_rule: nil, external_access_rule_id: nil, request_id: nil)
            #   Pass arguments to `create_external_access_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the network policy
            #     to create a new external access firewall rule in.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-policy`
            #   @param external_access_rule [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule, ::Hash]
            #     Required. The initial description of a new external access rule.
            #   @param external_access_rule_id [::String]
            #     Required. The user-provided identifier of the `ExternalAccessRule` to be
            #     created. This identifier must be unique among `ExternalAccessRule`
            #     resources within the parent and becomes the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param request_id [::String]
            #     A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest.new
            #
            #   # Call the create_external_access_rule method.
            #   result = client.create_external_access_rule request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_external_access_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateExternalAccessRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_external_access_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_external_access_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_external_access_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_external_access_rule, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single external access rule.
            # Only fields specified in `update_mask` are applied.
            #
            # @overload update_external_access_rule(request, options = nil)
            #   Pass arguments to `update_external_access_rule` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_external_access_rule(update_mask: nil, external_access_rule: nil, request_id: nil)
            #   Pass arguments to `update_external_access_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `ExternalAccessRule` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param external_access_rule [::Google::Cloud::VmwareEngine::V1::ExternalAccessRule, ::Hash]
            #     Required. Description of the external access rule.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest.new
            #
            #   # Call the update_external_access_rule method.
            #   result = client.update_external_access_rule request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_external_access_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateExternalAccessRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_external_access_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.external_access_rule&.name
                header_params["external_access_rule.name"] = request.external_access_rule.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_external_access_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_external_access_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_external_access_rule, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single external access rule.
            #
            # @overload delete_external_access_rule(request, options = nil)
            #   Pass arguments to `delete_external_access_rule` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_external_access_rule(name: nil, request_id: nil)
            #   Pass arguments to `delete_external_access_rule` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the external access firewall rule to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-policy/externalAccessRules/my-rule`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if the original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest.new
            #
            #   # Call the delete_external_access_rule method.
            #   result = client.delete_external_access_rule request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_external_access_rule request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteExternalAccessRuleRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_external_access_rule.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_external_access_rule.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_external_access_rule.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_external_access_rule, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists logging servers configured for a given private
            # cloud.
            #
            # @overload list_logging_servers(request, options = nil)
            #   Pass arguments to `list_logging_servers` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_logging_servers(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_logging_servers` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to be queried for
            #     logging servers.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param page_size [::Integer]
            #     The maximum number of logging servers to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListLoggingServersRequest` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListLoggingServersRequest` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of logging servers, you can
            #     exclude the ones named `example-server` by specifying
            #     `name != "example-server"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-server")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-server-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-server-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::LoggingServer>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::LoggingServer>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest.new
            #
            #   # Call the list_logging_servers method.
            #   result = client.list_logging_servers request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::LoggingServer.
            #     p item
            #   end
            #
            def list_logging_servers request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListLoggingServersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_logging_servers.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_logging_servers.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_logging_servers.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_logging_servers, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_logging_servers, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a logging server.
            #
            # @overload get_logging_server(request, options = nil)
            #   Pass arguments to `get_logging_server` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_logging_server(name: nil)
            #   Pass arguments to `get_logging_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the Logging Server to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::LoggingServer]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::LoggingServer]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest.new
            #
            #   # Call the get_logging_server method.
            #   result = client.get_logging_server request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::LoggingServer.
            #   p result
            #
            def get_logging_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetLoggingServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_logging_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_logging_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_logging_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_logging_server, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new logging server for a given private cloud.
            #
            # @overload create_logging_server(request, options = nil)
            #   Pass arguments to `create_logging_server` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_logging_server(parent: nil, logging_server: nil, logging_server_id: nil, request_id: nil)
            #   Pass arguments to `create_logging_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud
            #     to create a new Logging Server in.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param logging_server [::Google::Cloud::VmwareEngine::V1::LoggingServer, ::Hash]
            #     Required. The initial description of a new logging server.
            #   @param logging_server_id [::String]
            #     Required. The user-provided identifier of the `LoggingServer` to be
            #     created. This identifier must be unique among `LoggingServer` resources
            #     within the parent and becomes the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest.new
            #
            #   # Call the create_logging_server method.
            #   result = client.create_logging_server request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_logging_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateLoggingServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_logging_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_logging_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_logging_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_logging_server, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single logging server.
            # Only fields specified in `update_mask` are applied.
            #
            # @overload update_logging_server(request, options = nil)
            #   Pass arguments to `update_logging_server` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_logging_server(update_mask: nil, logging_server: nil, request_id: nil)
            #   Pass arguments to `update_logging_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `LoggingServer` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param logging_server [::Google::Cloud::VmwareEngine::V1::LoggingServer, ::Hash]
            #     Required. Logging server description.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest.new
            #
            #   # Call the update_logging_server method.
            #   result = client.update_logging_server request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_logging_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateLoggingServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_logging_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.logging_server&.name
                header_params["logging_server.name"] = request.logging_server.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_logging_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_logging_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_logging_server, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single logging server.
            #
            # @overload delete_logging_server(request, options = nil)
            #   Pass arguments to `delete_logging_server` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_logging_server(name: nil, request_id: nil)
            #   Pass arguments to `delete_logging_server` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the logging server to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/loggingServers/my-logging-server`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest.new
            #
            #   # Call the delete_logging_server method.
            #   result = client.delete_logging_server request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_logging_server request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteLoggingServerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_logging_server.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_logging_server.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_logging_server.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_logging_server, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists node types
            #
            # @overload list_node_types(request, options = nil)
            #   Pass arguments to `list_node_types` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_node_types(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_node_types` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to be queried for node types.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a`
            #   @param page_size [::Integer]
            #     The maximum number of node types to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListNodeTypes` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListNodeTypes` must match the call that provided the page token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of node types, you can
            #     exclude the ones named `standard-72` by specifying
            #     `name != "standard-72"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "standard-72")
            #     (virtual_cpu_count > 2)
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "standard-96") AND
            #     (virtual_cpu_count > 2) OR
            #     (name = "standard-72")
            #     ```
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::NodeType>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::NodeType>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest.new
            #
            #   # Call the list_node_types method.
            #   result = client.list_node_types request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::NodeType.
            #     p item
            #   end
            #
            def list_node_types request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListNodeTypesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_node_types.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_node_types.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_node_types.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_node_types, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_node_types, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single `NodeType`.
            #
            # @overload get_node_type(request, options = nil)
            #   Pass arguments to `get_node_type` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_node_type(name: nil)
            #   Pass arguments to `get_node_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the node type to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::NodeType]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::NodeType]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest.new
            #
            #   # Call the get_node_type method.
            #   result = client.get_node_type request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::NodeType.
            #   p result
            #
            def get_node_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetNodeTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_node_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_node_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_node_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_node_type, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of credentials for NSX appliance.
            #
            # @overload show_nsx_credentials(request, options = nil)
            #   Pass arguments to `show_nsx_credentials` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload show_nsx_credentials(private_cloud: nil)
            #   Pass arguments to `show_nsx_credentials` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param private_cloud [::String]
            #     Required. The resource name of the private cloud
            #     to be queried for credentials.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::Credentials]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::Credentials]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest.new
            #
            #   # Call the show_nsx_credentials method.
            #   result = client.show_nsx_credentials request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::Credentials.
            #   p result
            #
            def show_nsx_credentials request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ShowNsxCredentialsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.show_nsx_credentials.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.private_cloud
                header_params["private_cloud"] = request.private_cloud
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.show_nsx_credentials.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.show_nsx_credentials.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :show_nsx_credentials, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of credentials for Vcenter appliance.
            #
            # @overload show_vcenter_credentials(request, options = nil)
            #   Pass arguments to `show_vcenter_credentials` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload show_vcenter_credentials(private_cloud: nil, username: nil)
            #   Pass arguments to `show_vcenter_credentials` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param private_cloud [::String]
            #     Required. The resource name of the private cloud
            #     to be queried for credentials.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param username [::String]
            #     Optional. The username of the user to be queried for credentials.
            #     The default value of this field is CloudOwner@gve.local.
            #     The provided value must be one of the following:
            #     CloudOwner@gve.local,
            #     solution-user-01@gve.local,
            #     solution-user-02@gve.local,
            #     solution-user-03@gve.local,
            #     solution-user-04@gve.local,
            #     solution-user-05@gve.local,
            #     zertoadmin@gve.local.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::Credentials]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::Credentials]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest.new
            #
            #   # Call the show_vcenter_credentials method.
            #   result = client.show_vcenter_credentials request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::Credentials.
            #   p result
            #
            def show_vcenter_credentials request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ShowVcenterCredentialsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.show_vcenter_credentials.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.private_cloud
                header_params["private_cloud"] = request.private_cloud
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.show_vcenter_credentials.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.show_vcenter_credentials.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :show_vcenter_credentials, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resets credentials of the NSX appliance.
            #
            # @overload reset_nsx_credentials(request, options = nil)
            #   Pass arguments to `reset_nsx_credentials` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reset_nsx_credentials(private_cloud: nil, request_id: nil)
            #   Pass arguments to `reset_nsx_credentials` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param private_cloud [::String]
            #     Required. The resource name of the private cloud
            #     to reset credentials for.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest.new
            #
            #   # Call the reset_nsx_credentials method.
            #   result = client.reset_nsx_credentials request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def reset_nsx_credentials request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ResetNsxCredentialsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reset_nsx_credentials.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.private_cloud
                header_params["private_cloud"] = request.private_cloud
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reset_nsx_credentials.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reset_nsx_credentials.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :reset_nsx_credentials, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Resets credentials of the Vcenter appliance.
            #
            # @overload reset_vcenter_credentials(request, options = nil)
            #   Pass arguments to `reset_vcenter_credentials` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reset_vcenter_credentials(private_cloud: nil, request_id: nil, username: nil)
            #   Pass arguments to `reset_vcenter_credentials` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param private_cloud [::String]
            #     Required. The resource name of the private cloud
            #     to reset credentials for.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param username [::String]
            #     Optional. The username of the user to be to reset the credentials.
            #     The default value of this field is CloudOwner@gve.local.
            #     The provided value should be one of the following:
            #     solution-user-01@gve.local,
            #     solution-user-02@gve.local,
            #     solution-user-03@gve.local,
            #     solution-user-04@gve.local,
            #     solution-user-05@gve.local,
            #     zertoadmin@gve.local.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest.new
            #
            #   # Call the reset_vcenter_credentials method.
            #   result = client.reset_vcenter_credentials request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def reset_vcenter_credentials request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ResetVcenterCredentialsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reset_vcenter_credentials.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.private_cloud
                header_params["private_cloud"] = request.private_cloud
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reset_vcenter_credentials.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reset_vcenter_credentials.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :reset_vcenter_credentials, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of the `DnsForwarding` config.
            #
            # @overload get_dns_forwarding(request, options = nil)
            #   Pass arguments to `get_dns_forwarding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_dns_forwarding(name: nil)
            #   Pass arguments to `get_dns_forwarding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of a `DnsForwarding` to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/dnsForwarding`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::DnsForwarding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::DnsForwarding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest.new
            #
            #   # Call the get_dns_forwarding method.
            #   result = client.get_dns_forwarding request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::DnsForwarding.
            #   p result
            #
            def get_dns_forwarding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetDnsForwardingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_dns_forwarding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_dns_forwarding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_dns_forwarding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_dns_forwarding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of the `DnsForwarding` config, like associated
            # domains. Only fields specified in `update_mask` are applied.
            #
            # @overload update_dns_forwarding(request, options = nil)
            #   Pass arguments to `update_dns_forwarding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_dns_forwarding(dns_forwarding: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_dns_forwarding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param dns_forwarding [::Google::Cloud::VmwareEngine::V1::DnsForwarding, ::Hash]
            #     Required. DnsForwarding config details.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `DnsForwarding` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest.new
            #
            #   # Call the update_dns_forwarding method.
            #   result = client.update_dns_forwarding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_dns_forwarding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateDnsForwardingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_dns_forwarding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.dns_forwarding&.name
                header_params["dns_forwarding.name"] = request.dns_forwarding.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_dns_forwarding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_dns_forwarding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_dns_forwarding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `NetworkPeering` resource by its resource name. The resource
            # contains details of the network peering, such as peered
            # networks, import and export custom route configurations, and peering state.
            # NetworkPeering is a global resource and location can only be global.
            #
            # @overload get_network_peering(request, options = nil)
            #   Pass arguments to `get_network_peering` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_network_peering(name: nil)
            #   Pass arguments to `get_network_peering` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the network peering to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/global/networkPeerings/my-peering`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::NetworkPeering]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::NetworkPeering]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest.new
            #
            #   # Call the get_network_peering method.
            #   result = client.get_network_peering request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::NetworkPeering.
            #   p result
            #
            def get_network_peering request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetNetworkPeeringRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_network_peering.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_network_peering.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_network_peering.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_network_peering, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `NetworkPeering` resources in a given project. NetworkPeering is a
            # global resource and location can only be global.
            #
            # @overload list_network_peerings(request, options = nil)
            #   Pass arguments to `list_network_peerings` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_network_peerings(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_network_peerings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location (global) to query for
            #     network peerings. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example: `projects/my-project/locations/global`
            #   @param page_size [::Integer]
            #     The maximum number of network peerings to return in one page.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListNetworkPeerings` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListNetworkPeerings` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of network peerings, you can
            #     exclude the ones named `example-peering` by specifying
            #     `name != "example-peering"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-peering")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-peering-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-peering-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::NetworkPeering>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::NetworkPeering>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest.new
            #
            #   # Call the list_network_peerings method.
            #   result = client.list_network_peerings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::NetworkPeering.
            #     p item
            #   end
            #
            def list_network_peerings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListNetworkPeeringsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_network_peerings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_network_peerings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_network_peerings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_network_peerings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_network_peerings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new network peering between the peer network and VMware Engine
            # network provided in a `NetworkPeering` resource. NetworkPeering is a
            # global resource and location can only be global.
            #
            # @overload create_network_peering(request, options = nil)
            #   Pass arguments to `create_network_peering` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_network_peering(parent: nil, network_peering_id: nil, network_peering: nil, request_id: nil)
            #   Pass arguments to `create_network_peering` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to create the new network
            #     peering in. This value is always `global`, because `NetworkPeering` is a
            #     global resource. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example: `projects/my-project/locations/global`
            #   @param network_peering_id [::String]
            #     Required. The user-provided identifier of the new `NetworkPeering`.
            #     This identifier must be unique among `NetworkPeering` resources within the
            #     parent and becomes the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param network_peering [::Google::Cloud::VmwareEngine::V1::NetworkPeering, ::Hash]
            #     Required. The initial description of the new network peering.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest.new
            #
            #   # Call the create_network_peering method.
            #   result = client.create_network_peering request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_network_peering request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateNetworkPeeringRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_network_peering.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_network_peering.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_network_peering.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_network_peering, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `NetworkPeering` resource. When a network peering is deleted for
            # a VMware Engine network, the peer network becomes inaccessible to that
            # VMware Engine network. NetworkPeering is a global resource and location can
            # only be global.
            #
            # @overload delete_network_peering(request, options = nil)
            #   Pass arguments to `delete_network_peering` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_network_peering(name: nil, request_id: nil)
            #   Pass arguments to `delete_network_peering` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the network peering to be deleted.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/global/networkPeerings/my-peering`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest.new
            #
            #   # Call the delete_network_peering method.
            #   result = client.delete_network_peering request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_network_peering request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPeeringRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_network_peering.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_network_peering.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_network_peering.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_network_peering, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a `NetworkPeering` resource. Only the `description` field can be
            # updated. Only fields specified in `updateMask` are applied. NetworkPeering
            # is a global resource and location can only be global.
            #
            # @overload update_network_peering(request, options = nil)
            #   Pass arguments to `update_network_peering` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_network_peering(network_peering: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_network_peering` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param network_peering [::Google::Cloud::VmwareEngine::V1::NetworkPeering, ::Hash]
            #     Required. Network peering description.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `NetworkPeering` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest.new
            #
            #   # Call the update_network_peering method.
            #   result = client.update_network_peering request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_network_peering request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPeeringRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_network_peering.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.network_peering&.name
                header_params["network_peering.name"] = request.network_peering.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_network_peering.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_network_peering.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_network_peering, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the network peering routes exchanged over a peering connection.
            # NetworkPeering is a global resource and location can only be global.
            #
            # @overload list_peering_routes(request, options = nil)
            #   Pass arguments to `list_peering_routes` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_peering_routes(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_peering_routes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the network peering to retrieve peering
            #     routes from. Resource names are schemeless URIs that follow the conventions
            #     in https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/global/networkPeerings/my-peering`
            #   @param page_size [::Integer]
            #     The maximum number of peering routes to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListPeeringRoutes` call.
            #     Provide this to retrieve the subsequent page.
            #     When paginating, all other parameters provided to `ListPeeringRoutes` must
            #     match the call that provided the page token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     Currently, only filtering on the `direction` field is supported. To return
            #     routes imported from the peer network, provide "direction=INCOMING". To
            #     return routes exported from the VMware Engine network, provide
            #     "direction=OUTGOING". Other filter expressions return an error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PeeringRoute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PeeringRoute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest.new
            #
            #   # Call the list_peering_routes method.
            #   result = client.list_peering_routes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::PeeringRoute.
            #     p item
            #   end
            #
            def list_peering_routes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListPeeringRoutesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_peering_routes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_peering_routes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_peering_routes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_peering_routes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_peering_routes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new HCX activation key in a given private cloud.
            #
            # @overload create_hcx_activation_key(request, options = nil)
            #   Pass arguments to `create_hcx_activation_key` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_hcx_activation_key(parent: nil, hcx_activation_key: nil, hcx_activation_key_id: nil, request_id: nil)
            #   Pass arguments to `create_hcx_activation_key` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to create the key for.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/privateClouds/my-cloud`
            #   @param hcx_activation_key [::Google::Cloud::VmwareEngine::V1::HcxActivationKey, ::Hash]
            #     Required. The initial description of a new HCX activation key. When
            #     creating a new key, this field must be an empty object.
            #   @param hcx_activation_key_id [::String]
            #     Required. The user-provided identifier of the `HcxActivationKey` to be
            #     created. This identifier must be unique among `HcxActivationKey` resources
            #     within the parent and becomes the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param request_id [::String]
            #     A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest.new
            #
            #   # Call the create_hcx_activation_key method.
            #   result = client.create_hcx_activation_key request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_hcx_activation_key request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateHcxActivationKeyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_hcx_activation_key.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_hcx_activation_key.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_hcx_activation_key.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_hcx_activation_key, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `HcxActivationKey` resources in a given private cloud.
            #
            # @overload list_hcx_activation_keys(request, options = nil)
            #   Pass arguments to `list_hcx_activation_keys` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_hcx_activation_keys(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_hcx_activation_keys` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud
            #     to be queried for HCX activation keys.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/privateClouds/my-cloud`
            #   @param page_size [::Integer]
            #     The maximum number of HCX activation keys to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListHcxActivationKeys` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListHcxActivationKeys` must match the call that provided the page
            #     token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::HcxActivationKey>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::HcxActivationKey>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest.new
            #
            #   # Call the list_hcx_activation_keys method.
            #   result = client.list_hcx_activation_keys request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::HcxActivationKey.
            #     p item
            #   end
            #
            def list_hcx_activation_keys request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListHcxActivationKeysRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_hcx_activation_keys.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_hcx_activation_keys.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_hcx_activation_keys.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_hcx_activation_keys, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_hcx_activation_keys, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `HcxActivationKey` resource by its resource name.
            #
            # @overload get_hcx_activation_key(request, options = nil)
            #   Pass arguments to `get_hcx_activation_key` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_hcx_activation_key(name: nil)
            #   Pass arguments to `get_hcx_activation_key` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the HCX activation key to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::HcxActivationKey]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::HcxActivationKey]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest.new
            #
            #   # Call the get_hcx_activation_key method.
            #   result = client.get_hcx_activation_key request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::HcxActivationKey.
            #   p result
            #
            def get_hcx_activation_key request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetHcxActivationKeyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_hcx_activation_key.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_hcx_activation_key.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_hcx_activation_key.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_hcx_activation_key, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `NetworkPolicy` resource by its resource name.
            #
            # @overload get_network_policy(request, options = nil)
            #   Pass arguments to `get_network_policy` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_network_policy(name: nil)
            #   Pass arguments to `get_network_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the network policy to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::NetworkPolicy]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::NetworkPolicy]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest.new
            #
            #   # Call the get_network_policy method.
            #   result = client.get_network_policy request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::NetworkPolicy.
            #   p result
            #
            def get_network_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetNetworkPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_network_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_network_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_network_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_network_policy, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `NetworkPolicy` resources in a specified project and location.
            #
            # @overload list_network_policies(request, options = nil)
            #   Pass arguments to `list_network_policies` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_network_policies(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_network_policies` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location (region) to query for
            #     network policies. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example: `projects/my-project/locations/us-central1`
            #   @param page_size [::Integer]
            #     The maximum number of network policies to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListNetworkPolicies` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListNetworkPolicies` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of network policies, you can
            #     exclude the ones named `example-policy` by specifying
            #     `name != "example-policy"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-policy")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-policy-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-policy-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::NetworkPolicy>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::NetworkPolicy>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest.new
            #
            #   # Call the list_network_policies method.
            #   result = client.list_network_policies request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::NetworkPolicy.
            #     p item
            #   end
            #
            def list_network_policies request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListNetworkPoliciesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_network_policies.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_network_policies.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_network_policies.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_network_policies, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_network_policies, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new network policy in a given VMware Engine network of a
            # project and location (region). A new network policy cannot be created if
            # another network policy already exists in the same scope.
            #
            # @overload create_network_policy(request, options = nil)
            #   Pass arguments to `create_network_policy` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_network_policy(parent: nil, network_policy_id: nil, network_policy: nil, request_id: nil)
            #   Pass arguments to `create_network_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location (region)
            #     to create the new network policy in.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #      `projects/my-project/locations/us-central1`
            #   @param network_policy_id [::String]
            #     Required. The user-provided identifier of the network policy to be created.
            #     This identifier must be unique within parent
            #     `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
            #     the final token in the name URI.
            #     The identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param network_policy [::Google::Cloud::VmwareEngine::V1::NetworkPolicy, ::Hash]
            #     Required. The network policy configuration to use in the request.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest.new
            #
            #   # Call the create_network_policy method.
            #   result = client.create_network_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_network_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateNetworkPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_network_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_network_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_network_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_network_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a `NetworkPolicy` resource. Only the following fields can be
            # updated: `internet_access`, `external_ip`, `edge_services_cidr`.
            # Only fields specified in `updateMask` are applied. When updating a network
            # policy, the external IP network service can only be disabled if there are
            # no external IP addresses present in the scope of the policy. Also, a
            # `NetworkService` cannot be updated when `NetworkService.state` is set
            # to `RECONCILING`.
            #
            # During operation processing, the resource is temporarily in the `ACTIVE`
            # state before the operation fully completes. For that period of time, you
            # can't update the resource. Use the operation status to determine when the
            # processing fully completes.
            #
            # @overload update_network_policy(request, options = nil)
            #   Pass arguments to `update_network_policy` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_network_policy(network_policy: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_network_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param network_policy [::Google::Cloud::VmwareEngine::V1::NetworkPolicy, ::Hash]
            #     Required. Network policy description.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `NetworkPolicy` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest.new
            #
            #   # Call the update_network_policy method.
            #   result = client.update_network_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_network_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateNetworkPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_network_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.network_policy&.name
                header_params["network_policy.name"] = request.network_policy.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_network_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_network_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_network_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
            # when `NetworkService.state` is set to `RECONCILING` for either its external
            # IP or internet access service.
            #
            # @overload delete_network_policy(request, options = nil)
            #   Pass arguments to `delete_network_policy` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_network_policy(name: nil, request_id: nil)
            #   Pass arguments to `delete_network_policy` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the network policy to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest.new
            #
            #   # Call the delete_network_policy method.
            #   result = client.delete_network_policy request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_network_policy request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteNetworkPolicyRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_network_policy.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_network_policy.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_network_policy.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_network_policy, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Consumer VPCs bound to Management DNS Zone of a given private cloud.
            #
            # @overload list_management_dns_zone_bindings(request, options = nil)
            #   Pass arguments to `list_management_dns_zone_bindings` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_management_dns_zone_bindings(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_management_dns_zone_bindings` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud to be queried for
            #     management DNS zone bindings.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param page_size [::Integer]
            #     The maximum number of management DNS zone bindings to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListManagementDnsZoneBindings`
            #     call. Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListManagementDnsZoneBindings` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of Management DNS Zone Bindings,
            #     you can exclude the ones named `example-management-dns-zone-binding` by
            #     specifying `name != "example-management-dns-zone-binding"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-management-dns-zone-binding")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-management-dns-zone-binding-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-management-dns-zone-binding-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest.new
            #
            #   # Call the list_management_dns_zone_bindings method.
            #   result = client.list_management_dns_zone_bindings request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding.
            #     p item
            #   end
            #
            def list_management_dns_zone_bindings request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListManagementDnsZoneBindingsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_management_dns_zone_bindings.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_management_dns_zone_bindings.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_management_dns_zone_bindings.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_management_dns_zone_bindings, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_management_dns_zone_bindings, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a 'ManagementDnsZoneBinding' resource by its resource name.
            #
            # @overload get_management_dns_zone_binding(request, options = nil)
            #   Pass arguments to `get_management_dns_zone_binding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_management_dns_zone_binding(name: nil)
            #   Pass arguments to `get_management_dns_zone_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the management DNS zone binding to
            #     retrieve. Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest.new
            #
            #   # Call the get_management_dns_zone_binding method.
            #   result = client.get_management_dns_zone_binding request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding.
            #   p result
            #
            def get_management_dns_zone_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetManagementDnsZoneBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_management_dns_zone_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_management_dns_zone_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_management_dns_zone_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_management_dns_zone_binding, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new `ManagementDnsZoneBinding` resource in a private cloud.
            # This RPC creates the DNS binding and the resource that represents the
            # DNS binding of the consumer VPC network to the management DNS zone. A
            # management DNS zone is the Cloud DNS cross-project binding zone that
            # VMware Engine creates for each private cloud. It contains FQDNs and
            # corresponding IP addresses for the private cloud's ESXi hosts and
            # management VM appliances like vCenter and NSX Manager.
            #
            # @overload create_management_dns_zone_binding(request, options = nil)
            #   Pass arguments to `create_management_dns_zone_binding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_management_dns_zone_binding(parent: nil, management_dns_zone_binding: nil, management_dns_zone_binding_id: nil, request_id: nil)
            #   Pass arguments to `create_management_dns_zone_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private cloud
            #     to create a new management DNS zone binding for.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
            #   @param management_dns_zone_binding [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding, ::Hash]
            #     Required. The initial values for a new management DNS zone binding.
            #   @param management_dns_zone_binding_id [::String]
            #     Required. The user-provided identifier of the `ManagementDnsZoneBinding`
            #     resource to be created. This identifier must be unique among
            #     `ManagementDnsZoneBinding` resources within the parent and becomes the
            #     final token in the name URI. The identifier must meet the following
            #     requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest.new
            #
            #   # Call the create_management_dns_zone_binding method.
            #   result = client.create_management_dns_zone_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_management_dns_zone_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateManagementDnsZoneBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_management_dns_zone_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_management_dns_zone_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_management_dns_zone_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_management_dns_zone_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates a `ManagementDnsZoneBinding` resource.
            # Only fields specified in `update_mask` are applied.
            #
            # @overload update_management_dns_zone_binding(request, options = nil)
            #   Pass arguments to `update_management_dns_zone_binding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_management_dns_zone_binding(update_mask: nil, management_dns_zone_binding: nil, request_id: nil)
            #   Pass arguments to `update_management_dns_zone_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `ManagementDnsZoneBinding` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param management_dns_zone_binding [::Google::Cloud::VmwareEngine::V1::ManagementDnsZoneBinding, ::Hash]
            #     Required. New values to update the management DNS zone binding with.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest.new
            #
            #   # Call the update_management_dns_zone_binding method.
            #   result = client.update_management_dns_zone_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_management_dns_zone_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateManagementDnsZoneBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_management_dns_zone_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.management_dns_zone_binding&.name
                header_params["management_dns_zone_binding.name"] = request.management_dns_zone_binding.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_management_dns_zone_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_management_dns_zone_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_management_dns_zone_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `ManagementDnsZoneBinding` resource. When a management DNS zone
            # binding is deleted, the corresponding consumer VPC network is no longer
            # bound to the management DNS zone.
            #
            # @overload delete_management_dns_zone_binding(request, options = nil)
            #   Pass arguments to `delete_management_dns_zone_binding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_management_dns_zone_binding(name: nil, request_id: nil)
            #   Pass arguments to `delete_management_dns_zone_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the management DNS zone binding to delete.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if the original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest.new
            #
            #   # Call the delete_management_dns_zone_binding method.
            #   result = client.delete_management_dns_zone_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_management_dns_zone_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteManagementDnsZoneBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_management_dns_zone_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_management_dns_zone_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_management_dns_zone_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_management_dns_zone_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retries to create a `ManagementDnsZoneBinding` resource that is
            # in failed state.
            #
            # @overload repair_management_dns_zone_binding(request, options = nil)
            #   Pass arguments to `repair_management_dns_zone_binding` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload repair_management_dns_zone_binding(name: nil, request_id: nil)
            #   Pass arguments to `repair_management_dns_zone_binding` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the management DNS zone binding to repair.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/managementDnsZoneBindings/my-management-dns-zone-binding`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request ID,
            #     the server can check if the original operation with the same request ID was
            #     received, and if so, will ignore the second request. This prevents clients
            #     from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest.new
            #
            #   # Call the repair_management_dns_zone_binding method.
            #   result = client.repair_management_dns_zone_binding request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def repair_management_dns_zone_binding request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::RepairManagementDnsZoneBindingRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.repair_management_dns_zone_binding.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.repair_management_dns_zone_binding.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.repair_management_dns_zone_binding.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :repair_management_dns_zone_binding, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new VMware Engine network that can be used by a private cloud.
            #
            # @overload create_vmware_engine_network(request, options = nil)
            #   Pass arguments to `create_vmware_engine_network` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_vmware_engine_network(parent: nil, vmware_engine_network_id: nil, vmware_engine_network: nil, request_id: nil)
            #   Pass arguments to `create_vmware_engine_network` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to create the new VMware Engine
            #     network in. A VMware Engine network of type
            #     `LEGACY` is a regional resource, and a VMware
            #     Engine network of type `STANDARD` is a global resource.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/global`
            #   @param vmware_engine_network_id [::String]
            #     Required. The user-provided identifier of the new VMware Engine network.
            #     This identifier must be unique among VMware Engine network resources
            #     within the parent and becomes the final token in the name URI. The
            #     identifier must meet the following requirements:
            #
            #     * For networks of type LEGACY, adheres to the format:
            #     `{region-id}-default`. Replace `{region-id}` with the region where you want
            #     to create the VMware Engine network. For example, "us-central1-default".
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param vmware_engine_network [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork, ::Hash]
            #     Required. The initial description of the new VMware Engine network.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest.new
            #
            #   # Call the create_vmware_engine_network method.
            #   result = client.create_vmware_engine_network request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_vmware_engine_network request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreateVmwareEngineNetworkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_vmware_engine_network.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_vmware_engine_network.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_vmware_engine_network.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_vmware_engine_network, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a VMware Engine network resource. Only the following fields can be
            # updated: `description`. Only fields specified in `updateMask` are
            # applied.
            #
            # @overload update_vmware_engine_network(request, options = nil)
            #   Pass arguments to `update_vmware_engine_network` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_vmware_engine_network(vmware_engine_network: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_vmware_engine_network` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param vmware_engine_network [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork, ::Hash]
            #     Required. VMware Engine network description.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     VMware Engine network resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten. Only the
            #     following fields can be updated: `description`.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest.new
            #
            #   # Call the update_vmware_engine_network method.
            #   result = client.update_vmware_engine_network request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_vmware_engine_network request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdateVmwareEngineNetworkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_vmware_engine_network.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.vmware_engine_network&.name
                header_params["vmware_engine_network.name"] = request.vmware_engine_network.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_vmware_engine_network.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_vmware_engine_network.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_vmware_engine_network, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
            # Engine network after all resources that refer to it are deleted. For
            # example, a private cloud, a network peering, and a network policy can all
            # refer to the same VMware Engine network.
            #
            # @overload delete_vmware_engine_network(request, options = nil)
            #   Pass arguments to `delete_vmware_engine_network` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_vmware_engine_network(name: nil, request_id: nil, etag: nil)
            #   Pass arguments to `delete_vmware_engine_network` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the VMware Engine network to be deleted.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param etag [::String]
            #     Optional. Checksum used to ensure that the user-provided value is up to
            #     date before the server processes the request. The server compares provided
            #     checksum with the current checksum of the resource. If the user-provided
            #     value is out of date, this request returns an `ABORTED` error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest.new
            #
            #   # Call the delete_vmware_engine_network method.
            #   result = client.delete_vmware_engine_network request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_vmware_engine_network request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeleteVmwareEngineNetworkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_vmware_engine_network.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_vmware_engine_network.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_vmware_engine_network.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_vmware_engine_network, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `VmwareEngineNetwork` resource by its resource name. The
            # resource contains details of the VMware Engine network, such as its VMware
            # Engine network type, peered networks in a service project, and state
            # (for example, `CREATING`, `ACTIVE`, `DELETING`).
            #
            # @overload get_vmware_engine_network(request, options = nil)
            #   Pass arguments to `get_vmware_engine_network` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_vmware_engine_network(name: nil)
            #   Pass arguments to `get_vmware_engine_network` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the VMware Engine network to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest.new
            #
            #   # Call the get_vmware_engine_network method.
            #   result = client.get_vmware_engine_network request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork.
            #   p result
            #
            def get_vmware_engine_network request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetVmwareEngineNetworkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_vmware_engine_network.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_vmware_engine_network.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_vmware_engine_network.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_vmware_engine_network, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `VmwareEngineNetwork` resources in a given project and location.
            #
            # @overload list_vmware_engine_networks(request, options = nil)
            #   Pass arguments to `list_vmware_engine_networks` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_vmware_engine_networks(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_vmware_engine_networks` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to query for
            #     VMware Engine networks. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example: `projects/my-project/locations/global`
            #   @param page_size [::Integer]
            #     The maximum number of results to return in one page.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListVmwareEngineNetworks` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListVmwareEngineNetworks` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of network peerings, you can
            #     exclude the ones named `example-network` by specifying
            #     `name != "example-network"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-network")
            #     (createTime > "2021-04-12T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-network-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-network-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest.new
            #
            #   # Call the list_vmware_engine_networks method.
            #   result = client.list_vmware_engine_networks request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::VmwareEngineNetwork.
            #     p item
            #   end
            #
            def list_vmware_engine_networks request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListVmwareEngineNetworksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_vmware_engine_networks.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_vmware_engine_networks.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_vmware_engine_networks.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_vmware_engine_networks, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_vmware_engine_networks, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new private connection that can be used for accessing private
            # Clouds.
            #
            # @overload create_private_connection(request, options = nil)
            #   Pass arguments to `create_private_connection` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_private_connection(parent: nil, private_connection_id: nil, private_connection: nil, request_id: nil)
            #   Pass arguments to `create_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to create the new private
            #     connection in. Private connection is a regional resource.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/us-central1`
            #   @param private_connection_id [::String]
            #     Required. The user-provided identifier of the new private connection.
            #     This identifier must be unique among private connection resources
            #     within the parent and becomes the final token in the name URI. The
            #     identifier must meet the following requirements:
            #
            #     * Only contains 1-63 alphanumeric characters and hyphens
            #     * Begins with an alphabetical character
            #     * Ends with a non-hyphen character
            #     * Not formatted as a UUID
            #     * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
            #     (section 3.5)
            #   @param private_connection [::Google::Cloud::VmwareEngine::V1::PrivateConnection, ::Hash]
            #     Required. The initial description of the new private connection.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest.new
            #
            #   # Call the create_private_connection method.
            #   result = client.create_private_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::CreatePrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :create_private_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a `PrivateConnection` resource by its resource name. The resource
            # contains details of the private connection, such as connected
            # network, routing mode and state.
            #
            # @overload get_private_connection(request, options = nil)
            #   Pass arguments to `get_private_connection` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_private_connection(name: nil)
            #   Pass arguments to `get_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the private connection to retrieve.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/privateConnections/my-connection`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::PrivateConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::PrivateConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest.new
            #
            #   # Call the get_private_connection method.
            #   result = client.get_private_connection request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::PrivateConnection.
            #   p result
            #
            def get_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetPrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_private_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists `PrivateConnection` resources in a given project and location.
            #
            # @overload list_private_connections(request, options = nil)
            #   Pass arguments to `list_private_connections` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_private_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_private_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the location to query for
            #     private connections. Resource names are schemeless URIs that follow the
            #     conventions in https://cloud.google.com/apis/design/resource_names. For
            #     example: `projects/my-project/locations/us-central1`
            #   @param page_size [::Integer]
            #     The maximum number of private connections to return in one page.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListPrivateConnections` call.
            #     Provide this to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to
            #     `ListPrivateConnections` must match the call that provided the page
            #     token.
            #   @param filter [::String]
            #     A filter expression that matches resources returned in the response.
            #     The expression must specify the field name, a comparison
            #     operator, and the value that you want to use for filtering. The value
            #     must be a string, a number, or a boolean. The comparison operator
            #     must be `=`, `!=`, `>`, or `<`.
            #
            #     For example, if you are filtering a list of private connections, you can
            #     exclude the ones named `example-connection` by specifying
            #     `name != "example-connection"`.
            #
            #     To filter on multiple expressions, provide each separate expression within
            #     parentheses. For example:
            #     ```
            #     (name = "example-connection")
            #     (createTime > "2022-09-22T08:15:10.40Z")
            #     ```
            #
            #     By default, each expression is an `AND` expression. However, you
            #     can include `AND` and `OR` expressions explicitly.
            #     For example:
            #     ```
            #     (name = "example-connection-1") AND
            #     (createTime > "2021-04-12T08:15:10.40Z") OR
            #     (name = "example-connection-2")
            #     ```
            #   @param order_by [::String]
            #     Sorts list results by a certain order. By default, returned results
            #     are ordered by `name` in ascending order.
            #     You can also sort results in descending order based on the `name` value
            #     using `orderBy="name desc"`.
            #     Currently, only ordering by `name` is supported.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PrivateConnection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PrivateConnection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest.new
            #
            #   # Call the list_private_connections method.
            #   result = client.list_private_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::PrivateConnection.
            #     p item
            #   end
            #
            def list_private_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_private_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_private_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_private_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_private_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_private_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Modifies a `PrivateConnection` resource. Only `description` and
            # `routing_mode` fields can be updated. Only fields specified in `updateMask`
            # are applied.
            #
            # @overload update_private_connection(request, options = nil)
            #   Pass arguments to `update_private_connection` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_private_connection(private_connection: nil, update_mask: nil, request_id: nil)
            #   Pass arguments to `update_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param private_connection [::Google::Cloud::VmwareEngine::V1::PrivateConnection, ::Hash]
            #     Required. Private connection description.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     `PrivateConnection` resource by the update.
            #     The fields specified in the `update_mask` are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest.new
            #
            #   # Call the update_private_connection method.
            #   result = client.update_private_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::UpdatePrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.private_connection&.name
                header_params["private_connection.name"] = request.private_connection.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :update_private_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a `PrivateConnection` resource. When a private connection is
            # deleted for a VMware Engine network, the connected network becomes
            # inaccessible to that VMware Engine network.
            #
            # @overload delete_private_connection(request, options = nil)
            #   Pass arguments to `delete_private_connection` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_private_connection(name: nil, request_id: nil)
            #   Pass arguments to `delete_private_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the private connection to be deleted.
            #     Resource names are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names.
            #     For example:
            #     `projects/my-project/locations/us-central1/privateConnections/my-connection`
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest.new
            #
            #   # Call the delete_private_connection method.
            #   result = client.delete_private_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_private_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::DeletePrivateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_private_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_private_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_private_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :delete_private_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the private connection routes exchanged over a peering connection.
            #
            # @overload list_private_connection_peering_routes(request, options = nil)
            #   Pass arguments to `list_private_connection_peering_routes` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_private_connection_peering_routes(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_private_connection_peering_routes` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the private connection to retrieve peering
            #     routes from. Resource names are schemeless URIs that follow the conventions
            #     in https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/us-west1/privateConnections/my-connection`
            #   @param page_size [::Integer]
            #     The maximum number of peering routes to return in one page.
            #     The service may return fewer than this value.
            #     The maximum value is coerced to 1000.
            #     The default value of this field is 500.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListPrivateConnectionPeeringRoutes`
            #     call. Provide this to retrieve the subsequent page. When paginating, all
            #     other parameters provided to `ListPrivateConnectionPeeringRoutes` must
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PeeringRoute>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::VmwareEngine::V1::PeeringRoute>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest.new
            #
            #   # Call the list_private_connection_peering_routes method.
            #   result = client.list_private_connection_peering_routes request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::VmwareEngine::V1::PeeringRoute.
            #     p item
            #   end
            #
            def list_private_connection_peering_routes request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::ListPrivateConnectionPeeringRoutesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_private_connection_peering_routes.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_private_connection_peering_routes.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_private_connection_peering_routes.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :list_private_connection_peering_routes, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @vmware_engine_stub, :list_private_connection_peering_routes, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Grants the bind permission to the customer provided principal(user /
            # service account) to bind their DNS zone with the intranet VPC associated
            # with the project. DnsBindPermission is a global resource and location can
            # only be global.
            #
            # @overload grant_dns_bind_permission(request, options = nil)
            #   Pass arguments to `grant_dns_bind_permission` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload grant_dns_bind_permission(name: nil, principal: nil, request_id: nil)
            #   Pass arguments to `grant_dns_bind_permission` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the resource which stores the users/service accounts
            #     having the permission to bind to the corresponding intranet VPC of the
            #     consumer project. DnsBindPermission is a global resource. Resource names
            #     are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/global/dnsBindPermission`
            #   @param principal [::Google::Cloud::VmwareEngine::V1::Principal, ::Hash]
            #     Required. The consumer provided user/service account which needs to be
            #     granted permission to bind with the intranet VPC corresponding to the
            #     consumer project.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest.new
            #
            #   # Call the grant_dns_bind_permission method.
            #   result = client.grant_dns_bind_permission request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def grant_dns_bind_permission request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GrantDnsBindPermissionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.grant_dns_bind_permission.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.grant_dns_bind_permission.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.grant_dns_bind_permission.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :grant_dns_bind_permission, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets all the principals having bind permission on the intranet VPC
            # associated with the consumer project granted by the Grant API.
            # DnsBindPermission is a global resource and location can only be global.
            #
            # @overload get_dns_bind_permission(request, options = nil)
            #   Pass arguments to `get_dns_bind_permission` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_dns_bind_permission(name: nil)
            #   Pass arguments to `get_dns_bind_permission` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the resource which stores the users/service accounts
            #     having the permission to bind to the corresponding intranet VPC of the
            #     consumer project. DnsBindPermission is a global resource. Resource names
            #     are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/global/dnsBindPermission`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::VmwareEngine::V1::DnsBindPermission]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::VmwareEngine::V1::DnsBindPermission]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest.new
            #
            #   # Call the get_dns_bind_permission method.
            #   result = client.get_dns_bind_permission request
            #
            #   # The returned object is of type Google::Cloud::VmwareEngine::V1::DnsBindPermission.
            #   p result
            #
            def get_dns_bind_permission request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::GetDnsBindPermissionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_dns_bind_permission.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_dns_bind_permission.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_dns_bind_permission.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :get_dns_bind_permission, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Revokes the bind permission from the customer provided principal(user /
            # service account) on the intranet VPC associated with the consumer project.
            # DnsBindPermission is a global resource and location can only be global.
            #
            # @overload revoke_dns_bind_permission(request, options = nil)
            #   Pass arguments to `revoke_dns_bind_permission` via a request object, either of type
            #   {::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload revoke_dns_bind_permission(name: nil, principal: nil, request_id: nil)
            #   Pass arguments to `revoke_dns_bind_permission` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the resource which stores the users/service accounts
            #     having the permission to bind to the corresponding intranet VPC of the
            #     consumer project. DnsBindPermission is a global resource. Resource names
            #     are schemeless URIs that follow the conventions in
            #     https://cloud.google.com/apis/design/resource_names. For example:
            #     `projects/my-project/locations/global/dnsBindPermission`
            #   @param principal [::Google::Cloud::VmwareEngine::V1::Principal, ::Hash]
            #     Required. The consumer provided user/service account which needs to be
            #     granted permission to bind with the intranet VPC corresponding to the
            #     consumer project.
            #   @param request_id [::String]
            #     Optional. A request ID to identify requests. Specify a unique request ID
            #     so that if you must retry your request, the server will know to ignore
            #     the request if it has already been completed. The server guarantees that a
            #     request doesn't result in creation of duplicate commitments for at least 60
            #     minutes.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/vmware_engine/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest.new
            #
            #   # Call the revoke_dns_bind_permission method.
            #   result = client.revoke_dns_bind_permission request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def revoke_dns_bind_permission request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::VmwareEngine::V1::RevokeDnsBindPermissionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.revoke_dns_bind_permission.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::VmwareEngine::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.revoke_dns_bind_permission.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.revoke_dns_bind_permission.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @vmware_engine_stub.call_rpc :revoke_dns_bind_permission, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the VmwareEngine API.
            #
            # This class represents the configuration for VmwareEngine,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_private_clouds to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_private_clouds.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_private_clouds.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::VmwareEngine::V1::VmwareEngine::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "vmwareengine.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the VmwareEngine API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_private_clouds`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_private_clouds
                ##
                # RPC-specific configuration for `get_private_cloud`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_private_cloud
                ##
                # RPC-specific configuration for `create_private_cloud`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_private_cloud
                ##
                # RPC-specific configuration for `update_private_cloud`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_private_cloud
                ##
                # RPC-specific configuration for `delete_private_cloud`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_private_cloud
                ##
                # RPC-specific configuration for `undelete_private_cloud`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undelete_private_cloud
                ##
                # RPC-specific configuration for `list_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_clusters
                ##
                # RPC-specific configuration for `get_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_cluster
                ##
                # RPC-specific configuration for `create_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_cluster
                ##
                # RPC-specific configuration for `update_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_cluster
                ##
                # RPC-specific configuration for `delete_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_cluster
                ##
                # RPC-specific configuration for `list_nodes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_nodes
                ##
                # RPC-specific configuration for `get_node`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_node
                ##
                # RPC-specific configuration for `list_external_addresses`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_external_addresses
                ##
                # RPC-specific configuration for `fetch_network_policy_external_addresses`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_network_policy_external_addresses
                ##
                # RPC-specific configuration for `get_external_address`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_external_address
                ##
                # RPC-specific configuration for `create_external_address`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_external_address
                ##
                # RPC-specific configuration for `update_external_address`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_external_address
                ##
                # RPC-specific configuration for `delete_external_address`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_external_address
                ##
                # RPC-specific configuration for `list_subnets`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_subnets
                ##
                # RPC-specific configuration for `get_subnet`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_subnet
                ##
                # RPC-specific configuration for `update_subnet`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_subnet
                ##
                # RPC-specific configuration for `list_external_access_rules`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_external_access_rules
                ##
                # RPC-specific configuration for `get_external_access_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_external_access_rule
                ##
                # RPC-specific configuration for `create_external_access_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_external_access_rule
                ##
                # RPC-specific configuration for `update_external_access_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_external_access_rule
                ##
                # RPC-specific configuration for `delete_external_access_rule`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_external_access_rule
                ##
                # RPC-specific configuration for `list_logging_servers`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_logging_servers
                ##
                # RPC-specific configuration for `get_logging_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_logging_server
                ##
                # RPC-specific configuration for `create_logging_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_logging_server
                ##
                # RPC-specific configuration for `update_logging_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_logging_server
                ##
                # RPC-specific configuration for `delete_logging_server`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_logging_server
                ##
                # RPC-specific configuration for `list_node_types`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_node_types
                ##
                # RPC-specific configuration for `get_node_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_node_type
                ##
                # RPC-specific configuration for `show_nsx_credentials`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :show_nsx_credentials
                ##
                # RPC-specific configuration for `show_vcenter_credentials`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :show_vcenter_credentials
                ##
                # RPC-specific configuration for `reset_nsx_credentials`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reset_nsx_credentials
                ##
                # RPC-specific configuration for `reset_vcenter_credentials`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reset_vcenter_credentials
                ##
                # RPC-specific configuration for `get_dns_forwarding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_dns_forwarding
                ##
                # RPC-specific configuration for `update_dns_forwarding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_dns_forwarding
                ##
                # RPC-specific configuration for `get_network_peering`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_network_peering
                ##
                # RPC-specific configuration for `list_network_peerings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_network_peerings
                ##
                # RPC-specific configuration for `create_network_peering`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_network_peering
                ##
                # RPC-specific configuration for `delete_network_peering`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_network_peering
                ##
                # RPC-specific configuration for `update_network_peering`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_network_peering
                ##
                # RPC-specific configuration for `list_peering_routes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_peering_routes
                ##
                # RPC-specific configuration for `create_hcx_activation_key`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_hcx_activation_key
                ##
                # RPC-specific configuration for `list_hcx_activation_keys`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_hcx_activation_keys
                ##
                # RPC-specific configuration for `get_hcx_activation_key`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_hcx_activation_key
                ##
                # RPC-specific configuration for `get_network_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_network_policy
                ##
                # RPC-specific configuration for `list_network_policies`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_network_policies
                ##
                # RPC-specific configuration for `create_network_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_network_policy
                ##
                # RPC-specific configuration for `update_network_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_network_policy
                ##
                # RPC-specific configuration for `delete_network_policy`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_network_policy
                ##
                # RPC-specific configuration for `list_management_dns_zone_bindings`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_management_dns_zone_bindings
                ##
                # RPC-specific configuration for `get_management_dns_zone_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_management_dns_zone_binding
                ##
                # RPC-specific configuration for `create_management_dns_zone_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_management_dns_zone_binding
                ##
                # RPC-specific configuration for `update_management_dns_zone_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_management_dns_zone_binding
                ##
                # RPC-specific configuration for `delete_management_dns_zone_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_management_dns_zone_binding
                ##
                # RPC-specific configuration for `repair_management_dns_zone_binding`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :repair_management_dns_zone_binding
                ##
                # RPC-specific configuration for `create_vmware_engine_network`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_vmware_engine_network
                ##
                # RPC-specific configuration for `update_vmware_engine_network`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_vmware_engine_network
                ##
                # RPC-specific configuration for `delete_vmware_engine_network`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_vmware_engine_network
                ##
                # RPC-specific configuration for `get_vmware_engine_network`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_vmware_engine_network
                ##
                # RPC-specific configuration for `list_vmware_engine_networks`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_vmware_engine_networks
                ##
                # RPC-specific configuration for `create_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_private_connection
                ##
                # RPC-specific configuration for `get_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_private_connection
                ##
                # RPC-specific configuration for `list_private_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_private_connections
                ##
                # RPC-specific configuration for `update_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_private_connection
                ##
                # RPC-specific configuration for `delete_private_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_private_connection
                ##
                # RPC-specific configuration for `list_private_connection_peering_routes`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_private_connection_peering_routes
                ##
                # RPC-specific configuration for `grant_dns_bind_permission`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :grant_dns_bind_permission
                ##
                # RPC-specific configuration for `get_dns_bind_permission`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_dns_bind_permission
                ##
                # RPC-specific configuration for `revoke_dns_bind_permission`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :revoke_dns_bind_permission

                # @private
                def initialize parent_rpcs = nil
                  list_private_clouds_config = parent_rpcs.list_private_clouds if parent_rpcs.respond_to? :list_private_clouds
                  @list_private_clouds = ::Gapic::Config::Method.new list_private_clouds_config
                  get_private_cloud_config = parent_rpcs.get_private_cloud if parent_rpcs.respond_to? :get_private_cloud
                  @get_private_cloud = ::Gapic::Config::Method.new get_private_cloud_config
                  create_private_cloud_config = parent_rpcs.create_private_cloud if parent_rpcs.respond_to? :create_private_cloud
                  @create_private_cloud = ::Gapic::Config::Method.new create_private_cloud_config
                  update_private_cloud_config = parent_rpcs.update_private_cloud if parent_rpcs.respond_to? :update_private_cloud
                  @update_private_cloud = ::Gapic::Config::Method.new update_private_cloud_config
                  delete_private_cloud_config = parent_rpcs.delete_private_cloud if parent_rpcs.respond_to? :delete_private_cloud
                  @delete_private_cloud = ::Gapic::Config::Method.new delete_private_cloud_config
                  undelete_private_cloud_config = parent_rpcs.undelete_private_cloud if parent_rpcs.respond_to? :undelete_private_cloud
                  @undelete_private_cloud = ::Gapic::Config::Method.new undelete_private_cloud_config
                  list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                  @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                  get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                  @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                  create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                  @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                  update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                  @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                  delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                  @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                  list_nodes_config = parent_rpcs.list_nodes if parent_rpcs.respond_to? :list_nodes
                  @list_nodes = ::Gapic::Config::Method.new list_nodes_config
                  get_node_config = parent_rpcs.get_node if parent_rpcs.respond_to? :get_node
                  @get_node = ::Gapic::Config::Method.new get_node_config
                  list_external_addresses_config = parent_rpcs.list_external_addresses if parent_rpcs.respond_to? :list_external_addresses
                  @list_external_addresses = ::Gapic::Config::Method.new list_external_addresses_config
                  fetch_network_policy_external_addresses_config = parent_rpcs.fetch_network_policy_external_addresses if parent_rpcs.respond_to? :fetch_network_policy_external_addresses
                  @fetch_network_policy_external_addresses = ::Gapic::Config::Method.new fetch_network_policy_external_addresses_config
                  get_external_address_config = parent_rpcs.get_external_address if parent_rpcs.respond_to? :get_external_address
                  @get_external_address = ::Gapic::Config::Method.new get_external_address_config
                  create_external_address_config = parent_rpcs.create_external_address if parent_rpcs.respond_to? :create_external_address
                  @create_external_address = ::Gapic::Config::Method.new create_external_address_config
                  update_external_address_config = parent_rpcs.update_external_address if parent_rpcs.respond_to? :update_external_address
                  @update_external_address = ::Gapic::Config::Method.new update_external_address_config
                  delete_external_address_config = parent_rpcs.delete_external_address if parent_rpcs.respond_to? :delete_external_address
                  @delete_external_address = ::Gapic::Config::Method.new delete_external_address_config
                  list_subnets_config = parent_rpcs.list_subnets if parent_rpcs.respond_to? :list_subnets
                  @list_subnets = ::Gapic::Config::Method.new list_subnets_config
                  get_subnet_config = parent_rpcs.get_subnet if parent_rpcs.respond_to? :get_subnet
                  @get_subnet = ::Gapic::Config::Method.new get_subnet_config
                  update_subnet_config = parent_rpcs.update_subnet if parent_rpcs.respond_to? :update_subnet
                  @update_subnet = ::Gapic::Config::Method.new update_subnet_config
                  list_external_access_rules_config = parent_rpcs.list_external_access_rules if parent_rpcs.respond_to? :list_external_access_rules
                  @list_external_access_rules = ::Gapic::Config::Method.new list_external_access_rules_config
                  get_external_access_rule_config = parent_rpcs.get_external_access_rule if parent_rpcs.respond_to? :get_external_access_rule
                  @get_external_access_rule = ::Gapic::Config::Method.new get_external_access_rule_config
                  create_external_access_rule_config = parent_rpcs.create_external_access_rule if parent_rpcs.respond_to? :create_external_access_rule
                  @create_external_access_rule = ::Gapic::Config::Method.new create_external_access_rule_config
                  update_external_access_rule_config = parent_rpcs.update_external_access_rule if parent_rpcs.respond_to? :update_external_access_rule
                  @update_external_access_rule = ::Gapic::Config::Method.new update_external_access_rule_config
                  delete_external_access_rule_config = parent_rpcs.delete_external_access_rule if parent_rpcs.respond_to? :delete_external_access_rule
                  @delete_external_access_rule = ::Gapic::Config::Method.new delete_external_access_rule_config
                  list_logging_servers_config = parent_rpcs.list_logging_servers if parent_rpcs.respond_to? :list_logging_servers
                  @list_logging_servers = ::Gapic::Config::Method.new list_logging_servers_config
                  get_logging_server_config = parent_rpcs.get_logging_server if parent_rpcs.respond_to? :get_logging_server
                  @get_logging_server = ::Gapic::Config::Method.new get_logging_server_config
                  create_logging_server_config = parent_rpcs.create_logging_server if parent_rpcs.respond_to? :create_logging_server
                  @create_logging_server = ::Gapic::Config::Method.new create_logging_server_config
                  update_logging_server_config = parent_rpcs.update_logging_server if parent_rpcs.respond_to? :update_logging_server
                  @update_logging_server = ::Gapic::Config::Method.new update_logging_server_config
                  delete_logging_server_config = parent_rpcs.delete_logging_server if parent_rpcs.respond_to? :delete_logging_server
                  @delete_logging_server = ::Gapic::Config::Method.new delete_logging_server_config
                  list_node_types_config = parent_rpcs.list_node_types if parent_rpcs.respond_to? :list_node_types
                  @list_node_types = ::Gapic::Config::Method.new list_node_types_config
                  get_node_type_config = parent_rpcs.get_node_type if parent_rpcs.respond_to? :get_node_type
                  @get_node_type = ::Gapic::Config::Method.new get_node_type_config
                  show_nsx_credentials_config = parent_rpcs.show_nsx_credentials if parent_rpcs.respond_to? :show_nsx_credentials
                  @show_nsx_credentials = ::Gapic::Config::Method.new show_nsx_credentials_config
                  show_vcenter_credentials_config = parent_rpcs.show_vcenter_credentials if parent_rpcs.respond_to? :show_vcenter_credentials
                  @show_vcenter_credentials = ::Gapic::Config::Method.new show_vcenter_credentials_config
                  reset_nsx_credentials_config = parent_rpcs.reset_nsx_credentials if parent_rpcs.respond_to? :reset_nsx_credentials
                  @reset_nsx_credentials = ::Gapic::Config::Method.new reset_nsx_credentials_config
                  reset_vcenter_credentials_config = parent_rpcs.reset_vcenter_credentials if parent_rpcs.respond_to? :reset_vcenter_credentials
                  @reset_vcenter_credentials = ::Gapic::Config::Method.new reset_vcenter_credentials_config
                  get_dns_forwarding_config = parent_rpcs.get_dns_forwarding if parent_rpcs.respond_to? :get_dns_forwarding
                  @get_dns_forwarding = ::Gapic::Config::Method.new get_dns_forwarding_config
                  update_dns_forwarding_config = parent_rpcs.update_dns_forwarding if parent_rpcs.respond_to? :update_dns_forwarding
                  @update_dns_forwarding = ::Gapic::Config::Method.new update_dns_forwarding_config
                  get_network_peering_config = parent_rpcs.get_network_peering if parent_rpcs.respond_to? :get_network_peering
                  @get_network_peering = ::Gapic::Config::Method.new get_network_peering_config
                  list_network_peerings_config = parent_rpcs.list_network_peerings if parent_rpcs.respond_to? :list_network_peerings
                  @list_network_peerings = ::Gapic::Config::Method.new list_network_peerings_config
                  create_network_peering_config = parent_rpcs.create_network_peering if parent_rpcs.respond_to? :create_network_peering
                  @create_network_peering = ::Gapic::Config::Method.new create_network_peering_config
                  delete_network_peering_config = parent_rpcs.delete_network_peering if parent_rpcs.respond_to? :delete_network_peering
                  @delete_network_peering = ::Gapic::Config::Method.new delete_network_peering_config
                  update_network_peering_config = parent_rpcs.update_network_peering if parent_rpcs.respond_to? :update_network_peering
                  @update_network_peering = ::Gapic::Config::Method.new update_network_peering_config
                  list_peering_routes_config = parent_rpcs.list_peering_routes if parent_rpcs.respond_to? :list_peering_routes
                  @list_peering_routes = ::Gapic::Config::Method.new list_peering_routes_config
                  create_hcx_activation_key_config = parent_rpcs.create_hcx_activation_key if parent_rpcs.respond_to? :create_hcx_activation_key
                  @create_hcx_activation_key = ::Gapic::Config::Method.new create_hcx_activation_key_config
                  list_hcx_activation_keys_config = parent_rpcs.list_hcx_activation_keys if parent_rpcs.respond_to? :list_hcx_activation_keys
                  @list_hcx_activation_keys = ::Gapic::Config::Method.new list_hcx_activation_keys_config
                  get_hcx_activation_key_config = parent_rpcs.get_hcx_activation_key if parent_rpcs.respond_to? :get_hcx_activation_key
                  @get_hcx_activation_key = ::Gapic::Config::Method.new get_hcx_activation_key_config
                  get_network_policy_config = parent_rpcs.get_network_policy if parent_rpcs.respond_to? :get_network_policy
                  @get_network_policy = ::Gapic::Config::Method.new get_network_policy_config
                  list_network_policies_config = parent_rpcs.list_network_policies if parent_rpcs.respond_to? :list_network_policies
                  @list_network_policies = ::Gapic::Config::Method.new list_network_policies_config
                  create_network_policy_config = parent_rpcs.create_network_policy if parent_rpcs.respond_to? :create_network_policy
                  @create_network_policy = ::Gapic::Config::Method.new create_network_policy_config
                  update_network_policy_config = parent_rpcs.update_network_policy if parent_rpcs.respond_to? :update_network_policy
                  @update_network_policy = ::Gapic::Config::Method.new update_network_policy_config
                  delete_network_policy_config = parent_rpcs.delete_network_policy if parent_rpcs.respond_to? :delete_network_policy
                  @delete_network_policy = ::Gapic::Config::Method.new delete_network_policy_config
                  list_management_dns_zone_bindings_config = parent_rpcs.list_management_dns_zone_bindings if parent_rpcs.respond_to? :list_management_dns_zone_bindings
                  @list_management_dns_zone_bindings = ::Gapic::Config::Method.new list_management_dns_zone_bindings_config
                  get_management_dns_zone_binding_config = parent_rpcs.get_management_dns_zone_binding if parent_rpcs.respond_to? :get_management_dns_zone_binding
                  @get_management_dns_zone_binding = ::Gapic::Config::Method.new get_management_dns_zone_binding_config
                  create_management_dns_zone_binding_config = parent_rpcs.create_management_dns_zone_binding if parent_rpcs.respond_to? :create_management_dns_zone_binding
                  @create_management_dns_zone_binding = ::Gapic::Config::Method.new create_management_dns_zone_binding_config
                  update_management_dns_zone_binding_config = parent_rpcs.update_management_dns_zone_binding if parent_rpcs.respond_to? :update_management_dns_zone_binding
                  @update_management_dns_zone_binding = ::Gapic::Config::Method.new update_management_dns_zone_binding_config
                  delete_management_dns_zone_binding_config = parent_rpcs.delete_management_dns_zone_binding if parent_rpcs.respond_to? :delete_management_dns_zone_binding
                  @delete_management_dns_zone_binding = ::Gapic::Config::Method.new delete_management_dns_zone_binding_config
                  repair_management_dns_zone_binding_config = parent_rpcs.repair_management_dns_zone_binding if parent_rpcs.respond_to? :repair_management_dns_zone_binding
                  @repair_management_dns_zone_binding = ::Gapic::Config::Method.new repair_management_dns_zone_binding_config
                  create_vmware_engine_network_config = parent_rpcs.create_vmware_engine_network if parent_rpcs.respond_to? :create_vmware_engine_network
                  @create_vmware_engine_network = ::Gapic::Config::Method.new create_vmware_engine_network_config
                  update_vmware_engine_network_config = parent_rpcs.update_vmware_engine_network if parent_rpcs.respond_to? :update_vmware_engine_network
                  @update_vmware_engine_network = ::Gapic::Config::Method.new update_vmware_engine_network_config
                  delete_vmware_engine_network_config = parent_rpcs.delete_vmware_engine_network if parent_rpcs.respond_to? :delete_vmware_engine_network
                  @delete_vmware_engine_network = ::Gapic::Config::Method.new delete_vmware_engine_network_config
                  get_vmware_engine_network_config = parent_rpcs.get_vmware_engine_network if parent_rpcs.respond_to? :get_vmware_engine_network
                  @get_vmware_engine_network = ::Gapic::Config::Method.new get_vmware_engine_network_config
                  list_vmware_engine_networks_config = parent_rpcs.list_vmware_engine_networks if parent_rpcs.respond_to? :list_vmware_engine_networks
                  @list_vmware_engine_networks = ::Gapic::Config::Method.new list_vmware_engine_networks_config
                  create_private_connection_config = parent_rpcs.create_private_connection if parent_rpcs.respond_to? :create_private_connection
                  @create_private_connection = ::Gapic::Config::Method.new create_private_connection_config
                  get_private_connection_config = parent_rpcs.get_private_connection if parent_rpcs.respond_to? :get_private_connection
                  @get_private_connection = ::Gapic::Config::Method.new get_private_connection_config
                  list_private_connections_config = parent_rpcs.list_private_connections if parent_rpcs.respond_to? :list_private_connections
                  @list_private_connections = ::Gapic::Config::Method.new list_private_connections_config
                  update_private_connection_config = parent_rpcs.update_private_connection if parent_rpcs.respond_to? :update_private_connection
                  @update_private_connection = ::Gapic::Config::Method.new update_private_connection_config
                  delete_private_connection_config = parent_rpcs.delete_private_connection if parent_rpcs.respond_to? :delete_private_connection
                  @delete_private_connection = ::Gapic::Config::Method.new delete_private_connection_config
                  list_private_connection_peering_routes_config = parent_rpcs.list_private_connection_peering_routes if parent_rpcs.respond_to? :list_private_connection_peering_routes
                  @list_private_connection_peering_routes = ::Gapic::Config::Method.new list_private_connection_peering_routes_config
                  grant_dns_bind_permission_config = parent_rpcs.grant_dns_bind_permission if parent_rpcs.respond_to? :grant_dns_bind_permission
                  @grant_dns_bind_permission = ::Gapic::Config::Method.new grant_dns_bind_permission_config
                  get_dns_bind_permission_config = parent_rpcs.get_dns_bind_permission if parent_rpcs.respond_to? :get_dns_bind_permission
                  @get_dns_bind_permission = ::Gapic::Config::Method.new get_dns_bind_permission_config
                  revoke_dns_bind_permission_config = parent_rpcs.revoke_dns_bind_permission if parent_rpcs.respond_to? :revoke_dns_bind_permission
                  @revoke_dns_bind_permission = ::Gapic::Config::Method.new revoke_dns_bind_permission_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
