# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/vmmigration/v1/vmmigration_pb"
require "google/cloud/vm_migration/v1/vm_migration/rest"


class ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_sources
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sources_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sources parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sources ::Google::Cloud::VMMigration::V1::ListSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sources({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sources(::Google::Cloud::VMMigration::V1::ListSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sources_client_stub.call_count
      end
    end
  end

  def test_get_source
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::Source.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_source_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_source ::Google::Cloud::VMMigration::V1::GetSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_source(::Google::Cloud::VMMigration::V1::GetSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_source_client_stub.call_count
      end
    end
  end

  def test_create_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_id = "hello world"
    source = {}
    request_id = "hello world"

    create_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_source_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_source({ parent: parent, source_id: source_id, source: source, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_source parent: parent, source_id: source_id, source: source, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_source ::Google::Cloud::VMMigration::V1::CreateSourceRequest.new(parent: parent, source_id: source_id, source: source, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_source({ parent: parent, source_id: source_id, source: source, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_source(::Google::Cloud::VMMigration::V1::CreateSourceRequest.new(parent: parent, source_id: source_id, source: source, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_source_client_stub.call_count
      end
    end
  end

  def test_update_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    source = {}
    request_id = "hello world"

    update_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_update_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_source_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_source({ update_mask: update_mask, source: source, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_source update_mask: update_mask, source: source, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_source ::Google::Cloud::VMMigration::V1::UpdateSourceRequest.new(update_mask: update_mask, source: source, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_source({ update_mask: update_mask, source: source, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_source(::Google::Cloud::VMMigration::V1::UpdateSourceRequest.new(update_mask: update_mask, source: source, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_source_client_stub.call_count
      end
    end
  end

  def test_delete_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_source_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_source({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_source name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_source ::Google::Cloud::VMMigration::V1::DeleteSourceRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_source({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_source(::Google::Cloud::VMMigration::V1::DeleteSourceRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_source_client_stub.call_count
      end
    end
  end

  def test_fetch_inventory
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::FetchInventoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    source = "hello world"
    force_refresh = true

    fetch_inventory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_fetch_inventory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_inventory_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_inventory({ source: source, force_refresh: force_refresh }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_inventory source: source, force_refresh: force_refresh do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_inventory ::Google::Cloud::VMMigration::V1::FetchInventoryRequest.new(source: source, force_refresh: force_refresh) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_inventory({ source: source, force_refresh: force_refresh }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_inventory(::Google::Cloud::VMMigration::V1::FetchInventoryRequest.new(source: source, force_refresh: force_refresh), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_inventory_client_stub.call_count
      end
    end
  end

  def test_fetch_storage_inventory
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::FetchStorageInventoryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    source = "hello world"
    type = :STORAGE_TYPE_UNSPECIFIED
    force_refresh = true
    page_size = 42
    page_token = "hello world"

    fetch_storage_inventory_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_fetch_storage_inventory_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_storage_inventory_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_storage_inventory({ source: source, type: type, force_refresh: force_refresh, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_storage_inventory source: source, type: type, force_refresh: force_refresh, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_storage_inventory ::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest.new(source: source, type: type, force_refresh: force_refresh, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_storage_inventory({ source: source, type: type, force_refresh: force_refresh, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_storage_inventory(::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest.new(source: source, type: type, force_refresh: force_refresh, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_storage_inventory_client_stub.call_count
      end
    end
  end

  def test_list_utilization_reports
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListUtilizationReportsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    view = :UTILIZATION_REPORT_VIEW_UNSPECIFIED
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_utilization_reports_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_utilization_reports_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_utilization_reports_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_utilization_reports({ parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_utilization_reports parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_utilization_reports ::Google::Cloud::VMMigration::V1::ListUtilizationReportsRequest.new(parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_utilization_reports({ parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_utilization_reports(::Google::Cloud::VMMigration::V1::ListUtilizationReportsRequest.new(parent: parent, view: view, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_utilization_reports_client_stub.call_count
      end
    end
  end

  def test_get_utilization_report
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::UtilizationReport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :UTILIZATION_REPORT_VIEW_UNSPECIFIED

    get_utilization_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_utilization_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_utilization_report_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_utilization_report({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_utilization_report name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_utilization_report ::Google::Cloud::VMMigration::V1::GetUtilizationReportRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_utilization_report({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_utilization_report(::Google::Cloud::VMMigration::V1::GetUtilizationReportRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_utilization_report_client_stub.call_count
      end
    end
  end

  def test_create_utilization_report
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    utilization_report = {}
    utilization_report_id = "hello world"
    request_id = "hello world"

    create_utilization_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_utilization_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_utilization_report_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_utilization_report({ parent: parent, utilization_report: utilization_report, utilization_report_id: utilization_report_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_utilization_report parent: parent, utilization_report: utilization_report, utilization_report_id: utilization_report_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_utilization_report ::Google::Cloud::VMMigration::V1::CreateUtilizationReportRequest.new(parent: parent, utilization_report: utilization_report, utilization_report_id: utilization_report_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_utilization_report({ parent: parent, utilization_report: utilization_report, utilization_report_id: utilization_report_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_utilization_report(::Google::Cloud::VMMigration::V1::CreateUtilizationReportRequest.new(parent: parent, utilization_report: utilization_report, utilization_report_id: utilization_report_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_utilization_report_client_stub.call_count
      end
    end
  end

  def test_delete_utilization_report
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_utilization_report_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_utilization_report_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_utilization_report_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_utilization_report({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_utilization_report name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_utilization_report ::Google::Cloud::VMMigration::V1::DeleteUtilizationReportRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_utilization_report({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_utilization_report(::Google::Cloud::VMMigration::V1::DeleteUtilizationReportRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_utilization_report_client_stub.call_count
      end
    end
  end

  def test_list_datacenter_connectors
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListDatacenterConnectorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_datacenter_connectors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_datacenter_connectors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_datacenter_connectors_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_datacenter_connectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_datacenter_connectors parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_datacenter_connectors ::Google::Cloud::VMMigration::V1::ListDatacenterConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_datacenter_connectors({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_datacenter_connectors(::Google::Cloud::VMMigration::V1::ListDatacenterConnectorsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_datacenter_connectors_client_stub.call_count
      end
    end
  end

  def test_get_datacenter_connector
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::DatacenterConnector.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_datacenter_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_datacenter_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_datacenter_connector_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_datacenter_connector({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_datacenter_connector name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_datacenter_connector ::Google::Cloud::VMMigration::V1::GetDatacenterConnectorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_datacenter_connector({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_datacenter_connector(::Google::Cloud::VMMigration::V1::GetDatacenterConnectorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_datacenter_connector_client_stub.call_count
      end
    end
  end

  def test_create_datacenter_connector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    datacenter_connector_id = "hello world"
    datacenter_connector = {}
    request_id = "hello world"

    create_datacenter_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_datacenter_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_datacenter_connector_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_datacenter_connector({ parent: parent, datacenter_connector_id: datacenter_connector_id, datacenter_connector: datacenter_connector, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_datacenter_connector parent: parent, datacenter_connector_id: datacenter_connector_id, datacenter_connector: datacenter_connector, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_datacenter_connector ::Google::Cloud::VMMigration::V1::CreateDatacenterConnectorRequest.new(parent: parent, datacenter_connector_id: datacenter_connector_id, datacenter_connector: datacenter_connector, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_datacenter_connector({ parent: parent, datacenter_connector_id: datacenter_connector_id, datacenter_connector: datacenter_connector, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_datacenter_connector(::Google::Cloud::VMMigration::V1::CreateDatacenterConnectorRequest.new(parent: parent, datacenter_connector_id: datacenter_connector_id, datacenter_connector: datacenter_connector, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_datacenter_connector_client_stub.call_count
      end
    end
  end

  def test_delete_datacenter_connector
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_datacenter_connector_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_datacenter_connector_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_datacenter_connector_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_datacenter_connector({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_datacenter_connector name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_datacenter_connector ::Google::Cloud::VMMigration::V1::DeleteDatacenterConnectorRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_datacenter_connector({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_datacenter_connector(::Google::Cloud::VMMigration::V1::DeleteDatacenterConnectorRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_datacenter_connector_client_stub.call_count
      end
    end
  end

  def test_upgrade_appliance
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    datacenter_connector = "hello world"
    request_id = "hello world"

    upgrade_appliance_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_upgrade_appliance_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upgrade_appliance_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upgrade_appliance({ datacenter_connector: datacenter_connector, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upgrade_appliance datacenter_connector: datacenter_connector, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upgrade_appliance ::Google::Cloud::VMMigration::V1::UpgradeApplianceRequest.new(datacenter_connector: datacenter_connector, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upgrade_appliance({ datacenter_connector: datacenter_connector, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upgrade_appliance(::Google::Cloud::VMMigration::V1::UpgradeApplianceRequest.new(datacenter_connector: datacenter_connector, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upgrade_appliance_client_stub.call_count
      end
    end
  end

  def test_create_migrating_vm
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    migrating_vm_id = "hello world"
    migrating_vm = {}
    request_id = "hello world"

    create_migrating_vm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_migrating_vm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_migrating_vm_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_migrating_vm({ parent: parent, migrating_vm_id: migrating_vm_id, migrating_vm: migrating_vm, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_migrating_vm parent: parent, migrating_vm_id: migrating_vm_id, migrating_vm: migrating_vm, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_migrating_vm ::Google::Cloud::VMMigration::V1::CreateMigratingVmRequest.new(parent: parent, migrating_vm_id: migrating_vm_id, migrating_vm: migrating_vm, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_migrating_vm({ parent: parent, migrating_vm_id: migrating_vm_id, migrating_vm: migrating_vm, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_migrating_vm(::Google::Cloud::VMMigration::V1::CreateMigratingVmRequest.new(parent: parent, migrating_vm_id: migrating_vm_id, migrating_vm: migrating_vm, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_migrating_vm_client_stub.call_count
      end
    end
  end

  def test_list_migrating_vms
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListMigratingVmsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"
    view = :MIGRATING_VM_VIEW_UNSPECIFIED

    list_migrating_vms_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_migrating_vms_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_migrating_vms_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_migrating_vms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_migrating_vms parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_migrating_vms ::Google::Cloud::VMMigration::V1::ListMigratingVmsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_migrating_vms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_migrating_vms(::Google::Cloud::VMMigration::V1::ListMigratingVmsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_migrating_vms_client_stub.call_count
      end
    end
  end

  def test_get_migrating_vm
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::MigratingVm.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :MIGRATING_VM_VIEW_UNSPECIFIED

    get_migrating_vm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_migrating_vm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_migrating_vm_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_migrating_vm({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_migrating_vm name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_migrating_vm ::Google::Cloud::VMMigration::V1::GetMigratingVmRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_migrating_vm({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_migrating_vm(::Google::Cloud::VMMigration::V1::GetMigratingVmRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_migrating_vm_client_stub.call_count
      end
    end
  end

  def test_update_migrating_vm
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    migrating_vm = {}
    request_id = "hello world"

    update_migrating_vm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_update_migrating_vm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_migrating_vm_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_migrating_vm({ update_mask: update_mask, migrating_vm: migrating_vm, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_migrating_vm update_mask: update_mask, migrating_vm: migrating_vm, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_migrating_vm ::Google::Cloud::VMMigration::V1::UpdateMigratingVmRequest.new(update_mask: update_mask, migrating_vm: migrating_vm, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_migrating_vm({ update_mask: update_mask, migrating_vm: migrating_vm, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_migrating_vm(::Google::Cloud::VMMigration::V1::UpdateMigratingVmRequest.new(update_mask: update_mask, migrating_vm: migrating_vm, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_migrating_vm_client_stub.call_count
      end
    end
  end

  def test_delete_migrating_vm
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_migrating_vm_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_migrating_vm_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_migrating_vm_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_migrating_vm({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_migrating_vm name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_migrating_vm ::Google::Cloud::VMMigration::V1::DeleteMigratingVmRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_migrating_vm({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_migrating_vm(::Google::Cloud::VMMigration::V1::DeleteMigratingVmRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_migrating_vm_client_stub.call_count
      end
    end
  end

  def test_start_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    migrating_vm = "hello world"

    start_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_start_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_migration({ migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_migration migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_migration ::Google::Cloud::VMMigration::V1::StartMigrationRequest.new(migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_migration({ migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_migration(::Google::Cloud::VMMigration::V1::StartMigrationRequest.new(migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_migration_client_stub.call_count
      end
    end
  end

  def test_resume_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    migrating_vm = "hello world"

    resume_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_resume_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_migration({ migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_migration migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_migration ::Google::Cloud::VMMigration::V1::ResumeMigrationRequest.new(migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_migration({ migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_migration(::Google::Cloud::VMMigration::V1::ResumeMigrationRequest.new(migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_migration_client_stub.call_count
      end
    end
  end

  def test_pause_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    migrating_vm = "hello world"

    pause_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_pause_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, pause_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.pause_migration({ migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.pause_migration migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.pause_migration ::Google::Cloud::VMMigration::V1::PauseMigrationRequest.new(migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.pause_migration({ migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.pause_migration(::Google::Cloud::VMMigration::V1::PauseMigrationRequest.new(migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, pause_migration_client_stub.call_count
      end
    end
  end

  def test_finalize_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    migrating_vm = "hello world"

    finalize_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_finalize_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, finalize_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.finalize_migration({ migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.finalize_migration migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.finalize_migration ::Google::Cloud::VMMigration::V1::FinalizeMigrationRequest.new(migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.finalize_migration({ migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.finalize_migration(::Google::Cloud::VMMigration::V1::FinalizeMigrationRequest.new(migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, finalize_migration_client_stub.call_count
      end
    end
  end

  def test_extend_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    migrating_vm = "hello world"

    extend_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_extend_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, extend_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.extend_migration({ migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.extend_migration migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.extend_migration ::Google::Cloud::VMMigration::V1::ExtendMigrationRequest.new(migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.extend_migration({ migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.extend_migration(::Google::Cloud::VMMigration::V1::ExtendMigrationRequest.new(migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, extend_migration_client_stub.call_count
      end
    end
  end

  def test_create_clone_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    clone_job_id = "hello world"
    clone_job = {}
    request_id = "hello world"

    create_clone_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_clone_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_clone_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_clone_job({ parent: parent, clone_job_id: clone_job_id, clone_job: clone_job, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_clone_job parent: parent, clone_job_id: clone_job_id, clone_job: clone_job, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_clone_job ::Google::Cloud::VMMigration::V1::CreateCloneJobRequest.new(parent: parent, clone_job_id: clone_job_id, clone_job: clone_job, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_clone_job({ parent: parent, clone_job_id: clone_job_id, clone_job: clone_job, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_clone_job(::Google::Cloud::VMMigration::V1::CreateCloneJobRequest.new(parent: parent, clone_job_id: clone_job_id, clone_job: clone_job, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_clone_job_client_stub.call_count
      end
    end
  end

  def test_cancel_clone_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_clone_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_cancel_clone_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_clone_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_clone_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_clone_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_clone_job ::Google::Cloud::VMMigration::V1::CancelCloneJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_clone_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_clone_job(::Google::Cloud::VMMigration::V1::CancelCloneJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_clone_job_client_stub.call_count
      end
    end
  end

  def test_list_clone_jobs
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListCloneJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clone_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_clone_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_clone_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_clone_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_clone_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_clone_jobs ::Google::Cloud::VMMigration::V1::ListCloneJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_clone_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_clone_jobs(::Google::Cloud::VMMigration::V1::ListCloneJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_clone_jobs_client_stub.call_count
      end
    end
  end

  def test_get_clone_job
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::CloneJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_clone_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_clone_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_clone_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_clone_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_clone_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_clone_job ::Google::Cloud::VMMigration::V1::GetCloneJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_clone_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_clone_job(::Google::Cloud::VMMigration::V1::GetCloneJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_clone_job_client_stub.call_count
      end
    end
  end

  def test_create_cutover_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cutover_job_id = "hello world"
    cutover_job = {}
    request_id = "hello world"

    create_cutover_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_cutover_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cutover_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cutover_job({ parent: parent, cutover_job_id: cutover_job_id, cutover_job: cutover_job, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cutover_job parent: parent, cutover_job_id: cutover_job_id, cutover_job: cutover_job, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cutover_job ::Google::Cloud::VMMigration::V1::CreateCutoverJobRequest.new(parent: parent, cutover_job_id: cutover_job_id, cutover_job: cutover_job, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cutover_job({ parent: parent, cutover_job_id: cutover_job_id, cutover_job: cutover_job, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cutover_job(::Google::Cloud::VMMigration::V1::CreateCutoverJobRequest.new(parent: parent, cutover_job_id: cutover_job_id, cutover_job: cutover_job, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cutover_job_client_stub.call_count
      end
    end
  end

  def test_cancel_cutover_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_cutover_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_cancel_cutover_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_cutover_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_cutover_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_cutover_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_cutover_job ::Google::Cloud::VMMigration::V1::CancelCutoverJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_cutover_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_cutover_job(::Google::Cloud::VMMigration::V1::CancelCutoverJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_cutover_job_client_stub.call_count
      end
    end
  end

  def test_list_cutover_jobs
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListCutoverJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_cutover_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_cutover_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_cutover_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_cutover_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_cutover_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_cutover_jobs ::Google::Cloud::VMMigration::V1::ListCutoverJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_cutover_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_cutover_jobs(::Google::Cloud::VMMigration::V1::ListCutoverJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_cutover_jobs_client_stub.call_count
      end
    end
  end

  def test_get_cutover_job
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::CutoverJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cutover_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_cutover_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cutover_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cutover_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cutover_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cutover_job ::Google::Cloud::VMMigration::V1::GetCutoverJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cutover_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cutover_job(::Google::Cloud::VMMigration::V1::GetCutoverJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cutover_job_client_stub.call_count
      end
    end
  end

  def test_list_groups
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_groups_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_groups ::Google::Cloud::VMMigration::V1::ListGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_groups(::Google::Cloud::VMMigration::V1::ListGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_groups_client_stub.call_count
      end
    end
  end

  def test_get_group
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::Group.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_group_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_group ::Google::Cloud::VMMigration::V1::GetGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_group(::Google::Cloud::VMMigration::V1::GetGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_group_client_stub.call_count
      end
    end
  end

  def test_create_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    group_id = "hello world"
    group = {}
    request_id = "hello world"

    create_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_group_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_group({ parent: parent, group_id: group_id, group: group, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_group parent: parent, group_id: group_id, group: group, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_group ::Google::Cloud::VMMigration::V1::CreateGroupRequest.new(parent: parent, group_id: group_id, group: group, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_group({ parent: parent, group_id: group_id, group: group, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_group(::Google::Cloud::VMMigration::V1::CreateGroupRequest.new(parent: parent, group_id: group_id, group: group, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_group_client_stub.call_count
      end
    end
  end

  def test_update_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    group = {}
    request_id = "hello world"

    update_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_update_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_group_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_group({ update_mask: update_mask, group: group, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_group update_mask: update_mask, group: group, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_group ::Google::Cloud::VMMigration::V1::UpdateGroupRequest.new(update_mask: update_mask, group: group, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_group({ update_mask: update_mask, group: group, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_group(::Google::Cloud::VMMigration::V1::UpdateGroupRequest.new(update_mask: update_mask, group: group, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_group_client_stub.call_count
      end
    end
  end

  def test_delete_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_group_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_group({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_group name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_group ::Google::Cloud::VMMigration::V1::DeleteGroupRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_group({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_group(::Google::Cloud::VMMigration::V1::DeleteGroupRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_group_client_stub.call_count
      end
    end
  end

  def test_add_group_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    group = "hello world"
    migrating_vm = "hello world"

    add_group_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_add_group_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_group_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_group_migration({ group: group, migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_group_migration group: group, migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_group_migration ::Google::Cloud::VMMigration::V1::AddGroupMigrationRequest.new(group: group, migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_group_migration({ group: group, migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_group_migration(::Google::Cloud::VMMigration::V1::AddGroupMigrationRequest.new(group: group, migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_group_migration_client_stub.call_count
      end
    end
  end

  def test_remove_group_migration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    group = "hello world"
    migrating_vm = "hello world"

    remove_group_migration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_remove_group_migration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_group_migration_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_group_migration({ group: group, migrating_vm: migrating_vm }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_group_migration group: group, migrating_vm: migrating_vm do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_group_migration ::Google::Cloud::VMMigration::V1::RemoveGroupMigrationRequest.new(group: group, migrating_vm: migrating_vm) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_group_migration({ group: group, migrating_vm: migrating_vm }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_group_migration(::Google::Cloud::VMMigration::V1::RemoveGroupMigrationRequest.new(group: group, migrating_vm: migrating_vm), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_group_migration_client_stub.call_count
      end
    end
  end

  def test_list_target_projects
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListTargetProjectsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_target_projects_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_target_projects_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_target_projects_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_target_projects({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_target_projects parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_target_projects ::Google::Cloud::VMMigration::V1::ListTargetProjectsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_target_projects({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_target_projects(::Google::Cloud::VMMigration::V1::ListTargetProjectsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_target_projects_client_stub.call_count
      end
    end
  end

  def test_get_target_project
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::TargetProject.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_target_project_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_target_project_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_target_project_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_target_project({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_target_project name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_target_project ::Google::Cloud::VMMigration::V1::GetTargetProjectRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_target_project({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_target_project(::Google::Cloud::VMMigration::V1::GetTargetProjectRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_target_project_client_stub.call_count
      end
    end
  end

  def test_create_target_project
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    target_project_id = "hello world"
    target_project = {}
    request_id = "hello world"

    create_target_project_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_target_project_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_target_project_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_target_project({ parent: parent, target_project_id: target_project_id, target_project: target_project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_target_project parent: parent, target_project_id: target_project_id, target_project: target_project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_target_project ::Google::Cloud::VMMigration::V1::CreateTargetProjectRequest.new(parent: parent, target_project_id: target_project_id, target_project: target_project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_target_project({ parent: parent, target_project_id: target_project_id, target_project: target_project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_target_project(::Google::Cloud::VMMigration::V1::CreateTargetProjectRequest.new(parent: parent, target_project_id: target_project_id, target_project: target_project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_target_project_client_stub.call_count
      end
    end
  end

  def test_update_target_project
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    target_project = {}
    request_id = "hello world"

    update_target_project_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_update_target_project_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_target_project_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_target_project({ update_mask: update_mask, target_project: target_project, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_target_project update_mask: update_mask, target_project: target_project, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_target_project ::Google::Cloud::VMMigration::V1::UpdateTargetProjectRequest.new(update_mask: update_mask, target_project: target_project, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_target_project({ update_mask: update_mask, target_project: target_project, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_target_project(::Google::Cloud::VMMigration::V1::UpdateTargetProjectRequest.new(update_mask: update_mask, target_project: target_project, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_target_project_client_stub.call_count
      end
    end
  end

  def test_delete_target_project
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_target_project_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_target_project_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_target_project_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_target_project({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_target_project name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_target_project ::Google::Cloud::VMMigration::V1::DeleteTargetProjectRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_target_project({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_target_project(::Google::Cloud::VMMigration::V1::DeleteTargetProjectRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_target_project_client_stub.call_count
      end
    end
  end

  def test_list_replication_cycles
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListReplicationCyclesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_replication_cycles_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_replication_cycles_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_replication_cycles_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_replication_cycles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_replication_cycles parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_replication_cycles ::Google::Cloud::VMMigration::V1::ListReplicationCyclesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_replication_cycles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_replication_cycles(::Google::Cloud::VMMigration::V1::ListReplicationCyclesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_replication_cycles_client_stub.call_count
      end
    end
  end

  def test_get_replication_cycle
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ReplicationCycle.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_replication_cycle_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_replication_cycle_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_replication_cycle_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_replication_cycle({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_replication_cycle name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_replication_cycle ::Google::Cloud::VMMigration::V1::GetReplicationCycleRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_replication_cycle({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_replication_cycle(::Google::Cloud::VMMigration::V1::GetReplicationCycleRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_replication_cycle_client_stub.call_count
      end
    end
  end

  def test_list_image_imports
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListImageImportsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_image_imports_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_image_imports_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_image_imports_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_image_imports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_image_imports parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_image_imports ::Google::Cloud::VMMigration::V1::ListImageImportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_image_imports({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_image_imports(::Google::Cloud::VMMigration::V1::ListImageImportsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_image_imports_client_stub.call_count
      end
    end
  end

  def test_get_image_import
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ImageImport.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_image_import_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_image_import_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_image_import_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_image_import({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_image_import name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_image_import ::Google::Cloud::VMMigration::V1::GetImageImportRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_image_import({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_image_import(::Google::Cloud::VMMigration::V1::GetImageImportRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_image_import_client_stub.call_count
      end
    end
  end

  def test_create_image_import
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    image_import_id = "hello world"
    image_import = {}
    request_id = "hello world"

    create_image_import_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_image_import_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_image_import_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_image_import({ parent: parent, image_import_id: image_import_id, image_import: image_import, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_image_import parent: parent, image_import_id: image_import_id, image_import: image_import, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_image_import ::Google::Cloud::VMMigration::V1::CreateImageImportRequest.new(parent: parent, image_import_id: image_import_id, image_import: image_import, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_image_import({ parent: parent, image_import_id: image_import_id, image_import: image_import, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_image_import(::Google::Cloud::VMMigration::V1::CreateImageImportRequest.new(parent: parent, image_import_id: image_import_id, image_import: image_import, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_image_import_client_stub.call_count
      end
    end
  end

  def test_delete_image_import
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_image_import_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_image_import_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_image_import_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_image_import({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_image_import name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_image_import ::Google::Cloud::VMMigration::V1::DeleteImageImportRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_image_import({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_image_import(::Google::Cloud::VMMigration::V1::DeleteImageImportRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_image_import_client_stub.call_count
      end
    end
  end

  def test_list_image_import_jobs
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListImageImportJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_image_import_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_image_import_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_image_import_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_image_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_image_import_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_image_import_jobs ::Google::Cloud::VMMigration::V1::ListImageImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_image_import_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_image_import_jobs(::Google::Cloud::VMMigration::V1::ListImageImportJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_image_import_jobs_client_stub.call_count
      end
    end
  end

  def test_get_image_import_job
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ImageImportJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_image_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_image_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_image_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_image_import_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_image_import_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_image_import_job ::Google::Cloud::VMMigration::V1::GetImageImportJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_image_import_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_image_import_job(::Google::Cloud::VMMigration::V1::GetImageImportJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_image_import_job_client_stub.call_count
      end
    end
  end

  def test_cancel_image_import_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_image_import_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_cancel_image_import_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_image_import_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_image_import_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_image_import_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_image_import_job ::Google::Cloud::VMMigration::V1::CancelImageImportJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_image_import_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_image_import_job(::Google::Cloud::VMMigration::V1::CancelImageImportJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_image_import_job_client_stub.call_count
      end
    end
  end

  def test_create_disk_migration_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    disk_migration_job_id = "hello world"
    disk_migration_job = {}
    request_id = "hello world"

    create_disk_migration_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_create_disk_migration_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_disk_migration_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_disk_migration_job({ parent: parent, disk_migration_job_id: disk_migration_job_id, disk_migration_job: disk_migration_job, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_disk_migration_job parent: parent, disk_migration_job_id: disk_migration_job_id, disk_migration_job: disk_migration_job, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_disk_migration_job ::Google::Cloud::VMMigration::V1::CreateDiskMigrationJobRequest.new(parent: parent, disk_migration_job_id: disk_migration_job_id, disk_migration_job: disk_migration_job, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_disk_migration_job({ parent: parent, disk_migration_job_id: disk_migration_job_id, disk_migration_job: disk_migration_job, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_disk_migration_job(::Google::Cloud::VMMigration::V1::CreateDiskMigrationJobRequest.new(parent: parent, disk_migration_job_id: disk_migration_job_id, disk_migration_job: disk_migration_job, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_disk_migration_job_client_stub.call_count
      end
    end
  end

  def test_list_disk_migration_jobs
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::ListDiskMigrationJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_disk_migration_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_list_disk_migration_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_disk_migration_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_disk_migration_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_disk_migration_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_disk_migration_jobs ::Google::Cloud::VMMigration::V1::ListDiskMigrationJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_disk_migration_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_disk_migration_jobs(::Google::Cloud::VMMigration::V1::ListDiskMigrationJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_disk_migration_jobs_client_stub.call_count
      end
    end
  end

  def test_get_disk_migration_job
    # Create test objects.
    client_result = ::Google::Cloud::VMMigration::V1::DiskMigrationJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_disk_migration_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_get_disk_migration_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_disk_migration_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_disk_migration_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_disk_migration_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_disk_migration_job ::Google::Cloud::VMMigration::V1::GetDiskMigrationJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_disk_migration_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_disk_migration_job(::Google::Cloud::VMMigration::V1::GetDiskMigrationJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_disk_migration_job_client_stub.call_count
      end
    end
  end

  def test_update_disk_migration_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    disk_migration_job = {}
    request_id = "hello world"

    update_disk_migration_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_update_disk_migration_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_disk_migration_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_disk_migration_job({ update_mask: update_mask, disk_migration_job: disk_migration_job, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_disk_migration_job update_mask: update_mask, disk_migration_job: disk_migration_job, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_disk_migration_job ::Google::Cloud::VMMigration::V1::UpdateDiskMigrationJobRequest.new(update_mask: update_mask, disk_migration_job: disk_migration_job, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_disk_migration_job({ update_mask: update_mask, disk_migration_job: disk_migration_job, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_disk_migration_job(::Google::Cloud::VMMigration::V1::UpdateDiskMigrationJobRequest.new(update_mask: update_mask, disk_migration_job: disk_migration_job, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_disk_migration_job_client_stub.call_count
      end
    end
  end

  def test_delete_disk_migration_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_disk_migration_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_delete_disk_migration_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_disk_migration_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_disk_migration_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_disk_migration_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_disk_migration_job ::Google::Cloud::VMMigration::V1::DeleteDiskMigrationJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_disk_migration_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_disk_migration_job(::Google::Cloud::VMMigration::V1::DeleteDiskMigrationJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_disk_migration_job_client_stub.call_count
      end
    end
  end

  def test_run_disk_migration_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    run_disk_migration_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_run_disk_migration_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_disk_migration_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_disk_migration_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_disk_migration_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_disk_migration_job ::Google::Cloud::VMMigration::V1::RunDiskMigrationJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_disk_migration_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_disk_migration_job(::Google::Cloud::VMMigration::V1::RunDiskMigrationJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_disk_migration_job_client_stub.call_count
      end
    end
  end

  def test_cancel_disk_migration_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_disk_migration_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::VMMigration::V1::VMMigration::Rest::ServiceStub.stub :transcode_cancel_disk_migration_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_disk_migration_job_client_stub do
        # Create client
        client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_disk_migration_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_disk_migration_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_disk_migration_job ::Google::Cloud::VMMigration::V1::CancelDiskMigrationJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_disk_migration_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_disk_migration_job(::Google::Cloud::VMMigration::V1::CancelDiskMigrationJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_disk_migration_job_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::VMMigration::V1::VMMigration::Rest::Client::Configuration, config
  end
end
