# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module VMMigration
      module V1
        # ReplicationCycle contains information about the current replication cycle
        # status.
        # @!attribute [rw] name
        #   @return [::String]
        #     The identifier of the ReplicationCycle.
        # @!attribute [rw] cycle_number
        #   @return [::Integer]
        #     The cycle's ordinal number.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the replication cycle has started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the replication cycle has ended.
        # @!attribute [rw] total_pause_duration
        #   @return [::Google::Protobuf::Duration]
        #     The accumulated duration the replication cycle was paused.
        # @!attribute [rw] progress_percent
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     The current progress in percentage of this cycle.
        #     Was replaced by 'steps' field, which breaks down the cycle progression more
        #     accurately.
        # @!attribute [rw] steps
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CycleStep>]
        #     The cycle's steps list representing its progress.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::VMMigration::V1::ReplicationCycle::State]
        #     State of the ReplicationCycle.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the cycle in case of an
        #     error.
        # @!attribute [r] warnings
        #   @return [::Array<::Google::Cloud::VMMigration::V1::MigrationWarning>]
        #     Output only. Warnings that occurred during the cycle.
        class ReplicationCycle
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of a replication cycle.
          module State
            # The state is unknown. This is used for API compatibility only and is not
            # used by the system.
            STATE_UNSPECIFIED = 0

            # The replication cycle is running.
            RUNNING = 1

            # The replication cycle is paused.
            PAUSED = 2

            # The replication cycle finished with errors.
            FAILED = 3

            # The replication cycle finished successfully.
            SUCCEEDED = 4
          end
        end

        # CycleStep holds information about a step progress.
        # @!attribute [rw] initializing_replication
        #   @return [::Google::Cloud::VMMigration::V1::InitializingReplicationStep]
        #     Initializing replication step.
        #
        #     Note: The following fields are mutually exclusive: `initializing_replication`, `replicating`, `post_processing`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] replicating
        #   @return [::Google::Cloud::VMMigration::V1::ReplicatingStep]
        #     Replicating step.
        #
        #     Note: The following fields are mutually exclusive: `replicating`, `initializing_replication`, `post_processing`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] post_processing
        #   @return [::Google::Cloud::VMMigration::V1::PostProcessingStep]
        #     Post processing step.
        #
        #     Note: The following fields are mutually exclusive: `post_processing`, `initializing_replication`, `replicating`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the cycle step has started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the cycle step has ended.
        class CycleStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # InitializingReplicationStep contains specific step details.
        class InitializingReplicationStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReplicatingStep contains specific step details.
        # @!attribute [rw] total_bytes
        #   @return [::Integer]
        #     Total bytes to be handled in the step.
        # @!attribute [rw] replicated_bytes
        #   @return [::Integer]
        #     Replicated bytes in the step.
        # @!attribute [rw] last_two_minutes_average_bytes_per_second
        #   @return [::Integer]
        #     The source disks replication rate for the last 2 minutes in bytes per
        #     second.
        # @!attribute [rw] last_thirty_minutes_average_bytes_per_second
        #   @return [::Integer]
        #     The source disks replication rate for the last 30 minutes in bytes per
        #     second.
        class ReplicatingStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostProcessingStep contains specific step details.
        class PostProcessingStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ReplicationSync contain information about the last replica sync to the cloud.
        # @!attribute [rw] last_sync_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The most updated snapshot created time in the source that finished
        #     replication.
        class ReplicationSync
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MigratingVm describes the VM that will be migrated from a Source environment
        # and its replication state.
        # @!attribute [rw] compute_engine_target_defaults
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineTargetDefaults]
        #     Details of the target VM in Compute Engine.
        #
        #     Note: The following fields are mutually exclusive: `compute_engine_target_defaults`, `compute_engine_disks_target_defaults`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] compute_engine_disks_target_defaults
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDisksTargetDefaults]
        #     Details of the target Persistent Disks in Compute Engine.
        #
        #     Note: The following fields are mutually exclusive: `compute_engine_disks_target_defaults`, `compute_engine_target_defaults`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] vmware_source_vm_details
        #   @return [::Google::Cloud::VMMigration::V1::VmwareSourceVmDetails]
        #     Output only. Details of the VM from a Vmware source.
        #
        #     Note: The following fields are mutually exclusive: `vmware_source_vm_details`, `aws_source_vm_details`, `azure_source_vm_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] aws_source_vm_details
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceVmDetails]
        #     Output only. Details of the VM from an AWS source.
        #
        #     Note: The following fields are mutually exclusive: `aws_source_vm_details`, `vmware_source_vm_details`, `azure_source_vm_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] azure_source_vm_details
        #   @return [::Google::Cloud::VMMigration::V1::AzureSourceVmDetails]
        #     Output only. Details of the VM from an Azure source.
        #
        #     Note: The following fields are mutually exclusive: `azure_source_vm_details`, `vmware_source_vm_details`, `aws_source_vm_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The identifier of the MigratingVm.
        # @!attribute [rw] source_vm_id
        #   @return [::String]
        #     The unique ID of the VM in the source.
        #     The VM's name in vSphere can be changed, so this is not the VM's name but
        #     rather its moRef id. This id is of the form vm-<num>.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name attached to the MigratingVm by the user.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description attached to the migrating VM by the user.
        # @!attribute [rw] policy
        #   @return [::Google::Cloud::VMMigration::V1::SchedulePolicy]
        #     The replication schedule policy.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the migrating VM was created (this refers to this
        #     resource and not to the time it was installed in the source).
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the migrating VM resource was updated.
        # @!attribute [r] last_sync
        #   @return [::Google::Cloud::VMMigration::V1::ReplicationSync]
        #     Output only. The most updated snapshot created time in the source that
        #     finished replication.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::MigratingVm::State]
        #     Output only. State of the MigratingVm.
        # @!attribute [r] state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the migrating VM state was updated.
        # @!attribute [r] current_sync_info
        #   @return [::Google::Cloud::VMMigration::V1::ReplicationCycle]
        #     Output only. Details of the current running replication cycle.
        # @!attribute [r] last_replication_cycle
        #   @return [::Google::Cloud::VMMigration::V1::ReplicationCycle]
        #     Output only. Details of the last replication cycle. This will be updated
        #     whenever a replication cycle is finished and is not to be confused with
        #     last_sync which is only updated on successful replication cycles.
        # @!attribute [r] group
        #   @return [::String]
        #     Output only. The group this migrating vm is included in, if any. The group
        #     is represented by the full path of the appropriate
        #     {::Google::Cloud::VMMigration::V1::Group Group} resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels of the migrating VM.
        # @!attribute [r] recent_clone_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CloneJob>]
        #     Output only. The recent {::Google::Cloud::VMMigration::V1::CloneJob clone jobs}
        #     performed on the migrating VM. This field holds the vm's last completed
        #     clone job and the vm's running clone job, if one exists.
        #     Note: To have this field populated you need to explicitly request it via
        #     the "view" parameter of the Get/List request.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the Migrating VM in case of
        #     an error in replication.
        # @!attribute [r] recent_cutover_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CutoverJob>]
        #     Output only. The recent cutover jobs performed on the migrating VM.
        #     This field holds the vm's last completed cutover job and the vm's
        #     running cutover job, if one exists.
        #     Note: To have this field populated you need to explicitly request it via
        #     the "view" parameter of the Get/List request.
        # @!attribute [r] cutover_forecast
        #   @return [::Google::Cloud::VMMigration::V1::CutoverForecast]
        #     Output only. Provides details of future CutoverJobs of a MigratingVm.
        #     Set to empty when cutover forecast is unavailable.
        # @!attribute [r] expiration
        #   @return [::Google::Cloud::VMMigration::V1::MigratingVm::Expiration]
        #     Output only. Provides details about the expiration state of the migrating
        #     VM.
        class MigratingVm
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Expiration holds information about the expiration of a MigratingVm.
          # @!attribute [r] expire_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Timestamp of when this resource is considered expired.
          # @!attribute [r] extension_count
          #   @return [::Integer]
          #     Output only. The number of times expiration was extended.
          # @!attribute [r] extendable
          #   @return [::Boolean]
          #     Output only. Describes whether the expiration can be extended.
          class Expiration
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible values of the state/health of source VM.
          module State
            # The state was not sampled by the health checks yet.
            STATE_UNSPECIFIED = 0

            # The VM in the source is being verified.
            PENDING = 1

            # The source VM was verified, and it's ready to start replication.
            READY = 2

            # Migration is going through the first sync cycle.
            FIRST_SYNC = 3

            # The replication is active, and it's running or scheduled to run.
            ACTIVE = 4

            # The source VM is being turned off, and a final replication is currently
            # running.
            CUTTING_OVER = 7

            # The source VM was stopped and replicated. The replication is currently
            # paused.
            CUTOVER = 8

            # A cutover job is active and replication cycle is running the final sync.
            FINAL_SYNC = 9

            # The replication was paused by the user and no cycles are scheduled to
            # run.
            PAUSED = 10

            # The migrating VM is being finalized and migration resources are being
            # removed.
            FINALIZING = 11

            # The replication process is done. The migrating VM is finalized and no
            # longer consumes billable resources.
            FINALIZED = 12

            # The replication process encountered an unrecoverable error and was
            # aborted.
            ERROR = 13

            # The migrating VM has passed its expiration date. It might be possible to
            # bring it back to "Active" state by updating the TTL field. For more
            # information, see the documentation.
            EXPIRED = 14

            # The migrating VM's has been finalized and migration resources have been
            # removed.
            FINALIZED_EXPIRED = 17
          end
        end

        # CutoverForecast holds information about future CutoverJobs of a MigratingVm.
        # @!attribute [r] estimated_cutover_job_duration
        #   @return [::Google::Protobuf::Duration]
        #     Output only. Estimation of the CutoverJob duration.
        class CutoverForecast
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloneJob describes the process of creating a clone of a
        # {::Google::Cloud::VMMigration::V1::MigratingVm MigratingVM} to the
        # requested target based on the latest successful uploaded snapshots.
        # While the migration cycles of a MigratingVm take place, it is possible to
        # verify the uploaded VM can be started in the cloud, by creating a clone. The
        # clone can be created without any downtime, and it is created using the latest
        # snapshots which are already in the cloud. The cloneJob is only responsible
        # for its work, not its products, which means once it is finished, it will
        # never touch the instance it created. It will only delete it in case of the
        # CloneJob being cancelled or upon failure to clone.
        # @!attribute [r] compute_engine_target_details
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineTargetDetails]
        #     Output only. Details of the target VM in Compute Engine.
        #
        #     Note: The following fields are mutually exclusive: `compute_engine_target_details`, `compute_engine_disks_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] compute_engine_disks_target_details
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDisksTargetDetails]
        #     Output only. Details of the target Persistent Disks in Compute Engine.
        #
        #     Note: The following fields are mutually exclusive: `compute_engine_disks_target_details`, `compute_engine_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the clone job was created (as an API call, not when
        #     it was actually created in the target).
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the clone job was ended.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the clone.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::CloneJob::State]
        #     Output only. State of the clone job.
        # @!attribute [r] state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the state was last updated.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details for the errors that led to the Clone Job's
        #     state.
        # @!attribute [r] steps
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CloneStep>]
        #     Output only. The clone steps list representing its progress.
        class CloneJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of the clone job.
          module State
            # The state is unknown. This is used for API compatibility only and is not
            # used by the system.
            STATE_UNSPECIFIED = 0

            # The clone job has not yet started.
            PENDING = 1

            # The clone job is active and running.
            ACTIVE = 2

            # The clone job finished with errors.
            FAILED = 3

            # The clone job finished successfully.
            SUCCEEDED = 4

            # The clone job was cancelled.
            CANCELLED = 5

            # The clone job is being cancelled.
            CANCELLING = 6

            # OS adaptation is running as part of the clone job to generate license.
            ADAPTING_OS = 7
          end
        end

        # CloneStep holds information about the clone step progress.
        # @!attribute [rw] adapting_os
        #   @return [::Google::Cloud::VMMigration::V1::AdaptingOSStep]
        #     Adapting OS step.
        #
        #     Note: The following fields are mutually exclusive: `adapting_os`, `preparing_vm_disks`, `instantiating_migrated_vm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] preparing_vm_disks
        #   @return [::Google::Cloud::VMMigration::V1::PreparingVMDisksStep]
        #     Preparing VM disks step.
        #
        #     Note: The following fields are mutually exclusive: `preparing_vm_disks`, `adapting_os`, `instantiating_migrated_vm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] instantiating_migrated_vm
        #   @return [::Google::Cloud::VMMigration::V1::InstantiatingMigratedVMStep]
        #     Instantiating migrated VM step.
        #
        #     Note: The following fields are mutually exclusive: `instantiating_migrated_vm`, `adapting_os`, `preparing_vm_disks`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the step has started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the step has ended.
        class CloneStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AdaptingOSStep contains specific step details.
        class AdaptingOSStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PreparingVMDisksStep contains specific step details.
        class PreparingVMDisksStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # InstantiatingMigratedVMStep contains specific step details.
        class InstantiatingMigratedVMStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CutoverJob message describes a cutover of a migrating VM. The CutoverJob is
        # the operation of shutting down the VM, creating a snapshot and
        # cloning the VM using the replicated snapshot.
        # @!attribute [r] compute_engine_target_details
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineTargetDetails]
        #     Output only. Details of the target VM in Compute Engine.
        #
        #     Note: The following fields are mutually exclusive: `compute_engine_target_details`, `compute_engine_disks_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] compute_engine_disks_target_details
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDisksTargetDetails]
        #     Output only. Details of the target Persistent Disks in Compute Engine.
        #
        #     Note: The following fields are mutually exclusive: `compute_engine_disks_target_details`, `compute_engine_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the cutover job was created (as an API call, not when
        #     it was actually created in the target).
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the cutover job had finished.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the cutover job.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::CutoverJob::State]
        #     Output only. State of the cutover job.
        # @!attribute [r] state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the state was last updated.
        # @!attribute [r] progress_percent
        #   @return [::Integer]
        #     Output only. The current progress in percentage of the cutover job.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details for the errors that led to the Cutover Job's
        #     state.
        # @!attribute [r] state_message
        #   @return [::String]
        #     Output only. A message providing possible extra details about the current
        #     state.
        # @!attribute [r] steps
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CutoverStep>]
        #     Output only. The cutover steps list representing its progress.
        class CutoverJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of the cutover job.
          module State
            # The state is unknown. This is used for API compatibility only and is not
            # used by the system.
            STATE_UNSPECIFIED = 0

            # The cutover job has not yet started.
            PENDING = 1

            # The cutover job finished with errors.
            FAILED = 2

            # The cutover job finished successfully.
            SUCCEEDED = 3

            # The cutover job was cancelled.
            CANCELLED = 4

            # The cutover job is being cancelled.
            CANCELLING = 5

            # The cutover job is active and running.
            ACTIVE = 6

            # OS adaptation is running as part of the cutover job to generate license.
            ADAPTING_OS = 7
          end
        end

        # CutoverStep holds information about the cutover step progress.
        # @!attribute [rw] previous_replication_cycle
        #   @return [::Google::Cloud::VMMigration::V1::ReplicationCycle]
        #     A replication cycle prior cutover step.
        #
        #     Note: The following fields are mutually exclusive: `previous_replication_cycle`, `shutting_down_source_vm`, `final_sync`, `preparing_vm_disks`, `instantiating_migrated_vm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] shutting_down_source_vm
        #   @return [::Google::Cloud::VMMigration::V1::ShuttingDownSourceVMStep]
        #     Shutting down VM step.
        #
        #     Note: The following fields are mutually exclusive: `shutting_down_source_vm`, `previous_replication_cycle`, `final_sync`, `preparing_vm_disks`, `instantiating_migrated_vm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] final_sync
        #   @return [::Google::Cloud::VMMigration::V1::ReplicationCycle]
        #     Final sync step.
        #
        #     Note: The following fields are mutually exclusive: `final_sync`, `previous_replication_cycle`, `shutting_down_source_vm`, `preparing_vm_disks`, `instantiating_migrated_vm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] preparing_vm_disks
        #   @return [::Google::Cloud::VMMigration::V1::PreparingVMDisksStep]
        #     Preparing VM disks step.
        #
        #     Note: The following fields are mutually exclusive: `preparing_vm_disks`, `previous_replication_cycle`, `shutting_down_source_vm`, `final_sync`, `instantiating_migrated_vm`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] instantiating_migrated_vm
        #   @return [::Google::Cloud::VMMigration::V1::InstantiatingMigratedVMStep]
        #     Instantiating migrated VM step.
        #
        #     Note: The following fields are mutually exclusive: `instantiating_migrated_vm`, `previous_replication_cycle`, `shutting_down_source_vm`, `final_sync`, `preparing_vm_disks`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the step has started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the step has ended.
        class CutoverStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ShuttingDownSourceVMStep contains specific step details.
        class ShuttingDownSourceVMStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateCloneJob' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Clone's parent.
        # @!attribute [rw] clone_job_id
        #   @return [::String]
        #     Required. The clone job identifier.
        # @!attribute [rw] clone_job
        #   @return [::Google::Cloud::VMMigration::V1::CloneJob]
        #     Required. The clone request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateCloneJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CancelCloneJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The clone job id
        class CancelCloneJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'CancelCloneJob' request.
        class CancelCloneJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListCloneJobsRequest' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of source VMs.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of clone jobs to return. The service may
        #     return fewer than this value. If unspecified, at most 500 clone jobs will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListCloneJobs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCloneJobs` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListCloneJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListCloneJobs' request.
        # @!attribute [r] clone_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CloneJob>]
        #     Output only. The list of clone jobs response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListCloneJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetCloneJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CloneJob.
        class GetCloneJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Source message describes a specific vm migration Source resource. It contains
        # the source environment information.
        # @!attribute [rw] vmware
        #   @return [::Google::Cloud::VMMigration::V1::VmwareSourceDetails]
        #     Vmware type source details.
        #
        #     Note: The following fields are mutually exclusive: `vmware`, `aws`, `azure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceDetails]
        #     AWS type source details.
        #
        #     Note: The following fields are mutually exclusive: `aws`, `vmware`, `azure`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] azure
        #   @return [::Google::Cloud::VMMigration::V1::AzureSourceDetails]
        #     Azure type source details.
        #
        #     Note: The following fields are mutually exclusive: `azure`, `vmware`, `aws`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The Source name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update time timestamp.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels of the source.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of the source.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. Immutable. The encryption details of the source data stored by
        #     the service.
        class Source
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Encryption message describes the details of the applied encryption.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Required. The name of the encryption key that is stored in Google Cloud
        #     KMS.
        class Encryption
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VmwareSourceDetails message describes a specific source details for the
        # vmware source type.
        # @!attribute [rw] username
        #   @return [::String]
        #     The credentials username.
        # @!attribute [rw] password
        #   @return [::String]
        #     Input only. The credentials password. This is write only and can not be
        #     read in a GET operation.
        # @!attribute [rw] vcenter_ip
        #   @return [::String]
        #     The ip address of the vcenter this Source represents.
        # @!attribute [rw] thumbprint
        #   @return [::String]
        #     The thumbprint representing the certificate for the vcenter.
        # @!attribute [rw] resolved_vcenter_host
        #   @return [::String]
        #     The hostname of the vcenter.
        class VmwareSourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AwsSourceDetails message describes a specific source details for the
        # AWS source type.
        # @!attribute [rw] access_key_creds
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceDetails::AccessKeyCredentials]
        #     AWS Credentials using access key id and secret.
        # @!attribute [rw] aws_region
        #   @return [::String]
        #     Immutable. The AWS region that the source VMs will be migrated from.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceDetails::State]
        #     Output only. State of the source as determined by the health check.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the Source in case of an
        #     error.
        # @!attribute [rw] inventory_tag_list
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AwsSourceDetails::Tag>]
        #     AWS resource tags to limit the scope of the source inventory.
        # @!attribute [rw] inventory_security_group_names
        #   @return [::Array<::String>]
        #     AWS security group names to limit the scope of the source
        #     inventory.
        # @!attribute [rw] migration_resources_user_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User specified tags to add to every M2VM generated resource in AWS.
        #     These tags will be set in addition to the default tags that are set as part
        #     of the migration process. The tags must not begin with the reserved prefix
        #     `m2vm`.
        # @!attribute [r] public_ip
        #   @return [::String]
        #     Output only. The source's public IP. All communication initiated by this
        #     source will originate from this IP.
        class AwsSourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message describing AWS Credentials using access key id and secret.
          # @!attribute [rw] access_key_id
          #   @return [::String]
          #     AWS access key ID.
          # @!attribute [rw] secret_access_key
          #   @return [::String]
          #     Input only. AWS secret access key.
          # @!attribute [rw] session_token
          #   @return [::String]
          #     Input only. AWS session token.
          #     Used only when AWS security token service (STS) is responsible for
          #     creating the temporary credentials.
          class AccessKeyCredentials
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Tag is an AWS tag representation.
          # @!attribute [rw] key
          #   @return [::String]
          #     Required. Key of tag.
          # @!attribute [rw] value
          #   @return [::String]
          #     Required. Value of tag.
          class Tag
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MigrationResourcesUserTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible values of the state.
          module State
            # The state is unknown. This is used for API compatibility only and is not
            # used by the system.
            STATE_UNSPECIFIED = 0

            # The state was not sampled by the health checks yet.
            PENDING = 1

            # The source is available but might not be usable yet due to invalid
            # credentials or another reason.
            # The error message will contain further details.
            FAILED = 2

            # The source exists and its credentials were verified.
            ACTIVE = 3
          end
        end

        # AzureSourceDetails message describes a specific source details for the
        # Azure source type.
        # @!attribute [rw] client_secret_creds
        #   @return [::Google::Cloud::VMMigration::V1::AzureSourceDetails::ClientSecretCredentials]
        #     Azure Credentials using tenant ID, client ID and secret.
        # @!attribute [rw] subscription_id
        #   @return [::String]
        #     Immutable. Azure subscription ID.
        # @!attribute [rw] azure_location
        #   @return [::String]
        #     Immutable. The Azure location (region) that the source VMs will be migrated
        #     from.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::AzureSourceDetails::State]
        #     Output only. State of the source as determined by the health check.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the Source in case of an
        #     error.
        # @!attribute [rw] migration_resources_user_tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User specified tags to add to every M2VM generated resource in Azure.
        #     These tags will be set in addition to the default tags that are set as part
        #     of the migration process. The tags must not begin with the reserved prefix
        #     `m4ce` or `m2vm`.
        # @!attribute [r] resource_group_id
        #   @return [::String]
        #     Output only. The ID of the Azure resource group that contains all resources
        #     related to the migration process of this source.
        class AzureSourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message describing Azure Credentials using tenant ID, client ID and secret.
          # @!attribute [rw] tenant_id
          #   @return [::String]
          #     Azure tenant ID.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     Azure client ID.
          # @!attribute [rw] client_secret
          #   @return [::String]
          #     Input only. Azure client secret.
          class ClientSecretCredentials
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MigrationResourcesUserTagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible values of the state.
          module State
            # The state is unknown. This is used for API compatibility only and is not
            # used by the system.
            STATE_UNSPECIFIED = 0

            # The state was not sampled by the health checks yet.
            PENDING = 1

            # The source is available but might not be usable yet due to invalid
            # credentials or another reason.
            # The error message will contain further details.
            FAILED = 2

            # The source exists and its credentials were verified.
            ACTIVE = 3
          end
        end

        # DatacenterConnector message describes a connector between the Source and
        # Google Cloud, which is installed on a vmware datacenter (an OVA vm installed
        # by the user) to connect the Datacenter to Google Cloud and support vm
        # migration data transfer.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the connector was created (as an API call, not when
        #     it was actually installed).
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the connector was updated with an API call.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The connector's name.
        # @!attribute [rw] registration_id
        #   @return [::String]
        #     Immutable. A unique key for this connector. This key is internal to the OVA
        #     connector and is supplied with its creation during the registration process
        #     and can not be modified.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account to use in the connector when communicating with the
        #     cloud.
        # @!attribute [rw] version
        #   @return [::String]
        #     The version running in the DatacenterConnector. This is supplied by the OVA
        #     connector during the registration process and can not be modified.
        # @!attribute [r] bucket
        #   @return [::String]
        #     Output only. The communication channel between the datacenter connector and
        #     Google Cloud.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::DatacenterConnector::State]
        #     Output only. State of the DatacenterConnector, as determined by the health
        #     checks.
        # @!attribute [r] state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the state was last set.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the Datacenter Connector in
        #     case of an error.
        # @!attribute [r] appliance_infrastructure_version
        #   @return [::String]
        #     Output only. Appliance OVA version.
        #     This is the OVA which is manually installed by the user and contains the
        #     infrastructure for the automatically updatable components on the appliance.
        # @!attribute [r] appliance_software_version
        #   @return [::String]
        #     Output only. Appliance last installed update bundle version.
        #     This is the version of the automatically updatable components on the
        #     appliance.
        # @!attribute [r] available_versions
        #   @return [::Google::Cloud::VMMigration::V1::AvailableUpdates]
        #     Output only. The available versions for updating this appliance.
        # @!attribute [r] upgrade_status
        #   @return [::Google::Cloud::VMMigration::V1::UpgradeStatus]
        #     Output only. The status of the current / last upgradeAppliance operation.
        class DatacenterConnector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible values of the state.
          module State
            # The state is unknown. This is used for API compatibility only and is not
            # used by the system.
            STATE_UNSPECIFIED = 0

            # The state was not sampled by the health checks yet.
            PENDING = 1

            # The source was sampled by health checks and is not available.
            OFFLINE = 2

            # The source is available but might not be usable yet due to unvalidated
            # credentials or another reason. The credentials referred to are the ones
            # to the Source. The error message will contain further details.
            FAILED = 3

            # The source exists and its credentials were verified.
            ACTIVE = 4
          end
        end

        # UpgradeStatus contains information about upgradeAppliance operation.
        # @!attribute [rw] version
        #   @return [::String]
        #     The version to upgrade to.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::VMMigration::V1::UpgradeStatus::State]
        #     The state of the upgradeAppliance operation.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the upgrade operation in case
        #     of an error.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the operation was started.
        # @!attribute [rw] previous_version
        #   @return [::String]
        #     The version from which we upgraded.
        class UpgradeStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible values of the state.
          module State
            # The state was not sampled by the health checks yet.
            STATE_UNSPECIFIED = 0

            # The upgrade has started.
            RUNNING = 1

            # The upgrade failed.
            FAILED = 2

            # The upgrade finished successfully.
            SUCCEEDED = 3
          end
        end

        # Holds information about the available versions for upgrade.
        # @!attribute [rw] new_deployable_appliance
        #   @return [::Google::Cloud::VMMigration::V1::ApplianceVersion]
        #     The newest deployable version of the appliance.
        #     The current appliance can't be updated into this version, and the owner
        #     must manually deploy this OVA to a new appliance.
        # @!attribute [rw] in_place_update
        #   @return [::Google::Cloud::VMMigration::V1::ApplianceVersion]
        #     The latest version for in place update.
        #     The current appliance can be updated to this version using the API or m4c
        #     CLI.
        class AvailableUpdates
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes an appliance version.
        # @!attribute [rw] version
        #   @return [::String]
        #     The appliance version.
        # @!attribute [rw] uri
        #   @return [::String]
        #     A link for downloading the version.
        # @!attribute [rw] critical
        #   @return [::Boolean]
        #     Determine whether it's critical to upgrade the appliance to this version.
        # @!attribute [rw] release_notes_uri
        #   @return [::String]
        #     Link to a page that contains the version release notes.
        class ApplianceVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListSources' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of sources.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of sources to return. The service may return
        #     fewer than this value. If unspecified, at most 500 sources will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListSources` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListSources` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListSourcesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListSources' request.
        # @!attribute [r] sources
        #   @return [::Array<::Google::Cloud::VMMigration::V1::Source>]
        #     Output only. The list of sources response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListSourcesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetSource' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Source name.
        class GetSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateSource' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Source's parent.
        # @!attribute [rw] source_id
        #   @return [::String]
        #     Required. The source identifier.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::VMMigration::V1::Source]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update message for 'UpdateSources' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     Source resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] source
        #   @return [::Google::Cloud::VMMigration::V1::Source]
        #     Required. The update request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteSource' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Source name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteSourceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VMMigration::V1::VMMigration::Client#fetch_inventory fetchInventory}.
        # @!attribute [rw] source
        #   @return [::String]
        #     Required. The name of the Source.
        # @!attribute [rw] force_refresh
        #   @return [::Boolean]
        #     If this flag is set to true, the source will be queried instead of using
        #     cached results. Using this flag will make the call slower.
        class FetchInventoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # VmwareVmDetails describes a VM in vCenter.
        # @!attribute [rw] vm_id
        #   @return [::String]
        #     The VM's id in the source (note that this is not the MigratingVm's id).
        #     This is the moref id of the VM.
        # @!attribute [rw] datacenter_id
        #   @return [::String]
        #     The id of the vCenter's datacenter this VM is contained in.
        # @!attribute [rw] datacenter_description
        #   @return [::String]
        #     The descriptive name of the vCenter's datacenter this VM is contained in.
        # @!attribute [rw] uuid
        #   @return [::String]
        #     The unique identifier of the VM in vCenter.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the VM. Note that this is not necessarily unique.
        # @!attribute [rw] power_state
        #   @return [::Google::Cloud::VMMigration::V1::VmwareVmDetails::PowerState]
        #     The power state of the VM at the moment list was taken.
        # @!attribute [rw] cpu_count
        #   @return [::Integer]
        #     The number of cpus in the VM.
        # @!attribute [rw] memory_mb
        #   @return [::Integer]
        #     The size of the memory of the VM in MB.
        # @!attribute [rw] disk_count
        #   @return [::Integer]
        #     The number of disks the VM has.
        # @!attribute [rw] committed_storage_mb
        #   @return [::Integer]
        #     The total size of the storage allocated to the VM in MB.
        # @!attribute [rw] guest_description
        #   @return [::String]
        #     The VM's OS. See for example
        #     https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html
        #     for types of strings this might hold.
        # @!attribute [r] boot_option
        #   @return [::Google::Cloud::VMMigration::V1::VmwareVmDetails::BootOption]
        #     Output only. The VM Boot Option.
        # @!attribute [r] architecture
        #   @return [::Google::Cloud::VMMigration::V1::VmwareVmDetails::VmArchitecture]
        #     Output only. The CPU architecture.
        class VmwareVmDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible values for the power state of the VM.
          module PowerState
            # Power state is not specified.
            POWER_STATE_UNSPECIFIED = 0

            # The VM is turned ON.
            ON = 1

            # The VM is turned OFF.
            OFF = 2

            # The VM is suspended. This is similar to hibernation or sleep mode.
            SUSPENDED = 3
          end

          # Possible values for vm boot option.
          module BootOption
            # The boot option is unknown.
            BOOT_OPTION_UNSPECIFIED = 0

            # The boot option is EFI.
            EFI = 1

            # The boot option is BIOS.
            BIOS = 2
          end

          # Possible values for the VM architecture.
          module VmArchitecture
            # The architecture is unknown.
            VM_ARCHITECTURE_UNSPECIFIED = 0

            # The architecture is one of the x86 architectures.
            VM_ARCHITECTURE_X86_FAMILY = 1

            # The architecture is ARM64.
            VM_ARCHITECTURE_ARM64 = 2
          end
        end

        # AwsVmDetails describes a VM in AWS.
        # @!attribute [rw] vm_id
        #   @return [::String]
        #     The VM ID in AWS.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the VM. Note that this value is not necessarily unique.
        # @!attribute [rw] source_id
        #   @return [::String]
        #     The id of the AWS's source this VM is connected to.
        # @!attribute [rw] source_description
        #   @return [::String]
        #     The descriptive name of the AWS's source this VM is connected to.
        # @!attribute [r] power_state
        #   @return [::Google::Cloud::VMMigration::V1::AwsVmDetails::PowerState]
        #     Output only. The power state of the VM at the moment list was taken.
        # @!attribute [rw] cpu_count
        #   @return [::Integer]
        #     The number of CPU cores the VM has.
        # @!attribute [rw] memory_mb
        #   @return [::Integer]
        #     The memory size of the VM in MB.
        # @!attribute [rw] disk_count
        #   @return [::Integer]
        #     The number of disks the VM has.
        # @!attribute [rw] committed_storage_mb
        #   @return [::Integer]
        #     The total size of the storage allocated to the VM in MB.
        # @!attribute [rw] os_description
        #   @return [::String]
        #     The VM's OS.
        # @!attribute [rw] boot_option
        #   @return [::Google::Cloud::VMMigration::V1::AwsVmDetails::BootOption]
        #     The VM Boot Option.
        # @!attribute [rw] instance_type
        #   @return [::String]
        #     The instance type of the VM.
        # @!attribute [rw] vpc_id
        #   @return [::String]
        #     The VPC ID the VM belongs to.
        # @!attribute [rw] security_groups
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AwsSecurityGroup>]
        #     The security groups the VM belongs to.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The tags of the VM.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The AWS zone of the VM.
        # @!attribute [rw] virtualization_type
        #   @return [::Google::Cloud::VMMigration::V1::AwsVmDetails::VmVirtualizationType]
        #     The virtualization type.
        # @!attribute [rw] architecture
        #   @return [::Google::Cloud::VMMigration::V1::AwsVmDetails::VmArchitecture]
        #     The CPU architecture.
        # @!attribute [rw] vcpu_count
        #   @return [::Integer]
        #     The number of vCPUs the VM has. It is calculated as the
        #     number of CPU cores * threads per CPU the VM has.
        class AwsVmDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible values for the power state of the VM.
          module PowerState
            # Power state is not specified.
            POWER_STATE_UNSPECIFIED = 0

            # The VM is turned on.
            ON = 1

            # The VM is turned off.
            OFF = 2

            # The VM is suspended. This is similar to hibernation or sleep
            # mode.
            SUSPENDED = 3

            # The VM is starting.
            PENDING = 4
          end

          # The possible values for the vm boot option.
          module BootOption
            # The boot option is unknown.
            BOOT_OPTION_UNSPECIFIED = 0

            # The boot option is UEFI.
            EFI = 1

            # The boot option is LEGACY-BIOS.
            BIOS = 2
          end

          # Possible values for the virtualization types of the VM.
          module VmVirtualizationType
            # The virtualization type is unknown.
            VM_VIRTUALIZATION_TYPE_UNSPECIFIED = 0

            # The virtualziation type is HVM.
            HVM = 1

            # The virtualziation type is PARAVIRTUAL.
            PARAVIRTUAL = 2
          end

          # Possible values for the architectures of the VM.
          module VmArchitecture
            # The architecture is unknown.
            VM_ARCHITECTURE_UNSPECIFIED = 0

            # The architecture is I386.
            I386 = 1

            # The architecture is X86_64.
            X86_64 = 2

            # The architecture is ARM64.
            ARM64 = 3

            # The architecture is X86_64_MAC.
            X86_64_MAC = 4
          end
        end

        # AwsSecurityGroup describes a security group of an AWS VM.
        # @!attribute [rw] id
        #   @return [::String]
        #     The AWS security group id.
        # @!attribute [rw] name
        #   @return [::String]
        #     The AWS security group name.
        class AwsSecurityGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AzureVmDetails describes a VM in Azure.
        # @!attribute [rw] vm_id
        #   @return [::String]
        #     The VM full path in Azure.
        # @!attribute [rw] power_state
        #   @return [::Google::Cloud::VMMigration::V1::AzureVmDetails::PowerState]
        #     The power state of the VM at the moment list was taken.
        # @!attribute [rw] vm_size
        #   @return [::String]
        #     VM size as configured in Azure. Determines the VM's hardware spec.
        # @!attribute [rw] cpu_count
        #   @return [::Integer]
        #     The number of cpus the VM has.
        # @!attribute [rw] memory_mb
        #   @return [::Integer]
        #     The memory size of the VM in MB.
        # @!attribute [rw] disk_count
        #   @return [::Integer]
        #     The number of disks the VM has, including OS disk.
        # @!attribute [rw] committed_storage_mb
        #   @return [::Integer]
        #     The total size of the storage allocated to the VM in MB.
        # @!attribute [rw] os_disk
        #   @return [::Google::Cloud::VMMigration::V1::AzureVmDetails::OSDisk]
        #     Description of the OS disk.
        # @!attribute [rw] disks
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AzureVmDetails::Disk>]
        #     Description of the data disks.
        # @!attribute [rw] os_description
        #   @return [::Google::Cloud::VMMigration::V1::AzureVmDetails::OSDescription]
        #     Description of the OS.
        # @!attribute [rw] boot_option
        #   @return [::Google::Cloud::VMMigration::V1::AzureVmDetails::BootOption]
        #     The VM Boot Option.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The tags of the VM.
        # @!attribute [rw] computer_name
        #   @return [::String]
        #     The VM's ComputerName.
        # @!attribute [rw] architecture
        #   @return [::Google::Cloud::VMMigration::V1::AzureVmDetails::VmArchitecture]
        #     The CPU architecture.
        class AzureVmDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A message describing the OS disk.
          # @!attribute [rw] type
          #   @return [::String]
          #     The disk's type.
          # @!attribute [rw] name
          #   @return [::String]
          #     The disk's full name.
          # @!attribute [rw] size_gb
          #   @return [::Integer]
          #     The disk's size in GB.
          class OSDisk
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A message describing a data disk.
          # @!attribute [rw] name
          #   @return [::String]
          #     The disk name.
          # @!attribute [rw] size_gb
          #   @return [::Integer]
          #     The disk size in GB.
          # @!attribute [rw] lun
          #   @return [::Integer]
          #     The disk's Logical Unit Number (LUN).
          class Disk
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A message describing the VM's OS. Including OS, Publisher, Offer and Plan
          # if applicable.
          # @!attribute [rw] type
          #   @return [::String]
          #     OS type.
          # @!attribute [rw] publisher
          #   @return [::String]
          #     OS publisher.
          # @!attribute [rw] offer
          #   @return [::String]
          #     OS offer.
          # @!attribute [rw] plan
          #   @return [::String]
          #     OS plan.
          class OSDescription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible values for the power state of the VM.
          module PowerState
            # Power state is not specified.
            POWER_STATE_UNSPECIFIED = 0

            # The VM is starting.
            STARTING = 1

            # The VM is running.
            RUNNING = 2

            # The VM is stopping.
            STOPPING = 3

            # The VM is stopped.
            STOPPED = 4

            # The VM is deallocating.
            DEALLOCATING = 5

            # The VM is deallocated.
            DEALLOCATED = 6

            # The VM's power state is unknown.
            UNKNOWN = 7
          end

          # The possible values for the vm boot option.
          module BootOption
            # The boot option is unknown.
            BOOT_OPTION_UNSPECIFIED = 0

            # The boot option is UEFI.
            EFI = 1

            # The boot option is BIOS.
            BIOS = 2
          end

          # Possible values for the VM architecture.
          module VmArchitecture
            # The architecture is unknown.
            VM_ARCHITECTURE_UNSPECIFIED = 0

            # The architecture is one of the x86 architectures.
            VM_ARCHITECTURE_X86_FAMILY = 1

            # The architecture is ARM64.
            VM_ARCHITECTURE_ARM64 = 2
          end
        end

        # VmwareVmsDetails describes VMs in vCenter.
        # @!attribute [rw] details
        #   @return [::Array<::Google::Cloud::VMMigration::V1::VmwareVmDetails>]
        #     The details of the vmware VMs.
        class VmwareVmsDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AWSVmsDetails describes VMs in AWS.
        # @!attribute [rw] details
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AwsVmDetails>]
        #     The details of the AWS VMs.
        class AwsVmsDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AzureVmsDetails describes VMs in Azure.
        # @!attribute [rw] details
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AzureVmDetails>]
        #     The details of the Azure VMs.
        class AzureVmsDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::VMMigration::V1::VMMigration::Client#fetch_inventory fetchInventory}.
        # @!attribute [rw] vmware_vms
        #   @return [::Google::Cloud::VMMigration::V1::VmwareVmsDetails]
        #     The description of the VMs in a Source of type Vmware.
        #
        #     Note: The following fields are mutually exclusive: `vmware_vms`, `aws_vms`, `azure_vms`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] aws_vms
        #   @return [::Google::Cloud::VMMigration::V1::AwsVmsDetails]
        #     The description of the VMs in a Source of type AWS.
        #
        #     Note: The following fields are mutually exclusive: `aws_vms`, `vmware_vms`, `azure_vms`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] azure_vms
        #   @return [::Google::Cloud::VMMigration::V1::AzureVmsDetails]
        #     The description of the VMs in a Source of type Azure.
        #
        #     Note: The following fields are mutually exclusive: `azure_vms`, `vmware_vms`, `aws_vms`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the source was last queried (if the result
        #     is from the cache).
        class FetchInventoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::VMMigration::V1::VMMigration::Client#fetch_storage_inventory fetchStorageInventory}.
        # @!attribute [rw] source
        #   @return [::String]
        #     Required. The name of the Source.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VMMigration::V1::FetchStorageInventoryRequest::StorageType]
        #     Required. The type of the storage inventory to fetch.
        # @!attribute [rw] force_refresh
        #   @return [::Boolean]
        #     Optional. If this flag is set to true, the source will be queried instead
        #     of using cached results. Using this flag will make the call slower.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of VMs to return. The service may return
        #     fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `FetchStorageInventory`
        #     call. Provide this to retrieve the subsequent page. When paginating, all
        #     other parameters provided to `FetchStorageInventory` must match the call
        #     that provided the page token.
        class FetchStorageInventoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of the storage inventory to fetch.
          module StorageType
            # The type is unspecified.
            STORAGE_TYPE_UNSPECIFIED = 0

            # The type is disks.
            DISKS = 1

            # The type is snapshots.
            SNAPSHOTS = 2
          end
        end

        # Response message for
        # {::Google::Cloud::VMMigration::V1::VMMigration::Client#fetch_storage_inventory fetchStorageInventory}.
        # @!attribute [rw] resources
        #   @return [::Array<::Google::Cloud::VMMigration::V1::SourceStorageResource>]
        #     The list of storage resources in the source.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp when the source was last queried (if the result
        #     is from the cache).
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        class FetchStorageInventoryResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SourceStorageResource describes a storage resource in the source.
        # @!attribute [rw] aws_disk_details
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceDiskDetails]
        #     Source AWS volume details.
        class SourceStorageResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Utilization report details the utilization (CPU, memory, etc.) of selected
        # source VMs.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The report unique name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The report display name, as assigned by the user.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::UtilizationReport::State]
        #     Output only. Current state of the report.
        # @!attribute [r] state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the state was last set.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Provides details on the state of the report in case of an
        #     error.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the report was created (this refers to the time of
        #     the request, not the time the report creation completed).
        # @!attribute [rw] time_frame
        #   @return [::Google::Cloud::VMMigration::V1::UtilizationReport::TimeFrame]
        #     Time frame of the report.
        # @!attribute [r] frame_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The point in time when the time frame ends. Notice that the
        #     time frame is counted backwards. For instance if the "frame_end_time" value
        #     is 2021/01/20 and the time frame is WEEK then the report covers the week
        #     between 2021/01/20 and 2021/01/14.
        # @!attribute [r] vm_count
        #   @return [::Integer]
        #     Output only. Total number of VMs included in the report.
        # @!attribute [rw] vms
        #   @return [::Array<::Google::Cloud::VMMigration::V1::VmUtilizationInfo>]
        #     List of utilization information per VM.
        #     When sent as part of the request, the "vm_id" field is used in order to
        #     specify which VMs to include in the report. In that case all other fields
        #     are ignored.
        class UtilizationReport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Utilization report state.
          module State
            # The state is unknown. This value is not in use.
            STATE_UNSPECIFIED = 0

            # The report is in the making.
            CREATING = 1

            # Report creation completed successfully.
            SUCCEEDED = 2

            # Report creation failed.
            FAILED = 3
          end

          # Report time frame options.
          module TimeFrame
            # The time frame was not specified and will default to WEEK.
            TIME_FRAME_UNSPECIFIED = 0

            # One week.
            WEEK = 1

            # One month.
            MONTH = 2

            # One year.
            YEAR = 3
          end
        end

        # Utilization information of a single VM.
        # @!attribute [rw] vmware_vm_details
        #   @return [::Google::Cloud::VMMigration::V1::VmwareVmDetails]
        #     The description of the VM in a Source of type Vmware.
        # @!attribute [rw] vm_id
        #   @return [::String]
        #     The VM's ID in the source.
        # @!attribute [rw] utilization
        #   @return [::Google::Cloud::VMMigration::V1::VmUtilizationMetrics]
        #     Utilization metrics for this VM.
        class VmUtilizationInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Utilization metrics values for a single VM.
        # @!attribute [rw] cpu_max_percent
        #   @return [::Integer]
        #     Max CPU usage, percent.
        # @!attribute [rw] cpu_average_percent
        #   @return [::Integer]
        #     Average CPU usage, percent.
        # @!attribute [rw] memory_max_percent
        #   @return [::Integer]
        #     Max memory usage, percent.
        # @!attribute [rw] memory_average_percent
        #   @return [::Integer]
        #     Average memory usage, percent.
        # @!attribute [rw] disk_io_rate_max_kbps
        #   @return [::Integer]
        #     Max disk IO rate, in kilobytes per second.
        # @!attribute [rw] disk_io_rate_average_kbps
        #   @return [::Integer]
        #     Average disk IO rate, in kilobytes per second.
        # @!attribute [rw] network_throughput_max_kbps
        #   @return [::Integer]
        #     Max network throughput (combined transmit-rates and receive-rates), in
        #     kilobytes per second.
        # @!attribute [rw] network_throughput_average_kbps
        #   @return [::Integer]
        #     Average network throughput (combined transmit-rates and receive-rates), in
        #     kilobytes per second.
        class VmUtilizationMetrics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListUtilizationReports' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Utilization Reports parent.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::VMMigration::V1::UtilizationReportView]
        #     Optional. The level of details of each report.
        #     Defaults to BASIC.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of reports to return. The service may return
        #     fewer than this value. If unspecified, at most 500 reports will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListUtilizationReports`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListUtilizationReports`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListUtilizationReportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListUtilizationReports' request.
        # @!attribute [r] utilization_reports
        #   @return [::Array<::Google::Cloud::VMMigration::V1::UtilizationReport>]
        #     Output only. The list of reports.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListUtilizationReportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetUtilizationReport' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Utilization Report name.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::VMMigration::V1::UtilizationReportView]
        #     Optional. The level of details of the report.
        #     Defaults to FULL
        class GetUtilizationReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateUtilizationReport' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Utilization Report's parent.
        # @!attribute [rw] utilization_report
        #   @return [::Google::Cloud::VMMigration::V1::UtilizationReport]
        #     Required. The report to create.
        # @!attribute [rw] utilization_report_id
        #   @return [::String]
        #     Required. The ID to use for the report, which will become the final
        #     component of the reports's resource name.
        #
        #     This value maximum length is 63 characters, and valid characters
        #     are /[a-z][0-9]-/. It must start with an english letter and must not
        #     end with a hyphen.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateUtilizationReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteUtilizationReport' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Utilization Report name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteUtilizationReportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListDatacenterConnectors' request.
        # @!attribute [r] datacenter_connectors
        #   @return [::Array<::Google::Cloud::VMMigration::V1::DatacenterConnector>]
        #     Output only. The list of sources response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListDatacenterConnectorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetDatacenterConnector' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DatacenterConnector.
        class GetDatacenterConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateDatacenterConnector' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The DatacenterConnector's parent.
        #     Required. The Source in where the new DatacenterConnector will be created.
        #     For example:
        #     `projects/my-project/locations/us-central1/sources/my-source`
        # @!attribute [rw] datacenter_connector_id
        #   @return [::String]
        #     Required. The datacenterConnector identifier.
        # @!attribute [rw] datacenter_connector
        #   @return [::Google::Cloud::VMMigration::V1::DatacenterConnector]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDatacenterConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteDatacenterConnector' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The DatacenterConnector name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteDatacenterConnectorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'UpgradeAppliance' request.
        # @!attribute [rw] datacenter_connector
        #   @return [::String]
        #     Required. The DatacenterConnector name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpgradeApplianceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'UpgradeAppliance' request.
        class UpgradeApplianceResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListDatacenterConnectors' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of connectors.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of connectors to return. The service may
        #     return fewer than this value. If unspecified, at most 500 sources will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListDatacenterConnectors`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     `ListDatacenterConnectors` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListDatacenterConnectorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ComputeEngineTargetDefaults is a collection of details for creating a VM in a
        # target Compute Engine project.
        # @!attribute [rw] vm_name
        #   @return [::String]
        #     The name of the VM to create.
        # @!attribute [rw] target_project
        #   @return [::String]
        #     The full path of the resource of type TargetProject which represents the
        #     Compute Engine project in which to create this VM.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The zone in which to create the VM.
        # @!attribute [rw] machine_type_series
        #   @return [::String]
        #     The machine type series to create the VM with.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     The machine type to create the VM with.
        # @!attribute [rw] network_tags
        #   @return [::Array<::String>]
        #     A list of network tags to associate with the VM.
        # @!attribute [rw] network_interfaces
        #   @return [::Array<::Google::Cloud::VMMigration::V1::NetworkInterface>]
        #     List of NICs connected to this VM.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The service account to associate the VM with.
        # @!attribute [rw] disk_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDiskType]
        #     The disk type to use in the VM.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A map of labels to associate with the VM.
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineLicenseType]
        #     The license type to use in OS adaptation.
        # @!attribute [r] applied_license
        #   @return [::Google::Cloud::VMMigration::V1::AppliedLicense]
        #     Output only. The OS license returned from the adaptation module report.
        # @!attribute [rw] compute_scheduling
        #   @return [::Google::Cloud::VMMigration::V1::ComputeScheduling]
        #     Compute instance scheduling information (if empty default is used).
        # @!attribute [rw] secure_boot
        #   @return [::Boolean]
        #     Defines whether the instance has Secure Boot enabled.
        #     This can be set to true only if the VM boot option is EFI.
        # @!attribute [rw] enable_vtpm
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has vTPM enabled.
        #     This can be set to true only if the VM boot option is EFI.
        # @!attribute [rw] enable_integrity_monitoring
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has integrity monitoring enabled.
        #     This can be set to true only if the VM boot option is EFI, and vTPM is
        #     enabled.
        # @!attribute [r] boot_option
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineBootOption]
        #     Output only. The VM Boot Option, as set in the source VM.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The metadata key/value pairs to assign to the VM.
        # @!attribute [rw] additional_licenses
        #   @return [::Array<::String>]
        #     Additional licenses to assign to the VM.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     The hostname to assign to the VM.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. Immutable. The encryption to apply to the VM disks.
        # @!attribute [rw] boot_conversion
        #   @return [::Google::Cloud::VMMigration::V1::BootConversion]
        #     Optional. By default the virtual machine will keep its existing boot
        #     option. Setting this property will trigger an internal process which will
        #     convert the virtual machine from using the existing boot option to another.
        # @!attribute [rw] adaptation_modifiers
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AdaptationModifier>]
        #     Optional. AdaptationModifiers are the set of modifiers used during OS
        #     adaptation.
        # @!attribute [rw] disk_replica_zones
        #   @return [::Array<::String>]
        #     Optional. Additional replica zones of the target regional disks.
        #     If this list is not empty a regional disk will be created. The first
        #     supported zone would be the one stated in the
        #     {::Google::Cloud::VMMigration::V1::ComputeEngineTargetDefaults#zone zone} field.
        #     The rest are taken from this list. Please refer to the [regional disk
        #     creation
        #     API](https://cloud.google.com/compute/docs/regions-zones/global-regional-zonal-resources)
        #     for further details about regional vs zonal disks. If not specified, a
        #     zonal disk will be created in the same zone the VM is created.
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     Optional. If specified this will be the storage pool in which the disk is
        #     created. This is the full path of the storage pool resource, for example:
        #     "projects/my-project/zones/us-central1-a/storagePools/my-storage-pool".
        #     The storage pool must be in the same project and zone as the target disks.
        #     The storage pool's type must match the disk type.
        class ComputeEngineTargetDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # AdaptationModifier a modifier to be used for configuration of the OS
        # adaptation process.
        # @!attribute [rw] modifier
        #   @return [::String]
        #     Optional. The modifier name.
        # @!attribute [rw] value
        #   @return [::String]
        #     Optional. The value of the modifier.
        #     The actual value depends on the modifier and can also be empty.
        class AdaptationModifier
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ComputeEngineTargetDetails is a collection of details for creating a VM in a
        # target Compute Engine project.
        # @!attribute [rw] vm_name
        #   @return [::String]
        #     The name of the VM to create.
        # @!attribute [rw] project
        #   @return [::String]
        #     The Google Cloud target project ID or project name.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The zone in which to create the VM.
        # @!attribute [rw] machine_type_series
        #   @return [::String]
        #     The machine type series to create the VM with.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     The machine type to create the VM with.
        # @!attribute [rw] network_tags
        #   @return [::Array<::String>]
        #     A list of network tags to associate with the VM.
        # @!attribute [rw] network_interfaces
        #   @return [::Array<::Google::Cloud::VMMigration::V1::NetworkInterface>]
        #     List of NICs connected to this VM.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account to associate the VM with.
        # @!attribute [rw] disk_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDiskType]
        #     The disk type to use in the VM.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A map of labels to associate with the VM.
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineLicenseType]
        #     The license type to use in OS adaptation.
        # @!attribute [rw] applied_license
        #   @return [::Google::Cloud::VMMigration::V1::AppliedLicense]
        #     The OS license returned from the adaptation module report.
        # @!attribute [rw] compute_scheduling
        #   @return [::Google::Cloud::VMMigration::V1::ComputeScheduling]
        #     Compute instance scheduling information (if empty default is used).
        # @!attribute [rw] secure_boot
        #   @return [::Boolean]
        #     Defines whether the instance has Secure Boot enabled.
        #     This can be set to true only if the VM boot option is EFI.
        # @!attribute [rw] enable_vtpm
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has vTPM enabled.
        # @!attribute [rw] enable_integrity_monitoring
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has integrity monitoring enabled.
        # @!attribute [rw] boot_option
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineBootOption]
        #     The VM Boot Option, as set in the source VM.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The metadata key/value pairs to assign to the VM.
        # @!attribute [rw] additional_licenses
        #   @return [::Array<::String>]
        #     Additional licenses to assign to the VM.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     The hostname to assign to the VM.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. The encryption to apply to the VM disks.
        # @!attribute [rw] boot_conversion
        #   @return [::Google::Cloud::VMMigration::V1::BootConversion]
        #     Optional. By default the virtual machine will keep its existing boot
        #     option. Setting this property will trigger an internal process which will
        #     convert the virtual machine from using the existing boot option to another.
        # @!attribute [rw] adaptation_modifiers
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AdaptationModifier>]
        #     Optional. Modifiers to be used as configuration of the OS adaptation
        #     process.
        # @!attribute [rw] disk_replica_zones
        #   @return [::Array<::String>]
        #     Optional. Additional replica zones of the target regional disks.
        #     If this list is not empty a regional disk will be created. The first
        #     supported zone would be the one stated in the
        #     {::Google::Cloud::VMMigration::V1::ComputeEngineTargetDetails#zone zone} field.
        #     The rest are taken from this list. Please refer to the [regional disk
        #     creation
        #     API](https://cloud.google.com/compute/docs/regions-zones/global-regional-zonal-resources)
        #     for further details about regional vs zonal disks. If not specified, a
        #     zonal disk will be created in the same zone the VM is created.
        # @!attribute [rw] storage_pool
        #   @return [::String]
        #     Optional. The storage pool used for the VM disks.
        #     If specified this will be the storage pool in which the disk is created.
        #     This is the full path of the storage pool resource, for example:
        #     "projects/my-project/zones/us-central1-a/storagePools/my-storage-pool".
        #     The storage pool must be in the same project and zone as the target disks.
        #     The storage pool's type must match the disk type.
        class ComputeEngineTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # NetworkInterface represents a NIC of a VM.
        # @!attribute [rw] network
        #   @return [::String]
        #     Optional. The network to connect the NIC to.
        # @!attribute [rw] subnetwork
        #   @return [::String]
        #     Optional. The subnetwork to connect the NIC to.
        # @!attribute [rw] internal_ip
        #   @return [::String]
        #     Optional. The internal IP to define in the NIC.
        #     The formats accepted are: `ephemeral` \ ipv4 address \ a named address
        #     resource full path.
        # @!attribute [rw] external_ip
        #   @return [::String]
        #     Optional. The external IP to define in the NIC.
        # @!attribute [rw] network_tier
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineNetworkTier]
        #     Optional. The networking tier used for optimizing connectivity between
        #     instances and systems on the internet. Applies only for external ephemeral
        #     IP addresses. If left empty, will default to PREMIUM.
        class NetworkInterface
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AppliedLicense holds the license data returned by adaptation module report.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::VMMigration::V1::AppliedLicense::Type]
        #     The license type that was used in OS adaptation.
        # @!attribute [rw] os_license
        #   @return [::String]
        #     The OS license returned from the adaptation module's report.
        class AppliedLicense
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # License types used in OS adaptation.
          module Type
            # Unspecified license for the OS.
            TYPE_UNSPECIFIED = 0

            # No license available for the OS.
            NONE = 1

            # The license type is Pay As You Go license type.
            PAYG = 2

            # The license type is Bring Your Own License type.
            BYOL = 3
          end
        end

        # Node Affinity: the configuration of desired nodes onto which this Instance
        # could be scheduled. Based on
        # https://cloud.google.com/compute/docs/reference/rest/v1/instances/setScheduling
        # @!attribute [rw] key
        #   @return [::String]
        #     The label key of Node resource to reference.
        # @!attribute [rw] operator
        #   @return [::Google::Cloud::VMMigration::V1::SchedulingNodeAffinity::Operator]
        #     The operator to use for the node resources specified in the `values`
        #     parameter.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     Corresponds to the label values of Node resource.
        class SchedulingNodeAffinity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible types of node selection operators. Valid operators are IN for
          # affinity and NOT_IN for anti-affinity.
          module Operator
            # An unknown, unexpected behavior.
            OPERATOR_UNSPECIFIED = 0

            # The node resource group should be in these resources affinity.
            IN = 1

            # The node resource group should not be in these resources affinity.
            NOT_IN = 2
          end
        end

        # Scheduling information for VM on maintenance/restart behaviour and
        # node allocation in sole tenant nodes.
        # Options for instance behavior when the host machine undergoes
        # maintenance that may temporarily impact instance performance.
        # @!attribute [rw] on_host_maintenance
        #   @return [::Google::Cloud::VMMigration::V1::ComputeScheduling::OnHostMaintenance]
        #     How the instance should behave when the host machine undergoes
        #     maintenance that may temporarily impact instance performance.
        # @!attribute [rw] restart_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeScheduling::RestartType]
        #     Whether the Instance should be automatically restarted whenever it is
        #     terminated by Compute Engine (not terminated by user).
        #     This configuration is identical to `automaticRestart` field in Compute
        #     Engine create instance under scheduling.
        #     It was changed to an enum (instead of a boolean) to match the default
        #     value in Compute Engine which is automatic restart.
        # @!attribute [rw] node_affinities
        #   @return [::Array<::Google::Cloud::VMMigration::V1::SchedulingNodeAffinity>]
        #     A set of node affinity and anti-affinity configurations for sole tenant
        #     nodes.
        # @!attribute [rw] min_node_cpus
        #   @return [::Integer]
        #     The minimum number of virtual CPUs this instance will consume when
        #     running on a sole-tenant node. Ignored if no node_affinites are
        #     configured.
        class ComputeScheduling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          module OnHostMaintenance
            # An unknown, unexpected behavior.
            ON_HOST_MAINTENANCE_UNSPECIFIED = 0

            # Terminate the instance when the host machine undergoes maintenance.
            TERMINATE = 1

            # Migrate the instance when the host machine undergoes maintenance.
            MIGRATE = 2
          end

          # Defines whether the Instance should be automatically restarted whenever
          # it is terminated by Compute Engine (not terminated by user).
          module RestartType
            # Unspecified behavior. This will use the default.
            RESTART_TYPE_UNSPECIFIED = 0

            # The Instance should be automatically restarted whenever it is
            # terminated by Compute Engine.
            AUTOMATIC_RESTART = 1

            # The Instance isn't automatically restarted whenever it is
            # terminated by Compute Engine.
            NO_AUTOMATIC_RESTART = 2
          end
        end

        # ComputeEngineDisksTargetDefaults is a collection of details for creating
        # Persistent Disks in a target Compute Engine project.
        # @!attribute [rw] zone
        #   @return [::String]
        #     The zone in which to create the Persistent Disks.
        # @!attribute [rw] disks_target_defaults
        #   @return [::Google::Cloud::VMMigration::V1::DisksMigrationDisksTargetDefaults]
        #     Details of the disk only migration target.
        #
        #     Note: The following fields are mutually exclusive: `disks_target_defaults`, `vm_target_defaults`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vm_target_defaults
        #   @return [::Google::Cloud::VMMigration::V1::DisksMigrationVmTargetDefaults]
        #     Details of the VM migration target.
        #
        #     Note: The following fields are mutually exclusive: `vm_target_defaults`, `disks_target_defaults`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] target_project
        #   @return [::String]
        #     The full path of the resource of type TargetProject which represents the
        #     Compute Engine project in which to create the Persistent Disks.
        # @!attribute [rw] disks
        #   @return [::Array<::Google::Cloud::VMMigration::V1::PersistentDiskDefaults>]
        #     The details of each Persistent Disk to create.
        class ComputeEngineDisksTargetDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details for creation of a Persistent Disk.
        # @!attribute [rw] source_disk_number
        #   @return [::Integer]
        #     Required. The ordinal number of the source VM disk.
        # @!attribute [rw] disk_name
        #   @return [::String]
        #     Optional. The name of the Persistent Disk to create.
        # @!attribute [rw] disk_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDiskType]
        #     The disk type to use.
        # @!attribute [rw] additional_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     A map of labels to associate with the Persistent Disk.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. The encryption to apply to the disk.
        # @!attribute [rw] vm_attachment_details
        #   @return [::Google::Cloud::VMMigration::V1::VmAttachmentDetails]
        #     Optional. Details for attachment of the disk to a VM.
        #     Used when the disk is set to be attached to a target VM.
        class PersistentDiskDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AdditionalLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Details for attachment of the disk to a VM.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     Optional. Specifies a unique device name of your choice that is reflected
        #     into the /dev/disk/by-id/google-* tree of a Linux operating system running
        #     within the instance. If not specified, the server chooses a default device
        #     name to apply to this disk, in the form persistent-disk-x, where x is a
        #     number assigned by Google Compute Engine. This field is only applicable for
        #     persistent disks.
        class VmAttachmentDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details for a disk only migration.
        class DisksMigrationDisksTargetDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details for creation of a VM that migrated data disks will be attached to.
        # @!attribute [rw] vm_name
        #   @return [::String]
        #     Required. The name of the VM to create.
        # @!attribute [rw] machine_type_series
        #   @return [::String]
        #     Optional. The machine type series to create the VM with.
        #     For presentation only.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Required. The machine type to create the VM with.
        # @!attribute [rw] network_tags
        #   @return [::Array<::String>]
        #     Optional. A list of network tags to associate with the VM.
        # @!attribute [rw] network_interfaces
        #   @return [::Array<::Google::Cloud::VMMigration::V1::NetworkInterface>]
        #     Optional. NICs to attach to the VM.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The service account to associate the VM with.
        # @!attribute [rw] compute_scheduling
        #   @return [::Google::Cloud::VMMigration::V1::ComputeScheduling]
        #     Optional. Compute instance scheduling information (if empty default is
        #     used).
        # @!attribute [rw] secure_boot
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has Secure Boot enabled.
        #     This can be set to true only if the VM boot option is EFI.
        # @!attribute [rw] enable_vtpm
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has vTPM enabled.
        # @!attribute [rw] enable_integrity_monitoring
        #   @return [::Boolean]
        #     Optional. Defines whether the instance has integrity monitoring enabled.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The metadata key/value pairs to assign to the VM.
        # @!attribute [rw] additional_licenses
        #   @return [::Array<::String>]
        #     Optional. Additional licenses to assign to the VM.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Optional. The hostname to assign to the VM.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. A map of labels to associate with the VM.
        # @!attribute [rw] boot_disk_defaults
        #   @return [::Google::Cloud::VMMigration::V1::BootDiskDefaults]
        #     Optional. Details of the boot disk of the VM.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. The encryption to apply to the VM.
        class DisksMigrationVmTargetDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # BootDiskDefaults hold information about the boot disk of a VM.
        # @!attribute [rw] image
        #   @return [::Google::Cloud::VMMigration::V1::BootDiskDefaults::DiskImageDefaults]
        #     The image to use when creating the disk.
        # @!attribute [rw] disk_name
        #   @return [::String]
        #     Optional. The name of the disk.
        # @!attribute [rw] disk_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDiskType]
        #     Optional. The type of disk provisioning to use for the VM.
        # @!attribute [rw] device_name
        #   @return [::String]
        #     Optional. Specifies a unique device name of your choice that is reflected
        #     into the /dev/disk/by-id/google-* tree of a Linux operating system running
        #     within the instance. If not specified, the server chooses a default device
        #     name to apply to this disk, in the form persistent-disk-x, where x is a
        #     number assigned by Google Compute Engine. This field is only applicable for
        #     persistent disks.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. The encryption to apply to the boot disk.
        class BootDiskDefaults
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains details about the image source used to create the disk.
          # @!attribute [rw] source_image
          #   @return [::String]
          #     Required. The Image resource used when creating the disk.
          class DiskImageDefaults
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # ComputeEngineDisksTargetDetails is a collection of created Persistent Disks
        # details.
        # @!attribute [rw] disks_target_details
        #   @return [::Google::Cloud::VMMigration::V1::DisksMigrationDisksTargetDetails]
        #     Details of the disks-only migration target.
        #
        #     Note: The following fields are mutually exclusive: `disks_target_details`, `vm_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vm_target_details
        #   @return [::Google::Cloud::VMMigration::V1::DisksMigrationVmTargetDetails]
        #     Details for the VM the migrated data disks are attached to.
        #
        #     Note: The following fields are mutually exclusive: `vm_target_details`, `disks_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disks
        #   @return [::Array<::Google::Cloud::VMMigration::V1::PersistentDisk>]
        #     The details of each created Persistent Disk.
        class ComputeEngineDisksTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of a created Persistent Disk.
        # @!attribute [rw] source_disk_number
        #   @return [::Integer]
        #     The ordinal number of the source VM disk.
        # @!attribute [rw] disk_uri
        #   @return [::String]
        #     The URI of the Persistent Disk.
        class PersistentDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details for a disks-only migration.
        class DisksMigrationDisksTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details for the VM created VM as part of disks migration.
        # @!attribute [r] vm_uri
        #   @return [::String]
        #     Output only. The URI of the Compute Engine VM.
        class DisksMigrationVmTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A policy for scheduling replications.
        # @!attribute [rw] idle_duration
        #   @return [::Google::Protobuf::Duration]
        #     The idle duration between replication stages.
        # @!attribute [rw] skip_os_adaptation
        #   @return [::Boolean]
        #     A flag to indicate whether to skip OS adaptation during the replication
        #     sync. OS adaptation is a process where the VM's operating system undergoes
        #     changes and adaptations to fully function on Compute Engine.
        class SchedulePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateMigratingVm' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The MigratingVm's parent.
        # @!attribute [rw] migrating_vm_id
        #   @return [::String]
        #     Required. The migratingVm identifier.
        # @!attribute [rw] migrating_vm
        #   @return [::Google::Cloud::VMMigration::V1::MigratingVm]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateMigratingVmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'LisMigratingVmsRequest' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of MigratingVms.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of migrating VMs to return. The service may
        #     return fewer than this value. If unspecified, at most 500 migrating VMs
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListMigratingVms` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListMigratingVms`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::VMMigration::V1::MigratingVmView]
        #     Optional. The level of details of each migrating VM.
        class ListMigratingVmsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListMigratingVms' request.
        # @!attribute [r] migrating_vms
        #   @return [::Array<::Google::Cloud::VMMigration::V1::MigratingVm>]
        #     Output only. The list of Migrating VMs response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListMigratingVmsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetMigratingVm' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::VMMigration::V1::MigratingVmView]
        #     Optional. The level of details of the migrating VM.
        class GetMigratingVmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'UpdateMigratingVm' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     MigratingVm resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] migrating_vm
        #   @return [::Google::Cloud::VMMigration::V1::MigratingVm]
        #     Required. The update request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateMigratingVmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteMigratingVm' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        class DeleteMigratingVmRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'StartMigrationRequest' request.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        class StartMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'StartMigration' request.
        class StartMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'PauseMigration' request.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        class PauseMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'PauseMigration' request.
        class PauseMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ResumeMigration' request.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        class ResumeMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ResumeMigration' request.
        class ResumeMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'FinalizeMigration' request.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        class FinalizeMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ExtendMigrationRequest' request.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     Required. The name of the MigratingVm.
        class ExtendMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ExtendMigration' request.
        class ExtendMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'FinalizeMigration' request.
        class FinalizeMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TargetProject message represents a target Compute Engine project for a
        # migration or a clone.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The name of the target project.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. The target project ID (number) or project name.
        # @!attribute [rw] description
        #   @return [::String]
        #     The target project's description.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time this target project resource was created (not related
        #     to when the Compute Engine project it points to was created).
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the target project resource was updated.
        class TargetProject
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetTargetProject' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The TargetProject name.
        class GetTargetProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListTargetProjects' call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of targets.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of targets to return. The service may return
        #     fewer than this value. If unspecified, at most 500 targets will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListTargets` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListTargets` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListTargetProjectsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListTargetProjects' call.
        # @!attribute [r] target_projects
        #   @return [::Array<::Google::Cloud::VMMigration::V1::TargetProject>]
        #     Output only. The list of target response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListTargetProjectsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateTargetProject' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The TargetProject's parent.
        # @!attribute [rw] target_project_id
        #   @return [::String]
        #     Required. The target_project identifier.
        # @!attribute [rw] target_project
        #   @return [::Google::Cloud::VMMigration::V1::TargetProject]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateTargetProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update message for 'UpdateTargetProject' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     TargetProject resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] target_project
        #   @return [::Google::Cloud::VMMigration::V1::TargetProject]
        #     Required. The update request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateTargetProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteTargetProject' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The TargetProject name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteTargetProjectRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes message for 'Group' resource. The Group is a collections of several
        # MigratingVms.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The Group name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time timestamp.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update time timestamp.
        # @!attribute [rw] description
        #   @return [::String]
        #     User-provided description of the group.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name is a user defined name for this group which can be updated.
        # @!attribute [rw] migration_target_type
        #   @return [::Google::Cloud::VMMigration::V1::Group::MigrationTargetType]
        #     Immutable. The target type of this group.
        class Group
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible types of the group.
          module MigrationTargetType
            # Group type is not specified. This defaults to Compute Engine targets.
            MIGRATION_TARGET_TYPE_UNSPECIFIED = 0

            # All MigratingVMs in the group must have Compute Engine targets.
            MIGRATION_TARGET_TYPE_GCE = 1

            # All MigratingVMs in the group must have Compute Engine Disks targets.
            MIGRATION_TARGET_TYPE_DISKS = 2
          end
        end

        # Request message for 'ListGroups' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of groups.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of groups to return. The service may return
        #     fewer than this value. If unspecified, at most 500 groups will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListGroups` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListGroups` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListGroups' request.
        # @!attribute [r] groups
        #   @return [::Array<::Google::Cloud::VMMigration::V1::Group>]
        #     Output only. The list of groups response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetGroup' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The group name.
        class GetGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateGroup' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Group's parent.
        # @!attribute [rw] group_id
        #   @return [::String]
        #     Required. The group identifier.
        # @!attribute [rw] group
        #   @return [::Google::Cloud::VMMigration::V1::Group]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update message for 'UpdateGroups' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Field mask is used to specify the fields to be overwritten in the
        #     Group resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] group
        #   @return [::Google::Cloud::VMMigration::V1::Group]
        #     Required. The update request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteGroup' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Group name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'AddGroupMigration' request.
        # @!attribute [rw] group
        #   @return [::String]
        #     Required. The full path name of the Group to add to.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     The full path name of the MigratingVm to add.
        class AddGroupMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'AddGroupMigration' request.
        class AddGroupMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'RemoveMigration' request.
        # @!attribute [rw] group
        #   @return [::String]
        #     Required. The name of the Group.
        # @!attribute [rw] migrating_vm
        #   @return [::String]
        #     The MigratingVm to remove.
        class RemoveGroupMigrationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'RemoveMigration' request.
        class RemoveGroupMigrationResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateCutoverJob' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Cutover's parent.
        # @!attribute [rw] cutover_job_id
        #   @return [::String]
        #     Required. The cutover job identifier.
        # @!attribute [rw] cutover_job
        #   @return [::Google::Cloud::VMMigration::V1::CutoverJob]
        #     Required. The cutover request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateCutoverJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CancelCutoverJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The cutover job id
        class CancelCutoverJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'CancelCutoverJob' request.
        class CancelCutoverJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListCutoverJobsRequest' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of migrating VMs.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of cutover jobs to return. The service may
        #     return fewer than this value. If unspecified, at most 500 cutover jobs will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListCutoverJobs` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCutoverJobs` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListCutoverJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListCutoverJobs' request.
        # @!attribute [r] cutover_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::CutoverJob>]
        #     Output only. The list of cutover jobs response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListCutoverJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetCutoverJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CutoverJob.
        class GetCutoverJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents migration resource error information that can be used with
        # google.rpc.Status message. MigrationError is used to present the user with
        # error information in migration operations.
        # @!attribute [r] code
        #   @return [::Google::Cloud::VMMigration::V1::MigrationError::ErrorCode]
        #     Output only. The error code.
        # @!attribute [r] error_message
        #   @return [::Google::Rpc::LocalizedMessage]
        #     Output only. The localized error message.
        # @!attribute [r] action_item
        #   @return [::Google::Rpc::LocalizedMessage]
        #     Output only. Suggested action for solving the error.
        # @!attribute [r] help_links
        #   @return [::Array<::Google::Rpc::Help::Link>]
        #     Output only. URL(s) pointing to additional information on handling the
        #     current error.
        # @!attribute [r] error_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the error occurred.
        class MigrationError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents resource error codes.
          module ErrorCode
            # Default value. This value is not used.
            ERROR_CODE_UNSPECIFIED = 0

            # Migrate to Virtual Machines encountered an unknown error.
            UNKNOWN_ERROR = 1

            # Migrate to Virtual Machines encountered an error while validating
            # replication source health.
            SOURCE_VALIDATION_ERROR = 2

            # Migrate to Virtual Machines encountered an error during source data
            # operation.
            SOURCE_REPLICATION_ERROR = 3

            # Migrate to Virtual Machines encountered an error during target data
            # operation.
            TARGET_REPLICATION_ERROR = 4

            # Migrate to Virtual Machines encountered an error during OS adaptation.
            OS_ADAPTATION_ERROR = 5

            # Migrate to Virtual Machines encountered an error in clone operation.
            CLONE_ERROR = 6

            # Migrate to Virtual Machines encountered an error in cutover operation.
            CUTOVER_ERROR = 7

            # Migrate to Virtual Machines encountered an error during utilization
            # report creation.
            UTILIZATION_REPORT_ERROR = 8

            # Migrate to Virtual Machines encountered an error during appliance
            # upgrade.
            APPLIANCE_UPGRADE_ERROR = 9

            # Migrate to Virtual Machines encountered an error in image import
            # operation.
            IMAGE_IMPORT_ERROR = 10

            # Migrate to Virtual Machines encountered an error in disk migration
            # operation.
            DISK_MIGRATION_ERROR = 11
          end
        end

        # Represents migration resource warning information that can be used with
        # google.rpc.Status message. MigrationWarning is used to present the user with
        # warning information in migration operations.
        # @!attribute [rw] code
        #   @return [::Google::Cloud::VMMigration::V1::MigrationWarning::WarningCode]
        #     The warning code.
        # @!attribute [r] warning_message
        #   @return [::Google::Rpc::LocalizedMessage]
        #     Output only. The localized warning message.
        # @!attribute [r] action_item
        #   @return [::Google::Rpc::LocalizedMessage]
        #     Output only. Suggested action for solving the warning.
        # @!attribute [r] help_links
        #   @return [::Array<::Google::Rpc::Help::Link>]
        #     Output only. URL(s) pointing to additional information on handling the
        #     current warning.
        # @!attribute [rw] warning_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the warning occurred.
        class MigrationWarning
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents possible warning codes.
          module WarningCode
            # Default value. This value is not used.
            WARNING_CODE_UNSPECIFIED = 0

            # A warning originated from OS Adaptation.
            ADAPTATION_WARNING = 1
          end
        end

        # Represent the source Vmware VM details.
        # @!attribute [r] firmware
        #   @return [::Google::Cloud::VMMigration::V1::VmwareSourceVmDetails::Firmware]
        #     Output only. The firmware type of the source VM.
        # @!attribute [r] committed_storage_bytes
        #   @return [::Integer]
        #     Output only. The total size of the disks being migrated in bytes.
        # @!attribute [r] disks
        #   @return [::Array<::Google::Cloud::VMMigration::V1::VmwareSourceVmDetails::VmwareDiskDetails>]
        #     Output only. The disks attached to the source VM.
        # @!attribute [r] vm_capabilities_info
        #   @return [::Google::Cloud::VMMigration::V1::VmCapabilities]
        #     Output only. Information about VM capabilities needed for some Compute
        #     Engine features.
        # @!attribute [r] architecture
        #   @return [::Google::Cloud::VMMigration::V1::VmArchitecture]
        #     Output only. The VM architecture.
        class VmwareSourceVmDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The details of a Vmware VM disk.
          # @!attribute [r] disk_number
          #   @return [::Integer]
          #     Output only. The ordinal number of the disk.
          # @!attribute [r] size_gb
          #   @return [::Integer]
          #     Output only. Size in GB.
          # @!attribute [r] label
          #   @return [::String]
          #     Output only. The disk label.
          class VmwareDiskDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible values for Vmware VM firmware.
          module Firmware
            # The firmware is unknown.
            FIRMWARE_UNSPECIFIED = 0

            # The firmware is EFI.
            EFI = 1

            # The firmware is BIOS.
            BIOS = 2
          end
        end

        # Represent the source AWS VM details.
        # @!attribute [r] firmware
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceVmDetails::Firmware]
        #     Output only. The firmware type of the source VM.
        # @!attribute [r] committed_storage_bytes
        #   @return [::Integer]
        #     Output only. The total size of the disks being migrated in bytes.
        # @!attribute [r] disks
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AwsSourceVmDetails::AwsDiskDetails>]
        #     Output only. The disks attached to the source VM.
        # @!attribute [r] vm_capabilities_info
        #   @return [::Google::Cloud::VMMigration::V1::VmCapabilities]
        #     Output only. Information about VM capabilities needed for some Compute
        #     Engine features.
        # @!attribute [r] architecture
        #   @return [::Google::Cloud::VMMigration::V1::VmArchitecture]
        #     Output only. The VM architecture.
        class AwsSourceVmDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The details of an AWS instance disk.
          # @!attribute [r] disk_number
          #   @return [::Integer]
          #     Output only. The ordinal number of the disk.
          # @!attribute [r] volume_id
          #   @return [::String]
          #     Output only. AWS volume ID.
          # @!attribute [r] size_gb
          #   @return [::Integer]
          #     Output only. Size in GB.
          class AwsDiskDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible values for AWS VM firmware.
          module Firmware
            # The firmware is unknown.
            FIRMWARE_UNSPECIFIED = 0

            # The firmware is EFI.
            EFI = 1

            # The firmware is BIOS.
            BIOS = 2
          end
        end

        # Represent the source Azure VM details.
        # @!attribute [r] firmware
        #   @return [::Google::Cloud::VMMigration::V1::AzureSourceVmDetails::Firmware]
        #     Output only. The firmware type of the source VM.
        # @!attribute [r] committed_storage_bytes
        #   @return [::Integer]
        #     Output only. The total size of the disks being migrated in bytes.
        # @!attribute [r] disks
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AzureSourceVmDetails::AzureDiskDetails>]
        #     Output only. The disks attached to the source VM.
        # @!attribute [r] vm_capabilities_info
        #   @return [::Google::Cloud::VMMigration::V1::VmCapabilities]
        #     Output only. Information about VM capabilities needed for some Compute
        #     Engine features.
        # @!attribute [r] architecture
        #   @return [::Google::Cloud::VMMigration::V1::VmArchitecture]
        #     Output only. The VM architecture.
        class AzureSourceVmDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The details of an Azure VM disk.
          # @!attribute [r] disk_number
          #   @return [::Integer]
          #     Output only. The ordinal number of the disk.
          # @!attribute [r] disk_id
          #   @return [::String]
          #     Output only. Azure disk ID.
          # @!attribute [r] size_gb
          #   @return [::Integer]
          #     Output only. Size in GB.
          class AzureDiskDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible values for Azure VM firmware.
          module Firmware
            # The firmware is unknown.
            FIRMWARE_UNSPECIFIED = 0

            # The firmware is EFI.
            EFI = 1

            # The firmware is BIOS.
            BIOS = 2
          end
        end

        # Request message for 'LisReplicationCyclesRequest' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of ReplicationCycles.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of replication cycles to return. The service
        #     may return fewer than this value. If unspecified, at most 100 migrating VMs
        #     will be returned. The maximum value is 100; values above 100 will be
        #     coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Required. A page token, received from a previous `ListReplicationCycles`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListReplicationCycles`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. the order by fields for the result.
        class ListReplicationCyclesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListReplicationCycles' request.
        # @!attribute [r] replication_cycles
        #   @return [::Array<::Google::Cloud::VMMigration::V1::ReplicationCycle>]
        #     Output only. The list of replication cycles response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListReplicationCyclesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetReplicationCycle' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ReplicationCycle.
        class GetReplicationCycleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Migrating VM source information about the VM capabilities needed for some
        # Compute Engine features.
        # @!attribute [r] os_capabilities
        #   @return [::Array<::Google::Cloud::VMMigration::V1::OsCapability>]
        #     Output only. Unordered list. List of certain VM OS capabilities needed for
        #     some Compute Engine features.
        # @!attribute [r] last_os_capabilities_update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time OS capabilities list was updated.
        class VmCapabilities
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ImageImport describes the configuration of the image import to run.
        # @!attribute [rw] cloud_storage_uri
        #   @return [::String]
        #     Immutable. The path to the Cloud Storage file from which the image should
        #     be imported.
        # @!attribute [rw] disk_image_target_defaults
        #   @return [::Google::Cloud::VMMigration::V1::DiskImageTargetDetails]
        #     Immutable. Target details for importing a disk image, will be used by
        #     ImageImportJob.
        #
        #     Note: The following fields are mutually exclusive: `disk_image_target_defaults`, `machine_image_target_defaults`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] machine_image_target_defaults
        #   @return [::Google::Cloud::VMMigration::V1::MachineImageTargetDetails]
        #     Immutable. Target details for importing a machine image, will be used by
        #     ImageImportJob.
        #
        #     Note: The following fields are mutually exclusive: `machine_image_target_defaults`, `disk_image_target_defaults`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource path of the ImageImport.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the image import was created.
        # @!attribute [r] recent_image_import_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::ImageImportJob>]
        #     Output only. The result of the most recent runs for this ImageImport. All
        #     jobs for this ImageImport can be listed via ListImageImportJobs.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Immutable. The encryption details used by the image import process during
        #     the image adaptation for Compute Engine.
        class ImageImport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ImageImportJob describes the progress and result of an image import.
        # @!attribute [r] cloud_storage_uri
        #   @return [::String]
        #     Output only. The path to the Cloud Storage file from which the image
        #     should be imported.
        # @!attribute [r] disk_image_target_details
        #   @return [::Google::Cloud::VMMigration::V1::DiskImageTargetDetails]
        #     Output only. Target details used to import a disk image.
        #
        #     Note: The following fields are mutually exclusive: `disk_image_target_details`, `machine_image_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] machine_image_target_details
        #   @return [::Google::Cloud::VMMigration::V1::MachineImageTargetDetails]
        #     Output only. Target details used to import a machine image.
        #
        #     Note: The following fields are mutually exclusive: `machine_image_target_details`, `disk_image_target_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource path of the ImageImportJob.
        # @!attribute [r] created_resources
        #   @return [::Array<::String>]
        #     Output only. The resource paths of the resources created by the image
        #     import job.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::ImageImportJob::State]
        #     Output only. The state of the image import.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the image import was created (as an API call, not
        #     when it was actually created in the target).
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the image import was ended.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Provides details on the error that led to the image import
        #     state in case of an error.
        # @!attribute [r] warnings
        #   @return [::Array<::Google::Cloud::VMMigration::V1::MigrationWarning>]
        #     Output only. Warnings that occurred during the image import.
        # @!attribute [r] steps
        #   @return [::Array<::Google::Cloud::VMMigration::V1::ImageImportStep>]
        #     Output only. The image import steps list representing its progress.
        class ImageImportJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of the image import.
          module State
            # The state is unknown.
            STATE_UNSPECIFIED = 0

            # The image import has not yet started.
            PENDING = 1

            # The image import is active and running.
            RUNNING = 2

            # The image import has finished successfully.
            SUCCEEDED = 3

            # The image import has finished with errors.
            FAILED = 4

            # The image import is being cancelled.
            CANCELLING = 5

            # The image import was cancelled.
            CANCELLED = 6
          end
        end

        # ImageImportStep holds information about the image import step progress.
        # @!attribute [rw] initializing
        #   @return [::Google::Cloud::VMMigration::V1::InitializingImageImportStep]
        #     Initializing step.
        #
        #     Note: The following fields are mutually exclusive: `initializing`, `loading_source_files`, `adapting_os`, `creating_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] loading_source_files
        #   @return [::Google::Cloud::VMMigration::V1::LoadingImageSourceFilesStep]
        #     Loading source files step.
        #
        #     Note: The following fields are mutually exclusive: `loading_source_files`, `initializing`, `adapting_os`, `creating_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] adapting_os
        #   @return [::Google::Cloud::VMMigration::V1::AdaptingOSStep]
        #     Adapting OS step.
        #
        #     Note: The following fields are mutually exclusive: `adapting_os`, `initializing`, `loading_source_files`, `creating_image`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] creating_image
        #   @return [::Google::Cloud::VMMigration::V1::CreatingImageStep]
        #     Creating image step.
        #
        #     Note: The following fields are mutually exclusive: `creating_image`, `initializing`, `loading_source_files`, `adapting_os`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the step has started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the step has ended.
        class ImageImportStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # InitializingImageImportStep contains specific step details.
        class InitializingImageImportStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # LoadingImageSourceFilesStep contains specific step details.
        class LoadingImageSourceFilesStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreatingImageStep contains specific step details.
        class CreatingImageStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The target details of the image resource that will be created by the import
        # job.
        # @!attribute [rw] os_adaptation_parameters
        #   @return [::Google::Cloud::VMMigration::V1::ImageImportOsAdaptationParameters]
        #     Optional. Use to set the parameters relevant for the OS adaptation
        #     process.
        #
        #     Note: The following fields are mutually exclusive: `os_adaptation_parameters`, `data_disk_image_import`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_disk_image_import
        #   @return [::Google::Cloud::VMMigration::V1::DataDiskImageImport]
        #     Optional. Use to skip OS adaptation process.
        #
        #     Note: The following fields are mutually exclusive: `data_disk_image_import`, `os_adaptation_parameters`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_name
        #   @return [::String]
        #     Required. The name of the image to be created.
        # @!attribute [rw] target_project
        #   @return [::String]
        #     Required. Reference to the TargetProject resource that represents the
        #     target project in which the imported image will be created.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. An optional description of the image.
        # @!attribute [rw] family_name
        #   @return [::String]
        #     Optional. The name of the image family to which the new image belongs.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. A map of labels to associate with the image.
        # @!attribute [rw] additional_licenses
        #   @return [::Array<::String>]
        #     Optional. Additional licenses to assign to the image.
        #     Format:
        #     https://www.googleapis.com/compute/v1/projects/PROJECT_ID/global/licenses/LICENSE_NAME
        #     Or
        #     https://www.googleapis.com/compute/beta/projects/PROJECT_ID/global/licenses/LICENSE_NAME
        # @!attribute [rw] single_region_storage
        #   @return [::Boolean]
        #     Optional. Set to true to set the image storageLocations to the single
        #     region of the import job. When false, the closest multi-region is selected.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Immutable. The encryption to apply to the image.
        class DiskImageTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The target details of the machine image resource that will be created by the
        # image import job.
        # @!attribute [rw] os_adaptation_parameters
        #   @return [::Google::Cloud::VMMigration::V1::ImageImportOsAdaptationParameters]
        #     Optional. Use to set the parameters relevant for the OS adaptation
        #     process.
        #
        #     Note: The following fields are mutually exclusive: `os_adaptation_parameters`, `skip_os_adaptation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] skip_os_adaptation
        #   @return [::Google::Cloud::VMMigration::V1::SkipOsAdaptation]
        #     Optional. Use to skip OS adaptation process.
        #
        #     Note: The following fields are mutually exclusive: `skip_os_adaptation`, `os_adaptation_parameters`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] machine_image_name
        #   @return [::String]
        #     Required. The name of the machine image to be created.
        # @!attribute [rw] target_project
        #   @return [::String]
        #     Required. Reference to the TargetProject resource that represents the
        #     target project in which the imported machine image will be created.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. An optional description of the machine image.
        # @!attribute [rw] single_region_storage
        #   @return [::Boolean]
        #     Optional. Set to true to set the machine image storageLocations to the
        #     single region of the import job. When false, the closest multi-region is
        #     selected.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Immutable. The encryption to apply to the machine image.
        #     If the Image Import resource has an encryption, this field must be set to
        #     the same encryption key.
        # @!attribute [rw] machine_image_parameters_overrides
        #   @return [::Google::Cloud::VMMigration::V1::MachineImageParametersOverrides]
        #     Optional. Parameters overriding decisions based on the source machine image
        #     configurations.
        # @!attribute [rw] service_account
        #   @return [::Google::Cloud::VMMigration::V1::ServiceAccount]
        #     Optional. The service account to assign to the instance created by the
        #     machine image.
        # @!attribute [rw] additional_licenses
        #   @return [::Array<::String>]
        #     Optional. Additional licenses to assign to the instance created by the
        #     machine image. Format:
        #     https://www.googleapis.com/compute/v1/projects/PROJECT_ID/global/licenses/LICENSE_NAME
        #     Or
        #     https://www.googleapis.com/compute/beta/projects/PROJECT_ID/global/licenses/LICENSE_NAME
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels to apply to the instance created by the machine image.
        # @!attribute [rw] tags
        #   @return [::Array<::String>]
        #     Optional. The tags to apply to the instance created by the machine image.
        # @!attribute [rw] shielded_instance_config
        #   @return [::Google::Cloud::VMMigration::V1::ShieldedInstanceConfig]
        #     Optional. Shielded instance configuration.
        # @!attribute [rw] network_interfaces
        #   @return [::Array<::Google::Cloud::VMMigration::V1::NetworkInterface>]
        #     Optional. The network interfaces to create with the instance created by the
        #     machine image. Internal and external IP addresses, and network tiers are
        #     ignored for machine image import.
        class MachineImageTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Service account to assign to the instance created by the machine image.
        # @!attribute [rw] email
        #   @return [::String]
        #     Required. The email address of the service account.
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     Optional. The list of scopes to be made available for this service account.
        class ServiceAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Shielded instance configuration.
        # @!attribute [rw] secure_boot
        #   @return [::Google::Cloud::VMMigration::V1::ShieldedInstanceConfig::SecureBoot]
        #     Optional. Defines whether the instance created by the machine image has
        #     Secure Boot enabled. This can be set to true only if the image boot option
        #     is EFI.
        # @!attribute [rw] enable_vtpm
        #   @return [::Boolean]
        #     Optional. Defines whether the instance created by the machine image has
        #     vTPM enabled. This can be set to true only if the image boot option is EFI.
        # @!attribute [rw] enable_integrity_monitoring
        #   @return [::Boolean]
        #     Optional. Defines whether the instance created by the machine image has
        #     integrity monitoring enabled. This can be set to true only if the image
        #     boot option is EFI, and vTPM is enabled.
        class ShieldedInstanceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible values for secure boot.
          module SecureBoot
            # No explicit value is selected. Will use the configuration of the source
            # (if exists, otherwise the default will be false).
            SECURE_BOOT_UNSPECIFIED = 0

            # Use secure boot. This can be set to true only if the image boot option is
            # EFI.
            TRUE = 1

            # Do not use secure boot.
            FALSE = 2
          end
        end

        # Parameters overriding decisions based on the source machine image
        # configurations.
        # @!attribute [rw] machine_type
        #   @return [::String]
        #     Optional. The machine type to create the MachineImage with.
        #     If empty, the service will choose a relevant machine type based on the
        #     information from the source image.
        #     For more information about machine types, please refer to
        #     https://cloud.google.com/compute/docs/machine-resource.
        class MachineImageParametersOverrides
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Parameters affecting the OS adaptation process.
        # @!attribute [rw] generalize
        #   @return [::Boolean]
        #     Optional. Set to true in order to generalize the imported image.
        #     The generalization process enables co-existence of multiple VMs created
        #     from the same image.
        #     For Windows, generalizing the image removes computer-specific information
        #     such as installed drivers and the computer security identifier (SID).
        # @!attribute [rw] license_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineLicenseType]
        #     Optional. Choose which type of license to apply to the imported image.
        # @!attribute [rw] boot_conversion
        #   @return [::Google::Cloud::VMMigration::V1::BootConversion]
        #     Optional. By default the image will keep its existing boot option. Setting
        #     this property will trigger an internal process which will convert the
        #     image from using the existing boot option to another.
        #     The size of the boot disk might be increased to allow the conversion
        # @!attribute [rw] adaptation_modifiers
        #   @return [::Array<::Google::Cloud::VMMigration::V1::AdaptationModifier>]
        #     Optional. Modifiers to be used as configuration of the OS adaptation
        #     process.
        class ImageImportOsAdaptationParameters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Used when the image import is not using OS adaptation process.
        # @!attribute [rw] guest_os_features
        #   @return [::Array<::String>]
        #     Optional. A list of guest OS features to apply to the imported image. These
        #     features are flags that are used by Compute Engine to enable certain
        #     capabilities for virtual machine instances that are created from the image.
        #
        #     This field does not change the OS of the image; it only marks the image
        #     with the specified features. The user must ensure that the OS is
        #     compatible with the features.
        #
        #     For a list of available features, see
        #     https://cloud.google.com/compute/docs/images/create-custom#guest-os-features.
        class DataDiskImageImport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Mentions that the machine image import is not using OS adaptation process.
        class SkipOsAdaptation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetImageImport' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ImageImport name.
        class GetImageImportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListImageImports' call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of targets.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of targets to return. The service may return
        #     fewer than this value. If unspecified, at most 500 targets will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListImageImports` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListImageImports` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request (according to <a
        #     href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The order by fields for the result (according to <a
        #     href="https://google.aip.dev/132#ordering" target="_blank">AIP-132</a>).
        #     Currently ordering is only possible by "name" field.
        class ListImageImportsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListImageImports' call.
        # @!attribute [r] image_imports
        #   @return [::Array<::Google::Cloud::VMMigration::V1::ImageImport>]
        #     Output only. The list of target response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListImageImportsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CreateImageImport' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The ImageImport's parent.
        # @!attribute [rw] image_import_id
        #   @return [::String]
        #     Required. The image import identifier.
        #     This value maximum length is 63 characters, and valid characters are
        #     /[a-z][0-9]-/. It must start with an english letter and must not end with a
        #     hyphen.
        # @!attribute [rw] image_import
        #   @return [::Google::Cloud::VMMigration::V1::ImageImport]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateImageImportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteImageImport' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ImageImport name.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and t
        #     he request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteImageImportRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetImageImportJob' call.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The ImageImportJob name.
        class GetImageImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListImageImportJobs' call.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of targets.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of targets to return. The service may return
        #     fewer than this value. If unspecified, at most 500 targets will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListImageImportJobs`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListImageImportJobs`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request (according to <a
        #     href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The order by fields for the result (according to <a
        #     href="https://google.aip.dev/132#ordering" target="_blank">AIP-132</a>).
        #     Currently ordering is only possible by "name" field.
        class ListImageImportJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListImageImportJobs' call.
        # @!attribute [r] image_import_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::ImageImportJob>]
        #     Output only. The list of target response.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Output only. A token, which can be sent as `page_token` to retrieve the
        #     next page. If this field is omitted, there are no subsequent pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListImageImportJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CancelImageImportJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The image import job id.
        class CancelImageImportJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'CancelImageImportJob' request.
        class CancelImageImportJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the disk which will be migrated from the source environment.
        # The source disk has to be unattached.
        # @!attribute [rw] aws_source_disk_details
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceDiskDetails]
        #     Details of the unattached AWS source disk.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The identifier of the DiskMigrationJob.
        # @!attribute [rw] target_details
        #   @return [::Google::Cloud::VMMigration::V1::DiskMigrationJobTargetDetails]
        #     Required. Details of the target Disk in Compute Engine.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the DiskMigrationJob resource was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last time the DiskMigrationJob resource was updated.
        # @!attribute [r] state
        #   @return [::Google::Cloud::VMMigration::V1::DiskMigrationJob::State]
        #     Output only. State of the DiskMigrationJob.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Rpc::Status>]
        #     Output only. Provides details on the errors that led to the disk migration
        #     job's state in case of an error.
        # @!attribute [r] steps
        #   @return [::Array<::Google::Cloud::VMMigration::V1::DiskMigrationStep>]
        #     Output only. The disk migration steps list representing its progress.
        class DiskMigrationJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible values of the state/health of DiskMigrationJob.
          module State
            # The state is unspecified. This is not in use.
            STATE_UNSPECIFIED = 0

            # The initial state of the disk migration.
            # In this state the customers can update the target details.
            READY = 1

            # The migration is active, and it's running or scheduled to run.
            RUNNING = 3

            # The migration completed successfully.
            SUCCEEDED = 4

            # Migration cancellation was initiated.
            CANCELLING = 5

            # The migration was cancelled.
            CANCELLED = 6

            # The migration process encountered an unrecoverable error and was aborted.
            FAILED = 7
          end
        end

        # Details of the target disk in Compute Engine.
        # @!attribute [rw] target_disk
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDisk]
        #     Required. The target disk.
        # @!attribute [rw] target_project
        #   @return [::String]
        #     Required. The name of the resource of type TargetProject which represents
        #     the Compute Engine project in which to create the disk. Should be of the
        #     form: projects/\\{project}/locations/global/targetProjects/\\{target-project}
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. A map of labels to associate with the disk.
        # @!attribute [rw] encryption
        #   @return [::Google::Cloud::VMMigration::V1::Encryption]
        #     Optional. The encryption to apply to the disk.
        #     If the DiskMigrationJob parent Source resource has an encryption, this
        #     field must be set to the same encryption key.
        class DiskMigrationJobTargetDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # DiskMigrationStep holds information about the disk migration step progress.
        # @!attribute [rw] creating_source_disk_snapshot
        #   @return [::Google::Cloud::VMMigration::V1::CreatingSourceDiskSnapshotStep]
        #     Creating source disk snapshot step.
        #
        #     Note: The following fields are mutually exclusive: `creating_source_disk_snapshot`, `copying_source_disk_snapshot`, `provisioning_target_disk`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] copying_source_disk_snapshot
        #   @return [::Google::Cloud::VMMigration::V1::CopyingSourceDiskSnapshotStep]
        #     Copying source disk snapshot step.
        #
        #     Note: The following fields are mutually exclusive: `copying_source_disk_snapshot`, `creating_source_disk_snapshot`, `provisioning_target_disk`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] provisioning_target_disk
        #   @return [::Google::Cloud::VMMigration::V1::ProvisioningTargetDiskStep]
        #     Creating target disk step.
        #
        #     Note: The following fields are mutually exclusive: `provisioning_target_disk`, `creating_source_disk_snapshot`, `copying_source_disk_snapshot`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the step has started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the step has ended.
        class DiskMigrationStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreatingSourceDiskSnapshotStep contains specific step details.
        class CreatingSourceDiskSnapshotStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CopyingSourceDiskSnapshotStep contains specific step details.
        class CopyingSourceDiskSnapshotStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ProvisioningTargetDiskStep contains specific step details.
        class ProvisioningTargetDiskStep
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Compute Engine disk target details.
        # @!attribute [rw] disk_id
        #   @return [::String]
        #     Optional. Target Compute Engine Disk ID.
        #     This is the resource ID segment of the Compute Engine Disk to create.
        #     In the resource name compute/v1/projects/\\{project}/zones/\\{zone}/disks/disk1
        #     "disk1" is the resource ID for the disk.
        # @!attribute [rw] zone
        #   @return [::String]
        #     Required. The Compute Engine zone in which to create the disk. Should be of
        #     the form: projects/\\{target-project}/locations/\\{zone}
        # @!attribute [rw] replica_zones
        #   @return [::Array<::String>]
        #     Optional. Replication zones of the regional disk. Should be of the form:
        #     projects/\\{target-project}/locations/\\{replica-zone}
        #     Currently only one replica zone is supported.
        # @!attribute [rw] disk_type
        #   @return [::Google::Cloud::VMMigration::V1::ComputeEngineDiskType]
        #     Required. The disk type to use.
        class ComputeEngineDisk
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the source AWS Disk details.
        # @!attribute [rw] volume_id
        #   @return [::String]
        #     Required. AWS volume ID.
        # @!attribute [r] size_gib
        #   @return [::Integer]
        #     Output only. Size in GiB.
        # @!attribute [r] disk_type
        #   @return [::Google::Cloud::VMMigration::V1::AwsSourceDiskDetails::Type]
        #     Optional. Output only. Disk type.
        # @!attribute [r] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Output only. A map of AWS volume tags.
        class AwsSourceDiskDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible values for disk types.
          module Type
            # Unspecified AWS disk type. Should not be used.
            TYPE_UNSPECIFIED = 0

            # GP2 disk type.
            GP2 = 1

            # GP3 disk type.
            GP3 = 2

            # IO1 disk type.
            IO1 = 3

            # IO2 disk type.
            IO2 = 4

            # ST1 disk type.
            ST1 = 5

            # SC1 disk type.
            SC1 = 6

            # Standard disk type.
            STANDARD = 7
          end
        end

        # Request message for 'CreateDiskMigrationJob' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The DiskMigrationJob's parent.
        # @!attribute [rw] disk_migration_job_id
        #   @return [::String]
        #     Required. The DiskMigrationJob identifier.
        #     The maximum length of this value is 63 characters.
        #     Valid characters are lower case Latin letters, digits and hyphen.
        #     It must start with a Latin letter and must not end with a hyphen.
        # @!attribute [rw] disk_migration_job
        #   @return [::Google::Cloud::VMMigration::V1::DiskMigrationJob]
        #     Required. The create request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request timed out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDiskMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'ListDiskMigrationJobsRequest' request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of DiskMigrationJobs.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of disk migration jobs to return. The service
        #     may return fewer than this value. If unspecified, at most 500
        #     disk migration jobs will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListDiskMigrationJobs`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all parameters provided to `ListDiskMigrationJobs`
        #     except `page_size` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. The filter request (according to <a
        #     href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Ordering of the result list.
        class ListDiskMigrationJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'ListDiskMigrationJobs' request.
        # @!attribute [r] disk_migration_jobs
        #   @return [::Array<::Google::Cloud::VMMigration::V1::DiskMigrationJob>]
        #     Output only. The list of the disk migration jobs.
        # @!attribute [r] next_page_token
        #   @return [::String]
        #     Optional. Output only. A token, which can be sent as `page_token` to
        #     retrieve the next page. If this field is omitted, there are no subsequent
        #     pages.
        # @!attribute [r] unreachable
        #   @return [::Array<::String>]
        #     Output only. Locations that could not be reached.
        class ListDiskMigrationJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'GetDiskMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DiskMigrationJob.
        class GetDiskMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'UpdateDiskMigrationJob' request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     DiskMigrationJob resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask, then a mask equivalent to all fields that are
        #     populated (have a non-empty value), will be implied.
        # @!attribute [rw] disk_migration_job
        #   @return [::Google::Cloud::VMMigration::V1::DiskMigrationJob]
        #     Required. The update request body.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server will know to ignore
        #     the request if it has already been completed. The server will guarantee
        #     that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and
        #     the request timed out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateDiskMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'DeleteDiskMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DiskMigrationJob.
        class DeleteDiskMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'RunDiskMigrationJobRequest' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DiskMigrationJob.
        class RunDiskMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'RunDiskMigrationJob' request.
        class RunDiskMigrationJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for 'CancelDiskMigrationJob' request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DiskMigrationJob.
        class CancelDiskMigrationJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for 'CancelDiskMigrationJob' request.
        class CancelDiskMigrationJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Types of disks supported for Compute Engine VM.
        module ComputeEngineDiskType
          # An unspecified disk type. Will be used as STANDARD.
          COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED = 0

          # A Standard disk type.
          COMPUTE_ENGINE_DISK_TYPE_STANDARD = 1

          # SSD hard disk type.
          COMPUTE_ENGINE_DISK_TYPE_SSD = 2

          # An alternative to SSD persistent disks that balance performance and
          # cost.
          COMPUTE_ENGINE_DISK_TYPE_BALANCED = 3

          # Hyperdisk balanced disk type.
          COMPUTE_ENGINE_DISK_TYPE_HYPERDISK_BALANCED = 4
        end

        # Types of licenses used in OS adaptation.
        module ComputeEngineLicenseType
          # The license type is the default for the OS.
          COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT = 0

          # The license type is Pay As You Go license type.
          COMPUTE_ENGINE_LICENSE_TYPE_PAYG = 1

          # The license type is Bring Your Own License type.
          COMPUTE_ENGINE_LICENSE_TYPE_BYOL = 2
        end

        # Possible values for vm boot option.
        module ComputeEngineBootOption
          # The boot option is unknown.
          COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED = 0

          # The boot option is EFI.
          COMPUTE_ENGINE_BOOT_OPTION_EFI = 1

          # The boot option is BIOS.
          COMPUTE_ENGINE_BOOT_OPTION_BIOS = 2
        end

        # VM operating system (OS) capabilities needed for determining compatibility
        # with Compute Engine features supported by the migration.
        module OsCapability
          # This is for API compatibility only and is not in use.
          OS_CAPABILITY_UNSPECIFIED = 0

          # NVMe driver installed and the VM can use NVMe PD or local SSD.
          OS_CAPABILITY_NVME_STORAGE_ACCESS = 1

          # gVNIC virtual NIC driver supported.
          OS_CAPABILITY_GVNIC_NETWORK_INTERFACE = 2

          # IDPF virtual NIC driver supported.
          OS_CAPABILITY_IDPF_NETWORK_INTERFACE = 3
        end

        # Possible boot options conversions.
        module BootConversion
          # Unspecified conversion type.
          BOOT_CONVERSION_UNSPECIFIED = 0

          # No conversion.
          NONE = 1

          # Convert from BIOS to EFI.
          BIOS_TO_EFI = 2
        end

        # Controls the level of details of a Utilization Report.
        module UtilizationReportView
          # The default / unset value.
          # The API will default to FULL on single report request and BASIC for
          # multiple reports request.
          UTILIZATION_REPORT_VIEW_UNSPECIFIED = 0

          # Get the report metadata, without the list of VMs and their utilization
          # info.
          BASIC = 1

          # Include everything.
          FULL = 2
        end

        # Controls the level of details of a Migrating VM.
        module MigratingVmView
          # View is unspecified. The API will fallback to the default value.
          MIGRATING_VM_VIEW_UNSPECIFIED = 0

          # Get the migrating VM basic details.
          # The basic details do not include the recent clone jobs and recent cutover
          # jobs lists.
          MIGRATING_VM_VIEW_BASIC = 1

          # Include everything.
          MIGRATING_VM_VIEW_FULL = 2
        end

        # Possible values for the VM architecture.
        module VmArchitecture
          # The architecture is unknown.
          VM_ARCHITECTURE_UNSPECIFIED = 0

          # The architecture is one of the x86 architectures.
          VM_ARCHITECTURE_X86_FAMILY = 1

          # The architecture is ARM64.
          VM_ARCHITECTURE_ARM64 = 2
        end

        # Describes the networking tier used for configuring network access
        # configuration.
        module ComputeEngineNetworkTier
          # An unspecified network tier. Will be used as PREMIUM.
          COMPUTE_ENGINE_NETWORK_TIER_UNSPECIFIED = 0

          # A standard network tier.
          NETWORK_TIER_STANDARD = 1

          # A premium network tier.
          NETWORK_TIER_PREMIUM = 2
        end
      end
    end
  end
end
